/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.ExternalIdentity;
import com.sas.metadata.remote.Identity;
import com.sas.metadata.remote.Login;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.impl.IdentityImpl;
import com.sas.metadata.remote.impl.IdentityImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.ExternalIdentityInterface;
import com.sas.services.information.metadata.IdentityGroupInterface;
import com.sas.services.information.metadata.IdentityInterface;
import com.sas.services.information.metadata.IdentityMembership;
import com.sas.services.information.metadata.IdentityMembershipInterface;
import com.sas.services.information.metadata.LoginInterface;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@SASScope
public abstract class OMRIdentity
extends Metadata
implements IdentityInterface {
    private static final long serialVersionUID = 1781327562267029324L;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);

    public OMRIdentity() throws RemoteException {
        this(OMRIdentity.class);
    }

    public OMRIdentity(Identity o) throws RemoteException {
        this(o, OMRIdentity.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRIdentity(IdentityImpl o) throws RemoteException {
        this(o, OMRIdentity.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRIdentity(IdentityImpl_Stub o) throws RemoteException {
        this(o, OMRIdentity.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    protected OMRIdentity(Class theClass) throws RemoteException {
        super(theClass);
    }

    protected OMRIdentity(Identity o, Class theClass) throws RemoteException {
        super(o, theClass);
    }

    protected OMRIdentity(IdentityImpl o, Class theClass) throws RemoteException {
        super(o, theClass);
    }

    protected OMRIdentity(IdentityImpl_Stub o, Class theClass) throws RemoteException {
        super(o, theClass);
    }

    @Override
    public String getDisplayName() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Identity role = (Identity)this._repositoryObject;
        return role.getDisplayName();
    }

    @Override
    public void setDisplayName(String displayName) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Identity role = (Identity)this._repositoryObject;
        role.setDisplayName(displayName);
    }

    @Override
    public String getEffectiveDispayName() throws ServiceException, RemoteException {
        return this.getEffectiveDisplayName();
    }

    @Override
    public String getEffectiveDisplayName() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Identity role = (Identity)this._repositoryObject;
        String effectiveName = role.getDisplayName();
        if (effectiveName == null || effectiveName.trim().length() == 0) {
            effectiveName = role.getName();
        }
        return effectiveName;
    }

    @Override
    public String getIdentityType() throws ServiceException, RemoteException {
        return ((Root)this._repositoryObject).getCMetadataType();
    }

    @Override
    public List getLogins() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ArrayList<MetadataInterface> results = null;
        Identity identity = (Identity)this._repositoryObject;
        try {
            AssociationList logins = identity.getLogins(true);
            results = new ArrayList<MetadataInterface>(logins.size());
            Iterator it = logins.iterator();
            while (it.hasNext()) {
                MetadataInterface mi = this._repository.factoryProcess(it.next());
                results.add(mi);
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        return results;
    }

    @Override
    public void addLogin(LoginInterface login) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Identity identity = (Identity)this._repositoryObject;
        try {
            AssociationList logins = identity.getLogins();
            Login clogin = (Login)login.getRepositoryEntity();
            logins.add(clogin);
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void removeLogin(LoginInterface login) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Identity identity = (Identity)this._repositoryObject;
        try {
            AssociationList logins = identity.getLogins();
            Login clogin = (Login)login.getRepositoryEntity();
            logins.remove(clogin);
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public List getUserIds() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ArrayList<String> results = null;
        Identity identity = (Identity)this._repositoryObject;
        try {
            AssociationList logins = identity.getLogins();
            results = new ArrayList<String>(logins.size());
            for (Login login : logins) {
                results.add(login.getUserID());
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        return results;
    }

    @Override
    public List getIdentityGroups() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Identity identity = (Identity)this._repositoryObject;
        try {
            AssociationList groupList = identity.getIdentityGroups();
            ArrayList<MetadataInterface> list = new ArrayList<MetadataInterface>(groupList.size());
            if (groupList != null) {
                Iterator e = groupList.iterator();
                while (e.hasNext()) {
                    MetadataInterface mi = this._repository.factoryProcess(e.next());
                    list.add(mi);
                }
            }
            return list;
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public List<IdentityMembershipInterface> getIdentityMembershipLevels() throws ServiceException, RemoteException {
        try {
            Identity jomaIdentity = (Identity)this.getRepositoryEntity();
            IdentityGroupInterface SASUSERS = this.getRepository().getServer().getExplicitIdentityGroup("SASUSERS");
            IdentityGroupInterface PUBLIC = this.getRepository().getServer().getExplicitIdentityGroup("PUBLIC");
            MdStore store = jomaIdentity.getObjectStore();
            MdFactory fact = store.getFactory();
            MdOMIUtil util = fact.getOMIUtil();
            String type = jomaIdentity.getCMetadataType();
            String template = "<Templates><" + type + "><IdentityGroups/></" + type + "></Templates>";
            int options = 524556;
            util.getMetadataAllDepths(store, type, jomaIdentity.getId(), null, null, template, options);
            HashMap<String, IdentityMembershipInterface> memberships = new HashMap<String, IdentityMembershipInterface>();
            this.buildMemberships(memberships, jomaIdentity, 1);
            ArrayList<IdentityMembershipInterface> memberShiplist = new ArrayList<IdentityMembershipInterface>(memberships.size());
            int highestLevel = 0;
            if (memberships.size() > 0) {
                memberShiplist.addAll(memberships.values());
                Collections.sort(memberShiplist);
                IdentityMembershipInterface lastIdGrp = (IdentityMembershipInterface)memberShiplist.get(memberShiplist.size() - 1);
                highestLevel = lastIdGrp.getMemberShipLevel();
            }
            String THISobjId = ((Identity)this.getRepositoryEntity()).getId();
            String SASUSERSobjId = ((Identity)SASUSERS.getRepositoryEntity()).getId();
            String PUBLICobjId = ((Identity)PUBLIC.getRepositoryEntity()).getId();
            if (!THISobjId.equals(PUBLICobjId)) {
                int explIncrement = 1;
                if (!THISobjId.equals(SASUSERSobjId)) {
                    memberShiplist.add(new IdentityMembership(SASUSERS, highestLevel + explIncrement));
                    ++explIncrement;
                }
                memberShiplist.add(new IdentityMembership(PUBLIC, highestLevel + explIncrement));
            }
            return memberShiplist;
        }
        catch (Exception ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    private void buildMemberships(Map<String, IdentityMembershipInterface> memberships, Identity memberAtLevel, int level) throws Exception {
        ArrayList<IdentityMembership> memberShipList = new ArrayList<IdentityMembership>();
        AssociationList identityGroups = memberAtLevel.getIdentityGroups();
        if (identityGroups.size() == 0) {
            return;
        }
        for (Identity identity : identityGroups) {
            String identityGroupObjId = identity.getId();
            if (memberships.containsKey(identityGroupObjId)) {
                if (level <= memberships.get(identityGroupObjId).getMemberShipLevel()) continue;
                continue;
            }
            IdentityGroupInterface smartObjIdentityGroup = (IdentityGroupInterface)this.getRepository().factoryProcess(identity);
            IdentityMembership identityMembership = new IdentityMembership(smartObjIdentityGroup, level);
            memberships.put(identityGroupObjId, identityMembership);
            memberShipList.add(identityMembership);
        }
        for (IdentityMembershipInterface identityMembershipInterface : memberShipList) {
            Identity identity = (Identity)identityMembershipInterface.getIdentity().getRepositoryEntity();
            this.buildMemberships(memberships, identity, level + 1);
        }
    }

    @Override
    public List<ExternalIdentityInterface> getExternalIdentities() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ArrayList<ExternalIdentityInterface> results = null;
        Identity identity = (Identity)this._repositoryObject;
        try {
            AssociationList extIdentities = identity.getExternalIdentities();
            results = new ArrayList<ExternalIdentityInterface>(extIdentities.size());
            Iterator it = extIdentities.iterator();
            while (it.hasNext()) {
                MetadataInterface mi = this._repository.factoryProcess(it.next());
                results.add((ExternalIdentityInterface)mi);
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        return results;
    }

    @Override
    public void addExternalIdentity(ExternalIdentityInterface externalIdentity) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Identity identity = (Identity)this._repositoryObject;
        try {
            AssociationList externalIdentities = identity.getExternalIdentities();
            ExternalIdentity extIdentity = (ExternalIdentity)externalIdentity.getRepositoryEntity();
            externalIdentities.add(extIdentity);
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void removeExternalIdentity(ExternalIdentityInterface externalIdentity) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Identity identity = (Identity)this._repositoryObject;
        try {
            AssociationList externalIdentities = identity.getExternalIdentities();
            ExternalIdentity extIdentity = (ExternalIdentity)externalIdentity.getRepositoryEntity();
            externalIdentities.remove(extIdentity);
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }
}

