/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Document;
import com.sas.metadata.remote.Group;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Person;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.ResponsibleParty;
import com.sas.metadata.remote.impl.GroupImpl;
import com.sas.metadata.remote.impl.GroupImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.GroupInterface;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.OMRPerson;
import com.sas.services.information.metadata.PersonInterface;
import com.sas.services.information.metadata.RB;
import com.sas.services.user.UserContextInterface;
import com.sas.storage.editableproperties.LocalizableProperties;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.util.UsageVersion;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.Level;

@SASScope
public class OMRGroup
extends Metadata
implements GroupInterface,
LocalizableProperties,
Serializable {
    static final long serialVersionUID = 6087967592633407051L;
    private static final int EMPTY_LIST_INIT = 1;
    private boolean got_dependents = false;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);

    public OMRGroup() throws RemoteException {
        super(OMRGroup.class);
    }

    public OMRGroup(Group o) throws RemoteException {
        super(o, OMRGroup.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRGroup(GroupImpl o) throws RemoteException {
        super(o, OMRGroup.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRGroup(GroupImpl_Stub o) throws RemoteException {
        super(o, OMRGroup.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRGroup(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        super(OMRGroup.class);
        if (repos == null || name == null) {
            throw new IllegalArgumentException();
        }
        Group group = null;
        try {
            group = (Group)((OMIRepositoryInterface)repos).createMetadata(name, "Group");
            group.setUsageVersion(CURRENT_VERSION.encode());
            this._isCompatible = true;
            this._isReadCompatible = true;
            this._repositoryObject = group;
            this._repositoryFlag = 2;
            this.setRepository(repos);
            if (parent != null) {
                parent.addItem(this);
            }
        }
        catch (ServiceException ex) {
            if (group != null) {
                try {
                    group.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new RuntimeException(ex.getMessage(), (Throwable)((Object)ex));
        }
    }

    @Override
    public String getType() throws RemoteException {
        PrimaryType pt;
        String ptype;
        if (this._repositoryObject != null && (ptype = (pt = (PrimaryType)this._repositoryObject).getPublicType()) != null && ptype.trim().length() > 0) {
            return pt.getPublicType();
        }
        return "Group";
    }

    @Override
    public List members() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        return this.getMembers();
    }

    @Override
    public List getMembers() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Group group = (Group)this._repositoryObject;
        try {
            AssociationList memberList = group.getMembers();
            ArrayList<MetadataInterface> al = new ArrayList<MetadataInterface>(memberList.size());
            for (CMetadata cm : memberList) {
                if (cm instanceof Document && ((Document)cm).getTextRole().equalsIgnoreCase("Foreign Key")) {
                    Document doc = (Document)cm;
                    if (!doc.getURIType().equalsIgnoreCase("entitykey")) continue;
                    UserContextInterface uc = this._repository.getUserContext();
                    InformationServiceInterface is = OMRGroup.getInformationService();
                    try {
                        MetadataInterface mmi = is.fetchEntityByKey(uc, doc.getURI());
                        if (mmi == null) continue;
                        al.add(mmi);
                    }
                    catch (ServiceException ex) {
                        this.logFormat(Level.INFO, "com.sas.services.information.metadata.OMRGroup", RB.getResources(), "OMRGroup.brokenlink.ex.txt", this.getName());
                    }
                    continue;
                }
                MetadataInterface mi = this._repository.factoryProcess(cm);
                al.add(mi);
            }
            return al;
        }
        catch (MdException ex) {
            this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRGroup", ex);
        }
        catch (ServiceException ex) {
            this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRGroup", (Throwable)((Object)ex));
        }
        return new ArrayList(1);
    }

    @Override
    public List getMembersAllRepositories() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        if (!this.got_dependents) {
            Group group = (Group)this._repositoryObject;
            ArrayList<String> memberList = new ArrayList<String>(1);
            memberList.add("Members");
            try {
                MdObjectStore store = (MdObjectStore)group.getObjectStore();
                MdFactory factory = store.getFactory();
                Group cm = (Group)factory.getOMIUtil().getMetadataAllDepths((MdStore)store, "Group", group.getFQID(), new ArrayList(1), memberList, "", 18440);
                this.got_dependents = true;
                cm.setState(cm.getState());
            }
            catch (MdException mdex) {
                throw new ServiceException(mdex, mdex.getMessage());
            }
        }
        return this.getMembers();
    }

    @Override
    public void addMember(MetadataInterface member) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        this.add(member, false);
    }

    @Override
    public void addMemberOrdered(MetadataInterface member) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        this.add(member, true);
    }

    protected void add(MetadataInterface member, boolean ordered) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        Group group = (Group)this._repositoryObject;
        try {
            Object o = member.getRepositoryEntity();
            String myUrl = this._repository.getUrl();
            RepositoryInterface theirRepos = member.getRepository();
            String theirUrl = theirRepos.getUrl();
            int index = myUrl.indexOf(58);
            index = myUrl.indexOf(58, index + 1);
            index = myUrl.indexOf("/", index);
            myUrl = myUrl.substring(0, index);
            if (o instanceof CMetadata && theirUrl.startsWith(myUrl) && (this._repository.getBase().endsWith(((CMetadata)o).getRepositoryID()) || !ordered && ((OMIRepositoryInterface)this._repository).isInChild(member) || ((OMIRepositoryInterface)this._repository).isInParent(member))) {
                AssociationList ass = group.getMembers();
                ass.add(o);
            } else {
                MdObjectStore store = (MdObjectStore)group.getObjectStore();
                MdFactory factory = store.getFactory();
                Document doc = (Document)factory.createComplexMetadataObject(store, null, member.getName(), "Document", group.getRepositoryID());
                doc.setTextRole("Foreign Key");
                doc.setURIType("entitykey");
                doc.setURI(member.getEntityKey());
                doc.getGroups().add((Object)group);
            }
        }
        catch (MdException ex) {
            this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRGroup", ex);
        }
        catch (ServiceException ex) {
            this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRGroup", (Throwable)((Object)ex));
        }
    }

    @Override
    public boolean removeMember(MetadataInterface member) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Group group = (Group)this._repositoryObject;
        try {
            if (member.getRepository().equals(this._repository)) {
                AssociationList ass = group.getMembers();
                return ass.removeElement(member.getRepositoryEntity());
            }
            AssociationList ass = group.getMembers();
            for (Object o : ass) {
                Document doc;
                if (!(o instanceof Document) || !(doc = (Document)o).getTextRole().equalsIgnoreCase("Foreign Key") || !doc.getURI().equals(member.getEntityKey())) continue;
                doc.getGroups().remove((Object)group);
                doc.delete();
                return true;
            }
        }
        catch (MdException ex) {
            this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRGroup", ex);
        }
        catch (ServiceException ex) {
            this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRGroup", (Throwable)((Object)ex));
        }
        return false;
    }

    @Override
    public List getOwners() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Group group = (Group)this._repositoryObject;
        try {
            AssociationList partyList = group.getResponsibleParties();
            Iterator e = partyList.iterator();
            ArrayList<OMRPerson> al = new ArrayList<OMRPerson>(partyList.size());
            while (e.hasNext()) {
                ResponsibleParty rp = (ResponsibleParty)e.next();
                if (!rp.getRole().equalsIgnoreCase("owner")) continue;
                AssociationList assn = rp.getPersons();
                for (Person p : assn) {
                    OMRPerson op = (OMRPerson)this._repository.factoryProcess(p);
                    al.add(op);
                }
            }
            return al;
        }
        catch (MdException ex) {
            this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRGroup", ex);
        }
        catch (ServiceException ex) {
            this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRGroup", (Throwable)((Object)ex));
        }
        return null;
    }

    @Override
    public void addOwner(PersonInterface owner) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Group group = (Group)this._repositoryObject;
        try {
            ResponsibleParty rp2;
            AssociationList ass = group.getResponsibleParties();
            for (ResponsibleParty rp2 : ass) {
                if (!rp2.getRole().equalsIgnoreCase("owner")) continue;
                AssociationList assn = rp2.getPersons();
                assn.add(owner.getRepositoryEntity());
                return;
            }
            MdObjectStore store = (MdObjectStore)group.getObjectStore();
            MdFactory factory = store.getFactory();
            rp2 = (ResponsibleParty)factory.createComplexMetadataObject(store, null, this.getName() + " owner", "ResponsibleParty", group.getRepositoryID());
            rp2.setRole("owner");
            rp2.getPersons().add(owner.getRepositoryEntity());
            ass.add((Object)rp2);
        }
        catch (MdException ex) {
            this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRGroup", ex);
        }
    }

    @Override
    public void removeOwner(PersonInterface owner) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Group group = (Group)this._repositoryObject;
        try {
            AssociationList ass = group.getResponsibleParties();
            for (ResponsibleParty rp : ass) {
                if (!rp.getRole().equalsIgnoreCase("owner")) continue;
                AssociationList assn = rp.getPersons();
                assn.remove(owner.getRepositoryEntity());
                break;
            }
        }
        catch (MdException ex) {
            this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRGroup", ex);
        }
    }

    @Override
    public void delete() throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        Group group = (Group)this._repositoryObject;
        try {
            ArrayList ass = new ArrayList(group.getMembers());
            for (CMetadata cm : ass) {
                if (!(cm instanceof Document) || !((Document)cm).getTextRole().equalsIgnoreCase("Foreign Key")) continue;
                Document doc = (Document)cm;
                doc.delete();
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        super.delete();
    }

    @Override
    public void refresh() throws ServiceException, RemoteException {
        this.checkPulse(true);
        super.refresh();
        this.got_dependents = false;
        if (this._repositoryObject instanceof Group) {
            Group group = (Group)this._repositoryObject;
            try {
                group.getMembers(true);
            }
            catch (MdException e) {
                String msg = RB.getStringResource("OMRGroup.refreshMembers.ex.txt");
                throw new ServiceException(e, msg);
            }
            try {
                group.getResponsibleParties(true);
            }
            catch (MdException e) {
                String msg = RB.getStringResource("OMRGroup.refreshResponsibleParties.ex.txt");
                throw new ServiceException(e, msg);
            }
            try {
                group.getTrees(true);
            }
            catch (MdException e) {
                String msg = RB.getStringResource("OMRGroup.refreshTrees.ex.txt");
                throw new ServiceException(e, msg);
            }
        }
    }

    public PropertyList getLocalizableProperties() {
        return this.getDefaultLocalizableProperties();
    }

    public void setLocalizableProperties(PropertyMap map) {
        this.setDefaultLocalizableProperties(map);
    }
}

