/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.ExternalTable;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.impl.DataTableImpl;
import com.sas.metadata.remote.impl.ExternalTableImpl;
import com.sas.metadata.remote.impl.ExternalTableImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.ExternalTableInterface;
import com.sas.services.information.metadata.FileInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.OMRDataTable;
import com.sas.services.information.metadata.RB;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import org.apache.logging.log4j.Level;

@SASScope
public class OMRExternalFile
extends OMRDataTable
implements ExternalTableInterface {
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);

    public OMRExternalFile() throws RemoteException {
        super(OMRExternalFile.class);
    }

    protected OMRExternalFile(Class c) throws RemoteException {
        super(c);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRExternalFile(ExternalTable o) throws RemoteException {
        super((DataTable)o, OMRExternalFile.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    protected OMRExternalFile(ExternalTable o, Class c) throws RemoteException {
        super((DataTable)o, c);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRExternalFile(ExternalTableImpl o) throws RemoteException {
        super((DataTableImpl)o, OMRExternalFile.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    protected OMRExternalFile(ExternalTableImpl o, Class c) throws RemoteException {
        super((DataTableImpl)o, c);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRExternalFile(ExternalTableImpl_Stub o) throws RemoteException {
        super((DataTable)o, OMRExternalFile.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    protected OMRExternalFile(ExternalTableImpl_Stub o, Class c) throws RemoteException {
        super((DataTable)o, c);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRExternalFile(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        block5: {
            super(OMRExternalFile.class);
            if (repos == null || name == null) {
                throw new IllegalArgumentException();
            }
            try {
                OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
                ExternalTable dataTable = (ExternalTable)omirepository.createMetadata(name, "ExternalTable");
                dataTable.setPublicType("ExternalFile");
                dataTable.setUsageVersion(CURRENT_VERSION.encode());
                this._isCompatible = true;
                this._isReadCompatible = true;
                this._repositoryObject = dataTable;
                this._repositoryFlag = 2;
                this.setRepository(repos);
                if (parent == null) break block5;
                try {
                    parent.addItem(this);
                }
                catch (Exception ex) {
                    dataTable.delete();
                    throw new RuntimeException(ex.getMessage(), ex);
                }
            }
            catch (ServiceException ex) {
                this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRExternalTable", (Throwable)((Object)ex));
            }
        }
    }

    @Override
    public String getType() throws RemoteException {
        ExternalTable table;
        String pt;
        if (this._repositoryObject != null && (pt = (table = (ExternalTable)this._repositoryObject).getPublicType()) != null && pt.length() > 0) {
            return pt;
        }
        return "DataTable";
    }

    @Override
    public FileInterface getOwningFile() throws ServiceException, RemoteException {
        ExternalTable table = (ExternalTable)this._repositoryObject;
        try {
            File file = table.getOwningFile();
            FileInterface fi = (FileInterface)this._repository.factoryProcess(file);
            return fi;
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void setOwningFile(FileInterface file) throws ServiceException, RemoteException {
        ExternalTable table = (ExternalTable)this._repositoryObject;
        File cfile = (File)file.getRepositoryEntity();
        table.setOwningFile(cfile);
    }
}

