/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.DeployedDataPackage;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertyType;
import com.sas.metadata.remote.impl.DeployedDataPackageImpl;
import com.sas.metadata.remote.impl.DirectoryImpl;
import com.sas.metadata.remote.impl.DirectoryImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.DirectoryInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.OMRDeployedDataPackage;
import com.sas.services.information.metadata.RB;
import com.sas.util.UsageVersion;
import java.io.File;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.Level;

@SASScope
public class OMRDirectory
extends OMRDeployedDataPackage
implements DirectoryInterface,
Serializable {
    private static final long serialVersionUID = 191337324452906130L;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);

    public OMRDirectory() throws RemoteException {
        this(OMRDirectory.class);
    }

    public OMRDirectory(Directory o) throws RemoteException {
        this(o, OMRDirectory.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRDirectory(DirectoryImpl o) throws RemoteException {
        this(o, OMRDirectory.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRDirectory(DirectoryImpl_Stub o) throws RemoteException {
        this(o, OMRDirectory.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRDirectory(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        this(repos, name, parent, OMRDirectory.class);
    }

    protected OMRDirectory(Class theClass) throws RemoteException {
        super(theClass);
    }

    protected OMRDirectory(Directory o, Class theClass) throws RemoteException {
        super((DeployedDataPackage)o, theClass);
    }

    protected OMRDirectory(DirectoryImpl o, Class theClass) throws RemoteException {
        super((DeployedDataPackageImpl)o, theClass);
    }

    protected OMRDirectory(DirectoryImpl_Stub o, Class theClass) throws RemoteException {
        super((DeployedDataPackage)o, theClass);
    }

    protected OMRDirectory(RepositoryInterface repos, String name, FolderInterface parent, Class theClass) throws RemoteException {
        super(theClass);
        if (repos == null || name == null) {
            throw new IllegalArgumentException();
        }
        OMIRepositoryInterface omiRepos = null;
        try {
            omiRepos = (OMIRepositoryInterface)repos;
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException(RB.getStringResource("Metadata.wrongrepos.ex.txt"));
        }
        Directory directory = null;
        try {
            directory = (Directory)omiRepos.createMetadata(name, "Directory");
            directory.setUsageVersion(CURRENT_VERSION.encode());
            this._isCompatible = true;
            this._isReadCompatible = true;
        }
        catch (ServiceException svcex) {
            String message = svcex.getMessage();
            throw new IllegalArgumentException(message);
        }
        this._repositoryObject = directory;
        this._repositoryFlag = 2;
        this.setRepository(repos);
        if (parent != null) {
            try {
                parent.addItem(this);
            }
            catch (ServiceException ex) {
                directory.delete();
                throw new RuntimeException(ex.getMessage(), (Throwable)((Object)ex));
            }
        }
    }

    @Override
    public String getType() throws RemoteException {
        return "Directory";
    }

    @Override
    public String getFilePath() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Directory dir = (Directory)this._repositoryObject;
        return dir.getDirectoryName();
    }

    @Override
    public void setPath(String path) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Directory dir = (Directory)this._repositoryObject;
        dir.setDirectoryName(path);
    }

    @Override
    public boolean isRelative() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Directory dir = (Directory)this._repositoryObject;
        return dir.getIsRelative() != 0;
    }

    @Override
    public void setIsRelative(boolean flag) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Directory dir = (Directory)this._repositoryObject;
        dir.setIsRelative(flag ? 1 : 0);
    }

    @Override
    public void setParentDirectory(DirectoryInterface parent) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Directory dir = (Directory)this._repositoryObject;
        if (parent == null) {
            dir.setParent(null);
            dir.setIsRelative(0);
        } else {
            dir.setParent((Directory)parent.getRepositoryEntity());
            dir.setIsRelative(1);
        }
    }

    @Override
    public DirectoryInterface getParentDirectory() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Directory dir = (Directory)this._repositoryObject;
        try {
            Directory parent = dir.getParent();
            if (parent == null) {
                return null;
            }
            return (DirectoryInterface)this._repository.factoryProcess(parent);
        }
        catch (MdException t) {
            throw new ServiceException(t, t.getMessage());
        }
    }

    @Override
    public List getSubdirectories() throws ServiceException, RemoteException {
        ArrayList<MetadataInterface> result = null;
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Directory dir = (Directory)this._repositoryObject;
        try {
            AssociationList subdirlist = dir.getSubDirectories();
            if (subdirlist.size() == 0) {
                result = Collections.EMPTY_LIST;
            } else {
                result = new ArrayList<MetadataInterface>(subdirlist.size());
                Iterator it = subdirlist.iterator();
                while (it.hasNext()) {
                    result.add(this._repository.factoryProcess(it.next()));
                }
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        return result;
    }

    @Override
    public List getFiles() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        try {
            Directory dir = (Directory)this._repositoryObject;
            AssociationList files = dir.getFiles();
            ArrayList<MetadataInterface> result = new ArrayList<MetadataInterface>(files.size());
            Iterator it = files.iterator();
            while (it.hasNext()) {
                MetadataInterface mi = this._repository.factoryProcess(it.next());
                result.add(mi);
            }
            return result;
        }
        catch (MdException t) {
            throw new ServiceException(t, t.getMessage());
        }
    }

    @Override
    public void addFile(MetadataInterface file) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        try {
            Directory dir = (Directory)this._repositoryObject;
            AssociationList files = dir.getFiles();
            files.add(file.getRepositoryEntity());
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void removeFile(MetadataInterface file) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        try {
            Directory dir = (Directory)this._repositoryObject;
            AssociationList files = dir.getFiles();
            files.remove(file.getRepositoryEntity());
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public List getServers() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        try {
            Directory dir = (Directory)this._repositoryObject;
            AssociationList servers = dir.getDeployedComponents();
            ArrayList<MetadataInterface> result = new ArrayList<MetadataInterface>(servers.size());
            Iterator serverIt = servers.iterator();
            while (serverIt.hasNext()) {
                MetadataInterface mi = this._repository.factoryProcess(serverIt.next());
                result.add(mi);
            }
            return result;
        }
        catch (MdException ex) {
            this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRDirectory", ex);
        }
        catch (ServiceException ex) {
            this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRDirectory", (Throwable)((Object)ex));
        }
        return null;
    }

    @Override
    public void addServer(MetadataInterface server) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        try {
            Directory dir = (Directory)this._repositoryObject;
            AssociationList servers = dir.getDeployedComponents();
            servers.add(server.getRepositoryEntity());
            dir.setDeployedComponents(servers);
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void removeServer(MetadataInterface server) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        try {
            Directory dir = (Directory)this._repositoryObject;
            AssociationList servers = dir.getDeployedComponents();
            servers.remove(server.getRepositoryEntity());
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public boolean isBasePath() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        try {
            Directory dir = (Directory)this._repositoryObject;
            AssociationList properties = dir.getProperties();
            for (Property prop : properties) {
                if (!prop.getName().equalsIgnoreCase("Http Server Base Path") && !prop.getPropertyName().equalsIgnoreCase("HttpServerBasePath")) continue;
                return prop.getDefaultValue().equals("1") || prop.getDefaultValue().equalsIgnoreCase("true");
            }
        }
        catch (MdException ex) {
            this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRDirectory", ex);
        }
        return false;
    }

    @Override
    public void setIsBasePath(boolean value) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        try {
            Directory dir = (Directory)this._repositoryObject;
            AssociationList properties = dir.getProperties();
            for (Property prop : properties) {
                if (!prop.getName().equalsIgnoreCase("Http Server Base Path") && !prop.getPropertyName().equalsIgnoreCase("HttpServerBasePath")) continue;
                prop.setDefaultValue(String.valueOf(value));
                return;
            }
            MdObjectStore store = (MdObjectStore)dir.getObjectStore();
            MdFactory factory = store.getFactory();
            Property prop = (Property)factory.createComplexMetadataObject(store, null, "Http Server Base Path", "Property", dir.getRepositoryID());
            prop.setName("Http Server Base Path");
            prop.setPropertyName("HttpServerBasePath");
            prop.setDefaultValue(String.valueOf(value));
            PropertyType propType = (PropertyType)factory.createComplexMetadataObject(store, null, "Boolean", "PropertyType", dir.getRepositoryID());
            propType.setSQLType(-7);
            prop.setOwningType(propType);
            properties.add((Object)prop);
        }
        catch (MdException ex) {
            this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRDirectory", ex);
        }
    }

    @Override
    public boolean isDavEnabled() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        try {
            Directory dir = (Directory)this._repositoryObject;
            AssociationList properties = dir.getProperties();
            for (Property prop : properties) {
                if (!prop.getName().equalsIgnoreCase("Supports WebDAV") && !prop.getPropertyName().equalsIgnoreCase("SupportsWebDAV")) continue;
                String value = prop.getDefaultValue();
                if (value.equals("1")) {
                    value = "true";
                } else if (value.equals("0")) {
                    value = "false";
                }
                return Boolean.valueOf(value);
            }
        }
        catch (MdException ex) {
            this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRDirectory", ex);
        }
        return false;
    }

    @Override
    public void setIsDavEnabled(boolean value) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        try {
            Directory dir = (Directory)this._repositoryObject;
            AssociationList properties = dir.getProperties();
            for (Property prop : properties) {
                if (!prop.getName().equalsIgnoreCase("Supports WebDAV") && !prop.getPropertyName().equalsIgnoreCase("SupportsWebDAV")) continue;
                prop.setDefaultValue(String.valueOf(value));
                return;
            }
            MdObjectStore store = (MdObjectStore)dir.getObjectStore();
            MdFactory factory = store.getFactory();
            Property prop = (Property)factory.createComplexMetadataObject(store, null, "Supports WebDAV", "Property", dir.getRepositoryID());
            prop.setName("Supports WebDAV");
            prop.setPropertyName("SupportsWebDAV");
            prop.setDefaultValue(String.valueOf(value));
            PropertyType propType = (PropertyType)factory.createComplexMetadataObject(store, null, "Boolean", "PropertyType", dir.getRepositoryID());
            propType.setSQLType(-7);
            prop.setOwningType(propType);
            properties.add((Object)prop);
        }
        catch (MdException ex) {
            this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRDirectory", ex);
        }
    }

    @Override
    public String getDirectoryRole() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Directory dir = (Directory)this._repositoryObject;
        return dir.getDirectoryRole();
    }

    @Override
    public void setDirectoryRole(String role) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Directory dir = (Directory)this._repositoryObject;
        dir.setDirectoryRole(role);
    }

    @Override
    public String getAbsolutePath() throws ServiceException, RemoteException {
        String trimmedParent;
        String trimmedPath;
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        String filePath = this.getFilePath();
        if (!this.isRelative()) {
            return filePath;
        }
        DirectoryInterface parent = this.getParentDirectory();
        String parentPath = parent.getAbsolutePath();
        String separator = this.findSeparator(parentPath);
        if (separator.length() == 0) {
            separator = this.findSeparator(filePath);
        }
        if (separator.length() == 0) {
            separator = File.separator;
        }
        if ((trimmedPath = filePath).startsWith(separator)) {
            trimmedPath = filePath.substring(1);
        }
        if ((trimmedParent = parentPath).endsWith(separator)) {
            trimmedParent = parentPath.substring(0, parentPath.length() - 1);
        }
        return trimmedParent + separator + trimmedPath;
    }

    private String findSeparator(String path) {
        if (path == null || path.length() == 0) {
            return "";
        }
        int indexslash = path.indexOf(47);
        int indexback = path.indexOf("\\");
        if (indexslash == -1 && indexback == -1) {
            return "";
        }
        if (indexslash == -1) {
            return "\\";
        }
        return "/";
    }
}

