/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AccessControlTemplate;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.impl.AccessControlTemplateImpl;
import com.sas.metadata.remote.impl.AccessControlTemplateImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.AccessControlTemplateInterface;
import com.sas.services.information.metadata.AuthorizationBaseInterface;
import com.sas.services.information.metadata.AuthorizationUtil;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.RB;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@SASScope
public class OMRAccessControlTemplate
extends Metadata
implements AccessControlTemplateInterface {
    private static final long serialVersionUID = 1L;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);
    private AuthorizationBaseInterface ACTAuthorizationDefinition = null;

    public OMRAccessControlTemplate() throws RemoteException {
        super(OMRAccessControlTemplate.class);
    }

    public OMRAccessControlTemplate(AccessControlTemplate o) throws RemoteException {
        super(o, OMRAccessControlTemplate.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRAccessControlTemplate(AccessControlTemplateImpl o) throws RemoteException {
        super(o, OMRAccessControlTemplate.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRAccessControlTemplate(AccessControlTemplateImpl_Stub o) throws RemoteException {
        super(o, OMRAccessControlTemplate.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRAccessControlTemplate(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        super(OMRAccessControlTemplate.class);
        if (repos == null || name == null) {
            throw new IllegalArgumentException();
        }
        OMIRepositoryInterface omiRepos = null;
        try {
            omiRepos = (OMIRepositoryInterface)repos;
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException(RB.getStringResource("Metadata.wrongrepos.ex.txt"));
        }
        AccessControlTemplate act = null;
        try {
            act = (AccessControlTemplate)omiRepos.createMetadata(name, "AccessControlTemplate");
            act.setUsageVersion(CURRENT_VERSION.encode());
            act.setPublicType("ACT");
            this._isCompatible = true;
            this._isReadCompatible = true;
        }
        catch (ServiceException sex) {
            String message = sex.getMessage();
            throw new IllegalArgumentException(message);
        }
        this._repositoryObject = act;
        this._repositoryFlag = 2;
        this.setRepository(repos);
        if (parent != null) {
            try {
                parent.addItem(this);
            }
            catch (ServiceException ex) {
                act.delete();
                throw new RuntimeException(ex.getMessage(), (Throwable)((Object)ex));
            }
        }
    }

    @Override
    public List getAccessControlItems() throws ServiceException, RemoteException {
        ArrayList<MetadataInterface> results = null;
        AccessControlTemplate act = (AccessControlTemplate)this._repositoryObject;
        try {
            AssociationList itemList = act.getAccessControlItems();
            if (itemList.size() == 0) {
                return Collections.EMPTY_LIST;
            }
            results = new ArrayList<MetadataInterface>(itemList.size());
            Iterator it = itemList.iterator();
            while (it.hasNext()) {
                results.add(this._repository.factoryProcess(it.next()));
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        return results;
    }

    @Override
    public List getObjects() throws ServiceException, RemoteException {
        ArrayList<MetadataInterface> results = null;
        AccessControlTemplate act = (AccessControlTemplate)this._repositoryObject;
        try {
            AssociationList itemList = act.getObjects();
            if (itemList.size() == 0) {
                return Collections.EMPTY_LIST;
            }
            results = new ArrayList<MetadataInterface>(itemList.size());
            Iterator it = itemList.iterator();
            while (it.hasNext()) {
                results.add(this._repository.factoryProcess(it.next()));
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        return results;
    }

    @Override
    public String getUse() throws ServiceException, RemoteException {
        AccessControlTemplate act = (AccessControlTemplate)this._repositoryObject;
        return act.getUse();
    }

    @Override
    public void setUse(String use) throws ServiceException, RemoteException {
        AccessControlTemplate act = (AccessControlTemplate)this._repositoryObject;
        act.setUse(use);
    }

    @Override
    public AuthorizationBaseInterface getAuthorizationDefinitionUtil() throws ServiceException, RemoteException {
        try {
            if (this.ACTAuthorizationDefinition == null) {
                this.ACTAuthorizationDefinition = new AuthorizationUtil(this, true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.ACTAuthorizationDefinition;
    }

    @Override
    public String getType() throws RemoteException {
        return "ACT";
    }
}

