/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.services.information.Filter;

public class MessageQueueFilter
extends Filter {
    private static final long serialVersionUID = 1171336300641063085L;
    private static final int TEMPLATE_LENGTH = 200;
    private static final int SELECT_LENGTH = 200;
    private String[] _queueManagerClassIdentifiers;
    private String _queueManagerID;
    private String _queueID;
    private String _queueName;

    public MessageQueueFilter() {
    }

    public MessageQueueFilter(String repositoryId) {
        this.setOMRRepository(repositoryId);
    }

    public MessageQueueFilter(String repositoryId, String[] classIdentifiers) {
        this(repositoryId);
        this.setQueueManagerClassIdentifiers(classIdentifiers);
    }

    public MessageQueueFilter(String key, int relation, String value) {
        super(key, relation, value);
        this.setType("MessageQueue");
    }

    public final String getQueueID() {
        return this._queueID;
    }

    public final void setQueueID(String queueID) {
        this._queueID = queueID;
    }

    public final String getQueueName() {
        return this._queueName;
    }

    public final void setQueueName(String queueName) {
        this._queueName = queueName;
    }

    public final String getQueueManagerID() {
        return this._queueManagerID;
    }

    public final void setQueueManagerID(String queueManagerID) {
        this._queueManagerID = queueManagerID;
    }

    public final String[] getQueueManagerClassIdentifiers() {
        int length = this._queueManagerClassIdentifiers == null ? 0 : this._queueManagerClassIdentifiers.length;
        String[] classIdentifiers = new String[length];
        if (length > 0) {
            System.arraycopy(this._queueManagerClassIdentifiers, 0, classIdentifiers, 0, length);
        }
        return classIdentifiers;
    }

    public final void setQueueManagerClassIdentifiers(String[] classIdentifiers) {
        int length = classIdentifiers == null ? 0 : classIdentifiers.length;
        this._queueManagerClassIdentifiers = new String[length];
        if (length > 0) {
            System.arraycopy(classIdentifiers, 0, this._queueManagerClassIdentifiers, 0, length);
        }
    }

    @Override
    public String getOMRType() {
        return "Transformation";
    }

    @Override
    public String getXMLSelectString() {
        boolean hasQueueManagerAttributes;
        StringBuffer template = new StringBuffer(200);
        template.append("<Templates>\n");
        template.append("  <Transformation Name=\"\" TransformRole=\"\">\n");
        template.append("    <DeployedComponents>\n");
        template.append("      <ServerComponent Name=\"\" ClassIdentifier=\"\">\n");
        template.append("        <SourceConnections/>\n");
        template.append("      </ServerComponent>\n");
        template.append("    </DeployedComponents>\n");
        template.append("  </Transformation>\n");
        template.append("  <TCPIPConnection ApplicationProtocol=\"\" HostName=\"\" Port=\"\"/>\n");
        template.append("</Templates>");
        this.setOMRTemplate(template.toString());
        StringBuffer buffer = new StringBuffer(200);
        buffer.append("<XMLSelect Search=\"*[@TransformRole='");
        buffer.append("SASMessageQueue");
        buffer.append('\'');
        if (this._queueName != null) {
            buffer.append(" and @Name='");
            buffer.append(this._queueName);
            buffer.append('\'');
        }
        if (this._queueID != null) {
            buffer.append(" and @Id='");
            buffer.append(this._queueID);
            buffer.append('\'');
        }
        buffer.append(']');
        int numClassIds = this._queueManagerClassIdentifiers == null ? 0 : this._queueManagerClassIdentifiers.length;
        boolean bl = hasQueueManagerAttributes = this._queueManagerID != null || numClassIds > 0;
        if (hasQueueManagerAttributes) {
            buffer.append("[DeployedComponents/*[");
        }
        if (this._queueManagerID != null) {
            buffer.append("@Id='");
            buffer.append(this._queueManagerID);
            buffer.append('\'');
            if (numClassIds > 0) {
                buffer.append(" and ");
            }
        }
        if (numClassIds > 0) {
            boolean multipleIDs;
            int index = numClassIds - 1;
            boolean bl2 = multipleIDs = numClassIds > 1;
            if (multipleIDs) {
                buffer.append('(');
            }
            while (index > -1) {
                buffer.append("@ClassIdentifier='");
                buffer.append(this._queueManagerClassIdentifiers[index--]);
                buffer.append('\'');
                if (index <= -1) continue;
                buffer.append(" or ");
            }
            if (multipleIDs) {
                buffer.append(')');
            }
        }
        if (hasQueueManagerAttributes) {
            buffer.append("]]");
        }
        buffer.append("\"/>");
        return buffer.length() > 0 ? buffer.toString() : "";
    }

    @Override
    public String getDAVBasicSearchString() {
        return "UNSUPPORTED";
    }

    @Override
    public String getDAVSQLString() {
        return "UNSUPPORTED";
    }
}

