/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.OMIServer;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.MetadataNameConstraint;
import com.sas.services.information.metadata.RB;
import com.sas.services.information.metadata.RootFolderInterface;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.services.util.Names;
import com.sas.services.util.XMLUtil;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class FolderUtil {
    private static final String SHARED_DATA = "Shared Data";
    private static final String ORPHANED_CUBES = "Orphaned Cubes";
    private static final String ORPHANED_TABLES = "Orphaned Tables";
    private static final String DOCUMENTS = "Documents";
    private static final String NOTES = "Notes";
    private static final String SYSTEM = "System";
    private static final String SYSTEM_FOLDER_TYPE = "System";
    private static final String FOLDER_SUBTYPE = "Folder.";
    private static final int MAX_NAME_LENGTH = 60;

    public static FolderInterface getSharedDataFolder(MetadataInterface object) throws ServiceException, RemoteException {
        return FolderUtil.getTopLevelFolder(SHARED_DATA, object);
    }

    public static FolderInterface getSystemFolder(MetadataInterface object) throws ServiceException, RemoteException {
        return FolderUtil.getTopLevelFolder("System", object);
    }

    public static FolderInterface makeSharedDataFolder(MetadataInterface object) throws ServiceException, RemoteException {
        return FolderUtil.makeTopLevelFolder(SHARED_DATA, object, false);
    }

    public static FolderInterface makeDocumentsFolder(MetadataInterface object) throws ServiceException, RemoteException {
        return FolderUtil.makeTopLevelFolder(DOCUMENTS, object, false);
    }

    public static FolderInterface makeNotesFolder(MetadataInterface object) throws ServiceException, RemoteException {
        return FolderUtil.makeTopLevelFolder(NOTES, object, false);
    }

    public static FolderInterface makeSystemFolder(MetadataInterface object) throws ServiceException, RemoteException {
        return FolderUtil.makeTopLevelFolder("System", object, true);
    }

    public static FolderInterface getTopLevelFolder(String name, MetadataInterface object) throws ServiceException, RemoteException {
        FolderInterface folder = null;
        OMIRepositoryInterface repos = (OMIRepositoryInterface)object.getRepository();
        String reposType = repos.getRepositoryType();
        if (reposType.equals("FOUNDATION")) {
            folder = repos.getRootFolder(name);
        } else if (reposType.equals("CUSTOM")) {
            List folders = repos.getRootFolders();
            if (folders.size() <= 0) {
                throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"FolderUtil.NoRootFolder.fmt.txt", (Object)repos.getDefaultRepositoryName()));
            }
            FolderInterface rootFolder = (FolderInterface)folders.get(0);
            folder = rootFolder.getSubfolder(name);
        } else {
            FolderInterface parentFolder = object.getParent();
            if (parentFolder != null) {
                folder = FolderUtil.getTopLevelFolder(name, parentFolder);
            }
        }
        return folder;
    }

    public static FolderInterface makeTopLevelFolder(String name, MetadataInterface object, boolean systemFolder) throws ServiceException, RemoteException {
        FolderInterface folder = null;
        OMIRepositoryInterface repos = (OMIRepositoryInterface)object.getRepository();
        String reposType = repos.getRepositoryType();
        if (reposType.equalsIgnoreCase("FOUNDATION")) {
            RootFolderInterface root = ((OMIServer)repos.getServer()).getRootFolder();
            folder = root.makeSubfolder(name);
        } else if (reposType.equalsIgnoreCase("CUSTOM")) {
            List folders = repos.getRootFolders();
            if (folders.size() <= 0) {
                throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"FolderUtil.NoRootFolder.fmt.txt", (Object)repos.getDefaultRepositoryName()));
            }
            FolderInterface rootFolder = (FolderInterface)folders.get(0);
            folder = rootFolder.makeSubfolder(name);
        } else {
            FolderInterface parentFolder = object.getParent();
            if (parentFolder != null) {
                folder = FolderUtil.makeTopLevelFolder(name, parentFolder, systemFolder);
            }
        }
        if (folder.getState() == 1) {
            if (systemFolder) {
                folder.setFolderType("System");
            }
            folder.update();
        }
        return folder;
    }

    public static String makeValidObjectName(FolderInterface folder, MetadataInterface object) throws ServiceException, RemoteException {
        return FolderUtil.makeValidObjectName(folder, object, null);
    }

    public static String makeValidObjectName(FolderInterface folder, MetadataInterface object, MetadataNameConstraint constraint) throws ServiceException, RemoteException {
        String newName = object.getName();
        boolean bRenamed = false;
        if (!Names.validateOMRObjectName(newName, false)) {
            newName = Names.mapNameToOMRObjectName(newName);
            bRenamed = true;
        }
        FolderInterface parentFolder = object.getParent();
        boolean validName = false;
        String type = object.getType();
        FolderInterface target = folder;
        if (folder == null && parentFolder != null) {
            target = parentFolder;
        }
        if (parentFolder != null && target != null && target.getReposId().equalsIgnoreCase(parentFolder.getReposId())) {
            if (bRenamed) {
                if (!target.hasDuplicate(newName, type)) {
                    validName = true;
                }
            } else if (target.isItemNameUnique(object)) {
                validName = true;
            }
        } else if (target == null) {
            validName = true;
        } else if (!target.hasDuplicate(newName, type)) {
            validName = true;
        }
        if (constraint != null && !constraint.isNameValid(object, newName)) {
            validName = false;
        }
        if (!validName) {
            String baseName = newName;
            List members = target.getItems();
            Iterator iter = members.iterator();
            HashSet<String> membersOfInterest = new HashSet<String>();
            String tempName = baseName.toLowerCase();
            if (tempName.length() > 53) {
                tempName = tempName.substring(0, 53);
            }
            while (iter.hasNext()) {
                String name;
                MetadataInterface obj = (MetadataInterface)iter.next();
                String objType = obj.getType();
                if (!objType.equals(type) && !objType.startsWith(type + ".") || !(name = obj.getName().toLowerCase()).startsWith(tempName)) continue;
                membersOfInterest.add(name);
            }
            int count = 0;
            do {
                if (++count >= 10000) {
                    throw new ServiceException("Unable to create unique object name.  Too many name collisions.");
                }
                newName = baseName + "(" + Integer.toString(count) + ")";
                if (newName.length() > 60) {
                    baseName = baseName.substring(0, baseName.length() + 60 - newName.length());
                    newName = baseName + "(" + Integer.toString(count) + ")";
                }
                if (membersOfInterest.contains(newName.toLowerCase()) || constraint != null && !constraint.isNameValid(object, newName)) continue;
                validName = true;
            } while (!validName);
        }
        return newName;
    }

    public static String makeValidFolderName(FolderInterface folder, MetadataNameConstraint constraint) throws ServiceException, RemoteException {
        FolderInterface parentFolder = folder.getParent();
        return FolderUtil.makeValidFolderName(folder.getName(), parentFolder, constraint, true);
    }

    public static String makeValidFolderName(String folderName, FolderInterface parentFolder, MetadataNameConstraint constraint) throws ServiceException, RemoteException {
        return FolderUtil.makeValidFolderName(folderName, parentFolder, constraint, false);
    }

    private static String makeValidFolderName(String folderName, FolderInterface parentFolder, MetadataNameConstraint constraint, boolean folderExists) throws ServiceException, RemoteException {
        String newName = folderName;
        boolean bRenamed = false;
        if (!Names.validateOMRObjectName(newName, false)) {
            newName = Names.mapNameToOMRObjectName(newName);
            bRenamed = true;
        }
        boolean validName = false;
        String baseName = newName;
        if (parentFolder != null) {
            if (bRenamed) {
                if (!parentFolder.hasDuplicateSubfolder(newName)) {
                    validName = true;
                }
            } else {
                validName = folderExists ? FolderUtil.isFolderNameUnique(parentFolder, newName) : !parentFolder.hasDuplicateSubfolder(newName);
            }
        } else {
            validName = true;
        }
        if (constraint != null && !constraint.isNameValid(parentFolder, newName)) {
            validName = false;
        }
        int count = 0;
        while (!validName) {
            if (++count > 999) {
                throw new ServiceException("Unable to make valid unique name for folder " + folderName);
            }
            newName = baseName + "(" + Integer.toString(count) + ")";
            if (newName.length() > 60) {
                baseName = baseName.substring(0, baseName.length() + 60 - newName.length());
                newName = baseName + "(" + Integer.toString(count) + ")";
            }
            if (!parentFolder.hasDuplicateSubfolder(newName)) {
                validName = true;
            }
            if (constraint == null || constraint.isNameValid(parentFolder, newName)) continue;
            validName = false;
        }
        return newName;
    }

    public static boolean isFolderNameUnique(FolderInterface parentFolder, String folderName) throws ServiceException, RemoteException {
        int count;
        String normalizedFolderName = XMLUtil.normalize(folderName);
        OMIRepositoryInterface repos = (OMIRepositoryInterface)parentFolder.getRepository();
        Filter filter = new Filter();
        filter.setType("Tree");
        if (parentFolder instanceof RootFolderInterface) {
            filter.setExplicitSearchString("omi", "<XMLSelect search=\"*[@Name='" + normalizedFolderName + "'][SoftwareComponents/SoftwareComponent[@Id='" + parentFolder.getReposId() + "']]\" />");
            MetadataServerInterface server = (MetadataServerInterface)repos.getServer();
            count = server.getCountNoSecurity(filter, null);
        } else {
            filter.setExplicitSearchString("omi", "<XMLSelect search=\"*[@Id='" + parentFolder.getReposId() + "']\" />");
            filter.setOMRTemplate("<Templates><Tree><SubTrees search=\"Tree[@Name='" + normalizedFolderName + "']\" /></Tree></Templates>");
            count = repos.getCountNoSecurity(filter, "SubTrees");
        }
        return count == 1;
    }

    public static boolean isSystemFolder(FolderInterface folder) throws ServiceException, RemoteException {
        if ("System".equalsIgnoreCase(folder.getName())) {
            OMIRepositoryInterface repos = (OMIRepositoryInterface)folder.getRepository();
            if (repos == null) {
                return false;
            }
            RootFolderInterface rootFolder = repos.getServer().getRootFolder();
            String type = repos.getRepositoryType();
            if ("FOUNDATION".equalsIgnoreCase(type)) {
                return folder.getParent().equals(rootFolder);
            }
            if ("CUSTOM".equalsIgnoreCase(type)) {
                List reposTopLevelFolders = rootFolder.getSASFolders(repos);
                if (reposTopLevelFolders != null && !reposTopLevelFolders.isEmpty()) {
                    for (FolderInterface topLevelFolder : reposTopLevelFolders) {
                        String id = topLevelFolder.getIdentifier();
                        if (!id.equalsIgnoreCase(folder.getParent().getIdentifier())) continue;
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    public static boolean isDIStudioUngroupedFolder(FolderInterface folder) throws ServiceException, RemoteException {
        FolderInterface parent;
        return folder != null && folder.getName().equals("Ungrouped") && !FolderUtil.isInProjectRepository(null, folder) && (parent = folder.getParent()) != null && parent.getName().equals("SAS Data Integration Studio Custom Tree");
    }

    public static boolean isFolder(PublicObjectInterface object) throws ServiceException, RemoteException {
        TypeDescriptorInterface type = object.getTypeDescriptor();
        if (type != null) {
            String typeName = type.getTypeName();
            return FolderUtil.isFolder(typeName);
        }
        return false;
    }

    public static boolean isFolder(String publicType) {
        return publicType == null ? false : publicType.equalsIgnoreCase("Folder") || publicType.startsWith(FOLDER_SUBTYPE);
    }

    public static boolean isInProjectRepository(MetadataInterface mi, FolderInterface folder) throws ServiceException, RemoteException {
        OMIRepositoryInterface omiRepos;
        boolean returnValue = false;
        RepositoryInterface repos = null;
        if (mi != null && (repos = mi.getRepository()) != null && repos instanceof OMIRepositoryInterface && "PROJECT".equals((omiRepos = (OMIRepositoryInterface)repos).getRepositoryType())) {
            returnValue = true;
        }
        if (!returnValue && folder != null && (repos = folder.getRepository()) != null && repos instanceof OMIRepositoryInterface && "PROJECT".equals((omiRepos = (OMIRepositoryInterface)repos).getRepositoryType())) {
            returnValue = true;
        }
        return returnValue;
    }

    public static FolderInterface makeOrphanedCubesFolder(MetadataInterface object) throws ServiceException, RemoteException {
        FolderInterface sharedDataFolder = FolderUtil.makeSharedDataFolder(object);
        if (sharedDataFolder == null) {
            return null;
        }
        return sharedDataFolder.makeSubfolder(ORPHANED_CUBES);
    }

    public static FolderInterface makeOrphanedTablesFolder(MetadataInterface object) throws ServiceException, RemoteException {
        FolderInterface sharedDataFolder = FolderUtil.makeSharedDataFolder(object);
        if (sharedDataFolder == null) {
            return null;
        }
        return sharedDataFolder.makeSubfolder(ORPHANED_TABLES);
    }
}

