/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.browse;

import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.services.information.metadata.FolderUtil;
import com.sas.services.information.publicobject.ResponsibilityDetails;
import com.sas.util.UsageVersion;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BrowseMetadataUtil {
    private static final String PROPERTY_DISPLAY_NAME = "DisplayName";
    private static final String PROPERTY_USAGEVERSION = "UsageVersion";
    private static final String PROPERTY_EXTENSIONS_VALUE = "Value";
    private static final String PROPERTY_EXTENSIONS = "Extensions";
    private static final String PROPERTY_KEYWORDS = "Keywords";
    private static final String PROPERTY_RESPONSIBLE_PARTIES = "ResponsibleParties";

    public static String getPublicType(BrowseMetadataInterface browse) {
        return (String)browse.getRawData().get("PublicType");
    }

    public static UsageVersion getUsageVersion(BrowseMetadataInterface browse) {
        String version = (String)browse.get(PROPERTY_USAGEVERSION);
        if (version != null && version.length() > 0) {
            return UsageVersion.decode((double)Double.parseDouble(version));
        }
        return null;
    }

    public static String getDisplayName(BrowseMetadataInterface browse) {
        String displayName = (String)browse.get(PROPERTY_DISPLAY_NAME);
        if (displayName != null && displayName.length() > 0) {
            return displayName;
        }
        return browse.getName();
    }

    public static List<String> getKeywords(BrowseMetadataInterface browse) {
        ArrayList<String> result = null;
        List keywordList = (List)browse.get(PROPERTY_KEYWORDS);
        if (keywordList != null && keywordList.size() > 0) {
            result = new ArrayList<String>(keywordList.size());
            for (BrowseMetadataInterface keyword : keywordList) {
                String keywordText = (String)keyword.get("Name");
                if (keywordText == null || keywordText.trim().length() <= 0) continue;
                result.add(keywordText);
            }
        }
        return result;
    }

    public static Map<String, String> getExtendedAttributes(BrowseMetadataInterface browse) {
        HashMap<String, String> result = new HashMap<String, String>();
        List extensionList = (List)browse.get(PROPERTY_EXTENSIONS);
        if (extensionList != null && extensionList.size() > 0) {
            for (BrowseMetadataInterface nextExtension : extensionList) {
                result.put(nextExtension.getName(), (String)nextExtension.get(PROPERTY_EXTENSIONS_VALUE));
            }
        }
        return result;
    }

    public static String getModifiedBy(BrowseMetadataInterface browse) {
        ResponsibilityDetails details = BrowseMetadataUtil.getModifiedByDetails(browse);
        return details == null ? null : details.getName();
    }

    public static ResponsibilityDetails getModifiedByDetails(BrowseMetadataInterface browse) {
        return BrowseMetadataUtil.getCreatedModifiedByInfo(browse, "Modified By");
    }

    public static String getCreatedBy(BrowseMetadataInterface browse) {
        ResponsibilityDetails details = BrowseMetadataUtil.getCreatedByDetails(browse);
        return details == null ? null : details.getName();
    }

    public static ResponsibilityDetails getCreatedByDetails(BrowseMetadataInterface browse) {
        return BrowseMetadataUtil.getCreatedModifiedByInfo(browse, "Created By");
    }

    private static ResponsibilityDetails getCreatedModifiedByInfo(BrowseMetadataInterface browse, String role) {
        List<ResponsibilityDetails> responsibilities = BrowseMetadataUtil.getResponsibilities(browse, true);
        if (responsibilities != null) {
            for (ResponsibilityDetails responsibility : responsibilities) {
                if (!role.equalsIgnoreCase(responsibility.getRole())) continue;
                return responsibility;
            }
        }
        return null;
    }

    public static List<ResponsibilityDetails> getResponsibilities(BrowseMetadataInterface browse) {
        return BrowseMetadataUtil.getResponsibilities(browse, false);
    }

    private static List<ResponsibilityDetails> getResponsibilities(BrowseMetadataInterface browse, boolean includeCreatedModifiedByRoles) {
        ArrayList<ResponsibilityDetails> responsibilities = new ArrayList<ResponsibilityDetails>();
        List respPartiesList = (List)browse.get(PROPERTY_RESPONSIBLE_PARTIES);
        if (respPartiesList != null && respPartiesList.size() > 0) {
            for (BrowseMetadataInterface respParty : respPartiesList) {
                List persons;
                String role = (String)respParty.get("Role");
                if (!includeCreatedModifiedByRoles && ("Created By".equalsIgnoreCase(role) || "Modified By".equalsIgnoreCase(role)) || (persons = (List)respParty.get("Persons")) == null || persons.size() <= 0) continue;
                BrowseMetadataInterface person = (BrowseMetadataInterface)persons.get(0);
                String name = person.getName();
                String userName = (String)person.get(PROPERTY_DISPLAY_NAME);
                if (userName == null || userName.length() == 0) {
                    userName = name;
                }
                responsibilities.add(new ResponsibilityDetails(name, userName, role));
            }
        }
        return responsibilities;
    }

    public static String getDisplayPath(BrowseMetadataInterface browse) {
        String publicType = BrowseMetadataUtil.getPublicType(browse);
        if ("RootFolder".equalsIgnoreCase(publicType)) {
            return "/";
        }
        ArrayList<BrowseMetadataInterface> ancestors = new ArrayList<BrowseMetadataInterface>(5);
        try {
            BrowseMetadataInterface parent = BrowseMetadataUtil.getParent(browse);
            while (parent != null) {
                ancestors.add(parent);
                parent = BrowseMetadataUtil.getParent(parent);
            }
        }
        catch (IllegalStateException e) {
            return null;
        }
        StringBuilder path = new StringBuilder();
        Collections.reverse(ancestors);
        for (BrowseMetadataInterface ancestor : ancestors) {
            path.append('/').append(ancestor.getName());
        }
        path.append('/').append(browse.getName());
        return path.toString();
    }

    public static String getAbsolutePath(BrowseMetadataInterface browse) {
        String publicType;
        String path = BrowseMetadataUtil.getDisplayPath(browse);
        if (path != null && (publicType = BrowseMetadataUtil.getPublicType(browse)) != null && publicType.length() > 0) {
            int index = publicType.indexOf(".");
            if (index > -1) {
                publicType = publicType.substring(0, index);
            }
            if ("RootFolder".equalsIgnoreCase(publicType)) {
                publicType = "Folder";
            }
            path = path + "(" + publicType + ")";
        }
        return path;
    }

    private static BrowseMetadataInterface getParent(BrowseMetadataInterface browse) {
        BrowseMetadataInterface result;
        String publicType;
        BrowseMetadataInterface parent = null;
        List parents = (List)browse.get("ParentTree");
        if (parents == null || parents.isEmpty()) {
            parents = (List)browse.get("Trees");
        }
        if (parents != null && !parents.isEmpty() && FolderUtil.isFolder(publicType = BrowseMetadataUtil.getPublicType(result = (BrowseMetadataInterface)parents.get(0)))) {
            parent = result;
        }
        if (parent == null) {
            parents = (List)browse.get("SoftwareComponents");
            if (parents == null || parents.isEmpty()) {
                throw new IllegalStateException("Missing parent for " + browse.getName());
            }
            boolean validSC = false;
            for (BrowseMetadataInterface bmi : parents) {
                if (!"RootFolder".equalsIgnoreCase(BrowseMetadataUtil.getPublicType(bmi))) continue;
                validSC = true;
                break;
            }
            if (!validSC) {
                throw new IllegalStateException("Invalid root folder association");
            }
        }
        return parent;
    }
}

