/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information;

import com.sas.codepolicy.SASScope;
import com.sas.entities.GUID;
import com.sas.services.MergePolicy;
import com.sas.services.ServiceConfigurationException;
import com.sas.services.deployment.ConsumedResourceInterface;
import com.sas.services.information.FactoryAction;
import com.sas.services.information.InformationServiceInitObject;
import com.sas.services.information.RB;
import com.sas.text.Message;
import com.sas.util.Strings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@SASScope
public final class SmartDef
implements Cloneable,
ConsumedResourceInterface,
Serializable {
    private static final long serialVersionUID = -4022734706140815350L;
    static final String ELEMENT_NAME = "SmartObject";
    static final String ATTRIBUTE_UID = "uid";
    static final String ATTRIBUTE_SMARTTYPE = "smartType";
    static final String ATTRIBUTE_INTERFACE = "interface";
    static final String ELEMENT_FILTER_NAME = "Filter";
    static final String ATTRIBUTE_FILTER_CLASS = "class";
    private static final String TOKEN_DELIMITER = "::";
    private static final int COLLECTION_INIT = 8;
    private static final int HASHCODE_PRIME = 31;
    private String _id = GUID.newGUID();
    private String _smartType;
    private String _interfaceClass;
    private Map _actions;
    private String _filterClass;

    public SmartDef(String smartType, String interfaceClass) {
        this(null, smartType, interfaceClass, null, null);
    }

    public SmartDef(String uid, String smartType, String interfaceClass, String filterClass, Map actions) {
        if (uid != null && uid.length() > 0) {
            this._id = uid;
        }
        this._smartType = smartType;
        this._interfaceClass = interfaceClass;
        this._filterClass = filterClass;
        this._actions = actions == null ? new HashMap(8) : new HashMap(actions);
    }

    public String getID() {
        return this._id;
    }

    public String getSmartType() {
        return this._smartType;
    }

    public void setSmartType(String smartType) {
        this._smartType = smartType;
    }

    public String getInterfaceClass() {
        return this._interfaceClass;
    }

    public void setInterfaceClass(String interfaceClass) {
        this._interfaceClass = interfaceClass;
    }

    public String getFilterClass() {
        return this._filterClass;
    }

    public void setFilterClass(String filterClass) {
        this._filterClass = filterClass;
    }

    public Map getActions() {
        return this._actions;
    }

    public ActionDef getActionUsingID(String resourceID) {
        ActionDef actionDef = null;
        if (resourceID != null) {
            ActionDef nextActionDef2 = null;
            Iterator iter = this._actions.values().iterator();
            while (iter.hasNext()) {
                for (ActionDef nextActionDef2 : (List)iter.next()) {
                    if (!resourceID.equals(nextActionDef2.getResourceID())) continue;
                    actionDef = nextActionDef2;
                    break;
                }
                if (actionDef == null) continue;
                break;
            }
        }
        return actionDef;
    }

    public boolean addAction(ActionDef smartActionDef) {
        boolean wasAdded = false;
        String protocol = smartActionDef.getProtocol();
        FactoryAction newFactoryAction = smartActionDef.getAction();
        String newFactoryFilter = newFactoryAction.getFilter();
        ArrayList<ActionDef> actionDefList = (ArrayList<ActionDef>)this._actions.get(protocol);
        if (actionDefList != null) {
            String id = smartActionDef.getResourceID();
            ActionDef nextActionDef2 = null;
            FactoryAction nextFactoryAction = null;
            for (ActionDef nextActionDef2 : new ArrayList(actionDefList)) {
                nextFactoryAction = nextActionDef2.getAction();
                if (id.equals(nextActionDef2.getResourceID())) {
                    nextActionDef2.setAction(nextFactoryAction);
                    nextActionDef2.setType(smartActionDef.getType());
                    wasAdded = true;
                    break;
                }
                if (!Strings.equal((String)newFactoryFilter, (String)nextFactoryAction.getFilter(), (boolean)false, (boolean)false) || !newFactoryAction.getAction().equals(nextFactoryAction.getAction())) continue;
                wasAdded = true;
                break;
            }
            if (!wasAdded) {
                wasAdded = actionDefList.add(smartActionDef);
            }
        } else {
            actionDefList = new ArrayList<ActionDef>(8);
            this._actions.put(protocol, actionDefList);
            actionDefList.add(smartActionDef);
            wasAdded = true;
        }
        return wasAdded;
    }

    public boolean addAction(String protocol, String type, FactoryAction action) {
        return this.addAction(new ActionDef(protocol, type, action));
    }

    public static ActionDef newAction() {
        return new SmartDef("", "").new ActionDef("omi", "", new FactoryAction());
    }

    public Set getActionsForProtocol(String protocol) {
        HashSet<ActionDef> actionDefs = new HashSet<ActionDef>(this._actions.size());
        String theProtocol = protocol.toLowerCase();
        List actionDefList = (List)this._actions.get(theProtocol);
        if (actionDefList != null) {
            ActionDef actionDef2 = null;
            for (ActionDef actionDef2 : actionDefList) {
                if (!theProtocol.equals(actionDef2.getProtocol())) continue;
                actionDefs.add(actionDef2);
            }
        }
        return actionDefs;
    }

    ActionDef getAction(String protocol, ActionDef smartAction) {
        ActionDef theSmartAction = null;
        if (protocol != null && smartAction != null) {
            ActionDef nextActionDef2 = null;
            for (ActionDef nextActionDef2 : this.getActionsForProtocol(protocol)) {
                if (!smartAction.equals(nextActionDef2)) continue;
                theSmartAction = nextActionDef2;
                break;
            }
        }
        return theSmartAction;
    }

    public ActionDef removeActionDef(ActionDef actionDef) {
        ActionDef removedActionDef = null;
        if (actionDef == null) {
            throw new IllegalArgumentException();
        }
        String protocolKey = actionDef.getProtocol();
        Object o = this._actions.get(protocolKey);
        try {
            List list = (List)o;
            Iterator iter = list.iterator();
            ActionDef smartDefAction = null;
            while (iter.hasNext()) {
                smartDefAction = (ActionDef)iter.next();
                if (!actionDef.equals(smartDefAction)) continue;
                removedActionDef = smartDefAction;
                iter.remove();
            }
        }
        catch (ClassCastException e) {
            removedActionDef = (ActionDef)this._actions.remove(protocolKey);
        }
        return removedActionDef;
    }

    public String toString() {
        return this._smartType;
    }

    public boolean isUniqueAction(ActionDef smartDefAction, ActionDef newSmartDefAction) {
        boolean isUnique = true;
        String id = smartDefAction.getResourceID();
        ActionDef aSmartDefAction2 = null;
        Iterator iter = this.getActions().values().iterator();
        while (iter.hasNext()) {
            for (ActionDef aSmartDefAction2 : (List)iter.next()) {
                if (!newSmartDefAction.equals(aSmartDefAction2) || Strings.equal((String)id, (String)aSmartDefAction2.getResourceID(), (boolean)false, (boolean)false)) continue;
                isUnique = false;
                break;
            }
            if (isUnique) continue;
            break;
        }
        return isUnique;
    }

    public boolean isUniqueAction(ActionDef smartDefAction) {
        boolean isUnique = true;
        String id = smartDefAction.getResourceID();
        FactoryAction factoryAction = smartDefAction.getAction();
        String filter = factoryAction.getFilter();
        boolean hasFilter = filter != null && filter.length() > 0;
        boolean nextActionHasFilter = false;
        ActionDef nextSmartDefAction2 = null;
        FactoryAction nextFactoryAction = null;
        String nextFilter = null;
        Iterator iter = this.getActions().values().iterator();
        while (iter.hasNext()) {
            for (ActionDef nextSmartDefAction2 : (List)iter.next()) {
                if (Strings.equal((String)id, (String)nextSmartDefAction2.getResourceID(), (boolean)false, (boolean)false)) continue;
                if (smartDefAction.equals(nextSmartDefAction2)) {
                    isUnique = false;
                    break;
                }
                nextFactoryAction = nextSmartDefAction2.getAction();
                nextFilter = nextFactoryAction.getFilter();
                boolean bl = nextActionHasFilter = nextFilter != null && nextFilter.length() > 0;
                if (hasFilter) {
                    if (!nextActionHasFilter || !filter.equals(nextFilter)) continue;
                    isUnique = false;
                    continue;
                }
                if (nextActionHasFilter) continue;
                isUnique = false;
            }
            if (isUnique) continue;
            break;
        }
        return isUnique;
    }

    public boolean equals(Object o) {
        boolean isEqual = false;
        if (o instanceof SmartDef) {
            Map sdActions;
            SmartDef sd = (SmartDef)o;
            String filterClassThis = this._filterClass == null ? "" : this._filterClass;
            String filterClassOther = sd.getFilterClass();
            if (filterClassOther == null) {
                filterClassOther = "";
            }
            if (this._smartType.equals(sd.getSmartType()) && this._interfaceClass.equals(sd.getInterfaceClass()) && filterClassThis.equals(filterClassOther) && this._actions.equals(sdActions = sd.getActions())) {
                isEqual = true;
            }
        }
        return isEqual;
    }

    public int hashCode() {
        int hashCode = 5;
        int primeNumber = 31;
        hashCode = 31 * hashCode + (this._filterClass == null ? 0 : this._filterClass.hashCode());
        hashCode = 31 * hashCode + (this._interfaceClass == null ? 0 : this._interfaceClass.hashCode());
        hashCode = 31 * hashCode + (this._smartType == null ? 0 : this._smartType.hashCode());
        hashCode = 31 * hashCode + (this._actions == null ? 0 : this._actions.hashCode());
        return hashCode;
    }

    public ActionDef newActionDef() {
        return new ActionDef("omi", "type", new FactoryAction());
    }

    static Element createElementFilter(Document document, String filterClass) throws IllegalArgumentException {
        if (document == null) {
            throw new IllegalArgumentException();
        }
        Element smartActionElement = document.createElement(ELEMENT_FILTER_NAME);
        smartActionElement.setAttribute(ATTRIBUTE_FILTER_CLASS, filterClass);
        return smartActionElement;
    }

    @Override
    public Object clone() {
        try {
            SmartDef clone = (SmartDef)super.clone();
            clone = new SmartDef(this._id, this._smartType, this._interfaceClass, this._filterClass, this._actions);
            return clone;
        }
        catch (CloneNotSupportedException cnse) {
            SmartDef clone = new SmartDef(this._id, this._smartType, this._interfaceClass, this._filterClass, this._actions);
            return clone;
        }
    }

    boolean hasConflict(SmartDef other) {
        boolean isEqual = false;
        if (this == other) {
            isEqual = true;
        } else if (other != null) {
            String otherSmartType = other.getSmartType();
            String otherInterfaceClass = other.getInterfaceClass();
            String otherFilterClass = other.getFilterClass();
            String thisSmartType = this.getSmartType();
            String thisInterfaceClass = this.getInterfaceClass();
            String thisFilterClass = this.getFilterClass();
            boolean bl = isEqual = !(otherSmartType != null && !"".equals(otherSmartType) && thisSmartType != null && !Strings.equal((String)otherSmartType, (String)thisSmartType, (boolean)false, (boolean)false) || otherInterfaceClass != null && !"".equals(otherInterfaceClass) && thisInterfaceClass != null && !Strings.equal((String)otherInterfaceClass, (String)thisInterfaceClass, (boolean)false, (boolean)false) || otherFilterClass != null && !"".equals(otherFilterClass) && thisFilterClass != null && !Strings.equal((String)otherFilterClass, (String)thisFilterClass, (boolean)false, (boolean)false));
            if (isEqual) {
                HashMap<String, FactoryAction> filter2ActionMap = new HashMap<String, FactoryAction>(5);
                String otherFilter = null;
                ActionDef otherActionDef2 = null;
                FactoryAction otherFactoryAction = null;
                Iterator iter = other.getActions().values().iterator();
                while (iter.hasNext()) {
                    for (ActionDef otherActionDef2 : (List)iter.next()) {
                        FactoryAction factoryAction;
                        otherFactoryAction = otherActionDef2.getAction();
                        otherFilter = otherFactoryAction.getFilter();
                        if (otherFilter == null || otherFilter.length() <= 0 || (factoryAction = (FactoryAction)filter2ActionMap.get(otherFilter)) != null) continue;
                        filter2ActionMap.put(otherFilter, otherFactoryAction);
                    }
                }
                if (filter2ActionMap.size() > 0) {
                    String thisFilter = null;
                    FactoryAction thisFactoryAction = null;
                    Iterator iter2 = this._actions.values().iterator();
                    while (isEqual && iter2.hasNext()) {
                        ActionDef thisActionDef;
                        Iterator iterAction = ((List)iter2.next()).iterator();
                        while (iterAction.hasNext() && ((thisFilter = (thisFactoryAction = (thisActionDef = (ActionDef)iterAction.next()).getAction()).getFilter()) == null || thisFilter.length() <= 0 || (otherFactoryAction = (FactoryAction)filter2ActionMap.get(thisFilter)) == null || (isEqual = thisFactoryAction.equals(otherFactoryAction)))) {
                        }
                    }
                }
            }
        }
        return !isEqual;
    }

    void merge(SmartDef newSmartDef, InformationServiceInitObject serviceConfig, MergePolicy mergePolicy, Map resourceIdMap) throws ServiceConfigurationException {
        if (newSmartDef != null) {
            String value = newSmartDef.getSmartType();
            if (value != null) {
                this.setSmartType(value);
            }
            if ((value = newSmartDef.getInterfaceClass()) != null) {
                this.setInterfaceClass(value);
            }
            if ((value = newSmartDef.getFilterClass()) != null) {
                this.setFilterClass(value);
            }
            this.mergeActions(newSmartDef, serviceConfig, mergePolicy, resourceIdMap);
        }
    }

    void replace(SmartDef newSmartDef, InformationServiceInitObject serviceConfig, MergePolicy mergePolicy, Map resourceIdMap) throws ServiceConfigurationException {
        if (newSmartDef != null) {
            this.setSmartType(newSmartDef.getSmartType());
            this.setInterfaceClass(newSmartDef.getInterfaceClass());
            this.setFilterClass(newSmartDef.getFilterClass());
            this.replaceActions(newSmartDef, serviceConfig, mergePolicy, resourceIdMap);
        }
    }

    private void mergeActions(SmartDef newSmartDef, InformationServiceInitObject serviceConfig, MergePolicy mergePolicy, Map resourceIdMap) throws ServiceConfigurationException {
        String thisResourceID = null;
        Map.Entry mapEntry2 = null;
        String protocol = null;
        ActionDef newSmartActionDef2 = null;
        ActionDef thisSmartActionDef = null;
        for (Map.Entry mapEntry2 : newSmartDef.getActions().entrySet()) {
            protocol = (String)mapEntry2.getKey();
            for (ActionDef newSmartActionDef2 : (List)mapEntry2.getValue()) {
                boolean isSame;
                thisSmartActionDef = this.getActionUsingID(newSmartActionDef2.getResourceID());
                boolean bl = isSame = thisSmartActionDef != null;
                if (!isSame) {
                    thisSmartActionDef = this.getAction(protocol, newSmartActionDef2);
                }
                if (thisSmartActionDef == null) {
                    serviceConfig.addSmartDefAction(this, newSmartActionDef2);
                    thisResourceID = newSmartActionDef2.getResourceID();
                } else {
                    thisResourceID = thisSmartActionDef.getResourceID();
                    if (isSame) {
                        thisSmartActionDef.merge(newSmartActionDef2);
                    } else if (!thisSmartActionDef.hasConflict(newSmartActionDef2)) {
                        thisSmartActionDef.merge(newSmartActionDef2);
                    } else if (mergePolicy.isOKToReplace()) {
                        thisSmartActionDef.replace(newSmartActionDef2);
                    } else {
                        throw new ServiceConfigurationException(Message.format((ResourceBundle)RB.getResources(), (String)"InformationServiceInitObject.conflictFactoryAction.ex.fmt.txt", (Object)thisSmartActionDef.getAction(), (Object)newSmartActionDef2.getAction()));
                    }
                }
                resourceIdMap.put(newSmartActionDef2.getResourceID(), thisResourceID);
            }
        }
    }

    private void replaceActions(SmartDef newSmartDef, InformationServiceInitObject serviceConfig, MergePolicy mergePolicy, Map resourceIdMap) throws ServiceConfigurationException {
        SmartDef thisSmartDef = serviceConfig.getSmartDefUsingID(newSmartDef.getResourceID());
        Logger logger = LogManager.getLogger(SmartDef.class);
        boolean isDebugEnabled = logger.isDebugEnabled();
        Map.Entry mapEntry2 = null;
        String protocol = null;
        ActionDef newSmartActionDef2 = null;
        ActionDef thisSmartActionDef = null;
        for (Map.Entry mapEntry2 : newSmartDef.getActions().entrySet()) {
            protocol = (String)mapEntry2.getKey();
            for (ActionDef newSmartActionDef2 : (List)mapEntry2.getValue()) {
                boolean isSame;
                thisSmartActionDef = thisSmartDef.getActionUsingID(newSmartActionDef2.getResourceID());
                boolean bl = isSame = thisSmartActionDef != null;
                if (!isSame) {
                    thisSmartActionDef = thisSmartDef.getAction(protocol, newSmartActionDef2);
                }
                if (thisSmartActionDef == null) {
                    if (!thisSmartDef.hasActionConflict(newSmartActionDef2)) {
                        serviceConfig.addSmartDefAction(thisSmartDef, newSmartActionDef2);
                    } else if (isDebugEnabled) {
                        logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"SmartDef.actionConflict.fmt.txt", (Object)newSmartActionDef2.getAction().getAction(), (Object)thisSmartDef.getSmartType()));
                    }
                } else if (isSame) {
                    thisSmartActionDef.replace(newSmartActionDef2);
                } else if (!thisSmartActionDef.hasConflict(newSmartActionDef2)) {
                    thisSmartActionDef.merge(newSmartActionDef2);
                } else if (mergePolicy.isOKToReplace()) {
                    thisSmartActionDef.replace(newSmartActionDef2);
                } else {
                    throw new ServiceConfigurationException(Message.format((ResourceBundle)RB.getResources(), (String)"InformationServiceInitObject.conflictFactoryAction.ex.fmt.txt", (Object)thisSmartActionDef.getAction(), (Object)newSmartActionDef2.getAction()));
                }
                resourceIdMap.put(newSmartActionDef2.getResourceID(), thisSmartActionDef == null ? newSmartActionDef2.getResourceID() : thisSmartActionDef.getResourceID());
            }
        }
    }

    boolean hasActionConflict(ActionDef actionDef) {
        boolean hasConflict = false;
        if (actionDef != null) {
            ActionDef nextActionDef = null;
            Iterator iter = this._actions.values().iterator();
            while (!hasConflict && iter.hasNext()) {
                Iterator iterActions = ((List)iter.next()).iterator();
                while (iterActions.hasNext() && !(hasConflict = (nextActionDef = (ActionDef)iterActions.next()).hasConflict(actionDef))) {
                }
            }
        }
        return hasConflict;
    }

    public List getActionsForFilter(String actionFilter) {
        ArrayList<ActionDef> actionDefs = new ArrayList<ActionDef>(this._actions.size());
        boolean hasFilter = actionFilter != null && actionFilter.length() > 0;
        ActionDef nextActionDef2 = null;
        FactoryAction nextFactoryAction = null;
        String nextActionFilter = null;
        boolean nextActionHasFilter = false;
        Iterator iter = this._actions.values().iterator();
        while (iter.hasNext()) {
            for (ActionDef nextActionDef2 : (List)iter.next()) {
                nextFactoryAction = nextActionDef2.getAction();
                nextActionFilter = nextFactoryAction.getFilter();
                boolean bl = nextActionHasFilter = nextActionFilter != null && nextActionFilter.length() > 0;
                if (hasFilter) {
                    if (!nextActionHasFilter || !Strings.equal((String)actionFilter, (String)nextActionFilter, (boolean)false, (boolean)false)) continue;
                    actionDefs.add(nextActionDef2);
                    continue;
                }
                if (nextActionHasFilter) continue;
                actionDefs.add(nextActionDef2);
            }
        }
        return actionDefs;
    }

    @Override
    public String getResourceID() {
        return this._id;
    }

    @Override
    public String getResourceValue() {
        return this._smartType;
    }

    @Override
    public String getLocalizedResourceType() {
        return RB.getStringResource("SmartDef.resourceType.txt");
    }

    @Override
    public String getLocalizedResourceTypeAndValue() {
        return Message.format((ResourceBundle)RB.getResources(), (String)"ResourceTypeValue.smartDef.fmt.txt", (Object)this.getLocalizedResourceType(), (Object)this.getResourceValue());
    }

    @Override
    public String getResourceType() {
        return "SmartDef";
    }

    @Override
    public int getResourceTypeCode() {
        return 7;
    }

    @Override
    public boolean isRequired() {
        return false;
    }

    @SASScope
    public final class ActionDef
    implements Cloneable,
    ConsumedResourceInterface {
        private String _actionDefId;
        private String _protocol;
        private String _reposType;
        private FactoryAction _action;

        public ActionDef(String id, String protocol, String reposType, FactoryAction action) {
            this(protocol, reposType, action);
            this._actionDefId = id;
        }

        public ActionDef(String protocol, String reposType, FactoryAction action) {
            this.setProtocol(protocol);
            this._reposType = reposType;
            this._action = action;
        }

        public String getID() {
            return this._actionDefId;
        }

        public String getProtocol() {
            return this._protocol;
        }

        public void setProtocol(String protocol) {
            if (protocol == null) {
                throw new IllegalArgumentException("A non-null Information Service repository protocol must be specified.");
            }
            this._protocol = protocol.toLowerCase();
        }

        public String getType() {
            return this._reposType;
        }

        public void setType(String type) {
            this._reposType = type;
        }

        public FactoryAction getAction() {
            return this._action;
        }

        public void setAction(FactoryAction action) {
            this._action = action;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ActionDef)) {
                return false;
            }
            ActionDef ad = (ActionDef)o;
            return this._protocol.equals(ad.getProtocol()) && this._reposType.equals(ad.getType()) && this._action.getAction().equals(ad.getAction().getAction()) && this._action.getFilter().equals(ad.getAction().getFilter());
        }

        public int hashCode() {
            int hashCode = 5;
            int primeNumber = 31;
            String action = this._action.getAction();
            String filter = this._action.getFilter();
            hashCode = 31 * hashCode + (this._protocol == null ? 0 : this._protocol.hashCode());
            hashCode = 31 * hashCode + (this._reposType == null ? 0 : this._reposType.hashCode());
            hashCode = 31 * hashCode + (action == null ? 0 : action.hashCode());
            hashCode = 31 * hashCode + (filter == null ? 0 : filter.hashCode());
            return hashCode;
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            FactoryAction factoryAction = this._action == null ? null : (FactoryAction)this._action.clone();
            ActionDef clone = null;
            try {
                clone = (ActionDef)super.clone();
                clone.setAction(factoryAction);
                clone.setProtocol(this._protocol);
                clone.setType(this._reposType);
            }
            catch (CloneNotSupportedException cnse) {
                clone = new ActionDef(this._protocol, this._reposType, factoryAction);
            }
            return clone;
        }

        Element createElement(Document document) throws IllegalArgumentException {
            if (document == null) {
                throw new IllegalArgumentException();
            }
            Element smartActionElement = document.createElement("Action");
            smartActionElement.setAttribute(SmartDef.ATTRIBUTE_UID, this.getResourceID());
            smartActionElement.setAttribute("protocol", this.getProtocol());
            smartActionElement.setAttribute("type", this.getType());
            FactoryAction factoryAction = this.getAction();
            smartActionElement.setAttribute("action", factoryAction.getAction());
            String filter = factoryAction.getFilter();
            if (filter != null) {
                smartActionElement.setAttribute("filter", filter);
            }
            return smartActionElement;
        }

        public String toSmartObjectCreationAction() {
            StringBuffer sb = new StringBuffer();
            sb.append(this._protocol);
            sb.append(SmartDef.TOKEN_DELIMITER);
            sb.append(this._reposType);
            sb.append(SmartDef.TOKEN_DELIMITER);
            sb.append(this._action.getActionClassName());
            String filter = this._action.getFilter();
            if (filter != null && filter.length() > 0) {
                sb.append(SmartDef.TOKEN_DELIMITER);
                sb.append(filter);
            }
            return sb.toString();
        }

        public boolean hasConflict(ActionDef other) {
            boolean isEqual = false;
            if (this == other) {
                isEqual = true;
            } else if (other != null) {
                String otherType = other.getType();
                String otherProtocol = other.getProtocol();
                FactoryAction otherFactoryAction = other.getAction();
                String thisType = other.getType();
                String thisProtocol = other.getProtocol();
                FactoryAction thisFactoryAction = other.getAction();
                if (otherType != null && thisType != null) {
                    isEqual = Strings.equal((String)otherType, (String)thisType, (boolean)false, (boolean)false);
                }
                if (isEqual && otherProtocol != null && thisProtocol != null) {
                    isEqual = Strings.equal((String)otherProtocol, (String)thisProtocol, (boolean)false, (boolean)false);
                }
                if (isEqual && otherFactoryAction != null && thisFactoryAction != null) {
                    isEqual = thisFactoryAction.equals(otherFactoryAction);
                }
            }
            return !isEqual;
        }

        void merge(ActionDef newSmartActionDef) throws ServiceConfigurationException {
            if (newSmartActionDef != null) {
                FactoryAction action;
                String value = newSmartActionDef.getType();
                if (value != null) {
                    this.setType(value);
                }
                if ((value = newSmartActionDef.getProtocol()) != null) {
                    this.setProtocol(value);
                }
                if ((action = newSmartActionDef.getAction()) != null) {
                    this.setAction(action);
                }
            }
        }

        void replace(ActionDef newSmartActionDef) throws ServiceConfigurationException {
            if (newSmartActionDef != null) {
                this.setProtocol(newSmartActionDef.getProtocol());
                this.setType(newSmartActionDef.getType());
                this.setAction(newSmartActionDef.getAction());
            }
        }

        @Override
        public String getResourceID() {
            return this._action.getResourceID();
        }

        @Override
        public String getResourceValue() {
            return this.toSmartObjectCreationAction();
        }

        @Override
        public String getLocalizedResourceType() {
            return RB.getStringResource("ActionDef.resourceType.txt");
        }

        @Override
        public String getLocalizedResourceTypeAndValue() {
            return Message.format((ResourceBundle)RB.getResources(), (String)"ResourceTypeValue.smartAction.fmt.txt", (Object)this.getLocalizedResourceType(), (Object)this.getResourceValue());
        }

        @Override
        public String getResourceType() {
            return "SmartAction";
        }

        @Override
        public int getResourceTypeCode() {
            return 6;
        }

        @Override
        public boolean isRequired() {
            return false;
        }
    }
}

