/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information;

import com.sas.codepolicy.SASScope;
import com.sas.entities.GUID;
import com.sas.services.deployment.ConsumedResourceInterface;
import com.sas.services.information.RB;
import com.sas.text.Message;
import com.sas.util.Strings;
import java.io.Serializable;
import java.util.ResourceBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@SASScope
public final class RepositoryProtocol
implements Cloneable,
ConsumedResourceInterface,
Serializable {
    static final String ELEMENT_NAME = "Repository";
    static final String ATTRIBUTE_UID = "uid";
    static final String ATTRIBUTE_PROTOCOL = "protocol";
    static final String ATTRIBUTE_CLASS = "class";
    private static final int HASHCODE_PRIME = 7;
    private static final long serialVersionUID = 1L;
    private String _uid = GUID.newGUID();
    private String _protocol = "";
    private String _className = "";

    public RepositoryProtocol() {
    }

    public RepositoryProtocol(String protocol, String className) {
        this._protocol = protocol;
        this._className = className;
    }

    public RepositoryProtocol(String id, String protocol, String className) {
        this(protocol, className);
        this.setID(id);
    }

    public RepositoryProtocol(Element element) {
        if (element == null || !ELEMENT_NAME.equalsIgnoreCase(element.getNodeName())) {
            throw new IllegalArgumentException();
        }
        this.setProtocol(element.getAttribute(ATTRIBUTE_PROTOCOL));
        this.setClassName(element.getAttribute(ATTRIBUTE_CLASS));
        if (element.hasAttribute(ATTRIBUTE_UID)) {
            this.setID(element.getAttribute(ATTRIBUTE_UID));
        }
    }

    private void setID(String id) {
        if (id != null && id.length() > 0) {
            this._uid = id;
        }
    }

    public void setClassName(String className) {
        this._className = className;
    }

    public String getClassName() {
        return this._className;
    }

    public String getProtocol() {
        return this._protocol;
    }

    public void setProtocol(String protocol) {
        this._protocol = protocol;
    }

    boolean hasConflict(RepositoryProtocol other) {
        boolean isEqual = false;
        if (this == other) {
            isEqual = true;
        } else if (other != null) {
            String otherClass = other.getClassName();
            String otherProtocol = other.getProtocol();
            isEqual = !(otherClass != null && !"".equals(otherClass) && this._className != null && !Strings.equal((String)otherClass, (String)this._className, (boolean)false, (boolean)false) || otherProtocol != null && !"".equals(otherProtocol) && this._protocol != null && !Strings.equal((String)otherProtocol, (String)this._protocol, (boolean)false, (boolean)false));
        }
        return !isEqual;
    }

    void merge(RepositoryProtocol newObject) {
        if (newObject != null) {
            String value = newObject.getProtocol();
            if (value != null) {
                this.setProtocol(value);
            }
            if ((value = newObject.getClassName()) != null) {
                this.setClassName(value);
            }
        }
    }

    void replace(RepositoryProtocol newObject) {
        if (newObject != null) {
            this.setProtocol(newObject.getProtocol());
            this.setClassName(newObject.getClassName());
        }
    }

    @Override
    public String getResourceID() {
        return this._uid;
    }

    @Override
    public String getResourceValue() {
        return this._protocol;
    }

    @Override
    public String getLocalizedResourceType() {
        return RB.getStringResource("RepositoryProtocol.resourceType.txt");
    }

    @Override
    public String getLocalizedResourceTypeAndValue() {
        return Message.format((ResourceBundle)RB.getResources(), (String)"ResourceTypeValue.protocol.fmt.txt", (Object)this.getLocalizedResourceType(), (Object)this.getResourceValue());
    }

    @Override
    public String getResourceType() {
        return "Protocol";
    }

    @Override
    public int getResourceTypeCode() {
        return 2;
    }

    @Override
    public boolean isRequired() {
        return false;
    }

    Element createXMLElement(Document document) {
        if (document == null) {
            throw new IllegalArgumentException();
        }
        Element element = document.createElement(ELEMENT_NAME);
        element.setAttribute(ATTRIBUTE_PROTOCOL, this._protocol);
        element.setAttribute(ATTRIBUTE_CLASS, this._className);
        element.setAttribute(ATTRIBUTE_UID, this._uid);
        return element;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object o) {
        boolean isEqual = false;
        if (this == o) {
            isEqual = true;
        } else if (o == null) {
            isEqual = false;
        } else {
            try {
                RepositoryProtocol repositoryProtocol = (RepositoryProtocol)o;
                isEqual = Strings.equal((String)this.getProtocol(), (String)repositoryProtocol.getProtocol(), (boolean)false, (boolean)false) && Strings.equal((String)this.getClassName(), (String)repositoryProtocol.getClassName(), (boolean)false, (boolean)false);
            }
            catch (ClassCastException e) {
                isEqual = false;
            }
        }
        return isEqual;
    }

    public int hashCode() {
        int hashCode = 5;
        int primeNumber = 7;
        hashCode = 7 * hashCode + (this._className == null ? 0 : this._className.hashCode());
        hashCode = 7 * hashCode + (this._protocol == null ? 0 : this._protocol.hashCode());
        return hashCode;
    }

    public String toString() {
        return this._protocol;
    }

    public String toStringDetails() {
        return super.toString() + "[protocol=" + this._protocol + "][className=" + this._className + ']';
    }
}

