/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information;

import com.sas.services.ServiceException;
import com.sas.services.information.ChildRepositoryInterface;
import com.sas.services.information.OMIChildServer;
import com.sas.services.information.OMIServerRepository;
import com.sas.services.information.RepositoryInfo;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.rmi.RemoteException;
import java.util.List;

public class OMIServerChildRepository
extends OMIServerRepository
implements ChildRepositoryInterface {
    private static final long serialVersionUID = 7619777349512383640L;

    public OMIServerChildRepository() throws RemoteException {
        this(OMIServerChildRepository.class);
    }

    protected OMIServerChildRepository(Class theClass) throws RemoteException {
        super(theClass);
        this._url = "omi://";
        this._defaultRepository = null;
        this._isConnected = false;
        this.getUniqueId();
    }

    OMIServerChildRepository(OMIChildServer server, String defaultBase) throws ServiceException, RemoteException {
        this();
        this._defaultName = defaultBase;
        this._defaultRepository = server.getRepositoryId(defaultBase);
        this._defaultId = this._defaultRepository.substring(9);
        this._isConnected = true;
        this._isDestroyed = false;
        List infoList = server.getRepositoryInfo();
        for (RepositoryInfo nextInfo : infoList) {
            if (!this._defaultName.equals(nextInfo.getName())) continue;
            this._myType = nextInfo.getType();
        }
        try {
            this._url = server.getUrl() + "/" + URLEncoder.encode(defaultBase, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        this._omiServer = server;
        this.setUserContext(server.getUserContext());
    }

    @Override
    public void commit() throws ServiceException, RemoteException {
        this.pulseCheck();
        ((OMIChildServer)this._omiServer).commit();
    }

    @Override
    public void rollback() throws ServiceException, RemoteException {
        this.pulseCheck();
        ((OMIChildServer)this._omiServer).rollback();
    }
}

