/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information;

import com.sas.codepolicy.SASScope;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.VariableArray2dOfAnyHolder;
import com.sas.iom.SASIOMDefs.VariableArray2dOfStringHolder;
import com.sas.meta.SASOMI.IOMI;
import com.sas.meta.SASOMI.ISecurity;
import com.sas.meta.SASOMI.ISecurityAdmin;
import com.sas.meta.SASOMI.ISecurityAdminHelper;
import com.sas.meta.SASOMI.ISecurityAdminPackage.SECAD_ACT_ALREADY_EXISTS;
import com.sas.meta.SASOMI.ISecurityAdminPackage.SECAD_ACT_DOES_NOT_EXIST;
import com.sas.meta.SASOMI.ISecurityAdminPackage.SECAD_ACT_IN_DEPENDENT_REPOS;
import com.sas.meta.SASOMI.ISecurityAdminPackage.SECAD_ACT_NOT_REMOVED;
import com.sas.meta.SASOMI.ISecurityAdminPackage.SECAD_IDENTITY_DOES_NOT_EXIST;
import com.sas.meta.SASOMI.ISecurityAdminPackage.SECAD_INVALID_ACTION;
import com.sas.meta.SASOMI.ISecurityAdminPackage.SECAD_INVALID_IDENTITY_SPEC;
import com.sas.meta.SASOMI.ISecurityAdminPackage.SECAD_INVALID_PERMISSION_SPEC;
import com.sas.meta.SASOMI.ISecurityAdminPackage.SECAD_INVALID_RESOURCE_SPEC;
import com.sas.meta.SASOMI.ISecurityAdminPackage.SECAD_INVALID_TC_HANDLE;
import com.sas.meta.SASOMI.ISecurityAdminPackage.SECAD_NOT_AUTHORIZED;
import com.sas.meta.SASOMI.ISecurityAdminPackage.SECAD_OBJECT_NOT_ACT;
import com.sas.meta.SASOMI.ISecurityHelper;
import com.sas.meta.SASOMI.ISecurityPackage.InvalidAuthType;
import com.sas.meta.SASOMI.ISecurityPackage.InvalidCredHandle;
import com.sas.meta.SASOMI.ISecurityPackage.InvalidResourceSpec;
import com.sas.meta.SASOMI.ISecurityPackage.NoCredential;
import com.sas.meta.SASOMI.ISecurityPackage.NotTrustedUser;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Group;
import com.sas.metadata.remote.MdEvent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdFactoryEvent;
import com.sas.metadata.remote.MdFactoryImpl;
import com.sas.metadata.remote.MdFactoryListener;
import com.sas.metadata.remote.MdOMRConnection;
import com.sas.metadata.remote.MdObjectListener;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.MdStoreIDChangeListener;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.PropertyType;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.Tree;
import com.sas.metadata.remote.XMLUtil;
import com.sas.net.ssl.SSLRMISocketFactories;
import com.sas.services.ServiceException;
import com.sas.services.ServiceState;
import com.sas.services.cache.CacheException;
import com.sas.services.cache.CacheStatistics;
import com.sas.services.cache.impl.BaseCacheFactory;
import com.sas.services.connection.ConnectionResources;
import com.sas.services.deployment.Environment;
import com.sas.services.discovery.DiscoveryService;
import com.sas.services.discovery.LocalDiscoveryServiceInterface;
import com.sas.services.discovery.ServiceTemplate;
import com.sas.services.information.ACTEntry;
import com.sas.services.information.AuthResult;
import com.sas.services.information.Authorization;
import com.sas.services.information.ChildRepositoryInterface;
import com.sas.services.information.Factory;
import com.sas.services.information.FactoryException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterComponent;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.FilterNotSupportedException;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.InformationServiceTimerClient;
import com.sas.services.information.LoggerStream;
import com.sas.services.information.MetadataChangeEvent;
import com.sas.services.information.MetadataChangeListener;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.OMIChildRepository;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.OMIServer;
import com.sas.services.information.PartialFolderResultsException;
import com.sas.services.information.PartialListResultsException;
import com.sas.services.information.PartialResultsException;
import com.sas.services.information.RB;
import com.sas.services.information.RepositoryData;
import com.sas.services.information.RepositoryDef;
import com.sas.services.information.RepositoryEvent;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.RepositoryListenerInterface;
import com.sas.services.information.RepositoryUrlMismatchException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.browse.BrowseMetadata;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.services.information.cache.RepositoryCache;
import com.sas.services.information.metadata.FilteredFolder;
import com.sas.services.information.metadata.FilteredFolderInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.GroupInterface;
import com.sas.services.information.metadata.IdentityInterface;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.PersonInterface;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.services.information.rules.EvaluatorInterface;
import com.sas.services.information.util.ISEntityKey;
import com.sas.services.information.util.OMRFactoryManager;
import com.sas.services.information.util.OMRRepositoryKey;
import com.sas.services.security.Permission;
import com.sas.services.security.PermissionInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserIdentityInterface;
import com.sas.services.util.DateUtil;
import com.sas.services.util.Names;
import com.sas.services.util.URIUtil;
import com.sas.text.Message;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.dgc.VMID;
import java.rmi.server.UnicastRemoteObject;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.BooleanHolder;
import org.omg.CORBA.Object;
import org.omg.CORBA.StringHolder;

@SASScope
public class OMIRepository
extends UnicastRemoteObject
implements OMIRepositoryInterface,
MdObjectListener,
MetadataChangeListener,
MdStoreIDChangeListener,
MdFactoryListener,
InformationServiceTimerClient {
    private static final long serialVersionUID = 7501942435455996838L;
    public static final String ROOT_CLASSIDENTIFIER = "E5F27790-2149-11D6-8828-AA0004006D06";
    public static final String BIP_COMPONENTNAME = "BIP Service";
    public static final String BIP_ROOTNAME = "BIP Tree";
    private static final double SecondsInTheSixties = 3.156192E8;
    private static InformationServiceInterface _is;
    private static final int COLLECTION_INIT = 8;
    private static final int TREEBUFFER_INIT = 64;
    private static final String EX_MSG_CONNECTIONABORT = "connection abort";
    private static final String EX_MSG_EOFEXCEPTION = "EOFException";
    private static final String EX_MSG_SOCKETEXCEPTION = "SocketException";
    private String _domain = null;
    protected String _url = "omi://";
    private String _host = null;
    private String _principal = null;
    private String _password = null;
    protected String _defaultRepository = null;
    protected String _defaultName;
    protected String _defaultId;
    private String _isName = null;
    private int _portInt = 0;
    protected MdFactory _mdfactory = null;
    protected MdObjectStore _mdstore = null;
    private ISecurity _iSecurity;
    protected Logger _logger;
    protected IdentityInterface _person = null;
    private Factory _factory;
    protected RepositoryCache _cache = null;
    private UserContextInterface _user;
    protected boolean _isConnected = false;
    private boolean _connectionIsMine;
    private HashMap _repositories = null;
    private SoftwareComponent _bipRoot;
    private ArrayList _listeners;
    private int _childnum = 0;
    protected boolean _isDestroyed = false;
    protected String _subNum = "0";
    private boolean _reconnecting = false;
    private boolean _refreshCache = false;
    private String _myType = null;
    private List children;
    private List parents;
    private List projectRepositories;
    private String _uniqueId = null;
    private long _folderItemRefreshInterval = -1L;
    private long _folderSubfolderRefreshInterval = -1L;
    private long _metadataParentRefreshInterval = -1L;
    private SmartTypeHelper _myHelper = new SmartTypeHelper("Metadata");
    private Exception closeStack = null;
    private List _permissionList = null;
    private List _propertyTypeList = null;
    protected MetadataServerInterface _omiServer = null;
    private HashMap _tempMap = new HashMap(64);
    private static final int TESTLIST_INIT = 5;

    public static InformationServiceInterface getInformationService() {
        if (_is != null) {
            try {
                boolean isDeactive = ServiceState.isStateDeactivated(_is.getServiceState());
                if (isDeactive) {
                    _is = null;
                }
            }
            catch (RemoteException rex) {
                _is = null;
            }
        }
        if (_is == null) {
            LocalDiscoveryServiceInterface discoveryService = DiscoveryService.defaultInstance();
            try {
                _is = (InformationServiceInterface)discoveryService.findService(new ServiceTemplate(new Class[]{InformationServiceInterface.class}, null));
            }
            catch (ServiceException t) {
                _is = null;
            }
            catch (RemoteException e) {
                _is = null;
            }
        }
        return _is;
    }

    public static void clearInformationService() {
        _is = null;
    }

    public OMIRepository() throws RemoteException {
        this(OMIRepository.class);
    }

    protected OMIRepository(Class theClass) throws RemoteException {
        super(SSLRMISocketFactories.getInstance().getPortForClass(0, theClass), SSLRMISocketFactories.getInstance().getRMIClientSocketFactoryForClass(theClass), SSLRMISocketFactories.getInstance().getRMIServerSocketFactoryForClass(theClass));
        this._factory = Factory.getInstance();
        this._listeners = new ArrayList(8);
        this.children = new ArrayList(8);
        this.parents = new ArrayList(8);
        this.projectRepositories = new ArrayList(8);
        this.getUniqueId();
    }

    OMIRepository(OMIServer server, String defaultBase) throws ServiceException, RemoteException {
        this();
        this._cache = server.getRepositoryCache();
        this._defaultName = defaultBase;
        this._defaultRepository = server.getRepositoryId(defaultBase);
        this._defaultId = this._defaultRepository.substring(9);
        this._domain = server.getDomain();
        this._factory = server.getFactory();
        this._isConnected = true;
        this._isDestroyed = false;
        this._logger = LogManager.getLogger((String)"com.sas.services.information.OMIRepository");
        this._mdfactory = server.getMdFactory();
        this._mdfactory.addMdFactoryListener((MdFactoryListener)this);
        this._host = server.getHost();
        this._portInt = server.getPort();
        this._mdstore = server.getObjectStore();
        this._mdstore.addMdStoreIDChangeListener((MdStoreIDChangeListener)this);
        this._person = (PersonInterface)server.getUserContext().getPerson();
        if (this._person == null && server.getUserContext().getPersonFQID() != null) {
            this._person = (PersonInterface)this.fetch(server.getUserContext().getPersonFQID() + "/Person");
        }
        try {
            this._url = server.getUrl() + "/" + URLEncoder.encode(defaultBase, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        this._user = server.getUserContext();
        this._omiServer = server;
        this.getRepositoryData();
        this.initRepositories();
    }

    @Override
    public void setUserContext(UserContextInterface user) throws RemoteException {
        try {
            this.pulseCheck();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
        if (user == null) {
            return;
        }
        this._user = user;
    }

    @Override
    public UserContextInterface getUserContext() throws RemoteException {
        try {
            this.pulseCheck();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
        return this._user;
    }

    @Override
    public void setUser(PersonInterface person) throws RemoteException {
    }

    void setIdentity(IdentityInterface user) throws ServiceException, RemoteException {
        this._person = user;
    }

    @Override
    public void setISName(String name) throws RemoteException {
        try {
            this.pulseCheck();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
        if (name != null && name.length() > 0) {
            this._isName = name;
        }
    }

    @Override
    public String getISName() throws RemoteException {
        try {
            this.pulseCheck();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
        if (this._isName != null) {
            return this._isName;
        }
        InformationServiceInterface is = OMIRepository.getInformationService();
        List defs = is.getReposDefs();
        Iterator it = defs.iterator();
        String host = this._host;
        String port = String.valueOf(this._portInt);
        String defaultRepository = this._defaultRepository;
        while (it.hasNext()) {
            RepositoryDef rd = (RepositoryDef)it.next();
            if (this.isEqual(rd)) {
                this._isName = rd.getName();
                return rd.getName();
            }
            boolean host_match = false;
            try {
                InetAddress myAddress = InetAddress.getByName(host);
                InetAddress hisAddress = InetAddress.getByName(rd.getHost());
                host_match = myAddress.equals(hisAddress);
            }
            catch (UnknownHostException uhe) {
                host_match = this._host.equalsIgnoreCase(rd.getHost());
            }
            if (!rd.getProtocol().equalsIgnoreCase("omi") || !host_match || !rd.getPort().equals(port)) continue;
            if (this._defaultRepository == null) {
                this._isName = rd.getName();
                return rd.getName();
            }
            String defaultName = (String)this._repositories.get(defaultRepository);
            if (!rd.getBase().equalsIgnoreCase(defaultRepository) && (defaultName == null || !rd.getBase().equalsIgnoreCase(defaultName))) continue;
            this._isName = rd.getName();
            return rd.getName();
        }
        if (this._omiServer != null) {
            this._isName = this._omiServer.getName() + "." + this._defaultName;
            return this._isName;
        }
        return null;
    }

    @Override
    public PersonInterface getUser() throws RemoteException {
        try {
            this.pulseCheck();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
        if (this._person instanceof PersonInterface) {
            return (PersonInterface)this._person;
        }
        return null;
    }

    @Override
    public IdentityInterface getIdentity() throws ServiceException, RemoteException {
        return this._person;
    }

    @Override
    public IOMI getIOMI() throws IllegalStateException, RemoteException {
        try {
            this.pulseCheck();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
        if (!this.isConnected()) {
            throw new IllegalStateException(RB.getStringResource("OMIRepository.noconnection.ex.txt"));
        }
        return this._mdfactory.getConnection().getCMRHandle();
    }

    @Override
    public ISecurity getISecurity() throws IllegalStateException, RemoteException {
        try {
            this.pulseCheck();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
        if (!this.isConnected()) {
            throw new IllegalStateException(RB.getStringResource("OMIRepository.noconnection.ex.txt"));
        }
        if (this._mdfactory == null) {
            throw new IllegalStateException(RB.getStringResource("OMIRepository.iomnotset.ex.txt"));
        }
        if (this._iSecurity != null) {
            try {
                this._iSecurity._release();
            }
            finally {
                this._iSecurity = null;
            }
        }
        IOMI cnxn = this._mdfactory.getConnection().getCMRHandle();
        Object obj = cnxn._duplicate();
        this._iSecurity = ISecurityHelper.narrow((Object)obj);
        return this._iSecurity;
    }

    private ISecurityAdmin getISecAdmin() throws RemoteException {
        IOMI cnxn = this._mdfactory.getConnection().getCMRHandle();
        Object obj = cnxn._duplicate();
        ISecurityAdmin isa = ISecurityAdminHelper.narrow((Object)obj);
        return isa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean connect(IOMI connection, String base) throws ServiceException, RemoteException {
        InformationServiceInterface is;
        this.pulseCheck();
        if (connection == null) {
            return false;
        }
        if (this.isConnected()) {
            this.close(false);
        }
        boolean isRemote = !(is = OMIRepository.getInformationService()).isIsolated();
        this._connectionIsMine = false;
        try {
            this._mdfactory = new MdFactoryImpl(isRemote);
        }
        catch (MdException mdex) {
            throw new RuntimeException(RB.getStringResource("OMIReposiotyr.crtfactexcept.ex.txt"));
        }
        this._mdstore = this._mdfactory.createObjectStore();
        LoggerStream ls = null;
        Logger metadataLogger = LogManager.getLogger((String)"com.sas.metadata");
        Logger xmlLogger = LogManager.getLogger((String)"com.sas.metadata.xml");
        Logger perfLogger = LogManager.getLogger((String)"com.sas.metadata.perf");
        try {
            if (this._logger != null && this._mdfactory != null && (metadataLogger.isEnabled(Level.DEBUG) || xmlLogger.isEnabled(Level.DEBUG) || perfLogger.isEnabled(Level.DEBUG))) {
                String encoding = new OutputStreamWriter(new ByteArrayOutputStream()).getEncoding();
                this._mdfactory.getUtil().setDefaultEncoding(encoding);
                if (metadataLogger.isEnabled(Level.DEBUG)) {
                    ls = new LoggerStream("com.sas.metadata", Level.DEBUG);
                    this._mdfactory.setDebug(true);
                    this._mdfactory.getUtil().setOutputStream((OutputStream)ls, encoding);
                }
                if (xmlLogger.isDebugEnabled()) {
                    ls = new LoggerStream("com.sas.metadata.xml", Level.DEBUG);
                    this._mdfactory.setLoggingEnabled(true);
                    this._mdfactory.getUtil().setLogStream((OutputStream)ls, encoding);
                }
                if (perfLogger.isDebugEnabled()) {
                    ls = new LoggerStream("com.sas.metadata.perf", Level.DEBUG);
                    this._mdfactory.setPerf(true);
                    this._mdfactory.getUtil().setPerfStream((OutputStream)ls, encoding);
                }
            } else if (this._mdfactory != null) {
                this._mdfactory.setDebug(false);
                this._mdfactory.setLoggingEnabled(false);
            }
        }
        catch (RemoteException encoding) {
        }
        finally {
            if (ls != null) {
                ls.close();
            }
        }
        this._mdfactory.getConnection().setCMRHandle(connection);
        this._repositories = new HashMap(8);
        try {
            List reposList = this._mdfactory.getOMIUtil().getRepositories();
            for (CMetadata mi : reposList) {
                this._repositories.put(mi.getName().toUpperCase(), mi.getFQID());
                this._repositories.put(mi.getFQID(), mi.getName());
            }
        }
        catch (MdException mex) {
            throw new ServiceException(mex, RB.getStringResource("OMIRepository.retrreposlist.ex.txt"));
        }
        if (!this._reconnecting) {
            this._defaultRepository = base;
            if (this._defaultRepository != null && (this._defaultRepository.length() != 17 || this._defaultRepository.charAt(8) != '.')) {
                String reposId = (String)this._repositories.get(this._defaultRepository.toUpperCase());
                if (reposId == null) {
                    throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"OMIRepository.wrongrepos.ex.fmt.txt", (java.lang.Object)this._defaultRepository));
                }
                this._defaultRepository = reposId;
            }
            if (this._defaultRepository != null) {
                this._defaultName = (String)this._repositories.get(this._defaultRepository);
                this.getRepositoryData();
            }
            this._defaultId = this._defaultRepository.substring(9);
        }
        ISecurity isec = this.getISecurity();
        if (!this._reconnecting) {
            block31: {
                try {
                    StringHolder identHolder = new StringHolder();
                    isec.GetIdentity("", identHolder);
                    String identString = identHolder.value;
                    if (identString.equals("UNKNOWN:")) {
                        return true;
                    }
                    int index = identString.indexOf("/");
                    MetadataInterface mi = this.fetch(identString = identString.substring(index + 1));
                    if (mi != null) {
                        this.setIdentity((IdentityInterface)mi);
                    }
                }
                catch (InvalidCredHandle ich) {
                    throw new ServiceException(ich, ich.getMessage());
                }
                catch (GenericError ge) {
                    throw new ServiceException(ge, ge.getMessage());
                }
                catch (RemoteException ex) {
                    if (this._logger == null || !this._logger.isDebugEnabled()) break block31;
                    this._logger.debug(RB.getStringResource("OMIRepository.persretexcept.ex.txt"), (Throwable)ex);
                }
            }
            this._url = "";
            is.addInformationServiceTimerClient(this);
        }
        return true;
    }

    @Override
    public synchronized boolean connectWithProxy(String host, int port, String id, String password, String base, String proxy, boolean isSecure) throws ServiceException, RemoteException {
        this.pulseCheck();
        return this.connect(host, port, id, password, base);
    }

    @Override
    public boolean connect(String user, String password, RepositoryDef config) throws ServiceException, RemoteException {
        String host = config.getHost();
        int port = Integer.parseInt(config.getPort());
        String base = config.getBase();
        return this.connect(host, port, user, password, base);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean connect(String host, int port, String id, String password, String base) throws ServiceException, RemoteException {
        InformationServiceInterface is;
        java.lang.Object o;
        this.pulseCheck();
        if (this._isConnected) {
            return true;
        }
        String urkey = "OMIREPOSITORY:" + host + ':' + port;
        java.lang.Object cx = null;
        if (this._host != null) {
            if (this._logger != null) {
                this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"OMIRepository.reconnecting.msg.fmt", (java.lang.Object)this.getUrl(), (java.lang.Object)("omi://" + host + ':' + port + '/' + base)));
            }
            this._host = null;
            this._person = null;
        }
        if (this._user != null && (o = this._user.getSharedResource(urkey)) != null) {
            OMRFactoryManager ofm = (OMRFactoryManager)o;
            this._mdfactory = ofm.getFactory();
            this._host = ofm.getHost();
            this._portInt = ofm.getPort();
            this._principal = ofm.getUser();
            if (this._principal == null) {
                this._principal = "SSPI";
            }
            this._password = ofm.getPassword();
            ofm.lock();
            this._user.putSharedResource(urkey, ofm);
        }
        boolean isRemote = !(is = OMIRepository.getInformationService()).isIsolated();
        this._connectionIsMine = true;
        this._host = host;
        this._portInt = port;
        this._defaultRepository = base;
        if (this._logger != null && this._logger.isInfoEnabled()) {
            this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"OMIRepository.cncntohst.ex.fmt", (java.lang.Object)this._host, (java.lang.Object)String.valueOf(this._portInt)));
        }
        if (!this._reconnecting) {
            this._refreshCache = false;
            if (this._mdfactory == null) {
                try {
                    this._mdfactory = new MdFactoryImpl(isRemote);
                    if (this._user != null) {
                        String envKey = "ENVIRONMENT";
                        Environment environment = (Environment)this._user.getSharedResource(envKey);
                        MdOMRConnection mdOMRConnection = this._mdfactory.getConnection();
                        mdOMRConnection.setConnectionResources((ConnectionResources)environment);
                    }
                    try {
                        this._mdfactory.makeOMRConnection(this._host, String.valueOf(this._portInt), id, password);
                        if (this._logger != null && this._logger.isDebugEnabled()) {
                            this._logger.debug("Connected to omi://" + this._host + ':' + this._portInt + "  for user " + id);
                        }
                        this._principal = id;
                        this._password = password;
                    }
                    catch (MdException e) {
                        if (this._logger != null && this._logger.isInfoEnabled()) {
                            this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"OMIRepository.cnctfail.ex.fmt", (java.lang.Object)this._host, (java.lang.Object)String.valueOf(this._portInt)), (Throwable)e);
                        }
                        if (cx != null) {
                            cx.close();
                        }
                        this._mdfactory = null;
                        this._mdstore = null;
                        throw new ServiceException(e, Message.format((ResourceBundle)RB.getResources(), (String)"OMIRepository.cnctfail.ex.fmt", (java.lang.Object)this._host, (java.lang.Object)String.valueOf(this._portInt)));
                    }
                    if (this._user != null) {
                        OMRFactoryManager ofm = new OMRFactoryManager(this._mdfactory);
                        ofm.setConnectionParams(this._host, this._portInt, this._principal, this._password);
                        this._user.putSharedResource(urkey, ofm);
                    }
                }
                catch (MdException mdex) {
                    throw new RuntimeException(RB.getStringResource("OMIReposiotyr.crtfactexcept.ex.txt"));
                }
            }
            this._mdstore = this._mdfactory.createObjectStore();
            this._mdstore.addMdStoreIDChangeListener((MdStoreIDChangeListener)this);
            LoggerStream ls = null;
            Logger metadataLogger = LogManager.getLogger((String)"com.sas.metadata");
            Logger xmlLogger = LogManager.getLogger((String)"com.sas.metadata.xml");
            Logger perfLogger = LogManager.getLogger((String)"com.sas.metadata.perf");
            try {
                if (this._logger != null && this._mdfactory != null && (metadataLogger.isEnabled(Level.DEBUG) || xmlLogger.isEnabled(Level.DEBUG) || perfLogger.isEnabled(Level.DEBUG))) {
                    String encoding = new OutputStreamWriter(new ByteArrayOutputStream()).getEncoding();
                    this._mdfactory.getUtil().setDefaultEncoding(encoding);
                    if (metadataLogger.isEnabled(Level.DEBUG)) {
                        ls = new LoggerStream("com.sas.metadata", Level.DEBUG);
                        this._mdfactory.setDebug(true);
                        this._mdfactory.getUtil().setOutputStream((OutputStream)ls, encoding);
                    }
                    if (xmlLogger.isDebugEnabled()) {
                        ls = new LoggerStream("com.sas.metadata.xml", Level.DEBUG);
                        this._mdfactory.setLoggingEnabled(true);
                        this._mdfactory.getUtil().setLogStream((OutputStream)ls, encoding);
                    }
                    if (perfLogger.isDebugEnabled()) {
                        ls = new LoggerStream("com.sas.metadata.perf", Level.DEBUG);
                        this._mdfactory.setPerf(true);
                        this._mdfactory.getUtil().setPerfStream((OutputStream)ls, encoding);
                    }
                } else if (this._mdfactory != null) {
                    this._mdfactory.setDebug(false);
                    this._mdfactory.setLoggingEnabled(false);
                }
            }
            catch (RemoteException encoding) {
            }
            finally {
                if (ls != null) {
                    ls.close();
                }
            }
        }
        if (cx != null) {
            cx.close();
        }
        this._isConnected = true;
        this.initRepositories();
        if (!(this._defaultRepository == null || this._defaultRepository.startsWith("A0000001.") && this._defaultRepository.length() == 17 && this._defaultRepository.charAt(8) == '.')) {
            String reposId = (String)this._repositories.get(this._defaultRepository.toUpperCase());
            if (reposId == null) {
                throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"OMIRepository.wrongrepos.ex.fmt.txt", (java.lang.Object)this._defaultRepository));
            }
            this._defaultRepository = reposId;
        }
        if (this._defaultRepository != null) {
            this._defaultName = (String)this._repositories.get(this._defaultRepository);
            this.getRepositoryData();
        }
        this._defaultId = this._defaultRepository.substring(9);
        try {
            this._cache = (RepositoryCache)BaseCacheFactory.getCache((String)this.getClass().getName(), (String)this.cachePath(), (ClassLoader)this.getClass().getClassLoader());
        }
        catch (CacheException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        ISecurity isec = this.getISecurity();
        if (isec == null) {
            if (this._logger != null) {
                this._logger.warn(RB.getStringResource("OMIRepository.isecuritynull.ex.txt"));
            }
        } else {
            try {
                StringHolder identHolder = new StringHolder();
                isec.GetIdentity("", identHolder);
                String identString = identHolder.value;
                if (!identString.equals("UNKNOWN:")) {
                    int index = identString.indexOf(":");
                    int index2 = identString.indexOf("/");
                    String type = identString.substring(index + 1, index2);
                    String personId = identString.substring(index2 + 1);
                    MetadataInterface mi = this.fetch(personId + '/' + type);
                    if (mi != null && mi instanceof PersonInterface) {
                        this.setUser((PersonInterface)mi);
                    } else if (mi == null) {
                        if (this._logger != null) {
                            this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"OMIRepository.noperson.ex.fmt.txt", (java.lang.Object)this._principal));
                        }
                    } else if (this._logger != null) {
                        this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"OMIRepository.userbadclass.ex.fmt.txt", (java.lang.Object)this._principal, (java.lang.Object)mi.getType()));
                    }
                } else if (this._logger != null) {
                    this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"OMIRepository.noperson.ex.fmt.txt", (java.lang.Object)this._principal));
                }
            }
            catch (GenericError ex) {
                if (this._logger != null) {
                    this._logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"OMIRepository.authnologin.msg.fmt", (java.lang.Object)("omi:" + this._host + ':' + port + (this._defaultRepository == null ? "" : '/' + this._defaultRepository)), (java.lang.Object)id), (Throwable)ex);
                } else {
                    ex.printStackTrace(System.out);
                }
            }
            catch (InvalidCredHandle ex) {
                if (this._logger != null) {
                    this._logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"OMIRepository.authnologin.msg.fmt", (java.lang.Object)("omi:" + this._host + ':' + port + (this._defaultRepository == null ? "" : '/' + this._defaultRepository)), (java.lang.Object)id), (Throwable)ex);
                }
                ex.printStackTrace(System.out);
            }
        }
        this._url = "omi://" + this._host + ':' + port + (this._defaultRepository == null ? "" : '/' + this._defaultRepository);
        is.addMetadataChangeListener(this, this._url);
        is.addInformationServiceTimerClient(this);
        return true;
    }

    private void initRepositories() throws RemoteException, ServiceException {
        this._repositories = new HashMap(8);
        try {
            List reposList = this._mdfactory.getOMIUtil().getRepositories();
            for (CMetadata mi : reposList) {
                String reposName = mi.getName();
                if (reposName == null) {
                    if (this._logger != null) {
                        this._logger.error(RB.getStringResource("OMIRepository.nullreposname.ex.txt"));
                    }
                    this.close();
                    throw new ServiceException(RB.getStringResource("OMIRepository.nullreposname.ex.txt"));
                }
                this._repositories.put(reposName.toUpperCase(), mi.getFQID());
                this._repositories.put(mi.getFQID(), reposName);
                if (this._defaultRepository != null || reposList.size() <= 0) continue;
                mi = (CMetadata)reposList.get(0);
                this._defaultRepository = mi.getFQID();
                this._defaultId = this._defaultRepository.substring(9);
            }
        }
        catch (MdException mex) {
            throw new ServiceException(mex, RB.getStringResource("OMIRepository.retrreposlist.ex.txt"));
        }
    }

    private String cachePath() throws RemoteException {
        String id = this._principal;
        if (id.indexOf("@!*(generatedpassworddomain)*!") > 0) {
            id = id.substring(0, id.indexOf("@!*(generatedpassworddomain)*!"));
        }
        String subNumPath = this._subNum.replace('.', '/');
        String cacheNodePath = null;
        if (this._user != null) {
            String userid = this._user.getUniqueId();
            userid = userid.replace(':', '_');
            cacheNodePath = "/Metadata/omi/" + id + "/" + userid + "/" + this._host + "-" + this._portInt + "/" + (this._defaultRepository != null ? this._defaultRepository + '/' : "") + subNumPath;
        } else {
            cacheNodePath = "/Metadata/omi/" + id + "/" + this._host + "-" + this._portInt + "/" + (this._defaultRepository != null ? this._defaultRepository + '/' : "") + subNumPath;
        }
        return cacheNodePath;
    }

    protected void finalize() throws RemoteException {
        try {
            this.close();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public String toString() {
        try {
            this.pulseCheck();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
        return this._url;
    }

    @Override
    public void close() throws RemoteException {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void close(boolean notify) throws RemoteException {
        java.lang.Object o;
        InformationServiceInterface is;
        if (this._isDestroyed) {
            return;
        }
        if (this._mdstore != null) {
            this._mdstore.removeMdStoreIDChangeListener((MdStoreIDChangeListener)this);
        }
        this.closeStack = new Exception();
        String urkey = "OMIREPOSITORY:" + this._host + ':' + this._portInt;
        if (this._logger != null && this._logger.isInfoEnabled()) {
            this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"OMIRepository.closing.ex.fmt", (java.lang.Object)this._host, (java.lang.Object)String.valueOf(this._portInt)));
        }
        if ((is = OMIRepository.getInformationService()) != null) {
            try {
                is.removeInformationServiceTimerClient(this);
            }
            catch (ServiceException serviceException) {
                // empty catch block
            }
        }
        if (this._omiServer == null && this._cache != null) {
            this._cache.clear();
        }
        this._cache = null;
        this._isDestroyed = true;
        if (this._omiServer == null && this._mdstore != null) {
            try {
                this._mdstore.dispose();
            }
            catch (RemoteException t) {
                if (this._logger != null && this._logger.isDebugEnabled()) {
                    this._logger.debug("", (Throwable)t);
                }
            }
            finally {
                this._mdstore = null;
            }
        }
        if (this._omiServer == null && this._user != null && (o = this._user.getSharedResource(urkey)) != null) {
            OMRFactoryManager ofm = (OMRFactoryManager)o;
            if (!ofm.unlock()) {
                this._user.putSharedResource(urkey, ofm);
                this._mdfactory = null;
            } else {
                this._user.putSharedResource(urkey, null);
            }
        }
        if (this._omiServer == null && this._mdfactory != null) {
            this._mdfactory.getUtil().setOutputStream(null);
            this._mdfactory.getUtil().setLogStream(null);
            this._mdfactory.getUtil().setPerfStream(null);
            if (!this._connectionIsMine) {
                this._mdfactory.getConnection().setCMRHandle(null);
            }
            if (this._logger != null && this._logger.isDebugEnabled()) {
                this._logger.debug("Closing connection to omi://" + this._host + ':' + this._portInt + "  for user " + this._principal);
            }
            this._mdfactory.dispose();
            this._mdfactory.setDebug(false);
            this._mdfactory.setLoggingEnabled(false);
            this._mdfactory.getUtil().setOutputStream(null);
            this._mdfactory.setPerf(false);
            this._mdfactory.getUtil().setPerfStream(null);
            this._mdfactory = null;
        }
        if (this._iSecurity != null) {
            this._iSecurity._release();
            this._iSecurity = null;
            this._iSecurity = null;
        }
        this._logger = null;
        this._person = null;
        if (!this._reconnecting) {
            this._user = null;
        }
        this._bipRoot = null;
        if (this._repositories != null) {
            this._repositories.clear();
            this._repositories = null;
        }
        if (this._url != null && (is = OMIRepository.getInformationService()) != null) {
            try {
                is.removeMetadataChangeListener(this, this._url);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this._isConnected = false;
        if (this._listeners != null) {
            if (notify) {
                this.notifyListeners(3);
            }
            ArrayList arrayList = this._listeners;
            synchronized (arrayList) {
                this._listeners.clear();
                this._listeners = null;
            }
        }
        if (!this._reconnecting) {
            this._factory = null;
            this._myHelper = null;
            this.children = null;
            this.parents = null;
            this.projectRepositories = null;
            this._url = null;
            this._subNum = null;
            this._password = null;
            try {
                OMIRepository.unexportObject(this, true);
            }
            catch (NoSuchObjectException noSuchObjectException) {
                // empty catch block
            }
        }
    }

    @Override
    public MetadataInterface newMetadata(String reposId, String name, String type) throws ServiceException, RemoteException {
        this.pulseCheck();
        MetadataInterface mi = null;
        if (reposId == null) {
            if (this._defaultRepository != null) {
                reposId = this._defaultRepository.substring(this._defaultRepository.indexOf(".") + 1);
            } else {
                throw new ServiceException(RB.getStringResource("OMIRepository.reposidreq.ex.txt"));
            }
        }
        if (reposId.indexOf(".") > 0) {
            int index = reposId.indexOf(".");
            reposId = reposId.substring(0, index);
        }
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"OMIRepository.newmetadata.msg.fmt", (java.lang.Object)reposId, (java.lang.Object)name, (java.lang.Object)type));
        }
        try {
            Root newRoot = (Root)this._mdfactory.createComplexMetadataObject(this._mdstore, null, name, type, reposId);
            mi = this.factoryProcess(newRoot);
            return mi;
        }
        catch (RemoteException t) {
            throw new ServiceException(t, RB.getStringResource("OMIRepository.newmetadataex.ex.txt"));
        }
    }

    @Override
    public MetadataInterface newMetadata(MetadataInterface model, String name) throws ServiceException, RemoteException {
        this.pulseCheck();
        return this.newMetadataByModel(model, name);
    }

    @Override
    public MetadataInterface newMetadataByModel(MetadataInterface model, String name) throws ServiceException, RemoteException {
        this.pulseCheck();
        try {
            com.sas.metadata.Root root = (com.sas.metadata.Root)model.getRepositoryEntity();
            return this.newMetadata(root.getRepositoryID(), name, root.getCMetadataType());
        }
        catch (ClassCastException cce) {
            try {
                Root root = (Root)model.getRepositoryEntity();
                return this.newMetadata(root.getRepositoryID(), name, root.getCMetadataType());
            }
            catch (ClassCastException cce2) {
                throw new ServiceException(RB.getStringResource("OMIRepository.newwrongtyp.ex.txt"));
            }
        }
    }

    @Override
    public synchronized MetadataInterface fetch(String repositoryKey) throws ServiceException, RemoteException {
        this.pulseCheck();
        return this.fetch(repositoryKey, false);
    }

    @Override
    public MetadataInterface fetchByUrl(String entityURL, boolean bypassCache) throws ServiceException, RemoteException {
        URI entityURI = null;
        try {
            entityURI = new URI(entityURL);
        }
        catch (URISyntaxException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        String scheme = entityURI.getScheme().toLowerCase();
        if (!"sas-oma".equals(scheme)) {
            throw new RepositoryUrlMismatchException();
        }
        String host = entityURI.getHost();
        if (!host.equals(this._host)) {
            throw new RepositoryUrlMismatchException();
        }
        int port = entityURI.getPort();
        if (port != this._portInt) {
            throw new RepositoryUrlMismatchException();
        }
        String path = entityURI.getPath();
        return this.fetch(path, bypassCache);
    }

    @Override
    public MetadataInterface fetch(String repositoryKey, boolean bypassCache) throws ServiceException, RemoteException {
        Filter filter = null;
        String originalKey = repositoryKey;
        this.pulseCheck();
        if (!this.isConnected()) {
            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"OMIRepository.cnctfail.ex.fmt", (java.lang.Object)this._host, (java.lang.Object)String.valueOf(this._portInt)));
        }
        if (this._refreshCache) {
            this.doRefresh();
        }
        String template = null;
        if (filter != null && filter.getOMRTemplate() != null) {
            template = filter.getOMRTemplate();
        }
        int flags = 2056;
        if (template != null) {
            flags |= 4;
        } else {
            template = "";
        }
        if (filter != null && filter.getOMRFlags() != 0) {
            int fflags = filter.getOMRFlags();
            flags = (fflags & Integer.MIN_VALUE) != 0 ? fflags & Integer.MAX_VALUE : flags | fflags;
        }
        try {
            repositoryKey = URLDecoder.decode(repositoryKey, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"OMIRepository.fetchdata.msg.fmt.txt", (java.lang.Object)repositoryKey));
        }
        CMetadata cm = null;
        MetadataInterface mi = null;
        String type = null;
        try {
            ISEntityKey iseKey = new ISEntityKey(repositoryKey);
            String reposKey = iseKey.getRepositoryKey();
            OMRRepositoryKey omrKey = new OMRRepositoryKey(reposKey);
            type = omrKey.getType();
            repositoryKey = omrKey.getId();
        }
        catch (IllegalArgumentException iaex) {
            OMRRepositoryKey omrKey = new OMRRepositoryKey(repositoryKey);
            type = omrKey.getType();
            repositoryKey = omrKey.getId();
        }
        if (repositoryKey != null && (repositoryKey.length() != 17 || repositoryKey.charAt(8) != '.')) {
            String reposId = (String)this._repositories.get(repositoryKey.toUpperCase());
            if (reposId == null) {
                throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"OMIRepository.wrongrepos.ex.fmt.txt", (java.lang.Object)repositoryKey));
            }
            repositoryKey = reposId;
        }
        if (type == null) {
            throw new ServiceException(RB.getStringResource("OMIRepository.typereq.ex.txt"));
        }
        if (!bypassCache) {
            mi = (MetadataInterface)this._cache.get(repositoryKey);
            if (mi != null) {
                return mi;
            }
            String tKey = (String)this._tempMap.get(repositoryKey);
            if (tKey != null && (mi = (MetadataInterface)this._cache.get(tKey)) != null) {
                return mi;
            }
        }
        String reposPart = repositoryKey.substring(0, 8);
        try {
            if (!bypassCache && this._defaultRepository != null && this._defaultRepository.endsWith(reposPart)) {
                cm = this._mdstore.getObject(repositoryKey, true);
            }
            if (cm == null) {
                cm = this._mdfactory.getOMIUtil().getMetadataAllDepths((MdStore)this._mdstore, type, repositoryKey, new Vector(8), new Vector(8), template, flags);
            }
        }
        catch (MdException mex) {
            if (this.isConnectionException(mex) && this.doReconnect()) {
                return this.fetch(originalKey);
            }
            throw new ServiceException(mex, RB.getStringResource("OMIRepository.geterror.ex.txt"));
        }
        if (cm == null) {
            return null;
        }
        mi = this.factoryProcess(cm);
        return mi;
    }

    @Override
    public List search(FilterInterface filter) throws ServiceException, RemoteException {
        PartialListResultsException pre = null;
        this.pulseCheck();
        String filterString = filter.getXMLSelectString();
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"OMIRepository.srchparam.ex.fmt", (java.lang.Object)this._defaultName, (java.lang.Object)String.valueOf(this._portInt), (java.lang.Object)filterString));
        }
        if (!this.isConnected()) {
            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"OMIRepository.cnctfail.ex.fmt", (java.lang.Object)this._host, (java.lang.Object)String.valueOf(this._portInt)));
        }
        List protocols = filter.getProtocols();
        if (protocols != null && protocols.size() > 0 && !protocols.contains("omi")) {
            return Collections.EMPTY_LIST;
        }
        if (this._refreshCache) {
            this.doRefresh();
        }
        ArrayList result = new ArrayList(8);
        int flags = filter.getOMRFlags();
        if ("UNSUPPORTED".equals(filterString)) {
            throw new FilterNotSupportedException(Message.format((ResourceBundle)RB.getResources(), (String)"Repository.badFilter.ex.fmt.txt", (java.lang.Object)filter.toString()));
        }
        filterString = filterString + (filter.getOMRTemplate() == null ? "" : filter.getOMRTemplate());
        String type = filter.getOMRType();
        String repository = filter.getOMRRepository();
        ArrayList<String> repositoryList = new ArrayList<String>(8);
        ArrayList<String> typeList = new ArrayList<String>(8);
        if (repository != null && (repository.length() != 17 || repository.charAt(8) != '.')) {
            String reposId;
            if (this._repositories == null || this._repositories.size() == 0) {
                this._repositories = new HashMap(8);
                List reposList = this.getRepositories();
                for (MetadataInterface mi : reposList) {
                    this._repositories.put(mi.getName().toUpperCase(), mi.getReposId());
                    this._repositories.put(mi.getReposId(), mi.getName());
                }
            }
            if ((reposId = (String)this._repositories.get(repository.toUpperCase())) == null) {
                if (this._logger != null && this._logger.isDebugEnabled()) {
                    this._logger.debug("repository " + repository + " wasn't found in the list for this server");
                    Iterator coll = this._repositories.values().iterator();
                    while (coll.hasNext()) {
                        this._logger.debug("It does have: " + (String)coll.next());
                    }
                }
                throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"OMIRepository.wrongrepos.ex.fmt.txt", (java.lang.Object)repository));
            }
            repository = reposId;
        }
        if (repository == null) {
            if (this._defaultRepository != null) {
                repositoryList.add(this._defaultRepository);
            } else {
                for (MetadataInterface mi : this.getRepositories()) {
                    repositoryList.add(mi.getReposId());
                }
            }
        } else {
            repositoryList.add(repository);
        }
        if (type == null) {
            typeList.add("Root");
            flags |= 0x10;
        } else {
            typeList.add(type);
        }
        for (String nextRepos : repositoryList) {
            for (String nextType : typeList) {
                if (this._logger != null && this._logger.isInfoEnabled()) {
                    this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"OMIRepository.srchrepos.ex.fmt", (java.lang.Object)nextRepos, (java.lang.Object)nextType, (java.lang.Object)filterString));
                }
                try {
                    ArrayList nextResult = this.doSearch(nextType, nextRepos, filterString, flags);
                    if (nextResult == null) continue;
                    result.addAll(nextResult);
                }
                catch (PartialListResultsException plre) {
                    if (pre == null) {
                        pre = new PartialListResultsException(result, plre.getMessage());
                    }
                    Throwable[] exceptions = plre.getExceptions();
                    for (int i = 0; i < exceptions.length; ++i) {
                        pre.addException(exceptions[i]);
                    }
                    List list = plre.getResults();
                    result.addAll(list);
                }
            }
        }
        if (pre != null) {
            throw pre;
        }
        return result;
    }

    private synchronized ArrayList doSearch(String type, String repository, String filter, int flags) throws ServiceException, RemoteException {
        PartialResultsException pre = null;
        ArrayList<MetadataInterface> result = new ArrayList<MetadataInterface>(8);
        try {
            int my_flags = 396;
            if ((flags & Integer.MIN_VALUE) != 0) {
                flags &= Integer.MAX_VALUE;
                my_flags = 0;
            }
            List list = this._mdfactory.getOMIUtil().getMetadataObjectsSubset((MdStore)this._mdstore, repository, type, my_flags | flags, filter);
            for (CMetadata cm2 : list) {
                MetadataInterface mi = (MetadataInterface)this._cache.get(cm2.getFQID());
                if (mi == null) {
                    try {
                        mi = this.factoryProcess(cm2);
                        result.add(mi);
                    }
                    catch (ServiceException svcEx) {
                        if (this._logger != null && this._logger.isInfoEnabled()) {
                            this._logger.info(RB.getStringResource("OMIRepository.geterror.ex.txt"), (Throwable)((java.lang.Object)svcEx));
                        }
                        if (pre == null) {
                            pre = new PartialListResultsException(result, RB.getStringResource("OMIRepository.geterror.ex.txt"));
                        }
                        pre.addException((Throwable)((java.lang.Object)svcEx));
                    }
                    continue;
                }
                result.add(mi);
            }
        }
        catch (MdException mex) {
            if (this.isConnectionException(mex) && this.doReconnect()) {
                return this.doSearch(type, repository, filter, flags);
            }
            throw new ServiceException(mex, RB.getStringResource("OMIRepository.geterror.ex.txt"));
        }
        if (pre != null) {
            throw pre;
        }
        return result;
    }

    @Override
    public synchronized List getRepositories() throws ServiceException, RemoteException {
        this.pulseCheck();
        if (!this.isConnected()) {
            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"OMIRepository.cnctfail.ex.fmt", (java.lang.Object)this._host, (java.lang.Object)String.valueOf(this._portInt)));
        }
        ArrayList<MetadataInterface> result = new ArrayList<MetadataInterface>(8);
        try {
            List reposList = this._mdfactory.getOMIUtil().getRepositories();
            for (CMetadata cm : reposList) {
                if (cm.getName() == null && this._logger != null) {
                    this._logger.warn(RB.getStringResource("OMIRepository.nullreposname.ex.txt"));
                    this._logger.warn("Id: " + cm.getFQID());
                }
                MetadataInterface mi = this.factoryProcess(cm);
                result.add(mi);
            }
        }
        catch (MdException mex) {
            if (this.isConnectionException(mex) && this.doReconnect()) {
                return this.getRepositories();
            }
            throw new ServiceException(mex, RB.getStringResource("OMIRepository.geterror.ex.txt"));
        }
        return result;
    }

    public void updateEntity(java.lang.Object reposId, java.lang.Object input) throws ServiceException, RemoteException {
        this.pulseCheck();
        try {
            CMetadata cm = (CMetadata)input;
            cm.updateMetadataAll();
        }
        catch (MdException ex) {
            throw new ServiceException(ex, RB.getStringResource("OMIRepository.updateexcept.msg.txt"));
        }
    }

    @Override
    public void deleteEntity(MetadataInterface input) throws ServiceException, RemoteException {
        this.pulseCheck();
        java.lang.Object o = input.getRepositoryEntity();
        if (!(o instanceof CMetadata)) {
            throw new ServiceException(RB.getStringResource("OMIRepository.deletebadcls.ex.txt"));
        }
        this.deleteEntity((CMetadata)o);
    }

    @Override
    public void deleteEntity(CMetadata metadata) throws ServiceException, RemoteException {
        this.pulseCheck();
        try {
            String fqid = metadata.getFQID();
            this._mdfactory.deleteMetadataObject(metadata);
            this._cache.remove(fqid);
        }
        catch (MdException ex) {
            throw new ServiceException(ex, Message.format((ResourceBundle)RB.getResources(), (String)"OMIRepository.deleteerror.ex.fmt.txt", (java.lang.Object)metadata.getName(), (java.lang.Object)metadata.getFQID()));
        }
    }

    @Override
    public void deleteEntities(List metadataObjects) throws ServiceException, RemoteException {
        this.pulseCheck();
        try {
            this._mdfactory.deleteMetadataObjects(metadataObjects);
        }
        catch (MdException ex) {
            throw new ServiceException(ex, RB.getStringResource("OMIRepository.deleteerlst.ex.txt"));
        }
    }

    @Override
    public void addEntity(MetadataInterface input) throws ServiceException, RemoteException {
        this.pulseCheck();
        this.updateEntity(input.getReposId(), input.getRepositoryEntity());
    }

    @Override
    public String getUrl() throws RemoteException {
        try {
            this.pulseCheck();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
        return this._url;
    }

    @Override
    public String getDomain() throws RemoteException {
        try {
            this.pulseCheck();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
        return this._domain;
    }

    @Override
    public void setDomain(String domain) throws RemoteException {
        try {
            this.pulseCheck();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
        this._domain = domain;
    }

    @Override
    public boolean isEqual(java.lang.Object o) throws RemoteException {
        block23: {
            try {
                this.pulseCheck();
            }
            catch (ServiceException svcEx) {
                return false;
            }
            if (o == null) {
                return false;
            }
            if (this == o) {
                return true;
            }
            try {
                RepositoryDef r;
                block24: {
                    if (o instanceof OMIRepository) {
                        block22: {
                            OMIRepository l = (OMIRepository)o;
                            try {
                                InetAddress myAddress = InetAddress.getByName(this._host);
                                InetAddress hisAddress = InetAddress.getByName(l.getHost());
                                if (!myAddress.equals(hisAddress) || this._portInt != l.getPort()) {
                                    return false;
                                }
                            }
                            catch (UnknownHostException uhe) {
                                if (this._host.equalsIgnoreCase(l.getHost()) && this._portInt == l.getPort()) break block22;
                                return false;
                            }
                        }
                        return true;
                    }
                    if (!(o instanceof RepositoryDef)) break block23;
                    r = (RepositoryDef)o;
                    String protocol = r.getProtocol();
                    if (protocol == null) {
                        return false;
                    }
                    if (!protocol.equalsIgnoreCase("omi")) {
                        return false;
                    }
                    try {
                        InetAddress myAddress = InetAddress.getByName(this._host);
                        InetAddress hisAddress = InetAddress.getByName(r.getHost());
                        if (!myAddress.equals(hisAddress)) {
                            return false;
                        }
                    }
                    catch (UnknownHostException uhe) {
                        if (this._host.equalsIgnoreCase(r.getHost()) && this._portInt == Integer.parseInt(r.getPort())) break block24;
                        return false;
                    }
                }
                if (this._portInt != Integer.valueOf(r.getPort())) {
                    return false;
                }
                if (this._defaultRepository == null) {
                    if (r.getBase() != null) {
                        return false;
                    }
                } else {
                    String otherBase = r.getBase();
                    if (otherBase.length() != 17 || otherBase.charAt(8) != '.') {
                        String baseId = (String)this._repositories.get(otherBase.toUpperCase());
                        if (baseId == null) {
                            return false;
                        }
                        otherBase = baseId;
                    }
                    if (!this._defaultRepository.equalsIgnoreCase(otherBase)) {
                        return false;
                    }
                }
                return true;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public String getHost() throws RemoteException {
        try {
            this.pulseCheck();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
        return this._host;
    }

    @Override
    public int getPort() throws RemoteException {
        try {
            this.pulseCheck();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
        return this._portInt;
    }

    @Override
    public String getBase() throws RemoteException {
        try {
            this.pulseCheck();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
        return this._defaultRepository;
    }

    @Override
    public String getPrincipal() throws RemoteException {
        try {
            this.pulseCheck();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
        return this._principal;
    }

    @Override
    public MetadataInterface getTrackedObject(int trackingId) throws RemoteException {
        return null;
    }

    @Override
    public java.lang.Object narrow(RepositoryData entity) throws ServiceException, RemoteException {
        return entity;
    }

    @Override
    public void addRootFolder(FolderInterface folder) throws ServiceException, RemoteException {
        this.pulseCheck();
        try {
            Tree tree = (Tree)folder.getRepositoryEntity();
            tree.getParentTrees().clear();
            SoftwareComponent sc = this.getBipRoot(null);
            if (sc != null) {
                tree.getSoftwareComponents().add((java.lang.Object)sc);
            }
            tree.updateMetadataAll();
        }
        catch (MdException mex) {
            throw new ServiceException(RB.getStringResource("OMIRepository.updateexcept.msg.txt"));
        }
    }

    @Override
    public FolderInterface removeRootFolder(String folderName) throws ServiceException, RemoteException {
        this.pulseCheck();
        FolderInterface fi = this.getRootFolder(folderName);
        if (fi == null) {
            return null;
        }
        SoftwareComponent sc = this.getBipRoot(null);
        if (sc != null) {
            try {
                sc.getSoftwareTrees().remove(fi.getRepositoryEntity());
                return fi;
            }
            catch (MdException mex) {
                throw new ServiceException(RB.getStringResource("OMIRepository.updateexcept.msg.txt"));
            }
        }
        return null;
    }

    @Override
    public FolderInterface makeRootFolder(String name) throws ServiceException, RemoteException {
        this.pulseCheck();
        FolderInterface mi = null;
        if (this._defaultRepository == null) {
            throw new ServiceException(RB.getStringResource("OMIRepository.nodfltrepos.msg.txt"));
        }
        try {
            if (!Names.validateOMRObjectName(name, true)) {
                throw new ServiceException(RB.getStringResource("OMIRepository.invalidName.msg.txt"));
            }
        }
        catch (IllegalArgumentException e) {
            throw new ServiceException(e.getMessage());
        }
        String reposId = this._defaultRepository;
        try {
            SoftwareComponent bipRoot = this.getBipRoot(reposId);
            if (bipRoot == null) {
                throw new ServiceException(RB.getStringResource("OMIRepository.norootfnd.msg.txt"));
            }
            AssociationList treeAss = bipRoot.getSoftwareTrees();
            Iterator treeIt = treeAss.iterator();
            Tree newTree = null;
            while (treeIt.hasNext()) {
                Tree nextTree = (Tree)treeIt.next();
                if (!nextTree.getName().equals(name)) continue;
                newTree = nextTree;
            }
            if (newTree == null) {
                newTree = (Tree)this._mdfactory.createComplexMetadataObject(this._mdstore, null, name, "Tree", reposId.substring(9));
                newTree.setTreeType("Repository");
                try {
                    treeAss.add((java.lang.Object)newTree);
                    bipRoot.updateMetadataAll();
                }
                catch (MdException ex) {
                    throw new ServiceException(ex, RB.getStringResource("OMIRepository.treeadderr.msg.txt"));
                }
            }
            mi = (FolderInterface)this.factoryProcess(newTree);
            return mi;
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
    }

    @Override
    public FolderInterface getRootFolder(String name) throws ServiceException, RemoteException {
        this.pulseCheck();
        return this.getRootFolder(name, this._defaultRepository);
    }

    public FolderInterface getRootFolder(String name, String repository) throws ServiceException, RemoteException {
        List roots;
        this.pulseCheck();
        if (name == null) {
            name = BIP_ROOTNAME;
        }
        if ((roots = this.getRootFolders(repository)) == null) {
            return null;
        }
        for (FolderInterface folder : roots) {
            if (!name.equals(folder.getName())) continue;
            return folder;
        }
        return null;
    }

    @Override
    public List getRootFolders() throws ServiceException, RemoteException {
        this.pulseCheck();
        return this.getRootFolders(this._defaultRepository);
    }

    public List getRootFolders(String repository) throws ServiceException, RemoteException {
        this.pulseCheck();
        if (repository.length() != 17 || repository.charAt(8) != '.') {
            repository = (String)this._repositories.get(repository.toUpperCase());
        }
        String reposId = repository.substring(9);
        ArrayList<MetadataInterface> roots = new ArrayList<MetadataInterface>(8);
        SoftwareComponent bipRoot = this.getBipRoot(repository);
        if (bipRoot == null) {
            return roots;
        }
        try {
            AssociationList treeAss = bipRoot.getSoftwareTrees();
            for (Root root : treeAss) {
                if (!root.getFQID().startsWith(reposId)) continue;
                MetadataInterface mi = this.factoryProcess(root);
                roots.add(mi);
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, RB.getStringResource("OMIRepository.rtndexcept.ex.txt"));
        }
        return roots;
    }

    private SoftwareComponent getBipRoot(String repository) throws ServiceException, RemoteException {
        this.pulseCheck();
        if (this._bipRoot == null) {
            Filter filter = new Filter();
            FilterComponent fc = new FilterComponent("ClassIdentifier", 0, ROOT_CLASSIDENTIFIER);
            fc.addComponent(new FilterComponent("Name", 0, BIP_COMPONENTNAME));
            fc.setAggregation(0);
            filter.setFilterComponent(fc);
            filter.setOMRRepository(repository);
            filter.setType("SoftwareComponent");
            String type = "SoftwareComponent";
            int flags = 0;
            String filterString = filter.getXMLSelectString() + (filter.getOMRTemplate() == null ? "" : filter.getOMRTemplate());
            List rootComponents = null;
            try {
                int my_flags = 396;
                if ((flags & Integer.MIN_VALUE) != 0) {
                    flags &= Integer.MAX_VALUE;
                    my_flags = 0;
                }
                rootComponents = this._mdfactory.getOMIUtil().getMetadataObjectsSubset((MdStore)this._mdstore, repository, type, my_flags | flags, filterString);
            }
            catch (MdException mex) {
                if (this.isConnectionException(mex) && this.doReconnect()) {
                    return this.getBipRoot(repository);
                }
                throw new ServiceException(mex, RB.getStringResource("OMIRepository.geterror.ex.txt"));
            }
            for (SoftwareComponent folder : rootComponents) {
                if (!folder.getName().equals(BIP_COMPONENTNAME)) continue;
                this._bipRoot = folder;
            }
        }
        if (this._bipRoot == null) {
            throw new ServiceException(RB.getStringResource("OMIRepository.norootfnd.msg.txt"));
        }
        return this._bipRoot;
    }

    @Override
    public MetadataInterface getObjectByPath(PathUrl url) throws ServiceException, RemoteException {
        String itemName;
        this.pulseCheck();
        if (url == null) {
            return null;
        }
        String itemType = url.getType();
        String rootFolderName = url.getRootTree();
        FolderInterface folder = this.getRootFolder(rootFolderName);
        if (folder == null) {
            return null;
        }
        if ((url.getRootTree() == null || url.getRootTree().trim().length() == 0) && url.getPath() == null && "/".equals(url.getName()) && "Folder".equals(url.getType())) {
            return this._omiServer.getRootFolder();
        }
        String path = url.getPath();
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"OMIRepository.getbypath.msg.fmt.txt", (java.lang.Object)path, (java.lang.Object)url.getName(), (java.lang.Object)url.getType()));
        }
        if (path != null) {
            StringTokenizer st = new StringTokenizer(path, "/", false);
            while (st.hasMoreTokens()) {
                String name = st.nextToken();
                List subfolders = folder.getSubfolders();
                boolean gotFolder = false;
                for (MetadataInterface mi : subfolders) {
                    if (!(mi instanceof FolderInterface) || !mi.getName().equals(name)) continue;
                    folder = (FolderInterface)mi;
                    gotFolder = true;
                    break;
                }
                if (gotFolder) continue;
                if (this._logger != null && this._logger.isDebugEnabled()) {
                    this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"OMIRepository.nofolder.msg.fmt", (java.lang.Object)name, (java.lang.Object)path));
                }
                return null;
            }
        }
        if ((itemName = url.getName()) != null) {
            if (itemType != null && itemType.equalsIgnoreCase("Folder")) {
                List subfolders = folder.getSubfolders();
                for (MetadataInterface mi : subfolders) {
                    if (!(mi instanceof FolderInterface) || !mi.getName().equals(itemName)) continue;
                    folder = (FolderInterface)mi;
                    return folder;
                }
                if (this._logger != null && this._logger.isDebugEnabled()) {
                    this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"OMIRepository.nofolder.msg.fmt", (java.lang.Object)itemName, (java.lang.Object)path));
                }
                return null;
            }
            return folder.getItemByType(itemName, itemType);
        }
        return folder;
    }

    @Override
    public MetadataInterface getObjectByPath(String rootFolderName, String path, Class type) throws ServiceException, RemoteException {
        this.pulseCheck();
        if (rootFolderName == null) {
            rootFolderName = BIP_ROOTNAME;
        }
        if (path == null) {
            return null;
        }
        String pathName = null;
        int index = path.lastIndexOf("/");
        if (index < 0) {
            pathName = path;
            path = null;
        } else {
            pathName = path.substring(index + 1);
            path = path.substring(0, index);
        }
        String className = type.getName();
        index = className.lastIndexOf(".");
        className = className.substring(index + 1);
        PathUrl pathurl = new PathUrl(this._defaultRepository, rootFolderName, path, pathName, className);
        return this.getObjectByPath(pathurl);
    }

    @Override
    public MetadataInterface getObjectByPath(String rootFolderName, String path, String type) throws ServiceException, RemoteException {
        this.pulseCheck();
        return this.getObjectByPathString(rootFolderName, path, type);
    }

    @Override
    public MetadataInterface getObjectByPathString(String rootFolderName, String path, String type) throws ServiceException, RemoteException {
        this.pulseCheck();
        if (rootFolderName == null) {
            rootFolderName = BIP_ROOTNAME;
        }
        if (path == null) {
            return null;
        }
        String pathName = null;
        int index = path.lastIndexOf("/");
        if (index < 0) {
            pathName = path;
            path = null;
        } else {
            pathName = path.substring(index + 1);
            path = path.substring(0, index);
        }
        PathUrl pathurl = new PathUrl(this._defaultRepository, rootFolderName, path, pathName, type);
        return this.getObjectByPath(pathurl);
    }

    @Override
    public FilteredFolderInterface searchTree(String rootFolderName, FilterInterface filter) throws ServiceException, RemoteException {
        FolderInterface folder;
        this.pulseCheck();
        if (rootFolderName == null) {
            rootFolderName = BIP_ROOTNAME;
        }
        if ((folder = this.getRootFolder(rootFolderName)) == null) {
            return null;
        }
        return this.searchTreeFromBaseWithScope(folder, filter, -1);
    }

    @Override
    public FilteredFolderInterface searchTree(FolderInterface baseFolder, FilterInterface filter) throws ServiceException, RemoteException {
        this.pulseCheck();
        return this.searchTreeFromBaseWithScope(baseFolder, filter, -1);
    }

    @Override
    public FilteredFolderInterface searchTreeFromBase(FolderInterface baseFolder, FilterInterface filter) throws ServiceException, RemoteException {
        this.pulseCheck();
        if (baseFolder == null) {
            return null;
        }
        return this.searchTreeFromBaseWithScope(baseFolder, filter, -1);
    }

    @Override
    public FilteredFolderInterface searchTreeFromBaseWithScope(FolderInterface baseFolder, FilterInterface filter, int levels) throws ServiceException, RemoteException {
        PartialFolderResultsException pfre = null;
        this.pulseCheck();
        if (baseFolder == null) {
            return null;
        }
        ArrayList<String> treeList = new ArrayList<String>(8);
        HashMap<String, FilteredFolder> map = new HashMap<String, FilteredFolder>(8);
        FilteredFolder ffi = new FilteredFolder(null, baseFolder);
        ffi.setRepository(this);
        map.put(baseFolder.getReposId(), ffi);
        treeList.add(baseFolder.getReposId());
        this.buildChildStructure(ffi, levels, treeList, map);
        String[] treeArray = new String[treeList.size()];
        int treeListSize = treeList.size();
        for (int i = 0; i < treeListSize; ++i) {
            treeArray[i] = (String)treeList.get(i);
        }
        String origTemplate = filter.getOMRTemplate();
        String xmlselectString = filter.getXMLSelectString();
        if ("UNSUPPORTED".equals(xmlselectString)) {
            throw new FilterNotSupportedException(Message.format((ResourceBundle)RB.getResources(), (String)"Repository.badFilter.ex.fmt.txt", (java.lang.Object)filter.toString()));
        }
        TreeSearchFilter myFilter = new TreeSearchFilter(filter, treeArray);
        myFilter.setOMRTemplate(origTemplate);
        List searchCandidates = null;
        try {
            searchCandidates = this.search(myFilter);
        }
        catch (PartialListResultsException plre) {
            if (pfre == null) {
                pfre = new PartialFolderResultsException(ffi, RB.getStringResource("OMIRepository.geterror.ex.txt"));
            }
            Throwable[] exceptions = plre.getExceptions();
            for (int i = 0; i < exceptions.length; ++i) {
                pfre.addException(exceptions[i]);
            }
            searchCandidates = plre.getResults();
        }
        if (searchCandidates == null || searchCandidates.size() == 0) {
            if (pfre != null) {
                throw pfre;
            }
            return null;
        }
        for (MetadataInterface mi : searchCandidates) {
            List plist = mi.getParents();
            for (FolderInterface parent : plist) {
                String fqid = parent.getReposId();
                FilteredFolderInterface filteredParent = (FilteredFolderInterface)map.get(fqid);
                if (filteredParent == null) continue;
                filteredParent.addLocalItem(mi);
                FilteredFolderInterface grandParent = (FilteredFolderInterface)filteredParent.getParent();
                while (grandParent != null) {
                    grandParent.addSubfolder(filteredParent);
                    filteredParent = grandParent;
                    grandParent = (FilteredFolderInterface)filteredParent.getParent();
                }
            }
        }
        if (pfre != null) {
            throw pfre;
        }
        return ffi;
    }

    private void buildChildStructure(FilteredFolderInterface ffi, int levels, List treeList, Map map) throws ServiceException {
        if (levels == 0) {
            return;
        }
        try {
            FolderInterface folder = ffi.getFolder();
            List subfolders = folder.getSubfolders();
            for (MetadataInterface o : subfolders) {
                try {
                    FolderInterface subfolder = (FolderInterface)o;
                    FilteredFolder sfi = new FilteredFolder(ffi, subfolder);
                    sfi.setRepository(this);
                    map.put(subfolder.getReposId(), sfi);
                    treeList.add(subfolder.getReposId());
                    if (levels <= 0 && levels != -1) continue;
                    this.buildChildStructure(sfi, levels == -1 ? -1 : levels - 1, treeList, map);
                }
                catch (ClassCastException ccex) {
                    if (this._logger == null) continue;
                    this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"OMIRepository.notfolder.ex.fmt.txt", (java.lang.Object)o.getName(), (java.lang.Object)o.getClass().getName()));
                }
            }
        }
        catch (RemoteException rex) {
            throw new ServiceException(rex, rex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(RepositoryListenerInterface listener) throws ServiceException, RemoteException {
        this.pulseCheck();
        if (this._listeners != null) {
            ArrayList arrayList = this._listeners;
            synchronized (arrayList) {
                this._listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(RepositoryListenerInterface listener) throws ServiceException, RemoteException {
        this.pulseCheck();
        if (this._listeners != null) {
            ArrayList arrayList = this._listeners;
            synchronized (arrayList) {
                this._listeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(int event) throws RemoteException {
        RepositoryEvent repEvent = new RepositoryEvent(this, event);
        ArrayList list = null;
        ArrayList arrayList = this._listeners;
        synchronized (arrayList) {
            list = new ArrayList(this._listeners);
        }
        for (RepositoryListenerInterface next : list) {
            next.repositoryCallback(repEvent);
        }
    }

    @Override
    public void metadataChange(MetadataChangeEvent event) throws RemoteException {
        block5: {
            try {
                this.pulseCheck();
            }
            catch (ServiceException svcEx) {
                throw new IllegalStateException(svcEx.getMessage());
            }
            String id = event.getRepositoryId();
            MetadataInterface mi = (MetadataInterface)this._cache.get(id);
            if (mi != null) {
                try {
                    this.refreshEntity(mi);
                }
                catch (ServiceException svcex) {
                    if (this._logger == null) break block5;
                    this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"OMIRepository.refrshfail.ex.fmt.txt", (java.lang.Object)id), (Throwable)((java.lang.Object)svcex));
                }
            }
        }
    }

    @Override
    public void refreshEntity(MetadataInterface mi) throws ServiceException, RemoteException {
        this.pulseCheck();
        if (mi == null) {
            return;
        }
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"OMIRepository.refreshing.msg.fmt.txt", (java.lang.Object)mi));
        }
        CMetadata cm = (CMetadata)mi.getRepositoryEntity();
        try {
            this._mdstore.refreshObjectFromServer(cm, false, true, true);
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, Message.format((ResourceBundle)RB.getResources(), (String)"OMIRepository.refrshfail.ex.fmt.txt", (java.lang.Object)cm.getFQID()));
        }
    }

    public void MdObjectModified(MdEvent e) throws RemoteException {
        CMetadata cm = (CMetadata)e.getSource();
        MetadataInterface mi = (MetadataInterface)this._cache.get(cm.getFQID());
        if (mi != null) {
            InformationServiceInterface is = OMIRepository.getInformationService();
            MetadataChangeEvent event = new MetadataChangeEvent(this._url, cm.getFQID());
            is.metadataChange(event);
        } else {
            try {
                mi = this.factoryProcess(cm);
            }
            catch (ServiceException serviceException) {
                // empty catch block
            }
        }
    }

    @Override
    public synchronized int trackEntity(MetadataInterface entity) throws RemoteException {
        return -1;
    }

    @Override
    public String getDefaultRepositoryName() throws RemoteException {
        try {
            this.pulseCheck();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
        return this._defaultName;
    }

    @Override
    public String getDefaultRepositoryId() throws RemoteException {
        try {
            this.pulseCheck();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
        return this._defaultRepository;
    }

    @Override
    public synchronized ChildRepositoryInterface newChild() throws ServiceException, RemoteException {
        this.pulseCheck();
        MdObjectStore newstore = this._mdfactory.createObjectStore((MdStore)this._mdstore, "child" + this._childnum);
        ++this._childnum;
        OMIChildRepository ri = new OMIChildRepository(this._mdfactory, newstore, this, this._childnum);
        ri.setIdentity(this.getIdentity());
        ri.setUserContext(this.getUserContext());
        return ri;
    }

    protected synchronized void flush() throws ServiceException, RemoteException {
        try {
            this._mdstore.updatedMetadataAll();
        }
        catch (MdException t) {
            if (this._logger != null && this._logger.isDebugEnabled()) {
                this._logger.debug(RB.getStringResource("OMIRepository.updateexcept.msg.txt"), (Throwable)t);
            }
            throw new ServiceException(t, RB.getStringResource("OMIRepository.updateexcept.msg.txt"));
        }
    }

    protected String getSubNum() throws RemoteException {
        return this._subNum;
    }

    @Override
    public String getReposKey(Root reposObject) throws ServiceException, RemoteException {
        return reposObject.getFQID() + '/' + reposObject.getCMetadataType();
    }

    @Override
    public Root createMetadata(String name, String type) throws RemoteException, ServiceException {
        this.pulseCheck();
        String reposId = this._defaultRepository;
        if (reposId == null) {
            throw new ServiceException(RB.getStringResource("OMIRepository.nodefaultrepos.msg.txt"));
        }
        int index = reposId.indexOf(46);
        reposId = reposId.substring(index + 1);
        Root root = (Root)this._mdfactory.createComplexMetadataObject(this._mdstore, null, name, type, reposId);
        return root;
    }

    @Override
    public List browseSearch(FilterInterface filter) throws ServiceException, RemoteException {
        this.pulseCheck();
        if (!this.isConnected()) {
            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"OMIRepository.cnctfail.ex.fmt", (java.lang.Object)this._host, (java.lang.Object)String.valueOf(this._portInt)));
        }
        ArrayList<BrowseMetadata> result = new ArrayList<BrowseMetadata>(8);
        int flags = filter.getOMRFlags();
        String type = filter.getOMRType();
        if (type == null) {
            type = "Root";
            flags |= 0x10;
        }
        String defaultTemplate = null;
        defaultTemplate = "<Templates>\n  <" + type + ">\n    <Keywords/>\n    <ResponsibleParties/>\n  </" + type + ">\n  <ResponsibleParty>\n    <Persons/>\n  </ResponsibleParty>\n  <Person>\n    <EmailAddresses/>\n  </Person>\n</Templates>";
        String filterString = filter.getXMLSelectString();
        if ("UNSUPPORTED".equals(filterString)) {
            throw new FilterNotSupportedException(Message.format((ResourceBundle)RB.getResources(), (String)"Repository.badFilter.ex.fmt.txt", (java.lang.Object)filter.toString()));
        }
        filterString = filterString + (filter.getOMRTemplate() == null ? defaultTemplate : filter.getOMRTemplate());
        String repository = filter.getOMRRepository();
        if (repository == null) {
            repository = this._defaultRepository;
        }
        int my_flags = 67109260;
        if ((flags & Integer.MIN_VALUE) != 0) {
            flags &= Integer.MAX_VALUE;
            my_flags = 0;
        }
        try {
            List list = this._mdfactory.getOMIUtil().getMetadataObjectsNoCache(type, repository, filterString, my_flags | flags);
            for (Map nextMap : list) {
                this.updateMap(nextMap);
                BrowseMetadata bm = new BrowseMetadata(nextMap);
                result.add(bm);
            }
        }
        catch (MdException mex) {
            if (this.isConnectionException(mex) && this.doReconnect()) {
                return this.browseSearch(filter);
            }
            throw new ServiceException(mex, RB.getStringResource("OMIRepository.geterror.ex.txt"));
        }
        return result;
    }

    @Override
    public BrowseMetadataInterface browseFetch(String entityKey, FilterInterface filter) throws ServiceException, RemoteException {
        if (entityKey == null) {
            return null;
        }
        this.pulseCheck();
        if (!this.isConnected()) {
            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"OMIRepository.cnctfail.ex.fmt", (java.lang.Object)this._host, (java.lang.Object)String.valueOf(this._portInt)));
        }
        BrowseMetadata result = new BrowseMetadata(new HashMap(8));
        String type = null;
        try {
            ISEntityKey iseKey = new ISEntityKey(entityKey);
            String reposKey = iseKey.getRepositoryKey();
            OMRRepositoryKey omrKey = new OMRRepositoryKey(reposKey);
            type = omrKey.getType();
            entityKey = omrKey.getId();
        }
        catch (IllegalArgumentException iaex) {
            OMRRepositoryKey omrKey = new OMRRepositoryKey(entityKey);
            type = omrKey.getType();
            entityKey = omrKey.getId();
        }
        if (entityKey != null && (entityKey.length() != 17 || entityKey.charAt(8) != '.')) {
            String reposId = (String)this._repositories.get(entityKey.toUpperCase());
            if (reposId == null) {
                throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"OMIRepository.wrongrepos.ex.fmt.txt", (java.lang.Object)entityKey));
            }
            entityKey = reposId;
        }
        if (type == null) {
            throw new ServiceException(RB.getStringResource("OMIRepository.typereq.ex.txt"));
        }
        String defaultTemplate = null;
        defaultTemplate = "<Templates>\n  <" + type + ">\n    <Keywords/>\n    <ResponsibleParties/>\n  </" + type + ">\n  <ResponsibleParty>\n    <Persons/>\n  </ResponsibleParty>\n  <Person>\n    <EmailAddresses/>\n  </Person>\n</Templates>";
        String template = null;
        if (filter != null && filter.getOMRTemplate() != null) {
            template = filter.getOMRTemplate();
        }
        int flags = 67110924;
        if (filter != null && filter.getOMRFlags() != 0) {
            int fflags = filter.getOMRFlags();
            int n = flags = (fflags & Integer.MIN_VALUE) != 0 ? fflags & Integer.MAX_VALUE : flags | fflags;
        }
        if (template == null || template.length() == 0) {
            flags |= 1;
            template = defaultTemplate;
        }
        try {
            Map objectMap = this._mdfactory.getOMIUtil().getMetadataNoCache(type, entityKey, template, flags);
            this.updateMap(objectMap);
            result = new BrowseMetadata(objectMap);
        }
        catch (MdException mex) {
            if (this.isConnectionException(mex) && this.doReconnect()) {
                return this.browseFetch(entityKey, filter);
            }
            throw new ServiceException(mex, RB.getStringResource("OMIRepository.geterror.ex.txt"));
        }
        return result;
    }

    @Override
    public List browseFolder(String folderISEntityKey, FilterInterface filter) throws ServiceException, RemoteException {
        String type = null;
        String template = null;
        if (folderISEntityKey == null) {
            throw new IllegalArgumentException();
        }
        this.pulseCheck();
        if (!this.isConnected()) {
            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"OMIRepository.cnctfail.ex.fmt", (java.lang.Object)this._host, (java.lang.Object)String.valueOf(this._portInt)));
        }
        try {
            ISEntityKey iseKey = new ISEntityKey(folderISEntityKey);
            String reposKey = iseKey.getRepositoryKey();
            OMRRepositoryKey omrKey = new OMRRepositoryKey(reposKey);
            type = omrKey.getType();
            folderISEntityKey = omrKey.getId();
        }
        catch (IllegalArgumentException iaex) {
            OMRRepositoryKey omrKey = new OMRRepositoryKey(folderISEntityKey);
            type = omrKey.getType();
            folderISEntityKey = omrKey.getId();
        }
        if (filter == null || filter.getOMRType() == null && (filter.getXMLSelectString() == null || filter.getXMLSelectString().length() == 0)) {
            template = filter != null && filter.getOMRTemplate() != null ? filter.getOMRTemplate() : "<Templates>\n  <Transformation>\n    <Keywords/>\n    <ResponsibleParties/>\n  </Transformation>\n  <ClassifierMap>\n    <Keywords/>\n    <ResponsibleParties/>\n  </ClassifierMap>\n  <ResponsibleParty>\n    <Persons/>\n  </ResponsibleParty>\n  <Person>\n    <EmailAddresses/>\n  </Person>\n</Templates>";
            int flags = 67110925;
            if (filter != null && filter.getOMRFlags() != 0) {
                int more_flags = filter.getOMRFlags();
                flags = (more_flags & Integer.MIN_VALUE) != 0 ? more_flags & Integer.MAX_VALUE : flags | more_flags;
            }
            try {
                List subfolderList;
                ArrayList<BrowseMetadata> result = new ArrayList<BrowseMetadata>(8);
                Map objectMap = this._mdfactory.getOMIUtil().getMetadataNoCache(type, folderISEntityKey, template, flags);
                List memberList = (List)objectMap.get("Members");
                if (memberList != null) {
                    for (Map nextMember : memberList) {
                        this.updateMap(nextMember);
                        BrowseMetadata bm = new BrowseMetadata(nextMember);
                        result.add(bm);
                    }
                }
                if ((subfolderList = (List)objectMap.get("SubTrees")) != null) {
                    for (Map nextsubfolder : subfolderList) {
                        this.updateMap(nextsubfolder);
                        BrowseMetadata bm = new BrowseMetadata(nextsubfolder);
                        result.add(bm);
                    }
                }
                return result;
            }
            catch (MdException mex) {
                if (this.isConnectionException(mex) && this.doReconnect()) {
                    return this.browseFolder(folderISEntityKey, filter);
                }
                throw new ServiceException(mex, RB.getStringResource("OMIRepository.geterror.ex.txt"));
            }
        }
        TreeSearchFilter tFilter = new TreeSearchFilter(filter, folderISEntityKey);
        return this.browseSearch(tFilter);
    }

    @Override
    public List browseFolderRecursive(String folderISEntityKey, FilterInterface filter) throws ServiceException, RemoteException {
        if (folderISEntityKey == null) {
            throw new IllegalArgumentException();
        }
        this.pulseCheck();
        if (!this.isConnected()) {
            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"OMIRepository.cnctfail.ex.fmt", (java.lang.Object)this._host, (java.lang.Object)String.valueOf(this._portInt)));
        }
        if (filter == null) {
            filter = new Filter();
        }
        String type = null;
        String keyType = null;
        try {
            ISEntityKey iseKey = new ISEntityKey(folderISEntityKey);
            String reposKey = iseKey.getRepositoryKey();
            OMRRepositoryKey omrKey = new OMRRepositoryKey(reposKey);
            keyType = omrKey.getType();
            folderISEntityKey = omrKey.getId();
        }
        catch (IllegalArgumentException iaex) {
            OMRRepositoryKey omrKey = new OMRRepositoryKey(folderISEntityKey);
            keyType = omrKey.getType();
            folderISEntityKey = omrKey.getId();
        }
        String template = "<Templates>\n  <Tree>\n    <SubTrees/>\n    <Members/>\n  </Tree>\n  <Transformation>\n    <Keywords/>\n    <ResponsibleParties/>\n  </Transformation>\n  <ClassifierMap>\n    <Keywords/>\n    <ResponsibleParties/>\n  </ClassifierMap>\n  <ResponsibleParty>\n    <Persons/>\n  </ResponsibleParty>\n  <Person>\n    <EmailAddresses/>\n  </Person>\n</Templates>";
        type = filter.getOMRType();
        if (type == null) {
            type = keyType;
            String select = filter.getXMLSelectString();
            if (select == null || select.length() == 0) {
                int flags = 67110924;
                if (filter.getOMRFlags() != 0) {
                    int fflags = filter.getOMRFlags();
                    int n = flags = (fflags & Integer.MIN_VALUE) != 0 ? fflags & Integer.MAX_VALUE : flags | fflags;
                }
                if (filter.getOMRTemplate() != null) {
                    template = filter.getOMRTemplate();
                }
                try {
                    List subfolderList;
                    ArrayList<BrowseMetadata> result = new ArrayList<BrowseMetadata>(8);
                    Map objectMap = this._mdfactory.getOMIUtil().getMetadataNoCache("Tree", folderISEntityKey, template, flags);
                    List memberList = (List)objectMap.get("Members");
                    if (memberList != null) {
                        for (Map nextMember : memberList) {
                            this.updateMap(nextMember);
                            BrowseMetadata bm = new BrowseMetadata(nextMember);
                            result.add(bm);
                        }
                    }
                    if ((subfolderList = (List)objectMap.get("SubTrees")) != null) {
                        for (Map nextsubfolder : subfolderList) {
                            this.updateMap(nextsubfolder);
                            BrowseMetadata bm = new BrowseMetadata(nextsubfolder);
                            result.add(bm);
                        }
                    }
                    return result;
                }
                catch (MdException mex) {
                    if (this.isConnectionException(mex) && this.doReconnect()) {
                        return this.browseFolderRecursive(folderISEntityKey, filter);
                    }
                    throw new ServiceException(mex, RB.getStringResource("OMIRepository.geterror.ex.txt"));
                }
            }
        }
        if (filter.getOMRTemplate() == null || filter.getOMRTemplate().length() == 0) {
            filter.setOMRTemplate(template);
        }
        template = "<Templates>\n  <Tree>\n    <SubTrees/>\n  </Tree>\n</Templates>";
        int flags = 4;
        try {
            ArrayList treeList = new ArrayList(8);
            Map objectMap = this._mdfactory.getOMIUtil().getMetadataNoCache("Tree", folderISEntityKey, template, flags);
            this.getSubtreesFromMap(objectMap, treeList);
            if (treeList.size() > 0) {
                String[] trees = treeList.toArray(new String[0]);
                TreeSearchFilter tFilter = new TreeSearchFilter(filter, trees);
                return this.browseSearch(tFilter);
            }
        }
        catch (MdException mex) {
            if (this.isConnectionException(mex) && this.doReconnect()) {
                return this.browseFolderRecursive(folderISEntityKey, filter);
            }
            throw new ServiceException(mex, RB.getStringResource("OMIRepository.geterror.ex.txt"));
        }
        return new ArrayList(8);
    }

    @Override
    public BrowseMetadataInterface browseObjectByPath(PathUrl pathurl, FilterInterface filter) throws ServiceException, RemoteException {
        String repository;
        int index;
        this.pulseCheck();
        boolean folderMode = false;
        StringBuffer buffer = new StringBuffer(8);
        buffer.append("<XMLSelect search=\"Tree");
        String path = pathurl.getPath();
        String type = pathurl.getType();
        String name = pathurl.getName();
        ArrayList<String> pathList = null;
        String rootFolder = pathurl.getRootTree();
        String container = null;
        if (filter == null) {
            filter = new Filter();
        }
        if (type.equalsIgnoreCase("Folder")) {
            folderMode = true;
        }
        if (path != null) {
            StringTokenizer st = new StringTokenizer(path, "/", false);
            pathList = new ArrayList(8);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                pathList.add(token);
            }
        }
        if (folderMode) {
            if (name == null) {
                container = rootFolder;
            } else {
                if (pathList == null) {
                    pathList = new ArrayList<String>(8);
                }
                container = name;
                pathList.add(0, rootFolder);
            }
        } else if (pathList != null && pathList.size() > 0) {
            container = (String)pathList.get(pathList.size() - 1);
            pathList.remove(container);
            pathList.add(0, rootFolder);
        } else {
            container = rootFolder;
        }
        buffer.append("[@Name='" + container + "']");
        buffer.append("[");
        if (pathList != null && pathList.size() > 0) {
            for (int i = pathList.size() - 1; i >= 0; --i) {
                buffer.append("ParentTree/Tree[@Name='" + pathList.get(i) + "']/");
            }
        }
        buffer.append("SoftwareComponents/SoftwareComponent[@Name='BIP Service']]\" />");
        int my_flags = 67109260;
        int flags = filter.getOMRFlags();
        String defaultTemplate = "<Templates>\n  <Tree>\n    <Members/>\n  </Tree>\n  <Transformation>\n    <Keywords/>\n    <ResponsibleParties/>\n  </Transformation>\n  <ClassifierMap>\n    <Keywords/>\n    <ResponsibleParties/>\n  </ClassifierMap>\n  <ResponsibleParty>\n    <Persons/>\n  </ResponsibleParty>\n  <Person>\n    <EmailAddresses/>\n  </Person>\n</Templates>";
        String filterTemplate = filter.getOMRTemplate();
        if (filterTemplate != null && (index = filterTemplate.indexOf("<Tree>")) < 0) {
            String ttemplate = filterTemplate.toLowerCase();
            index = ttemplate.indexOf("<templates>");
            String part1 = filterTemplate.substring(0, index);
            filterTemplate = part1 + "\n  <Tree>\n    <Members/>\n  </Tree>";
        }
        String filterString = buffer.toString() + (filterTemplate == null ? defaultTemplate : filterTemplate);
        if ((flags & Integer.MIN_VALUE) != 0) {
            flags &= Integer.MAX_VALUE;
            my_flags = 0;
        }
        if ((repository = filter.getOMRRepository()) == null) {
            repository = this._defaultRepository;
        }
        BrowseMetadata containerBM = null;
        try {
            List list = this._mdfactory.getOMIUtil().getMetadataObjectsNoCache("Tree", repository, filterString, my_flags | flags);
            if (list.size() == 0) {
                return null;
            }
            Map nextMap = (Map)list.get(0);
            this.updateMap(nextMap);
            containerBM = new BrowseMetadata(nextMap);
        }
        catch (MdException mex) {
            if (this.isConnectionException(mex) && this.doReconnect()) {
                return this.browseObjectByPath(pathurl, filter);
            }
            throw new ServiceException(mex, RB.getStringResource("OMIRepository.geterror.ex.txt"));
        }
        if (folderMode) {
            return containerBM;
        }
        List members = (List)containerBM.get("Members");
        if (members != null) {
            for (BrowseMetadataInterface next : members) {
                if (!name.equalsIgnoreCase(next.getName()) || !type.equalsIgnoreCase(next.getSmartType())) continue;
                return next;
            }
        }
        return null;
    }

    private void updateMap(Map rawData) throws RemoteException {
        String idString;
        long result;
        double sasDate;
        String smartType = this.getSmartType(rawData);
        rawData.put("smarttype", smartType);
        try {
            String isek = this.getBrowseEntityKey(smartType, (String)rawData.get("MetadataObjectType"), (String)rawData.get("Id"));
            rawData.put("ISEntityKey", isek);
        }
        catch (ServiceException svcEx) {
            rawData.put("ISEntityKey", "Error getting entity key");
        }
        String dateString = (String)rawData.get("MetadataCreated");
        if (dateString != null) {
            sasDate = Double.valueOf(dateString);
            result = DateUtil.SASDateTimeToJavaDate(sasDate, TimeZone.getTimeZone("GMT"));
            rawData.put("MetadataCreated", Long.toString(result));
        }
        if ((dateString = (String)rawData.get("MetadataUpdated")) != null) {
            sasDate = Double.valueOf(dateString);
            result = DateUtil.SASDateTimeToJavaDate(sasDate, TimeZone.getTimeZone("GMT"));
            rawData.put("MetadataUpdated", Long.toString(result));
        }
        if ((idString = (String)rawData.get("Id")) != null) {
            rawData.put("reposid", idString);
        }
        Collection valueCollection = rawData.values();
        for (java.lang.Object o : valueCollection) {
            if (!(o instanceof List)) continue;
            List nextList = (List)o;
            Iterator listIt = nextList.iterator();
            while (listIt.hasNext()) {
                try {
                    Map nextMap = (Map)listIt.next();
                    this.updateMap(nextMap);
                }
                catch (ClassCastException classCastException) {}
            }
        }
    }

    private String getBrowseEntityKey(String smartType, String nativeType, String reposId) throws ServiceException {
        String reposUrl;
        StringBuffer buffer = new StringBuffer();
        buffer.append(smartType);
        buffer.append("+");
        String reposName = null;
        try {
            reposName = this.getISName();
        }
        catch (RemoteException rex) {
            reposName = "RemoteException";
        }
        if (reposName == null) {
            reposUrl = null;
            String domain = null;
            try {
                reposUrl = this.getUrl();
                domain = this.getDomain();
            }
            catch (RemoteException rex) {
                throw new ServiceException(rex, RB.getStringResource("OMIRepository.geturlerror.ex.txt"));
            }
            try {
                URI uri = new URI(reposUrl);
                reposUrl = new String(uri.getScheme() + "://" + uri.getAuthority() + (domain != null ? ";domain=" + domain : ""));
                if (uri.getRawPath().length() > 1) {
                    reposUrl = reposUrl + uri.getRawPath();
                }
            }
            catch (URISyntaxException ex) {
                this._logger.warn(RB.getStringResource("OMIRepository.badurlformat.ex.txt"), (Throwable)ex);
            }
            buffer.append(reposUrl);
        } else {
            reposUrl = this._url;
            int index = reposUrl.indexOf(":");
            String protocol = reposUrl.substring(0, index);
            try {
                buffer.append(protocol + "://" + URLEncoder.encode(reposName, "UTF-8"));
            }
            catch (UnsupportedEncodingException ex) {
                buffer.append(protocol + "://" + reposName);
            }
        }
        buffer.append("/");
        reposName = this._defaultName;
        if (reposName != null) {
            try {
                buffer.append("reposname=" + URLEncoder.encode(reposName, "UTF-8") + "/");
            }
            catch (UnsupportedEncodingException ex) {
                throw new ServiceException(ex, RB.getStringResource("OMIRepository.geturlerror.ex.txt"));
            }
        }
        buffer.append(nativeType + ";id=");
        buffer.append(reposId);
        return buffer.toString();
    }

    private void getSubtreesFromMap(Map treeMap, List treeList) {
        treeList.add((String)treeMap.get("Id"));
        List list = (List)treeMap.get("SubTrees");
        if (list != null) {
            Iterator it = list.iterator();
            while (it.hasNext()) {
                try {
                    Map nextMap = (Map)it.next();
                    this.getSubtreesFromMap(nextMap, treeList);
                }
                catch (ClassCastException classCastException) {}
            }
        }
    }

    private String getSmartType(Map rawData) {
        String key = "omi:" + ((String)rawData.get("MetadataObjectType")).toLowerCase();
        try {
            String action = this._factory.getAction(key, rawData, this);
            if (action == null) {
                return "Metadata";
            }
            String classString = action.substring(action.lastIndexOf(":") + 1);
            SmartTypeHelper.Result str = this._myHelper.lookup(classString);
            rawData.put("isAFolder", str.isFolderStr());
            rawData.put("smartclass", classString);
            return str.getSmartType();
        }
        catch (ServiceException ex) {
            this._logger.warn(RB.getStringResource("OMIRepository.smrttypeerr.ex.txt"), (Throwable)((java.lang.Object)ex));
            return "Metadata";
        }
    }

    @Override
    public void runInformationServiceTimer() throws RemoteException {
        this._refreshCache = true;
    }

    private synchronized void doRefresh() throws RemoteException {
        this._cache.evict();
        this._refreshCache = false;
    }

    @Override
    public String getCredentials(String subject) throws ServiceException, RemoteException {
        this.pulseCheck();
        try {
            ISecurity is = this.getISecurity();
            StringHolder stringHolder = new StringHolder();
            is.GetCredentials(subject, stringHolder);
            return stringHolder.value;
        }
        catch (GenericError ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (NotTrustedUser ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (NoCredential ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void freeCredentials(String credential) throws ServiceException, RemoteException {
        this.pulseCheck();
        try {
            ISecurity is = this.getISecurity();
            is.FreeCredentials(credential);
        }
        catch (GenericError ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public boolean isAuthorized(String credential, String resource, String permission) throws ServiceException, RemoteException {
        this.pulseCheck();
        try {
            StringHolder stringHolder = new StringHolder();
            BooleanHolder booleanHolder = new BooleanHolder();
            if (this._logger != null && this._logger.isDebugEnabled()) {
                this._logger.debug("checking authorization for " + credential + " to " + permission + " on " + resource);
            }
            ISecurity is = this.getISecurity();
            is.IsAuthorized(credential, resource, permission, stringHolder, booleanHolder);
            if (this._logger != null && this._logger.isDebugEnabled()) {
                this._logger.debug("Authorization check result is " + stringHolder.value + ' ' + booleanHolder.value);
            }
            return booleanHolder.value;
        }
        catch (GenericError ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (NotTrustedUser ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (InvalidCredHandle ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (InvalidResourceSpec ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public List getAuthorizationsOnObj(String resource, List identities, List permissions, int flags) throws ServiceException, RemoteException {
        ArrayList<Authorization> results = new ArrayList<Authorization>();
        ISecurityAdmin isa = this.getISecAdmin();
        try {
            String[][] idArray = null;
            if (identities != null) {
                idArray = new String[identities.size()][2];
                for (int i = 0; i < identities.size(); ++i) {
                    IdentityInterface ii = (IdentityInterface)identities.get(i);
                    idArray[i][0] = ii.getType();
                    idArray[i][1] = ii.getName();
                }
            }
            String permString = "";
            if (permissions != null) {
                StringBuffer buf = new StringBuffer();
                Iterator it = permissions.iterator();
                boolean first_perm = true;
                while (it.hasNext()) {
                    Permission perm = (Permission)it.next();
                    if (!first_perm) {
                        buf.append(",");
                    }
                    buf.append(perm.getAction());
                    first_perm = false;
                }
                permString = buf.toString();
            }
            VariableArray2dOfAnyHolder authHolder = new VariableArray2dOfAnyHolder();
            isa.GetAuthorizationsOnObj("", resource, flags, idArray, permString, authHolder);
            Any[][] authValue = authHolder.value;
            for (int i = 0; i < authValue.length; ++i) {
                String authType;
                String idType = authValue[i][0].extract_string();
                String idName = authValue[i][1].extract_string();
                int authSource = authValue[i][2].extract_long();
                String string = authType = (authSource & 0x2A) > 0 ? "Grant" : "Deny";
                if ((authSource & 3) > 0) {
                    authSource = 1;
                } else if ((authSource & 0xC) > 0) {
                    authSource = 2;
                } else if ((authSource & 0x30) > 0) {
                    authSource = 3;
                }
                String authString = authValue[i][3].extract_string();
                String condString = authValue[i][4].extract_string();
                Authorization nextResult = new Authorization(idType, idName, authString, authSource, authType, condString);
                results.add(nextResult);
            }
        }
        catch (SECAD_INVALID_RESOURCE_SPEC ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_INVALID_TC_HANDLE ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_IDENTITY_DOES_NOT_EXIST ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_INVALID_IDENTITY_SPEC ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_INVALID_PERMISSION_SPEC ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_NOT_AUTHORIZED ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_INVALID_ACTION ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (GenericError ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        return results;
    }

    @Override
    public void setAuthorizationsOnObj(String resource, List authorizations, int flags) throws ServiceException, RemoteException {
        if (authorizations == null || authorizations.size() == 0) {
            return;
        }
        ISecurityAdmin isa = this.getISecAdmin();
        try {
            try {
                String[][] authArray = new String[authorizations.size()][5];
                for (int i = 0; i < authorizations.size(); ++i) {
                    Authorization auth = (Authorization)authorizations.get(i);
                    authArray[i][0] = auth.getIdentType();
                    authArray[i][1] = auth.getIdentName();
                    authArray[i][2] = auth.getAuthType().substring(0, 1).toUpperCase();
                    authArray[i][3] = auth.getAuthAction();
                    authArray[i][4] = auth.getConditions();
                }
                isa.SetAuthorizationsOnObj("", resource, flags, authArray);
            }
            catch (SECAD_INVALID_RESOURCE_SPEC ex) {
                throw new ServiceException(ex, ex.getMessage());
            }
            catch (SECAD_INVALID_TC_HANDLE ex) {
                throw new ServiceException(ex, ex.getMessage());
            }
            catch (SECAD_IDENTITY_DOES_NOT_EXIST ex) {
                throw new ServiceException(ex, ex.getMessage());
            }
            catch (SECAD_INVALID_IDENTITY_SPEC ex) {
                throw new ServiceException(ex, ex.getMessage());
            }
            catch (SECAD_INVALID_PERMISSION_SPEC ex) {
                throw new ServiceException(ex, ex.getMessage());
            }
            catch (SECAD_NOT_AUTHORIZED ex) {
                throw new ServiceException(ex, ex.getMessage());
            }
            catch (SECAD_INVALID_ACTION ex) {
                throw new ServiceException(ex, ex.getMessage());
            }
        }
        catch (GenericError ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public List getIdentitiesOnObj(String resource, int flags) throws ServiceException, RemoteException {
        if (resource == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> results = new ArrayList<String>();
        ISecurityAdmin isa = this.getISecAdmin();
        try {
            VariableArray2dOfStringHolder idList = new VariableArray2dOfStringHolder();
            isa.GetIdentitiesOnObj("", resource, flags, idList);
            String[][] idArray = idList.value;
            for (int i = 0; i < idArray.length; ++i) {
                results.add(idArray[i][0] + "/" + idArray[i][1]);
            }
        }
        catch (SECAD_INVALID_RESOURCE_SPEC ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_INVALID_TC_HANDLE ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_INVALID_ACTION ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (GenericError ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (Exception ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        return results;
    }

    @Override
    public List getACTsOnObj(String resource) throws ServiceException, RemoteException {
        if (resource == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ACTEntry> results = new ArrayList<ACTEntry>();
        ISecurityAdmin isa = this.getISecAdmin();
        try {
            VariableArray2dOfStringHolder actList = new VariableArray2dOfStringHolder();
            isa.GetACTsOnObj("", resource, 0, actList);
            String[][] actArray = actList.value;
            for (int i = 0; i < actArray.length; ++i) {
                ACTEntry entry = new ACTEntry(actArray[i][0], actArray[i][1], actArray[i][2], null);
                results.add(entry);
            }
        }
        catch (SECAD_INVALID_RESOURCE_SPEC ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_INVALID_ACTION ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_INVALID_TC_HANDLE ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_NOT_AUTHORIZED ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (GenericError ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        return results;
    }

    @Override
    public void appyACTToObj(String resource, String act) throws ServiceException, RemoteException {
        if (resource == null || act == null) {
            return;
        }
        ISecurityAdmin isa = this.getISecAdmin();
        try {
            isa.ApplyACTToObj("", resource, 0, act);
        }
        catch (SECAD_ACT_DOES_NOT_EXIST ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_ACT_IN_DEPENDENT_REPOS ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_INVALID_RESOURCE_SPEC ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_INVALID_ACTION ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_INVALID_TC_HANDLE ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_NOT_AUTHORIZED ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_OBJECT_NOT_ACT ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (GenericError ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (Exception ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void removeACTFromObj(String resource, String act) throws ServiceException, RemoteException {
        if (resource == null || act == null) {
            return;
        }
        ISecurityAdmin isa = this.getISecAdmin();
        try {
            isa.RemoveACTFromObj("", resource, 0, act);
        }
        catch (SECAD_ACT_DOES_NOT_EXIST ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_ACT_NOT_REMOVED ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_INVALID_RESOURCE_SPEC ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_INVALID_ACTION ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_INVALID_TC_HANDLE ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_NOT_AUTHORIZED ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (GenericError ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (Exception ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public List getAccessControlTemplateList(int flags) throws ServiceException, RemoteException {
        ISecurityAdmin isa = this.getISecAdmin();
        ArrayList<ACTEntry> results = null;
        try {
            results = new ArrayList<ACTEntry>();
            String repos = "REPOSID:" + this._defaultRepository.substring(9);
            VariableArray2dOfStringHolder actList = new VariableArray2dOfStringHolder();
            isa.GetAccessControlTemplateList("", repos, flags, actList);
            String[][] actArray = actList.value;
            for (int i = 0; i < actArray.length; ++i) {
                ACTEntry entry = new ACTEntry(actArray[i][1], actArray[i][2], actArray[i][3], actArray[i][4]);
                results.add(entry);
            }
        }
        catch (SECAD_INVALID_RESOURCE_SPEC ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_INVALID_TC_HANDLE ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_INVALID_ACTION ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_NOT_AUTHORIZED ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (GenericError ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        return results;
    }

    @Override
    public void createAccessControTemplate(ACTEntry act) throws ServiceException, RemoteException {
        if (act == null) {
            return;
        }
        if (act.getName() == null) {
            return;
        }
        ISecurityAdmin isa = this.getISecAdmin();
        try {
            int attCnt = 1;
            String repos = "REPOSID:" + this._defaultRepository.substring(9);
            String name = act.getName();
            String description = act.getDescription();
            String use = act.getUse();
            if (description != null) {
                ++attCnt;
            }
            if (use != null) {
                ++attCnt;
            }
            String[][] actAttArray = new String[attCnt][2];
            int i = 0;
            actAttArray[i][0] = "NAME";
            actAttArray[i][1] = name;
            ++i;
            if (description != null) {
                actAttArray[i][0] = "DESCRIPTION";
                actAttArray[i][1] = description;
                ++i;
            }
            if (use != null) {
                actAttArray[i][0] = "USE";
                actAttArray[i][1] = use;
            }
            isa.CreateAccessControlTemplate(null, repos, actAttArray);
        }
        catch (SECAD_INVALID_RESOURCE_SPEC ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_INVALID_TC_HANDLE ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_ACT_ALREADY_EXISTS ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_NOT_AUTHORIZED ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (GenericError ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void destroyAccessControlTemplate(String act) throws ServiceException, RemoteException {
        if (act == null) {
            return;
        }
        ISecurityAdmin isa = this.getISecAdmin();
        try {
            isa.DestroyAccessControlTemplate(null, act);
        }
        catch (SECAD_INVALID_RESOURCE_SPEC ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_INVALID_TC_HANDLE ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_ACT_DOES_NOT_EXIST ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_NOT_AUTHORIZED ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (GenericError ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (Exception ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void setAccessControlTemplateAttribs(ACTEntry act) throws ServiceException, RemoteException {
        if (act == null) {
            return;
        }
        if (act.getName() == null) {
            return;
        }
        ISecurityAdmin isa = this.getISecAdmin();
        try {
            int attCnt = 1;
            String repos = "REPOSID:" + this._defaultRepository.substring(9);
            String name = act.getName();
            String description = act.getDescription();
            String use = act.getUse();
            if (description != null) {
                ++attCnt;
            }
            if (use != null) {
                ++attCnt;
            }
            String[][] actAttArray = new String[attCnt][2];
            int i = 0;
            actAttArray[i][0] = "NAME";
            actAttArray[i][1] = name;
            ++i;
            if (description != null) {
                actAttArray[i][0] = "DESCRIPTION";
                actAttArray[i][1] = description;
                ++i;
            }
            if (use != null) {
                actAttArray[i][0] = "USE";
                actAttArray[i][1] = use;
            }
            isa.SetAccessControlTemplateAttribs(null, repos, actAttArray);
        }
        catch (SECAD_INVALID_RESOURCE_SPEC ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_INVALID_TC_HANDLE ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_ACT_DOES_NOT_EXIST ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_ACT_ALREADY_EXISTS ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_NOT_AUTHORIZED ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (GenericError ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (Exception ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public ACTEntry getAccessControlTemplateAttribs(String act) throws ServiceException, RemoteException {
        if (act == null) {
            return null;
        }
        ISecurityAdmin isa = this.getISecAdmin();
        try {
            VariableArray2dOfStringHolder actList = new VariableArray2dOfStringHolder();
            isa.GetAccessControlTemplateAttribs(null, act, actList);
            String[][] actArray = actList.value;
            String name = null;
            String description = null;
            String use = null;
            for (int i = 0; i < actArray.length; ++i) {
                String attr = actArray[i][0];
                if ("NAME".equalsIgnoreCase(attr)) {
                    name = actArray[i][1];
                    continue;
                }
                if ("DESCRIPTION".equalsIgnoreCase(attr)) {
                    description = actArray[i][1];
                    continue;
                }
                if (!"USE".equalsIgnoreCase(attr)) continue;
                use = actArray[i][1];
            }
            String objId = act.substring(act.indexOf("/") + 1);
            ACTEntry entry = new ACTEntry(objId, name, description, use);
            return entry;
        }
        catch (SECAD_INVALID_RESOURCE_SPEC ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_INVALID_TC_HANDLE ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (SECAD_NOT_AUTHORIZED ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (GenericError ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (Exception ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public AuthResult isAuthorizedWithConditions(String credential, String resource, String permission) throws ServiceException, RemoteException {
        if (resource == null) {
            return null;
        }
        if (permission == null) {
            return null;
        }
        try {
            if (credential == null) {
                credential = "";
            }
            StringHolder stringHolder = new StringHolder();
            BooleanHolder booleanHolder = new BooleanHolder();
            if (this._logger != null && this._logger.isDebugEnabled()) {
                this._logger.debug("checking authorization for " + credential + " to " + permission + " on " + resource);
            }
            ISecurity is = this.getISecurity();
            is.IsAuthorized(credential, resource, permission, stringHolder, booleanHolder);
            if (this._logger != null && this._logger.isDebugEnabled()) {
                this._logger.debug("Authorization check result is " + stringHolder.value + " " + booleanHolder.value);
            }
            AuthResult result = new AuthResult(booleanHolder.value, stringHolder.value);
            return result;
        }
        catch (GenericError ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (NotTrustedUser ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (InvalidCredHandle ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (InvalidResourceSpec ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public String[][] getAuthorizations(String authType, String credHandle, String resource, String permission) throws ServiceException, RemoteException {
        if (authType == null || resource == null || permission == null) {
            return null;
        }
        if (credHandle == null) {
            credHandle = "";
        }
        try {
            ISecurity is = this.getISecurity();
            VariableArray2dOfStringHolder returnAuthorizations = new VariableArray2dOfStringHolder();
            is.GetAuthorizations(authType, credHandle, resource, permission, returnAuthorizations);
            return returnAuthorizations.value;
        }
        catch (GenericError ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (NotTrustedUser ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (InvalidCredHandle ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (InvalidResourceSpec ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (InvalidAuthType ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public Date getCreateDate(MetadataInterface mi) throws ServiceException, RemoteException {
        int index;
        this.pulseCheck();
        CMetadata cm = (CMetadata)mi.getRepositoryEntity();
        if (this._mdfactory == null) {
            return null;
        }
        String xml = "<GetMetadata><Metadata><" + cm.getCMetadataType() + " Id=\"" + cm.getFQID() + '\"' + " Name=\"\" MetadataCreated=\"\" MetadataUpdated=\"\"/></Metadata><ns>SAS</ns><Flags>67108864</Flags><options/></GetMetadata>";
        Logger xmlLogger = LogManager.getLogger((String)"com.sas.metadata.xml");
        if (xmlLogger.isDebugEnabled()) {
            xmlLogger.debug(xml);
        }
        StringHolder outXml = new StringHolder();
        try {
            IOMI cnxn = this._mdfactory.getConnection().getCMRHandle();
            cnxn.DoRequest(xml, outXml);
        }
        catch (GenericError ex) {
            return null;
        }
        String xmlOut = outXml.value;
        if (xmlLogger.isDebugEnabled()) {
            xmlLogger.debug(XMLUtil.formatXML((String)xmlOut));
        }
        if ((index = xmlOut.indexOf("MetadataCreated")) < 0) {
            return null;
        }
        int index2 = xmlOut.indexOf("\"", index += 17);
        String sasCreateString = xmlOut.substring(index, index2);
        double time = Double.parseDouble(sasCreateString);
        TimeZone timezone = TimeZone.getTimeZone("GMT");
        long javaDate = (long)((time - 3.156192E8) * 1000.0 - (double)timezone.getRawOffset());
        Date result = new Date(javaDate);
        return result;
    }

    @Override
    public Date getModifiedDate(MetadataInterface mi) throws ServiceException, RemoteException {
        int index;
        this.pulseCheck();
        CMetadata cm = (CMetadata)mi.getRepositoryEntity();
        if (this._mdfactory == null) {
            return null;
        }
        String xml = "<GetMetadata><Metadata><" + cm.getCMetadataType() + " Id=\"" + cm.getFQID() + '\"' + " Name=\"\" MetadataCreated=\"\" MetadataUpdated=\"\"/></Metadata><ns>SAS</ns><Flags>67108864</Flags><options/></GetMetadata>";
        Logger xmlLogger = LogManager.getLogger((String)"com.sas.metadata.xml");
        if (xmlLogger.isDebugEnabled()) {
            xmlLogger.debug(xml);
        }
        StringHolder outXml = new StringHolder();
        try {
            this._mdfactory.getConnection().getCMRHandle().DoRequest(xml, outXml);
        }
        catch (GenericError ex) {
            return null;
        }
        String xmlOut = outXml.value;
        if (xmlLogger.isDebugEnabled()) {
            xmlLogger.debug(XMLUtil.formatXML((String)xmlOut));
        }
        if ((index = xmlOut.indexOf("MetadataUpdated")) < 0) {
            return null;
        }
        int index2 = xmlOut.indexOf("\"", index += 17);
        String sasCreateString = xmlOut.substring(index, index2);
        double time = Double.parseDouble(sasCreateString);
        TimeZone timezone = TimeZone.getTimeZone("GMT");
        long javaDate = (long)((time - 3.156192E8) * 1000.0 - (double)timezone.getRawOffset());
        Date result = new Date(javaDate);
        return result;
    }

    @Override
    public String getRepositoryType() throws RemoteException {
        try {
            this.pulseCheck();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
        return this._myType;
    }

    @Override
    public boolean isChild(String repositoryID) throws RemoteException {
        try {
            this.pulseCheck();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
        return this.children.contains(repositoryID);
    }

    @Override
    public boolean isChild(RepositoryInterface repos) throws RemoteException {
        try {
            this.pulseCheck();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
        if (repos instanceof OMIRepositoryInterface) {
            String id = ((OMIRepositoryInterface)repos).getDefaultRepositoryId();
            return this.isChild(id);
        }
        return false;
    }

    @Override
    public boolean isInChild(MetadataInterface metadata) throws RemoteException {
        try {
            this.pulseCheck();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
        RepositoryInterface ri = metadata.getRepository();
        if (ri instanceof OMIRepositoryInterface) {
            String id = ((OMIRepositoryInterface)ri).getDefaultRepositoryId();
            boolean result = this.isChild(id);
            return result;
        }
        return false;
    }

    @Override
    public boolean isParent(String repositoryID) throws RemoteException {
        try {
            this.pulseCheck();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
        return this.parents.contains(repositoryID);
    }

    @Override
    public boolean isParent(RepositoryInterface repos) throws RemoteException {
        try {
            this.pulseCheck();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
        if (repos instanceof OMIRepositoryInterface) {
            String id = ((OMIRepositoryInterface)repos).getDefaultRepositoryId();
            return this.isParent(id);
        }
        return false;
    }

    @Override
    public boolean isInParent(MetadataInterface metadata) throws RemoteException {
        try {
            this.pulseCheck();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
        RepositoryInterface ri = metadata.getRepository();
        if (ri instanceof OMIRepositoryInterface) {
            String id = ((OMIRepositoryInterface)ri).getDefaultRepositoryId();
            boolean result = this.isParent(id);
            return result;
        }
        return false;
    }

    @Override
    public boolean isInProject(MetadataInterface metadata) throws RemoteException {
        try {
            this.pulseCheck();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
        String id = metadata.getReposId();
        String reposId = "A0000001." + id.substring(id.indexOf(".") + 1);
        return this.projectRepositories.contains(reposId);
    }

    @Override
    public List getParents() throws RemoteException {
        try {
            this.pulseCheck();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
        return new ArrayList(this.parents);
    }

    @Override
    public List getChildren() throws RemoteException {
        try {
            this.pulseCheck();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
        return new ArrayList(this.children);
    }

    @Override
    public String getUniqueId() throws RemoteException {
        if (this._uniqueId != null) {
            return this._uniqueId;
        }
        this._uniqueId = new VMID().toString() + ':' + this.hashCode();
        return this._uniqueId;
    }

    private void getRepositoryData() {
        block14: {
            if (this._defaultRepository == null) {
                return;
            }
            String xml = "<GetMetadata>\n  <Metadata>\n    <RepositoryBase Id=\"" + this._defaultRepository + "\">\n      <DependencyUses/>\n      <DependencyUsedBy/>\n    </RepositoryBase>\n  </Metadata>\n  <ns>REPOS</ns>\n  <Flags>8</Flags>\n  <options/>\n</GetMetadata>";
            StringHolder outXml = new StringHolder();
            try {
                this._mdfactory.getConnection().getCMRHandle().DoRequest(xml, outXml);
            }
            catch (RemoteException rex) {
                return;
            }
            catch (GenericError ex) {
                return;
            }
            try {
                String xmlOut = outXml.value;
                int index = xmlOut.indexOf("<Metadata>");
                index += 10;
                while (xmlOut.charAt(index) == '\n' || xmlOut.charAt(index) == '\r' || xmlOut.charAt(index) == ' ') {
                    ++index;
                }
                int index2 = xmlOut.indexOf("</Metadata>");
                String metadata = xmlOut.substring(index, index2);
                index = metadata.indexOf("<RepositoryBase");
                index2 = metadata.indexOf(">");
                String myData = metadata.substring(index, index2 + 1);
                index2 = myData.indexOf("RepositoryType");
                index = myData.indexOf("\"", index2);
                index2 = myData.indexOf("\"", index + 1);
                this._myType = myData.substring(index + 1, index2);
                index = metadata.indexOf("<DependencyUses>");
                index2 = metadata.indexOf("</DependencyUses>");
                String uses = null;
                if (index2 > (index += 16) + 1) {
                    uses = metadata.substring(index, index2);
                    index = uses.indexOf("<RepositoryBase");
                    while (index > -1) {
                        index2 = uses.indexOf("Id=", index);
                        index = uses.indexOf("\"", index2);
                        index2 = uses.indexOf("\"", index + 1);
                        String usesRepository = uses.substring(index + 1, index2);
                        this.parents.add(usesRepository);
                        index = uses.indexOf("<RepositoryBase", index2);
                    }
                }
                index = metadata.indexOf("<DependencyUsedBy>");
                index2 = metadata.indexOf("</DependencyUsedBy>");
                String usedBy = null;
                if (index2 <= (index += 18) + 1) break block14;
                usedBy = metadata.substring(index, index2);
                index = usedBy.indexOf("<RepositoryBase");
                while (index > -1) {
                    index2 = usedBy.indexOf("Id=", index);
                    index = usedBy.indexOf("\"", index2);
                    index2 = usedBy.indexOf("\"", index + 1);
                    String usedByRepository = usedBy.substring(index + 1, index2);
                    this.children.add(usedByRepository);
                    try {
                        index2 = usedBy.indexOf("RepositoryType", index);
                        index = usedBy.indexOf("\"", index2);
                        index2 = usedBy.indexOf("\"", index + 1);
                        String reposType = usedBy.substring(index + 1, index2);
                        if (reposType.equalsIgnoreCase("project")) {
                            this.projectRepositories.add(usedByRepository);
                        }
                    }
                    catch (IndexOutOfBoundsException iobex) {
                        this._logger.warn("", (Throwable)iobex);
                    }
                    index = usedBy.indexOf("<RepositoryBase", index2);
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    private boolean isConnected() throws RemoteException {
        if (this._isConnected) {
            return true;
        }
        if (this._mdfactory != null) {
            try {
                this.doReconnect();
            }
            catch (ServiceException svcex) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doReconnect() throws ServiceException, RemoteException {
        if (this._omiServer != null) {
            this._omiServer.reconnect();
            return true;
        }
        this._isConnected = false;
        this._reconnecting = true;
        boolean result = false;
        try {
            String user = null;
            String password = null;
            if (this._user != null && this._domain != null) {
                List idents = null;
                PrivGetIdentities action = new PrivGetIdentities(this._user, this._domain);
                try {
                    idents = (List)AccessController.doPrivileged(action);
                }
                catch (PrivilegedActionException pae) {
                    Throwable t = pae.getCause();
                    if (t instanceof RemoteException) {
                        throw (RemoteException)t;
                    }
                    if (t instanceof SecurityException) {
                        throw (SecurityException)t;
                    }
                    throw new ServiceException(t, t.getMessage());
                }
                if (idents != null && idents.size() > 0) {
                    UserIdentityInterface ident = (UserIdentityInterface)idents.get(0);
                    user = (String)ident.getPrincipal();
                    password = (String)ident.getCredential();
                }
            } else {
                user = this._principal;
                password = this._password;
            }
            this._mdfactory.closeOMRConnection();
            this._mdfactory.makeOMRConnection(this._host, String.valueOf(this._portInt), user, password);
            this._isConnected = true;
            Logger connectLogger = LogManager.getLogger((String)"com.sas.services.information.OMIRepository.connection");
            if (connectLogger.isDebugEnabled()) {
                connectLogger.debug("Connected to omi://" + this._host + ':' + this._portInt + "  for user " + this._principal);
            }
            this.notifyListeners(2);
            result = true;
        }
        catch (MdException mdex) {
            this.notifyListeners(1);
            if (this._logger != null && this._logger.isInfoEnabled()) {
                this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"OMIRepository.cnctfail.ex.fmt", (java.lang.Object)this._host, (java.lang.Object)String.valueOf(this._portInt)), (Throwable)mdex);
            }
            result = false;
        }
        catch (RemoteException e) {
            this.notifyListeners(1);
            if (this._logger != null && this._logger.isInfoEnabled()) {
                this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"OMIRepository.cnctfail.ex.fmt", (java.lang.Object)this._host, (java.lang.Object)String.valueOf(this._portInt)), (Throwable)e);
            }
            result = false;
        }
        finally {
            this._reconnecting = false;
        }
        return result;
    }

    private boolean isConnectionException(Throwable ex) {
        String mexMessage = ex.getMessage();
        return mexMessage != null && (mexMessage.indexOf(EX_MSG_EOFEXCEPTION) > -1 || mexMessage.indexOf(EX_MSG_SOCKETEXCEPTION) > -1 || mexMessage.indexOf(EX_MSG_CONNECTIONABORT) > -1) || this.ioExceptionInChain(ex);
    }

    private boolean ioExceptionInChain(Throwable ex) {
        while (ex != null) {
            if (ex instanceof IOException) {
                return true;
            }
            Throwable t = ex.getCause();
            if (t == ex) break;
            ex = t;
        }
        return false;
    }

    @Override
    public void setFolderItemRefreshInterval(long msecInterval) throws RemoteException {
        this._folderItemRefreshInterval = msecInterval;
    }

    @Override
    public long getFolderItemRefreshInterval() throws RemoteException {
        return this._folderItemRefreshInterval;
    }

    @Override
    public void setFolderSubfolderRefreshInterval(long msecInterval) throws RemoteException {
        this._folderSubfolderRefreshInterval = msecInterval;
    }

    @Override
    public long getFolderSubfolderRefreshInterval() throws RemoteException {
        return this._folderSubfolderRefreshInterval;
    }

    @Override
    public void setParentRefreshInterval(long msecInterval) throws RemoteException {
        this._metadataParentRefreshInterval = msecInterval;
    }

    @Override
    public long getParentRefreshInterval() throws RemoteException {
        return this._metadataParentRefreshInterval;
    }

    @Override
    public int getCountNoSecurity(Filter filter, String association) throws ServiceException, RemoteException {
        if (this._omiServer != null) {
            if (filter.getOMRRepository() == null) {
                filter.setOMRRepository(this._defaultRepository);
            }
            return this._omiServer.getCountNoSecurity(filter, association);
        }
        if (association == null) {
            association = "";
        }
        VariableArray2dOfStringHolder result = new VariableArray2dOfStringHolder();
        String template = filter.getOMRTemplate();
        int flags = 0x184 | filter.getOMRFlags();
        StringBuffer buffer = new StringBuffer();
        buffer.append("<GetMetadataObjects>");
        buffer.append("  <Reposid>" + this._defaultRepository + "</Reposid>");
        buffer.append("  <Type>" + filter.getOMRType() + "</Type>");
        buffer.append("  <Objects/>");
        buffer.append("  <NS>SAS</NS>");
        buffer.append("  <Flags>" + flags + "</Flags>");
        buffer.append("  <options>");
        buffer.append(filter.getXMLSelectString());
        if (template != null) {
            buffer.append(template);
        }
        buffer.append("  </options>");
        buffer.append("</GetMetadataObjects>");
        ISecurity isec = this.getISecurity();
        try {
            isec.GetAuthorizations("getCountNoSecurity", "", buffer.toString(), association, result);
        }
        catch (GenericError t) {
            throw new ServiceException(t, t.getMessage());
        }
        catch (InvalidAuthType t) {
            throw new ServiceException(t, t.getMessage());
        }
        catch (InvalidResourceSpec t) {
            throw new ServiceException(t, t.getMessage());
        }
        catch (NotTrustedUser t) {
            throw new ServiceException(t, t.getMessage());
        }
        catch (InvalidCredHandle ich) {
            throw new ServiceException(ich, ich.getMessage());
        }
        if (result != null) {
            String string = result.value[0][1];
            int count = Integer.parseInt(string);
            return count;
        }
        return 0;
    }

    @Override
    public String[][] getInheritedPermissions(IdentityInterface identity, MetadataInterface metadata, List permissions) throws ServiceException, RemoteException {
        ISecurity iSecurity = this.getISecurity();
        if (iSecurity != null) {
            Root cm = (Root)metadata.getRepositoryEntity();
            StringBuffer permBuffer = new StringBuffer(8);
            int permissionsSize = permissions.size();
            for (int i = 0; i < permissionsSize; ++i) {
                PermissionInterface pi = (PermissionInterface)permissions.get(i);
                if (i != 0) {
                    permBuffer.append(", ");
                }
                permBuffer.append(pi.getAction());
            }
            String permList = permBuffer.toString();
            String resourceId = "OMSOBJ:" + cm.getCMetadataType() + '/' + cm.getFQID();
            String credId = "OMSOBJ:" + ((Root)identity.getRepositoryEntity()).getCMetadataType() + '/' + identity.getReposId();
            VariableArray2dOfStringHolder iPerms = new VariableArray2dOfStringHolder();
            try {
                iSecurity.GetAuthorizations("getInheritedPermissions", credId, resourceId, permList, iPerms);
            }
            catch (InvalidAuthType iat) {
                throw new ServiceException(iat, iat.getMessage());
            }
            catch (InvalidCredHandle ich) {
                throw new ServiceException(ich, ich.getMessage());
            }
            catch (InvalidResourceSpec irs) {
                throw new ServiceException(irs, irs.getMessage());
            }
            catch (NotTrustedUser ntu) {
                throw new ServiceException(ntu, ntu.getMessage());
            }
            catch (GenericError ge) {
                throw new ServiceException(ge, ge.getMessage());
            }
            String[][] inheritedperms = iPerms.value;
            return inheritedperms;
        }
        return null;
    }

    @Override
    public String[][] getInheritedIdentities(MetadataInterface mi) throws ServiceException, RemoteException {
        ISecurity iSecurity = this.getISecurity();
        if (iSecurity != null) {
            Root cm = (Root)mi.getRepositoryEntity();
            String resourceId = "OMSOBJ:" + cm.getCMetadataType() + '/' + cm.getFQID();
            VariableArray2dOfStringHolder iNames = new VariableArray2dOfStringHolder();
            try {
                iSecurity.GetAuthorizations("getInheritedIdentities", "", resourceId, "", iNames);
            }
            catch (InvalidAuthType iat) {
                throw new ServiceException(iat, iat.getMessage());
            }
            catch (NotTrustedUser ntu) {
                throw new ServiceException(ntu, ntu.getMessage());
            }
            catch (InvalidResourceSpec irs) {
                throw new ServiceException(irs, irs.getMessage());
            }
            catch (InvalidCredHandle ich) {
                throw new ServiceException(ich, ich.getMessage());
            }
            catch (GenericError ge) {
                throw new ServiceException(ge, ge.getMessage());
            }
            String[][] inheritedidents = iNames.value;
            return inheritedidents;
        }
        return null;
    }

    @Override
    public boolean isAuthorized(MetadataInterface mi, String permission) throws ServiceException, RemoteException {
        Root cm = (Root)mi.getRepositoryEntity();
        ISecurity isecurity = this.getISecurity();
        StringHolder stringHolder = new StringHolder();
        BooleanHolder resultHolder = new BooleanHolder();
        String resource = "OMSOBJ:" + cm.getCMetadataType() + '/' + cm.getFQID();
        try {
            isecurity.IsAuthorized("", resource, permission, stringHolder, resultHolder);
            return resultHolder.value;
        }
        catch (NotTrustedUser ntu) {
            throw new ServiceException(ntu, ntu.getMessage());
        }
        catch (InvalidResourceSpec irs) {
            throw new ServiceException(irs, irs.getMessage());
        }
        catch (InvalidCredHandle ich) {
            throw new ServiceException(ich, ich.getMessage());
        }
        catch (GenericError ge) {
            throw new ServiceException(ge, ge.getMessage());
        }
    }

    @Override
    public MetadataInterface factoryProcess(java.lang.Object o) throws ServiceException, RemoteException {
        this.pulseCheck();
        if (this._omiServer != null) {
            return this._omiServer.factoryProcess(o);
        }
        try {
            Root root = (Root)o;
            String id = root.getFQID();
            MetadataInterface result = (MetadataInterface)this._cache.get(id);
            if (result == null && (result = this._factory.processWithRepository(root, this)) == null) {
                result = new Metadata(root);
                result.setRepository(this);
            }
            return result;
        }
        catch (ClassCastException ccex) {
            throw new ServiceException(ccex, RB.getStringResource("Repository.wrongtype.ex.txt"));
        }
    }

    @Override
    public void addToCache(MetadataInterface newMetadata) throws ServiceException, RemoteException {
        this.pulseCheck();
        java.lang.Object o = this._cache.get(newMetadata.getReposId());
        if (o == null) {
            this._cache.put(newMetadata);
        }
    }

    protected final void pulseCheck() throws ServiceException {
        if (this._isDestroyed) {
            if (this.closeStack != null && this._logger.isDebugEnabled()) {
                this._logger.debug(RB.getStringResource("Repository.isdestroyed.ex.txt"), (Throwable)this.closeStack);
            }
            throw new ServiceException(RB.getStringResource("Repository.isdestroyed.ex.txt"));
        }
    }

    public void MdObjectCreated(MdEvent e, String id) throws RemoteException {
    }

    public void MdObjectDeleted(MdEvent e, String id) throws RemoteException {
        this._cache.remove(id);
    }

    public void MdObjectsCreated(MdEvent e, List ids) throws RemoteException {
    }

    @Override
    public byte[] toByteArray() throws RemoteException, ServiceException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this._domain);
            oos.writeObject(this._host);
            oos.writeInt(this._portInt);
            oos.writeObject(this._principal);
            oos.writeObject(this._password);
            oos.writeObject(this._defaultRepository);
            oos.writeObject(this._defaultName);
            oos.writeObject(this._isName);
            Collection cacheList = this._cache.values();
            ArrayList<String> list = new ArrayList<String>(cacheList.size());
            for (MetadataInterface mi : cacheList) {
                try {
                    list.add(mi.getEntityKey());
                }
                catch (IllegalStateException illegalStateException) {}
            }
            oos.writeObject(list);
            byte[] blobArray = baos.toByteArray();
            return blobArray;
        }
        catch (IOException ex) {
            return null;
        }
    }

    @Override
    public void fromByteArry(UserContextInterface uci, byte[] data) throws RemoteException, ServiceException {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        try {
            ObjectInputStream ois = new ObjectInputStream(bais);
            this._user = uci;
            String domain = (String)ois.readObject();
            String host = (String)ois.readObject();
            int portInt = ois.readInt();
            String principal = (String)ois.readObject();
            String password = (String)ois.readObject();
            String defaultRepository = (String)ois.readObject();
            String defaultName = (String)ois.readObject();
            String isName = (String)ois.readObject();
            this.connect(host, portInt, principal, password, defaultRepository);
            List cacheList = (List)ois.readObject();
            this.loadCache(cacheList);
            this.setDomain(domain);
            this._defaultName = defaultName;
            this._isName = isName;
        }
        catch (ClassNotFoundException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (IOException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    private void loadCache(List cacheList) {
        StringBuffer xmlBuffer = new StringBuffer(1024);
        xmlBuffer.append("<GetMetadata>\n");
        xmlBuffer.append("  <Metadata>\n");
        Iterator it = cacheList.iterator();
        ISEntityKey eKey = null;
        OMRRepositoryKey aKey = null;
        while (it.hasNext()) {
            String nextKey = (String)it.next();
            eKey = new ISEntityKey(nextKey);
            aKey = new OMRRepositoryKey(eKey.getRepositoryKey());
            xmlBuffer.append("    <" + aKey.getType() + "Id=\"" + aKey.getId() + "\"/>\n");
        }
        xmlBuffer.append("  </Metadata>\n");
        xmlBuffer.append("  <ns>SAS</ns>\n");
        xmlBuffer.append("  <Flags>8</Flags>\n");
        xmlBuffer.append("  <options/>\n");
        xmlBuffer.append("</GetMetadata>\n");
        StringHolder outXml = new StringHolder();
        try {
            this._mdfactory.getConnection().getCMRHandle().DoRequest(xmlBuffer.toString(), outXml);
            String outString = outXml.value;
            this._mdfactory.getOMIUtil().getOMIUtility().populateStoreFromString((MdStore)this._mdstore, outString, 2, false);
        }
        catch (GenericError ex) {
            return;
        }
        catch (RemoteException ex) {
            return;
        }
        catch (MdException ex) {
            return;
        }
    }

    @Override
    public boolean isDestroyed() throws RemoteException {
        return this._isDestroyed;
    }

    @Override
    public CacheStatistics getCacheStatistics() throws ServiceException, RemoteException {
        return this._cache.getCacheStatistics();
    }

    @Override
    public String getFactoryKey(java.lang.Object o) throws ServiceException, RemoteException {
        try {
            Root root = (Root)o;
            String publicType = ((PrimaryType)root).getPublicType();
            TypeDescriptorInterface tdi = this._omiServer.getTypeDescriptor(publicType);
            if (tdi != null) {
                return "tdi:" + publicType.toLowerCase();
            }
            String key = "omi:" + root.getCMetadataType().toLowerCase();
            return key;
        }
        catch (ClassCastException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public MetadataInterface produceDefaultMetadata(java.lang.Object o) throws RemoteException, ServiceException {
        Metadata result = new Metadata(o);
        result.setRepository(this);
        return result;
    }

    @Override
    public boolean factoryTest(java.lang.Object testObject, String filterString) throws RemoteException, ServiceException {
        ArrayList<java.lang.Object> testObjects = new ArrayList<java.lang.Object>(5);
        testObjects.add(testObject);
        StringTokenizer st = new StringTokenizer(filterString, "/", false);
        while (st.hasMoreTokens()) {
            String nextToken = st.nextToken();
            if (nextToken.charAt(0) == '@') {
                StringBuffer buffer = new StringBuffer(nextToken);
                while (st.hasMoreTokens()) {
                    buffer.append('/' + st.nextToken());
                }
                nextToken = buffer.toString();
                int index = nextToken.indexOf("=");
                String string = nextToken.substring(1, index);
                index = nextToken.indexOf("'");
                if (index < 0) {
                    throw new FactoryException(Message.format((ResourceBundle)RB.getResources(), (String)"Factory.badfileter.ex.fmt", (java.lang.Object)nextToken));
                }
                int index2 = nextToken.lastIndexOf("'");
                if (index2 <= index) {
                    throw new FactoryException(Message.format((ResourceBundle)RB.getResources(), (String)"Factory.badfileter.ex.fmt", (java.lang.Object)nextToken));
                }
                String value = nextToken.substring(index + 1, index2);
                for (java.lang.Object e : testObjects) {
                    Map testMap;
                    String attrValue;
                    if (e instanceof Root) {
                        Root nextTest = (Root)e;
                        try {
                            Map attrMap = nextTest.getAttrs();
                            String attrValue2 = (String)attrMap.get(string);
                            if (attrValue2 == null || !value.equalsIgnoreCase(attrValue2)) continue;
                            return true;
                        }
                        catch (ClassCastException cce) {
                            cce.printStackTrace(System.out);
                            continue;
                        }
                    }
                    if (!(e instanceof Map) || (attrValue = (String)(testMap = (Map)e).get(string)) == null || !value.equalsIgnoreCase(attrValue)) continue;
                    return true;
                }
                return false;
            }
            if (nextToken.charAt(0) == '*') {
                ArrayList newTestObjects = new ArrayList(5);
                nextToken = nextToken.substring(1);
                if (testObject instanceof Root) {
                    Iterator filterIt = testObjects.iterator();
                    while (filterIt.hasNext()) {
                        try {
                            Root root = (Root)filterIt.next();
                            AssociationList items = root.getAssociatedObjects(nextToken);
                            if (items == null || items.size() <= 0) continue;
                            newTestObjects.addAll(items);
                        }
                        catch (MdException mdException) {
                            throw new ServiceException(mdException, mdException.getMessage());
                        }
                    }
                    testObjects = newTestObjects;
                } else if (testObject instanceof Map) {
                    for (Map map : testObjects) {
                        OMIRepository.addToTestObjects(map, nextToken, newTestObjects);
                    }
                    testObjects = newTestObjects;
                }
                if (testObjects.size() != 0) continue;
                return false;
            }
            throw new FactoryException(Message.format((ResourceBundle)RB.getResources(), (String)"Factory.badfileter.ex.fmt", (java.lang.Object)nextToken));
        }
        return false;
    }

    @Override
    public EvaluatorInterface getEvaluator(java.lang.Object o) {
        return new OMIEvaluator(o);
    }

    private static void addToTestObjects(Map nextObject, String nextToken, List newTestObjects) {
        List list = (List)nextObject.get(nextToken);
        if (list != null) {
            int listSize = list.size();
            for (int i = 0; i < listSize; ++i) {
                java.lang.Object testObject = list.get(i);
                if (!(testObject instanceof Map)) continue;
                newTestObjects.add(testObject);
            }
        }
    }

    @Override
    public int isProfileRepository(String url) throws RemoteException {
        if (url == null) {
            String type = this.getRepositoryType();
            if ("FOUNDATION".equalsIgnoreCase(type)) {
                return 1;
            }
            return 0;
        }
        if (URIUtil.url1StartsWithUrl2(url, this.getUrl()) != null) {
            String type = this.getRepositoryType();
            if ("FOUNDATION".equalsIgnoreCase(type)) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    @Override
    public int getOMRVersion() throws ServiceException, RemoteException {
        try {
            int result = this._mdfactory.getConnection().getPlatformVersion();
            return result;
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public List getPermissions() throws ServiceException, RemoteException {
        if (this._permissionList == null) {
            Filter filter = new Filter();
            filter.setType("Permission");
            filter.setOMRFlags(8192);
            this._permissionList = this.search(filter);
        }
        return this._permissionList;
    }

    @Override
    public List getPredefinedPropertyTypes() throws ServiceException, RemoteException {
        if (this._propertyTypeList == null) {
            Filter filter = new Filter("Name", 0, "Entity Property Types");
            filter.setType("Group");
            List groupList = this.search(filter);
            if (groupList.size() > 0) {
                GroupInterface mgroup = (GroupInterface)groupList.get(0);
                Group group = (Group)mgroup.getRepositoryEntity();
                try {
                    AssociationList memberList = group.getMembers();
                    this._propertyTypeList = new ArrayList(memberList.size());
                    for (PropertyType pt : memberList) {
                        MetadataInterface mi = this.factoryProcess(pt);
                        this._propertyTypeList.add(mi);
                    }
                }
                catch (MdException ex) {
                    throw new ServiceException(ex, ex.getMessage());
                }
            }
        }
        return this._propertyTypeList;
    }

    public void MdStoreIDChange(MdEvent e, List itemsOld, List itemsNew) throws RemoteException {
        if (itemsOld.size() != itemsNew.size()) {
            return;
        }
        for (int i = 0; i < itemsOld.size(); ++i) {
            MetadataInterface mi;
            String oldId = (String)itemsOld.get(i);
            String newId = (String)itemsNew.get(i);
            if (!oldId.substring(0, 8).equals(this._defaultId) || (mi = (MetadataInterface)this._cache.get(oldId)) == null) continue;
            this._cache.remove(oldId);
            this._cache.put(newId, mi);
            this._tempMap.put(oldId, newId);
        }
    }

    public void MdObjectsCreated(MdFactoryEvent e) {
    }

    public void MdObjectsDeleted(MdFactoryEvent e) {
        String[] idarray = e.getObjectIDs();
        for (int i = 0; i < idarray.length; ++i) {
            String nextid = idarray[i];
            this._cache.remove(nextid);
        }
    }

    public void MdObjectsModified(MdFactoryEvent e) {
    }

    public void MdObjectsAdded(MdEvent e, List items) throws RemoteException {
    }

    public void MdObjectsRemoved(MdEvent e, List items) throws RemoteException {
    }

    public void MdObjectsModified(MdEvent e, List items) throws RemoteException {
    }

    @Override
    public ServerInterface getServer() throws ServiceException, RemoteException {
        return this._omiServer;
    }

    @Override
    public void refreshAllData() throws ServiceException, RemoteException {
        MdObjectStore store = this._mdstore;
        try {
            store.refreshStoreFromServer(true, true);
        }
        catch (MdException e) {
            throw new ServiceException(e, e.getMessage());
        }
    }

    @Override
    public boolean isUserAuthorizedInRepository(String permission) throws ServiceException, RemoteException {
        return false;
    }

    @Override
    public void populateAttributes(String id, String name, String type, String desc, String path, String engine, String options, String access, String effectiveAccess, String format, String state, Date metadataCreated, Date metadataUpdated) throws RemoteException {
    }

    @SASScope
    private class PrivGetIdentities
    implements PrivilegedExceptionAction {
        private UserContextInterface _user;
        private String _domain;

        PrivGetIdentities(UserContextInterface user, String domain) {
            this._user = user;
            this._domain = domain;
        }

        public java.lang.Object run() throws Exception {
            if (this._domain != null) {
                ArrayList list = this._user.getIdentitiesByDomain(this._domain, false, "");
                if (list == null) {
                    list = new ArrayList(0);
                }
                return list;
            }
            List list = this._user.getIdentities();
            return list;
        }
    }

    @SASScope
    public class OMIEvaluator
    implements EvaluatorInterface {
        java.lang.Object _theRoot;

        public OMIEvaluator(java.lang.Object o) {
            this._theRoot = o;
        }

        @Override
        public boolean evaluate(String path, String value) throws RemoteException, ServiceException {
            ArrayList<java.lang.Object> testObjects = new ArrayList<java.lang.Object>(5);
            testObjects.add(this._theRoot);
            StringTokenizer st = new StringTokenizer(path, "/", false);
            while (st.hasMoreTokens()) {
                String nextToken = st.nextToken();
                if (nextToken.charAt(0) == '@') {
                    String attribute = nextToken.substring(1);
                    for (java.lang.Object e : testObjects) {
                        Map testMap;
                        String attrValue;
                        if (e instanceof Root) {
                            Root nextTest = (Root)e;
                            try {
                                Map attrMap = nextTest.getAttrs();
                                String attrValue2 = (String)attrMap.get(attribute);
                                if (attrValue2 == null || !value.equalsIgnoreCase(attrValue2)) continue;
                                return true;
                            }
                            catch (ClassCastException cce) {
                                cce.printStackTrace(System.out);
                                continue;
                            }
                            catch (RemoteException cce) {
                                continue;
                            }
                        }
                        if (!(e instanceof Map) || (attrValue = (String)(testMap = (Map)e).get(attribute)) == null || !value.equalsIgnoreCase(attrValue)) continue;
                        return true;
                    }
                    return false;
                }
                if (nextToken.charAt(0) != '*') continue;
                ArrayList newTestObjects = new ArrayList(5);
                nextToken = nextToken.substring(1);
                if (this._theRoot instanceof Root) {
                    Iterator filterIt = testObjects.iterator();
                    while (filterIt.hasNext()) {
                        try {
                            Root root = (Root)filterIt.next();
                            AssociationList items = root.getAssociatedObjects(nextToken);
                            if (items == null || items.size() <= 0) continue;
                            newTestObjects.addAll(items);
                        }
                        catch (MdException mdException) {
                            throw new ServiceException(mdException, mdException.getMessage());
                        }
                    }
                    testObjects = newTestObjects;
                } else if (this._theRoot instanceof Map) {
                    for (Map map : testObjects) {
                        OMIRepository.addToTestObjects(map, nextToken, newTestObjects);
                    }
                    testObjects = newTestObjects;
                }
                if (testObjects.size() != 0) continue;
                return false;
            }
            return false;
        }

        @Override
        public List setPath(String path) throws ServiceException, RemoteException {
            ArrayList<java.lang.Object> testObjects = new ArrayList<java.lang.Object>(5);
            testObjects.add(this._theRoot);
            StringTokenizer st = new StringTokenizer(path, "/", false);
            while (st.hasMoreTokens()) {
                String nextToken = st.nextToken();
                if (nextToken.charAt(0) == '*') {
                    ArrayList newTestObjects = new ArrayList(5);
                    nextToken = nextToken.substring(1);
                    if (this._theRoot instanceof Root) {
                        Iterator filterIt = testObjects.iterator();
                        while (filterIt.hasNext()) {
                            try {
                                Root root = (Root)filterIt.next();
                                AssociationList items = root.getAssociatedObjects(nextToken);
                                if (items == null || items.size() <= 0) continue;
                                newTestObjects.addAll(items);
                            }
                            catch (MdException mdException) {
                                throw new ServiceException(mdException, mdException.getMessage());
                            }
                        }
                        testObjects = newTestObjects;
                    } else if (this._theRoot instanceof Map) {
                        for (Map map : testObjects) {
                            OMIRepository.addToTestObjects(map, nextToken, newTestObjects);
                        }
                        testObjects = newTestObjects;
                    }
                }
                if (testObjects.size() != 0) continue;
                return testObjects;
            }
            return testObjects;
        }

        @Override
        public boolean evaluateObject(java.lang.Object o, String attribute, String value) throws RemoteException, ServiceException {
            block10: {
                if (attribute == null || value == null) {
                    return false;
                }
                if (attribute.charAt(0) == '@') {
                    attribute = attribute.substring(1);
                }
                if (o instanceof Root) {
                    Root nextTest = (Root)o;
                    try {
                        Map attrMap = nextTest.getAttrs();
                        String attrValue = (String)attrMap.get(attribute);
                        if (attrValue == null) {
                            return false;
                        }
                        if (value.equalsIgnoreCase(attrValue)) {
                            return true;
                        }
                        break block10;
                    }
                    catch (ClassCastException cce) {
                        throw new ServiceException(cce, cce.getMessage());
                    }
                }
                if (o instanceof Map) {
                    Map testMap = (Map)o;
                    String attrValue = (String)testMap.get(attribute);
                    if (attrValue == null) {
                        return false;
                    }
                    if (value.equalsIgnoreCase(attrValue)) {
                        return true;
                    }
                }
            }
            return false;
        }
    }

    @SASScope
    private class TreeSearchFilter
    extends Filter {
        private static final long serialVersionUID = 5682278581650865715L;
        String _selectString;
        String _type;
        String _template;

        public TreeSearchFilter(FilterInterface oldFilter, String treeId) {
            this(oldFilter, new String[]{treeId});
        }

        public TreeSearchFilter(FilterInterface oldFilter, String[] trees) {
            String oldSelect = oldFilter.getXMLSelectString();
            if (oldSelect == null || oldSelect.length() == 0) {
                StringBuffer buffer = new StringBuffer(64);
                buffer.append("    <XMLSelect search=\"*[Trees/Tree[");
                for (int i = 0; i < trees.length; ++i) {
                    if (i > 0) {
                        buffer.append(" or ");
                    }
                    buffer.append(" @Id='" + trees[i] + '\'');
                }
                buffer.append("]]\" />");
                this._selectString = buffer.toString();
            } else {
                int index = oldSelect.indexOf("\"");
                if (oldSelect.charAt(++index) == '@') {
                    int index2 = oldSelect.lastIndexOf(34);
                    StringBuffer buffer = new StringBuffer(oldSelect.substring(0, index) + "*[" + oldSelect.substring(index, index2) + "][Trees/Tree[");
                    for (int i = 0; i < trees.length; ++i) {
                        if (i > 0) {
                            buffer.append(" or ");
                        }
                        buffer.append(" @Id='" + trees[i] + '\'');
                    }
                    buffer.append("]]" + oldSelect.substring(index2));
                    this._selectString = buffer.toString();
                } else if (oldSelect.charAt(index) == '*' && oldSelect.charAt(index + 1) == '[') {
                    if (oldSelect.charAt(index + 2) == '@') {
                        int indexValueStart = oldSelect.indexOf(39, index);
                        int indexValueEnd = oldSelect.indexOf(39, indexValueStart + 1);
                        int indexAttrEnd = oldSelect.indexOf("]", indexValueEnd);
                        int indexAssnStart = oldSelect.indexOf(91, indexAttrEnd);
                        if (indexAssnStart == -1) {
                            StringBuffer buffer = new StringBuffer(oldSelect.substring(0, indexAttrEnd + 1) + "[Trees/Tree[");
                            for (int i = 0; i < trees.length; ++i) {
                                if (i > 0) {
                                    buffer.append(" or ");
                                }
                                buffer.append("@Id='" + trees[i] + '\'');
                            }
                            buffer.append("]]" + oldSelect.substring(indexAttrEnd + 1));
                            this._selectString = buffer.toString();
                        } else {
                            int indexAssnEnd = oldSelect.lastIndexOf(93);
                            String keywordFix = null;
                            if (oldSelect.indexOf("Keywords") > 0) {
                                keywordFix = "/Objects/*";
                            }
                            StringBuffer buffer = new StringBuffer(oldSelect.substring(0, indexAssnEnd) + (keywordFix == null ? "" : keywordFix) + "/Trees/Tree[");
                            for (int i = 0; i < trees.length; ++i) {
                                if (i > 0) {
                                    buffer.append(" or ");
                                }
                                buffer.append("@Id='" + trees[i] + '\'');
                            }
                            buffer.append(']' + oldSelect.substring(indexAssnEnd));
                            this._selectString = buffer.toString();
                        }
                    } else {
                        int indexAssnEnd = oldSelect.lastIndexOf(93);
                        String keywordFix = null;
                        if (oldSelect.indexOf("Keywords") > 0) {
                            keywordFix = "/Objects/*";
                        }
                        StringBuffer buffer = new StringBuffer(oldSelect.substring(0, indexAssnEnd) + (keywordFix == null ? "" : keywordFix) + "/Trees/Tree[");
                        for (int i = 0; i < trees.length; ++i) {
                            if (i > 0) {
                                buffer.append(" or ");
                            }
                            buffer.append("@Id='" + trees[i] + '\'');
                        }
                        buffer.append(']' + oldSelect.substring(indexAssnEnd));
                        this._selectString = buffer.toString();
                    }
                }
            }
            this._type = oldFilter.getOMRType();
            this._template = oldFilter.getOMRTemplate();
            this.setOMRFlags(oldFilter.getOMRFlags());
        }

        @Override
        public String getType() {
            return this._type;
        }

        @Override
        public String getOMRType() {
            return this._type;
        }

        @Override
        public String getOMRTemplate() {
            return this._template;
        }

        @Override
        public String getXMLSelectString() {
            return this._selectString;
        }
    }

    @SASScope
    static class SmartTypeHelper {
        private static String TRUE = Boolean.TRUE.toString();
        private static String FALSE = Boolean.FALSE.toString();
        private Result _defaultResult;
        private Map _results = Collections.synchronizedMap(new HashMap(8));

        SmartTypeHelper(String defaultSmartType) {
            this._defaultResult = new Result(defaultSmartType, false);
        }

        Result getDefaultResult() {
            return this._defaultResult;
        }

        Result lookup(String className) throws ServiceException {
            Result rval = (Result)this._results.get(className);
            if (rval == null) {
                try {
                    MetadataInterface emptyMd = (MetadataInterface)Factory.getInstance().newInstance(className);
                    String smartType = emptyMd.getType();
                    boolean isFolder = emptyMd instanceof FolderInterface;
                    rval = new Result(smartType, isFolder);
                    this._results.put(className, rval);
                }
                catch (ClassNotFoundException e) {
                    this._results.put(className, this.getDefaultResult());
                    throw new ServiceException(e, e.getMessage());
                }
                catch (ServiceException e) {
                    this._results.put(className, this.getDefaultResult());
                    throw e;
                }
                catch (RemoteException e) {
                    this._results.put(className, this.getDefaultResult());
                    throw new ServiceException(e, e.getMessage());
                }
            }
            return rval;
        }

        @SASScope
        static class Result {
            private String _smartType;
            private boolean _isFolder;

            public Result(String smartType, boolean isFolder) {
                this._smartType = smartType;
                this._isFolder = isFolder;
            }

            public String getSmartType() {
                return this._smartType;
            }

            public boolean isFolder() {
                return this._isFolder;
            }

            public String isFolderStr() {
                return this._isFolder ? TRUE : FALSE;
            }
        }
    }
}

