/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information;

import com.sas.codepolicy.SASScope;
import com.sas.services.AbstractServiceFactory;
import com.sas.services.RemoteServiceInterface;
import com.sas.services.ServiceConfigurationException;
import com.sas.services.ServiceConfigurationInterface;
import com.sas.services.ServiceException;
import com.sas.services.discovery.DiscoveryServiceInterface;
import com.sas.services.information.InformationService;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.InformationServiceProfile;
import com.sas.services.information.RB;
import org.apache.logging.log4j.LogManager;

@SASScope
public class InformationServiceFactory
extends AbstractServiceFactory {
    public InformationServiceFactory() throws ServiceConfigurationException {
        super(new InformationServiceProfile());
    }

    @Override
    public final RemoteServiceInterface getService(ServiceConfigurationInterface serviceConfiguration, DiscoveryServiceInterface discoveryService) throws ServiceException {
        InformationServiceInterface service = null;
        try {
            service = InformationService.getInstance(serviceConfiguration, discoveryService);
        }
        catch (RuntimeException e) {
            LogManager.getLogger(InformationServiceFactory.class).error(RB.getStringResource("InformationServiceFactory.unableToObtainService.ex.txt"), (Throwable)e);
            throw e;
        }
        if (service == null) {
            throw new ServiceException(RB.getStringResource("InformationServiceFactory.unableToObtainService.ex.txt"));
        }
        return service;
    }

    public static final InformationServiceInterface createService(ServiceConfigurationInterface serviceConfiguration, DiscoveryServiceInterface discoveryService) throws ServiceException {
        return (InformationServiceInterface)new InformationServiceFactory().getService(serviceConfiguration, discoveryService);
    }
}

