/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information;

import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.services.information.RepositoryData;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PersonInterface;
import com.sas.services.information.metadata.PersonalRepositoryInterface;
import com.sas.services.information.metadata.dav.DAVEntityInterface;
import com.sas.services.information.metadata.dav.DAVFolderInterface;
import com.sas.services.webdav.SharedResourceInterface;
import java.io.File;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.List;

@SASScope(value="ALL")
public interface DAVRepositoryInterface
extends RepositoryInterface {
    public InputStream fetchContents(String var1) throws ServiceException, RemoteException;

    public void fetchContents(String var1, File var2) throws ServiceException, RemoteException;

    public String getHttpUrl() throws RemoteException;

    public void updateEntity(DAVEntityInterface var1) throws ServiceException, RemoteException;

    public String getReposIdwoTypeFromUrl(String var1) throws RemoteException;

    public PersonInterface makePersonalAnchor() throws ServiceException, RemoteException;

    public PersonalRepositoryInterface getPersonalRepository() throws ServiceException, RemoteException;

    public boolean getHttps() throws RemoteException;

    public boolean supportsACL() throws RemoteException;

    public boolean supportsSEARCH() throws RemoteException;

    public List getItems(DAVFolderInterface var1) throws RemoteException;

    public RepositoryData fetchRepositoryData(String var1) throws ServiceException, RemoteException;

    @Deprecated
    public MetadataInterface copyTo(DAVEntityInterface var1, DAVFolderInterface var2) throws ServiceException, RemoteException;

    @Deprecated
    public MetadataInterface moveTo(DAVEntityInterface var1, DAVFolderInterface var2) throws ServiceException, RemoteException;

    public MetadataInterface copyTo(DAVEntityInterface var1, DAVFolderInterface var2, String var3) throws ServiceException, RemoteException;

    public MetadataInterface moveTo(DAVEntityInterface var1, DAVFolderInterface var2, String var3) throws ServiceException, RemoteException;

    public void setACLFromStore(DAVEntityInterface var1) throws RemoteException;

    public void version(MetadataInterface var1) throws ServiceException, RemoteException;

    public void checkout(MetadataInterface var1) throws ServiceException, RemoteException;

    public void checkin(MetadataInterface var1) throws ServiceException, RemoteException;

    public void checkin(MetadataInterface var1, String var2) throws ServiceException, RemoteException;

    public void uncheckout(MetadataInterface var1) throws ServiceException, RemoteException;

    public int trackEntity(MetadataInterface var1) throws RemoteException;

    public void addToCache(MetadataInterface var1) throws RemoteException;

    public SharedResourceInterface getSharedResource() throws RemoteException;

    public List getPreviousVersionNames(MetadataInterface var1) throws ServiceException, RemoteException;

    public MetadataInterface getVersion(MetadataInterface var1, String var2) throws ServiceException, RemoteException;

    public String getServerString() throws RemoteException;
}

