/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.discovery;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.RemoteServiceInterface;
import com.sas.util.Strings;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class Services
implements Serializable {
    private static final long serialVersionUID = 9080982359342216906L;
    private final Set<RemoteServiceInterface> _services = Collections.synchronizedSet(new HashSet(5));

    public Services() {
    }

    public Services(Services services) throws IllegalArgumentException {
        if (services == null) {
            throw new IllegalArgumentException();
        }
        this._services.addAll(services.getCollection());
    }

    public final boolean add(Object object) {
        boolean wasAdded = false;
        if (object instanceof RemoteServiceInterface) {
            RemoteServiceInterface service = (RemoteServiceInterface)object;
            wasAdded = this._services.add(service);
        }
        return wasAdded;
    }

    public final boolean add(RemoteServiceInterface service) {
        boolean wasAdded = false;
        if (this.isOKToAdd(service)) {
            wasAdded = this._services.add(service);
        }
        return wasAdded;
    }

    public final boolean remove(RemoteServiceInterface service) {
        return this._services.remove(service);
    }

    public final boolean addAll(Services services) {
        boolean wasCollectionAltered = false;
        if (services != null) {
            wasCollectionAltered = this.addServices(services.getCollection());
        }
        return wasCollectionAltered;
    }

    private final boolean addServices(Collection<RemoteServiceInterface> services) throws IllegalArgumentException {
        boolean wasCollectionAltered = false;
        if (services != null) {
            Iterator<RemoteServiceInterface> iter = services.iterator();
            int collectionSize = services.size();
            ArrayList<RemoteServiceInterface> list = new ArrayList<RemoteServiceInterface>(collectionSize);
            RemoteServiceInterface service2 = null;
            boolean wasServiceAdded = false;
            while (iter.hasNext()) {
                service2 = iter.next();
                if (null == service2) continue;
                list.add(service2);
            }
            for (RemoteServiceInterface service2 : list) {
                wasServiceAdded = this.add(service2);
                wasCollectionAltered = wasCollectionAltered || wasServiceAdded;
            }
        }
        return wasCollectionAltered;
    }

    public final boolean removeAll(Services services) {
        return this._services.removeAll(services.getCollection());
    }

    public final Collection<RemoteServiceInterface> getCollection() {
        return new HashSet<RemoteServiceInterface>(this._services);
    }

    public final void setCollection(Collection<RemoteServiceInterface> collection) {
        this.addServices(collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Iterator<RemoteServiceInterface> iterator() {
        HashSet<RemoteServiceInterface> set = null;
        Set<RemoteServiceInterface> set2 = this._services;
        synchronized (set2) {
            set = new HashSet<RemoteServiceInterface>(this._services);
        }
        return set.iterator();
    }

    public final int size() {
        return this._services.size();
    }

    private final boolean isOKToAdd(RemoteServiceInterface service) {
        boolean isOKToAdd;
        block3: {
            isOKToAdd = false;
            try {
                String entityKeyAdd;
                if (service == null || (entityKeyAdd = service.getEntityKey()) == null) break block3;
                Iterator<RemoteServiceInterface> iter = this._services.iterator();
                RemoteServiceInterface nextService = null;
                String entityKey = null;
                isOKToAdd = true;
                while (iter.hasNext()) {
                    nextService = iter.next();
                    if (null == nextService || !Strings.equal((String)entityKeyAdd, (String)(entityKey = nextService.getEntityKey()), (boolean)false, (boolean)false)) continue;
                    isOKToAdd = false;
                    break;
                }
            }
            catch (RemoteException e) {
                isOKToAdd = false;
            }
        }
        return isOKToAdd;
    }
}

