/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.discovery;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.AbstractServiceAttribute;
import com.sas.services.discovery.RB;
import com.sas.text.Message;
import java.net.InetAddress;
import java.util.Map;
import java.util.ResourceBundle;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public final class HostAttribute
extends AbstractServiceAttribute {
    private static final long serialVersionUID = 3832619573575759413L;
    public String host;
    public String address;

    public HostAttribute() {
    }

    public HostAttribute(InetAddress inetAddress) {
        if (inetAddress == null) {
            throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"IllegalArgument.specifyNonNullValue.ex.fmt.txt", (Object)InetAddress.class.getName()));
        }
        this.setAttributes(inetAddress.getHostName(), inetAddress.getHostAddress());
    }

    public HostAttribute(String hostName) {
        this.host = hostName;
    }

    public HostAttribute(String hostName, String hostAddress) {
        this.setAttributes(hostName, hostAddress);
    }

    private void setAttributes(String hostName, String hostAddress) {
        this.host = hostName;
        this.address = hostAddress;
    }

    @Override
    public Map<String, String> getFieldNameToValueMap() {
        Map<String, String> map = super.getFieldNameToValueMap();
        map.put("host", this.host);
        map.put("address", this.address);
        return map;
    }
}

