/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.discovery;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.net.rmi.RemoteObjectExporterInterface;
import com.sas.net.rmi.UnicastRemoteObjectExporter;
import com.sas.net.ssl.SSLRMISocketFactories;
import com.sas.services.AbstractRemoteService;
import com.sas.services.InitializationException;
import com.sas.services.RemoteServiceInterface;
import com.sas.services.ServiceAttributeInterface;
import com.sas.services.ServiceConfigurationInterface;
import com.sas.services.ServiceException;
import com.sas.services.ServiceState;
import com.sas.services.discovery.DiscoveryService;
import com.sas.services.discovery.DiscoveryServiceInterface;
import com.sas.services.discovery.FindServiceInterface;
import com.sas.services.discovery.RB;
import com.sas.services.discovery.RemoteDiscoveryServiceProxy;
import com.sas.services.discovery.ServiceComponentAttribute;
import com.sas.services.discovery.ServiceNotAvailableException;
import com.sas.services.discovery.ServiceTemplate;
import com.sas.services.discovery.Services;
import com.sas.services.util.GetPropertyAction;
import com.sas.text.Message;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.util.Iterator;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;

@SASScope(value="ALL")
@SubjectToChange
public final class ActivatableDiscoveryService
extends AbstractRemoteService
implements DiscoveryServiceInterface {
    private DiscoveryServiceInterface _discoveryService = new DiscoveryService();
    private final Object _syncObj = new Object();

    private ActivatableDiscoveryService(DiscoveryServiceInterface discoveryService) {
        super(discoveryService);
        SSLRMISocketFactories sslRMISocketFactories = SSLRMISocketFactories.getInstance();
        Class<?> theClass = this.getClass();
        this.setRemoteableExporter((RemoteObjectExporterInterface)new UnicastRemoteObjectExporter((Remote)this, sslRMISocketFactories.getPortForClass(0, theClass), sslRMISocketFactories.getRMIClientSocketFactoryForClass(theClass), sslRMISocketFactories.getRMIServerSocketFactoryForClass(theClass), true));
    }

    public ActivatableDiscoveryService(ServiceConfigurationInterface serviceConfiguration, DiscoveryServiceInterface discoveryService) throws ServiceException, IllegalArgumentException {
        this(discoveryService);
        try {
            this.configure(serviceConfiguration);
            this.bindToDiscoveryService();
        }
        catch (RemoteException e) {
            throw new ServiceException(e, e.getLocalizedMessage());
        }
    }

    @Override
    public void configure(ServiceConfigurationInterface serviceConfiguration) throws InitializationException, RemoteException, ServiceException, IllegalArgumentException {
        if (serviceConfiguration == null) {
            throw new IllegalArgumentException();
        }
        super.configure(serviceConfiguration);
    }

    @Override
    public RemoteServiceInterface getServiceProxy() throws IllegalStateException {
        RemoteDiscoveryServiceProxy proxy = null;
        if (ServiceState.isStateDeactivated(this.getServiceState())) {
            throw new IllegalStateException(RB.getStringResource("ActivatableDiscoveryService.serviceDestroyed.txt"));
        }
        try {
            proxy = new RemoteDiscoveryServiceProxy(this);
        }
        catch (InitializationException e) {
            LogManager.getLogger(ActivatableDiscoveryService.class).warn(RB.getStringResource("ActivatableDiscoveryService.getServiceProxy.ex.txt"), (Throwable)((Object)e));
        }
        return proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() throws ServiceException, RemoteException {
        Object object = this._syncObj;
        synchronized (object) {
            try {
                if (this._discoveryService != null) {
                    if (this.isHandlingJVMShutdown() && this._discoveryService instanceof AbstractRemoteService) {
                        ((AbstractRemoteService)((Object)this._discoveryService)).handleJVMShutdown();
                    } else {
                        this._discoveryService.destroy();
                    }
                }
            }
            catch (ServiceException e) {
                LogManager.getLogger(ActivatableDiscoveryService.class).error(Message.format((ResourceBundle)RB.getResources(), (String)"ActivatableDiscoveryService.destroy.ex.fmt.log", (Object)this.getClass().getName()), (Throwable)((Object)e));
            }
            catch (RemoteException e) {
                LogManager.getLogger(ActivatableDiscoveryService.class).error(Message.format((ResourceBundle)RB.getResources(), (String)"ActivatableDiscoveryService.destroy.ex.fmt.log", (Object)this.getClass().getName()), (Throwable)e);
            }
            finally {
                this._discoveryService = null;
                super.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DiscoveryServiceInterface getDiscoveryService() throws IllegalStateException {
        if (ServiceState.isStateDeactivated(this.getServiceState())) {
            throw new IllegalStateException(RB.getStringResource("ActivatableDiscoveryService.serviceDestroyed.txt"));
        }
        Object object = this._syncObj;
        synchronized (object) {
            if (this._discoveryService == null) {
                this._discoveryService = new DiscoveryService();
            }
        }
        return this._discoveryService;
    }

    @Override
    public RemoteServiceInterface findServiceUsingId(String runtimeServiceId) throws ServiceException, ServiceNotAvailableException, IllegalStateException, RemoteException {
        return this.findService(new ServiceTemplate(new Class[]{RemoteServiceInterface.class}, new ServiceAttributeInterface[]{new ServiceComponentAttribute(null, null, runtimeServiceId)}));
    }

    @Override
    public RemoteServiceInterface findService(ServiceTemplate serviceTemplate) throws ServiceException, ServiceNotAvailableException, IllegalArgumentException, RemoteException {
        RemoteServiceInterface service = null;
        String discoveryServiceId = this.getEntityKey();
        if (!DiscoveryService.isOkToProcessRequest(discoveryServiceId, serviceTemplate)) {
            throw new ServiceNotAvailableException();
        }
        service = serviceTemplate != null && serviceTemplate.isSatisfiedBy(this) ? this : this.getDiscoveryService().findService(serviceTemplate);
        return service;
    }

    @Override
    public Services findServices(ServiceTemplate serviceTemplate, int maxNumMatches, Services discoveredServices) throws ServiceException, ServiceNotAvailableException, IllegalStateException, RemoteException {
        Services services = discoveredServices;
        String discoveryServiceId = this.getEntityKey();
        if (!DiscoveryService.isOkToProcessRequest(discoveryServiceId, serviceTemplate)) {
            throw new ServiceNotAvailableException(Message.format((ResourceBundle)RB.getResources(), (String)"DiscoveryService.processedServiceTemplate.fmt.txt", (Object)discoveryServiceId, (Object)serviceTemplate.toString()));
        }
        if (maxNumMatches > services.size() && serviceTemplate != null && serviceTemplate.isSatisfiedBy(this)) {
            services.add(this);
        }
        if (maxNumMatches > services.size()) {
            services = this.getDiscoveryService().findServices(serviceTemplate, maxNumMatches, services);
        }
        return services;
    }

    @Override
    public Iterator<RemoteServiceInterface> getRemoteServices() throws RemoteException {
        return this.getDiscoveryService().getRemoteServices();
    }

    @Override
    public Iterator<RemoteServiceInterface> getLocalServices() throws RemoteException {
        return this.getDiscoveryService().getLocalServices();
    }

    @Override
    public void addDiscoveryDelegate(FindServiceInterface serviceFinder) throws RemoteException {
        if (serviceFinder != null) {
            this.getDiscoveryService().addDiscoveryDelegate(serviceFinder);
        }
    }

    @Override
    public void removeDiscoveryDelegate(FindServiceInterface serviceFinder) throws RemoteException {
        if (serviceFinder == null) {
            throw new IllegalArgumentException();
        }
        this.getDiscoveryService().removeDiscoveryDelegate(serviceFinder);
    }

    @Override
    public Iterator<FindServiceInterface> getDiscoverers() throws RemoteException {
        return this.getDiscoveryService().getDiscoverers();
    }

    @Override
    public void addService(RemoteServiceInterface service) throws ServiceException, RemoteException {
        if (service == null) {
            throw new ServiceException(RB.getStringResource("ActivatableDiscoveryService.unableToCacheNullService.ex.txt"));
        }
        this.getDiscoveryService().addService(service);
    }

    @Override
    public void removeService(RemoteServiceInterface service) throws RemoteException {
        this.getDiscoveryService().removeService(service);
    }

    public String getServiceName() {
        return ActivatableDiscoveryService.class.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        String lineSeparator = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
        String none = Message.format((ResourceBundle)RB.getResources(), (String)"DiscoveryService.none.fmt.txt", (Object)lineSeparator);
        StringBuilder sb = new StringBuilder(Message.format((ResourceBundle)RB.getResources(), (String)"ActivatableDiscoveryService.toString.fmt.txt", (Object)lineSeparator, (Object)lineSeparator));
        Message messageIterationItem = new Message(RB.getResources(), "IterationItem.fmt.txt");
        Exception ex = null;
        try {
            RemoteServiceInterface service = null;
            Iterator<FindServiceInterface> iterator = this.getDiscoverers();
            sb.append(Message.format((ResourceBundle)RB.getResources(), (String)"DiscoveryService.discoveryDelegates.fmt.txt", (Object)lineSeparator));
            int i = 1;
            if (!iterator.hasNext()) {
                sb.append(none);
            }
            while (iterator.hasNext()) {
                service = (RemoteServiceInterface)((Object)iterator.next());
                sb.append(messageIterationItem.toString((Object)i++, (Object)(service.getClass().getName() + " [" + service.getEntityKey() + ']'), (Object)lineSeparator));
            }
            sb.append(Message.format((ResourceBundle)RB.getResources(), (String)"DiscoveryService.servicesNonRemoteable.fmt.txt", (Object)lineSeparator));
            i = 1;
            Iterator<RemoteServiceInterface> serviceIter = this.getLocalServices();
            if (!serviceIter.hasNext()) {
                sb.append(none);
            }
            while (serviceIter.hasNext()) {
                service = serviceIter.next();
                sb.append(messageIterationItem.toString((Object)i++, (Object)(service.getClass().getName() + " [" + service.getEntityKey() + ']'), (Object)lineSeparator));
            }
            sb.append(Message.format((ResourceBundle)RB.getResources(), (String)"DiscoveryService.servicesRemoteable.fmt.txt", (Object)lineSeparator));
            i = 1;
            serviceIter = this.getRemoteServices();
            if (!serviceIter.hasNext()) {
                sb.append(none);
            }
            while (serviceIter.hasNext()) {
                service = serviceIter.next();
                sb.append(messageIterationItem.toString((Object)i++, (Object)(service.getClass().getName() + " [" + service.getEntityKey() + ']'), (Object)lineSeparator));
            }
        }
        catch (RemoteException e) {
            ex = e;
        }
        catch (ClassCastException e) {
            ex = e;
        }
        finally {
            if (ex != null) {
                sb.append(ex.getLocalizedMessage());
            }
            sb.append('}');
        }
        return sb.toString();
    }
}

