/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.deployment;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.services.ServiceException;
import com.sas.services.deployment.AbstractImporter;
import com.sas.services.deployment.OperationMonitorInterface;
import com.sas.services.deployment.RB;
import com.sas.services.deployment.ServiceDeploymentImportException;
import com.sas.services.deployment.ServiceDeploymentImportFile;
import com.sas.services.deployment.ServiceDeployments;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope
class SoftwareComponentRemoteImporter
extends AbstractImporter {
    private MdFactory _mdFactory;

    SoftwareComponentRemoteImporter(String repositoryId, ServiceDeploymentImportFile serviceDeploymentImportFile, OperationMonitorInterface operationMonitor, MdFactory mdFactory) throws IllegalArgumentException {
        super(repositoryId, serviceDeploymentImportFile, operationMonitor);
        if (mdFactory == null) {
            throw new IllegalArgumentException(RB.getStringResource("IllegalArgument.specifyMetadataFactory.ex.txt"));
        }
        this._mdFactory = mdFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final void importServiceDeployment(String serviceDeploymentXML) throws ServiceDeploymentImportException {
        block7: {
            Throwable exception = null;
            try {
                this._mdFactory.getOMIUtil().DoRequest(serviceDeploymentXML);
            }
            catch (MdException e) {
                exception = e;
            }
            catch (RemoteException e) {
                exception = e;
            }
            finally {
                if (exception == null) break block7;
                throw new ServiceDeploymentImportException(exception, RB.getStringResource("ServiceDeploymentImporter.unableToImport.ex.txt"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final boolean isServiceDeploymentNameUnique(String serviceDeploymentToImport) throws ServiceException {
        HashSet<String> serviceDeploymentNames;
        block19: {
            serviceDeploymentNames = null;
            MdObjectStore mdObjectStore = null;
            Exception exception = null;
            Logger logger = LogManager.getLogger(this.getClass());
            try {
                mdObjectStore = this._mdFactory.createObjectStore(null, SoftwareComponentRemoteImporter.class.getName());
                HashSet<String> serviceDeploymentsToImport = new HashSet<String>(1);
                serviceDeploymentsToImport.add(serviceDeploymentToImport);
                List<SoftwareComponent> installedServiceDeployments = ServiceDeployments.getServiceDeployments((MdStore)mdObjectStore, this.getRepositoryId(), serviceDeploymentsToImport);
                if (installedServiceDeployments != null) {
                    serviceDeploymentNames = new HashSet<String>(installedServiceDeployments.size());
                    for (SoftwareComponent serviceDeployment : installedServiceDeployments) {
                        serviceDeploymentNames.add(serviceDeployment.getName());
                    }
                }
            }
            catch (ClassCastException e) {
                exception = e;
                return (boolean)exception;
            }
            catch (RemoteException e) {
                exception = e;
                return (boolean)exception;
            }
            finally {
                block20: {
                    if (mdObjectStore != null) {
                        try {
                            mdObjectStore.dispose();
                        }
                        catch (RemoteException e) {
                            if (logger == null) break block20;
                            logger.error(e.getLocalizedMessage());
                        }
                    }
                }
                if (exception == null) break block19;
                if (logger != null) {
                    logger.error(exception.getLocalizedMessage());
                }
                throw new ServiceException(exception, RB.getStringResource("AbstractImporter.isDeploymentNameUnique.ex.txt"));
            }
        }
        return serviceDeploymentNames == null || serviceDeploymentNames.size() == 0;
    }

    @Override
    final void destroy() {
        try {
            this._mdFactory = null;
        }
        finally {
            super.destroy();
        }
    }
}

