/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.deployment;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.services.deployment.DeployableService;
import com.sas.services.deployment.RB;
import java.io.Serializable;
import java.text.MessageFormat;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public final class ServiceLookupFailedException
extends ServiceException
implements Serializable {
    private static final int STRING_LENGTH_MESSAGE = 250;
    private static final long serialVersionUID = 1451236784494895240L;
    private DeployableService[] _deployableServices;

    ServiceLookupFailedException(String message) {
        super(message);
    }

    public ServiceLookupFailedException(Throwable throwable, String message) {
        super(throwable, message);
    }

    public ServiceLookupFailedException(DeployableService[] deployableServices) {
        this(RB.getStringResource("ServiceLookupFailedException.defaultMessage.ex.txt"));
        this.setDeployableServices(deployableServices);
    }

    private void setDeployableServices(DeployableService[] deployableServices) {
        this._deployableServices = deployableServices;
    }

    public DeployableService[] getDeployableServices() {
        int numItems = this._deployableServices != null ? this._deployableServices.length : 0;
        DeployableService[] deployableServices = new DeployableService[numItems];
        if (numItems > 0) {
            System.arraycopy(this._deployableServices, 0, deployableServices, 0, numItems);
        }
        return deployableServices;
    }

    public String getMessage() {
        String msg = super.getMessage();
        int numServiceLookupFailures = this._deployableServices != null ? this._deployableServices.length : 0;
        String failedLookupMsg = null;
        DeployableService deployableService = null;
        if (numServiceLookupFailures > 0) {
            StringBuilder detailMsg = new StringBuilder(250);
            for (int i = 0; i < numServiceLookupFailures; ++i) {
                deployableService = this._deployableServices[i];
                failedLookupMsg = MessageFormat.format(RB.getStringResource("ServiceLookupFailedException.defaultMessage.ex.fmt.txt"), deployableService.toString());
                detailMsg.append(failedLookupMsg);
            }
            msg = detailMsg.toString();
        }
        return msg;
    }
}

