/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.deployment;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.ServiceComponent;
import com.sas.services.MergePolicy;
import com.sas.services.ServiceException;
import com.sas.services.deployment.AbstractMetadataSource;
import com.sas.services.deployment.CLIOptionsConfig;
import com.sas.services.deployment.CLIOptionsMeta;
import com.sas.services.deployment.CLIOptionsServiceDeployment;
import com.sas.services.deployment.Environment;
import com.sas.services.deployment.MergePolicyAdd;
import com.sas.services.deployment.MergePolicyReplace;
import com.sas.services.deployment.RB;
import com.sas.services.deployment.ServiceDeployment;
import com.sas.services.util.UncaughtRuntimeExceptionHandler;
import com.sas.text.Message;
import java.io.File;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.ResourceBundle;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public final class ServiceConfigInstaller {
    private ServiceConfigInstaller() {
    }

    public static void main(String[] args) throws ServiceException {
        Thread.setDefaultUncaughtExceptionHandler(new UncaughtRuntimeExceptionHandler(true));
        ServiceException exception = null;
        try {
            ServiceConfigInstaller.installConfig(args);
        }
        catch (ServiceException e) {
            exception = e;
            LogManager.getLogger(ServiceConfigInstaller.class).error("Unable to install foundation service configuration.", (Throwable)((Object)e));
        }
        System.exit(exception == null ? 0 : -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void installConfig(String[] args) throws ServiceException {
        boolean isDebugLog;
        Logger logger;
        block56: {
            logger = LogManager.getLogger(ServiceConfigInstaller.class);
            isDebugLog = logger != null && logger.isDebugEnabled();
            MdStore mdStore = null;
            CLIOptionsMeta cliOptionsMeta = new CLIOptionsMeta();
            Option cliOptionMetaServer = cliOptionsMeta.createOptionMetaServer();
            Option cliOptionMetaPort = cliOptionsMeta.createOptionPort();
            Option cliOptionMetaRepository = cliOptionsMeta.createOptionRepository();
            Option cliOptionIsPrompting = new CLIOptionsConfig().createOptionIsPrompting();
            CLIOptionsServiceDeployment cliDeployment = new CLIOptionsServiceDeployment();
            Option optionDeploymentName = cliDeployment.createOptionDeploymentName();
            optionDeploymentName.setRequired(true);
            Option optionServiceName = cliDeployment.createOptionServiceName();
            optionServiceName.setRequired(true);
            Option optionServiceGroupName = cliDeployment.createOptionServiceGroupName();
            optionServiceGroupName.setRequired(true);
            Option optionServiceConfigFile = cliDeployment.createOptionServiceConfigFile();
            optionServiceConfigFile.setRequired(true);
            Option optionApplication = cliDeployment.createOptionServiceApplication();
            Option optionIsOverwriteConfig = cliDeployment.createOptionIsOverwriteConfig();
            Option cliOptionMetaUser = cliOptionsMeta.createOptionUser();
            Option cliOptionPassword = cliOptionsMeta.createOptionPassword();
            Option cliOptionMetaPasswordOnStdin = cliOptionsMeta.createOptionPasswordOnStdin();
            Option cliOptionSecPackageList = cliOptionsMeta.createOptionSecPackageList();
            Option cliOptionSPN = cliOptionsMeta.createOptionSPN();
            String serviceDeploymentName = null;
            String serviceGroupName = null;
            String serviceName = null;
            String serviceConfigFile = null;
            ServiceException exception = null;
            try {
                Options options = new Options();
                options.addOption(cliOptionMetaServer);
                options.addOption(cliOptionMetaPort);
                options.addOption(cliOptionMetaRepository);
                options.addOption(cliOptionIsPrompting);
                options.addOption(optionApplication);
                options.addOption(optionIsOverwriteConfig);
                options.addOption(optionDeploymentName);
                options.addOption(optionServiceGroupName);
                options.addOption(optionServiceName);
                options.addOption(optionServiceConfigFile);
                OptionGroup optionGroupCx = new OptionGroup();
                optionGroupCx.setRequired(true);
                optionGroupCx.addOption(cliOptionMetaUser);
                optionGroupCx.addOption(cliOptionSecPackageList);
                options.addOptionGroup(optionGroupCx);
                options.addOption(cliOptionPassword);
                options.addOption(cliOptionMetaPasswordOnStdin);
                options.addOption(cliOptionSPN);
                String metaPass = null;
                boolean isValid = false;
                CommandLine cmdLine = null;
                try {
                    if (isDebugLog) {
                        logger.debug(RB.getStringResource("ServiceConfigInstaller.parsingCmdLineArgs.log"));
                    }
                    cmdLine = new DefaultParser().parse(options, args);
                    String metaHost = cmdLine.getOptionValue(cliOptionsMeta.getNameOfOptionServer());
                    String metaPort = cmdLine.getOptionValue(cliOptionsMeta.getNameOfOptionPort());
                    String secPackageList = cmdLine.getOptionValue(cliOptionsMeta.getNameOfOptionSecPackageList());
                    String metaSPN = cmdLine.getOptionValue(cliOptionsMeta.getNameOfOptionSPN());
                    String metaUser = cmdLine.getOptionValue(cliOptionsMeta.getNameOfOptionUser());
                    boolean isPasswordOnStdin = Boolean.parseBoolean(cmdLine.getOptionValue(cliOptionsMeta.getNameOfOptionPasswordOnStdin()));
                    metaPass = cmdLine.getOptionValue(cliOptionsMeta.getNameOfOptionPassword());
                    serviceName = cmdLine.getOptionValue(optionServiceName.getOpt());
                    serviceGroupName = cmdLine.getOptionValue(optionServiceGroupName.getOpt());
                    serviceConfigFile = cmdLine.getOptionValue(optionServiceConfigFile.getOpt());
                    serviceDeploymentName = cmdLine.getOptionValue(optionDeploymentName.getOpt());
                    String applicationName = cmdLine.getOptionValue(optionApplication.getOpt());
                    boolean isOverwriteConfig = Boolean.parseBoolean(cmdLine.getOptionValue(optionIsOverwriteConfig.getOpt()));
                    if (isDebugLog) {
                        logger.debug(RB.getStringResource("ServiceConfigInstaller.validateCmdLineArgs.log"));
                    }
                    boolean bl = isValid = cmdLine.hasOption(cliOptionsMeta.getNameOfOptionServer()) && cmdLine.hasOption(cliOptionsMeta.getNameOfOptionPort()) && cmdLine.hasOption(cliOptionsMeta.getNameOfOptionRepository()) && applicationName != null && serviceConfigFile != null && serviceDeploymentName != null && serviceGroupName != null && serviceName != null && (metaUser != null && (isPasswordOnStdin || metaPass != null) || secPackageList != null);
                    if (isValid) {
                        ServiceComponent serviceComponent;
                        HashMap<String, String> metaOptions = new HashMap<String, String>(7);
                        String optionName = cliOptionsMeta.getNameOfOptionServer();
                        metaOptions.put(optionName, metaHost);
                        optionName = cliOptionsMeta.getNameOfOptionPort();
                        metaOptions.put(optionName, metaPort);
                        optionName = cliOptionsMeta.getNameOfOptionRepository();
                        String repositoryName = cmdLine.getOptionValue(optionName);
                        metaOptions.put(optionName, repositoryName);
                        if (secPackageList != null) {
                            if (isDebugLog) {
                                logger.debug(RB.getStringResource("ServiceConfigInstaller.connectUsingSecPackage.log"));
                            }
                            optionName = cliOptionsMeta.getNameOfOptionSecPackageList();
                            metaOptions.put(optionName, secPackageList);
                            optionName = cliOptionsMeta.getNameOfOptionSPN();
                            metaOptions.put(optionName, metaSPN);
                        } else {
                            if (isDebugLog) {
                                logger.debug(RB.getStringResource("ServiceConfigInstaller.connectUsingCredential.log"));
                            }
                            optionName = cliOptionsMeta.getNameOfOptionUser();
                            metaOptions.put(optionName, metaUser);
                            if (isPasswordOnStdin) {
                                String dashOptionName = '-' + cliOptionsMeta.getNameOfOptionPassword();
                                if (isDebugLog) {
                                    logger.debug(RB.getStringResource("ServiceConfigInstaller.getCredentialFromStdIn.log"));
                                }
                                metaPass = CLIOptionsConfig.getOptionValueFromSystemIn(dashOptionName, Boolean.parseBoolean(cmdLine.getOptionValue(cliOptionIsPrompting.getOpt())) ? Message.format((ResourceBundle)RB.getResources(), (String)"CLIOptionsMeta.specifyMetaPass.fmt.txt", (Object)dashOptionName) : null, null);
                                if (isDebugLog) {
                                    logger.debug(RB.getStringResource("ServiceConfigInstaller.gotCredentialFromStdIn.log"));
                                }
                                if (metaPass == null) {
                                    throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"CLIOptionsMeta.specifyMetaPass.ex.fmt.txt", (Object)cliOptionsMeta.getNameOfOptionPassword()));
                                }
                            }
                        }
                        if (metaPass != null) {
                            metaOptions.put(cliOptionsMeta.getNameOfOptionPassword(), metaPass);
                        }
                        if (isDebugLog) {
                            logger.debug(RB.getStringResource("ServiceConfigInstaller.createMdStore.log"));
                        }
                        mdStore = AbstractMetadataSource.createMdStore(false, metaOptions, new Environment());
                        if (isDebugLog) {
                            logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceConfigInstaller.queryServiceDeployment.fmt.log", (Object)repositoryName, (Object)serviceDeploymentName));
                        }
                        ServiceDeployment serviceDeployment = new ServiceDeployment(repositoryName, serviceDeploymentName, mdStore);
                        if (isDebugLog) {
                            logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceConfigInstaller.queryServiceComponent.fmt.log", (Object)serviceDeploymentName, (Object)serviceGroupName, (Object)serviceName));
                        }
                        if ((serviceComponent = serviceDeployment.getServiceComponent(serviceGroupName, serviceName)) == null) {
                            throw new ServiceException(new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceDeployment.getService.ex.fmt.txt", (Object)serviceDeploymentName, (Object)serviceGroupName, (Object)serviceName)));
                        }
                        MergePolicy mergePolicy = null;
                        if (isOverwriteConfig) {
                            if (isDebugLog) {
                                logger.debug(RB.getStringResource("ServiceConfigInstaller.policyOverwriteConflicts.log"));
                            }
                            mergePolicy = new MergePolicyReplace();
                        } else {
                            if (isDebugLog) {
                                logger.debug(RB.getStringResource("ServiceConfigInstaller.policyFailIfConflict.log"));
                            }
                            mergePolicy = new MergePolicyAdd();
                        }
                        if (isDebugLog) {
                            Message.format((ResourceBundle)RB.getResources(), (String)"ServiceConfigInstaller.installingServiceConfig.fmt.log", (Object)serviceConfigFile, (Object)serviceComponent.getName());
                        }
                        serviceDeployment.installServiceConfigurationUsingPolicy(applicationName, new File(serviceConfigFile), serviceComponent, mergePolicy);
                        if (isDebugLog) {
                            RB.getStringResource("ServiceConfigInstaller.persistingServiceConfig.log");
                        }
                        serviceComponent.updateMetadataAll();
                        if (logger.isInfoEnabled()) {
                            logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceDeployment.installedServiceConfig.fmt.txt", (Object)applicationName, (Object)serviceName, (Object)serviceComponent.getFQID(), (Object)serviceGroupName, (Object)serviceDeploymentName, (Object)serviceConfigFile));
                        }
                    }
                }
                finally {
                    metaPass = null;
                    if (!isValid) {
                        StringBuilder sb = new StringBuilder();
                        String nextOption = "> -";
                        sb.append(ServiceConfigInstaller.class.getName());
                        sb.append(" -");
                        sb.append(cliOptionMetaServer.getOpt());
                        sb.append(" <");
                        sb.append(cliOptionMetaServer.getArgName());
                        sb.append("> -");
                        sb.append(cliOptionMetaPort.getOpt());
                        sb.append(" <");
                        sb.append(cliOptionMetaPort.getArgName());
                        sb.append("> -");
                        sb.append(cliOptionMetaRepository.getOpt());
                        sb.append(" <");
                        sb.append(cliOptionMetaRepository.getArgName());
                        sb.append("> -");
                        sb.append(optionApplication.getOpt());
                        sb.append(" [<");
                        sb.append(optionApplication.getArgName());
                        sb.append(">] -");
                        sb.append(optionIsOverwriteConfig.getOpt());
                        sb.append(" [<");
                        sb.append(optionIsOverwriteConfig.getArgName());
                        sb.append(">] -");
                        sb.append(optionDeploymentName.getOpt());
                        sb.append(" <");
                        sb.append(optionDeploymentName.getArgName());
                        sb.append("> -");
                        sb.append(optionServiceGroupName.getOpt());
                        sb.append(" <");
                        sb.append(optionServiceGroupName.getArgName());
                        sb.append(">] -");
                        sb.append(optionServiceName.getOpt());
                        sb.append(" <");
                        sb.append(optionServiceName.getArgName());
                        sb.append("> [-");
                        sb.append(cliOptionMetaUser.getOpt());
                        sb.append(" <");
                        sb.append(cliOptionMetaUser.getArgName());
                        sb.append("> [[-");
                        sb.append(cliOptionPassword.getOpt());
                        sb.append(" <");
                        sb.append(cliOptionPassword.getArgName());
                        sb.append(">] | [-");
                        sb.append(cliOptionMetaPasswordOnStdin.getOpt());
                        sb.append(" <");
                        sb.append(cliOptionMetaPasswordOnStdin.getArgName());
                        sb.append(">]] | [-");
                        sb.append(cliOptionSecPackageList.getOpt());
                        sb.append(" <");
                        sb.append(cliOptionSecPackageList.getArgName());
                        sb.append("> [-");
                        sb.append(cliOptionSPN.getOpt());
                        sb.append(" <");
                        sb.append(cliOptionSPN.getArgName());
                        sb.append(">]]");
                        new HelpFormatter().printHelp(sb.toString(), options);
                    }
                }
            }
            catch (MdException e) {
                exception = new ServiceException(e);
            }
            catch (ParseException e) {
                exception = new ServiceException(e);
            }
            catch (RemoteException e) {
                exception = new ServiceException(e);
            }
            catch (IllegalArgumentException e) {
                exception = new ServiceException(e);
            }
            catch (ServiceException e) {
                exception = e;
            }
            finally {
                cliOptionPassword = null;
                cliOptionMetaUser = null;
                if (mdStore != null) {
                    try {
                        mdStore.getFactory().dispose();
                    }
                    catch (RemoteException e) {
                        logger.error(RB.getStringResource("ServiceConfigurationFactory.disposeFactory.ex.log"), (Throwable)e);
                    }
                }
                if (exception == null) break block56;
                logger.error(RB.getStringResource("ServiceConfigInstaller.main.ex.txt"), (Throwable)((Object)exception));
                throw exception;
            }
        }
        if (isDebugLog) {
            logger.debug(RB.getStringResource("ServiceConfigInstaller.returningFromMain.log"));
        }
    }
}

