/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.deployment;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdStore;
import com.sas.services.ServiceException;
import com.sas.services.deployment.AbstractMetadataSource;
import com.sas.services.deployment.CLIOptionsConfig;
import com.sas.services.deployment.CLIOptionsMeta;
import com.sas.services.deployment.CLIOptionsServiceDeployment;
import com.sas.services.deployment.Environment;
import com.sas.services.deployment.RB;
import com.sas.services.deployment.ServiceDeployment;
import com.sas.services.util.UncaughtRuntimeExceptionHandler;
import com.sas.text.Message;
import java.io.File;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.ResourceBundle;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public final class ServiceConfigExporter {
    private ServiceConfigExporter() {
    }

    public static void main(String[] args) throws RemoteException, MdException {
        Thread.setDefaultUncaughtExceptionHandler(new UncaughtRuntimeExceptionHandler(true));
        ServiceException exception = null;
        try {
            ServiceConfigExporter.exportServiceConfigurations(args);
        }
        catch (ServiceException e) {
            exception = e;
            LogManager.getLogger(ServiceConfigExporter.class).error("Unable to export foundation service configurations.", (Throwable)((Object)e));
        }
        System.exit(exception == null ? 0 : -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportServiceConfigurations(String[] args) throws ServiceException, RemoteException, MdException {
        Logger logger;
        block30: {
            logger = LogManager.getLogger(ServiceConfigExporter.class);
            MdStore mdStore = null;
            CLIOptionsMeta cliOptionsMeta = new CLIOptionsMeta();
            Option cliOptionMetaServer = cliOptionsMeta.createOptionMetaServer();
            Option cliOptionMetaPort = cliOptionsMeta.createOptionPort();
            Option cliOptionMetaRepository = cliOptionsMeta.createOptionRepository();
            Option cliOptionIsPrompting = new CLIOptionsConfig().createOptionIsPrompting();
            CLIOptionsServiceDeployment cliDeployment = new CLIOptionsServiceDeployment();
            Option optionDeploymentName = cliDeployment.createOptionDeploymentName();
            optionDeploymentName.setRequired(true);
            Option optionFileDirectory = cliDeployment.createOptionDirectory();
            optionFileDirectory.setRequired(true);
            Option optionPropertyFile = cliDeployment.createOptionPropertyFile();
            optionPropertyFile.setRequired(true);
            Option cliOptionMetaUser = cliOptionsMeta.createOptionUser();
            Option cliOptionMetaPassword = cliOptionsMeta.createOptionPassword();
            Option cliOptionMetaPasswordOnStdin = cliOptionsMeta.createOptionPasswordOnStdin();
            Option cliOptionSecPackageList = cliOptionsMeta.createOptionSecPackageList();
            Option cliOptionSPN = cliOptionsMeta.createOptionSPN();
            String serviceDeploymentName = null;
            String exportDirectory = null;
            String propertyFile = null;
            ServiceException exception = null;
            try {
                Options options = new Options();
                options.addOption(cliOptionMetaServer);
                options.addOption(cliOptionMetaPort);
                options.addOption(cliOptionMetaRepository);
                options.addOption(cliOptionIsPrompting);
                options.addOption(optionDeploymentName);
                options.addOption(optionFileDirectory);
                options.addOption(optionPropertyFile);
                OptionGroup optionGroupCx = new OptionGroup();
                optionGroupCx.setRequired(true);
                optionGroupCx.addOption(cliOptionMetaUser);
                optionGroupCx.addOption(cliOptionSecPackageList);
                options.addOptionGroup(optionGroupCx);
                options.addOption(cliOptionMetaPassword);
                options.addOption(cliOptionMetaPasswordOnStdin);
                options.addOption(cliOptionSPN);
                String metaPass = null;
                boolean isValid = false;
                CommandLine cmdLine = null;
                try {
                    cmdLine = new DefaultParser().parse(options, args);
                    String metaHost = cmdLine.getOptionValue(cliOptionsMeta.getNameOfOptionServer());
                    String metaPort = cmdLine.getOptionValue(cliOptionsMeta.getNameOfOptionPort());
                    String secPackageList = cmdLine.getOptionValue(cliOptionsMeta.getNameOfOptionSecPackageList());
                    String metaSPN = cmdLine.getOptionValue(cliOptionsMeta.getNameOfOptionSPN());
                    String metaUser = cmdLine.getOptionValue(cliOptionsMeta.getNameOfOptionUser());
                    boolean isPasswordOnStdin = Boolean.parseBoolean(cmdLine.getOptionValue(cliOptionsMeta.getNameOfOptionPasswordOnStdin()));
                    metaPass = cmdLine.getOptionValue(cliOptionsMeta.getNameOfOptionPassword());
                    exportDirectory = cmdLine.getOptionValue(optionFileDirectory.getOpt());
                    serviceDeploymentName = cmdLine.getOptionValue(optionDeploymentName.getOpt());
                    propertyFile = cmdLine.getOptionValue(optionPropertyFile.getOpt());
                    boolean bl = isValid = cmdLine.hasOption(cliOptionsMeta.getNameOfOptionServer()) && cmdLine.hasOption(cliOptionsMeta.getNameOfOptionPort()) && cmdLine.hasOption(cliOptionsMeta.getNameOfOptionRepository()) && exportDirectory != null && serviceDeploymentName != null && (metaUser != null && (isPasswordOnStdin || metaPass != null) || secPackageList != null);
                    if (isValid) {
                        HashMap<String, String> metaOptions = new HashMap<String, String>(7);
                        String optionName = cliOptionsMeta.getNameOfOptionServer();
                        metaOptions.put(optionName, metaHost);
                        optionName = cliOptionsMeta.getNameOfOptionPort();
                        metaOptions.put(optionName, metaPort);
                        optionName = cliOptionsMeta.getNameOfOptionRepository();
                        String repositoryName = cmdLine.getOptionValue(optionName);
                        metaOptions.put(optionName, repositoryName);
                        if (secPackageList != null) {
                            optionName = cliOptionsMeta.getNameOfOptionSecPackageList();
                            metaOptions.put(optionName, secPackageList);
                            optionName = cliOptionsMeta.getNameOfOptionSPN();
                            metaOptions.put(optionName, metaSPN);
                        } else {
                            String dashOptionName;
                            optionName = cliOptionsMeta.getNameOfOptionUser();
                            metaOptions.put(optionName, metaUser);
                            if (isPasswordOnStdin && (metaPass = CLIOptionsConfig.getOptionValueFromSystemIn(dashOptionName = '-' + cliOptionsMeta.getNameOfOptionPassword(), Boolean.parseBoolean(cmdLine.getOptionValue(cliOptionIsPrompting.getOpt())) ? Message.format((ResourceBundle)RB.getResources(), (String)"CLIOptionsMeta.specifyMetaPass.fmt.txt", (Object)dashOptionName) : null, null)) == null) {
                                throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"CLIOptionsMeta.specifyMetaPass.ex.fmt.txt", (Object)cliOptionsMeta.getNameOfOptionPassword()));
                            }
                        }
                        if (metaPass != null) {
                            metaOptions.put(cliOptionsMeta.getNameOfOptionPassword(), metaPass);
                        }
                        mdStore = AbstractMetadataSource.createMdStore(false, metaOptions, new Environment());
                        ServiceDeployment serviceDeployment = new ServiceDeployment(repositoryName, serviceDeploymentName, mdStore);
                        serviceDeployment.exportServiceConfigurations(new File(exportDirectory), new File(propertyFile));
                    }
                }
                finally {
                    metaPass = null;
                    if (!isValid) {
                        StringBuilder sb = new StringBuilder();
                        String nextOption = "> -";
                        sb.append(ServiceConfigExporter.class.getName());
                        sb.append(" -");
                        sb.append(cliOptionMetaServer.getOpt());
                        sb.append(" <");
                        sb.append(cliOptionMetaServer.getArgName());
                        sb.append("> -");
                        sb.append(cliOptionMetaPort.getOpt());
                        sb.append(" <");
                        sb.append(cliOptionMetaPort.getArgName());
                        sb.append("> -");
                        sb.append(cliOptionMetaRepository.getOpt());
                        sb.append(" <");
                        sb.append(cliOptionMetaRepository.getArgName());
                        sb.append("> -");
                        sb.append(optionDeploymentName.getOpt());
                        sb.append(" <");
                        sb.append(optionDeploymentName.getArgName());
                        sb.append("> -");
                        sb.append(optionFileDirectory.getOpt());
                        sb.append(" <");
                        sb.append(optionFileDirectory.getArgName());
                        sb.append("> -");
                        sb.append(optionPropertyFile.getOpt());
                        sb.append(" <");
                        sb.append(optionPropertyFile.getArgName());
                        sb.append("> [-");
                        sb.append(cliOptionMetaUser.getOpt());
                        sb.append(" <");
                        sb.append(cliOptionMetaUser.getArgName());
                        sb.append("> [[-");
                        sb.append(cliOptionMetaPassword.getOpt());
                        sb.append(" <");
                        sb.append(cliOptionMetaPassword.getArgName());
                        sb.append(">] | [-");
                        sb.append(cliOptionMetaPasswordOnStdin.getOpt());
                        sb.append(" <");
                        sb.append(cliOptionMetaPasswordOnStdin.getArgName());
                        sb.append(">]] | [-");
                        sb.append(cliOptionSecPackageList.getOpt());
                        sb.append(" <");
                        sb.append(cliOptionSecPackageList.getArgName());
                        sb.append("> [-");
                        sb.append(cliOptionSPN.getOpt());
                        sb.append(" <");
                        sb.append(cliOptionSPN.getArgName());
                        sb.append(">]]");
                        new HelpFormatter().printHelp(sb.toString(), options);
                    }
                }
            }
            catch (ParseException e) {
                exception = new ServiceException(e);
            }
            catch (IllegalArgumentException e) {
                exception = new ServiceException(e);
            }
            catch (ServiceException e) {
                exception = e;
            }
            finally {
                cliOptionMetaPassword = null;
                cliOptionMetaUser = null;
                if (mdStore != null) {
                    try {
                        mdStore.getFactory().dispose();
                    }
                    catch (RemoteException e) {
                        logger.error(RB.getStringResource("ServiceConfigurationFactory.disposeFactory.ex.log"), (Throwable)e);
                    }
                }
                if (exception == null) break block30;
                logger.error(RB.getStringResource("ServiceConfigExporter.main.ex.txt"), (Throwable)((Object)exception));
                throw exception;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug(RB.getStringResource("ServiceConfigInstaller.returningFromMain.log"));
        }
    }
}

