/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.deployment;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.InitializationException;
import com.sas.services.ServiceAttributeInterface;
import com.sas.services.ServiceConfiguration;
import com.sas.services.ServiceConfigurationInterface;
import com.sas.services.deployment.RB;
import com.sas.services.deployment.ServiceAttributeFactoryInterface;
import com.sas.services.util.GetPropertyAction;
import com.sas.text.Message;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class ServiceAttribute
implements ServiceAttributeFactoryInterface {
    private String _attributeClassName;
    private Map<String, String> _attributeNameValuePairs;
    private ServiceAttributeInterface _serviceAttribute;

    public ServiceAttribute(String attributeClassName) {
        this.setAttributeClassName(attributeClassName);
    }

    public final String getAttributeClassName() {
        return this._attributeClassName;
    }

    public final void setAttributeClassName(String attributeClassName) {
        this._attributeClassName = attributeClassName;
    }

    public final void put(String attributeName, String attributeValue) {
        this.getNameValueMap().put(attributeName, attributeValue);
    }

    public final Map<String, String> getNameValueMap() {
        if (this._attributeNameValuePairs == null) {
            this._attributeNameValuePairs = new HashMap<String, String>(5);
        }
        return this._attributeNameValuePairs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ServiceAttributeInterface getServiceAttribute() {
        ServiceAttributeFactoryInterface serviceAttributeFactory = null;
        ServiceConfiguration serviceConfiguration = null;
        String className = this.getAttributeClassName();
        if (this._serviceAttribute == null && className != null) {
            Serializable exception = null;
            try {
                ClassLoader classLoader = this.getClass().getClassLoader();
                Class<?> attributeClass = classLoader.loadClass(className);
                Object object = attributeClass.newInstance();
                if (object instanceof ServiceAttributeFactoryInterface) {
                    serviceAttributeFactory = (ServiceAttributeFactoryInterface)object;
                    serviceConfiguration = new ServiceConfiguration(this.getNameValueMap());
                } else if (object instanceof ServiceAttributeInterface) {
                    serviceAttributeFactory = this;
                    serviceConfiguration = new ServiceConfiguration(new AttributeConfiguration(attributeClass, (ServiceAttributeInterface)object));
                }
                if (serviceAttributeFactory != null) {
                    this._serviceAttribute = serviceAttributeFactory.getServiceAttribute(serviceConfiguration);
                }
            }
            catch (ClassNotFoundException e) {
                exception = e;
            }
            catch (IllegalAccessException e) {
                exception = e;
            }
            catch (InstantiationException e) {
                exception = e;
            }
            catch (InitializationException e) {
                exception = e;
            }
            catch (IllegalArgumentException e) {
                exception = e;
            }
            finally {
                if (exception != null) {
                    LogManager.getLogger(ServiceAttribute.class).error(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceAttribute.getServiceAttribute.ex.fmt.txt", (Object)className), (Throwable)exception);
                }
            }
        }
        return this._serviceAttribute;
    }

    @Override
    public final ServiceAttributeInterface getServiceAttribute(ServiceConfigurationInterface serviceConfiguration) throws InitializationException {
        if (serviceConfiguration == null) {
            throw new IllegalArgumentException();
        }
        ServiceAttributeInterface serviceAttribute = null;
        Object initObject = serviceConfiguration.getInitializationObject();
        if (initObject != null && initObject instanceof AttributeConfiguration) {
            serviceAttribute = this.getServiceAttribute((AttributeConfiguration)initObject);
        }
        return serviceAttribute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ServiceAttributeInterface getServiceAttribute(AttributeConfiguration attributeConfiguration) throws InitializationException {
        ServiceAttributeInterface serviceAttribute;
        block25: {
            serviceAttribute = null;
            ReflectiveOperationException exception = null;
            try {
                Iterator<String> iteratorFields = this.getNameValueMap().keySet().iterator();
                String fieldName = null;
                Comparable<Boolean> fieldValue = null;
                Field field = null;
                Class<Object> fieldClass = null;
                serviceAttribute = attributeConfiguration.getAttribute();
                while (iteratorFields.hasNext()) {
                    fieldName = iteratorFields.next();
                    String fieldValueString = this.getNameValueMap().get(fieldName);
                    field = attributeConfiguration.getAttributeClass().getField(fieldName);
                    fieldClass = field.getType();
                    if (!fieldClass.isAssignableFrom(String.class)) {
                        if (fieldClass.isAssignableFrom(Boolean.class)) {
                            fieldValue = Boolean.valueOf(fieldValueString);
                        } else if (fieldClass.isAssignableFrom(Integer.class)) {
                            fieldValue = Integer.valueOf(fieldValueString);
                        } else if (fieldClass.isAssignableFrom(Short.class)) {
                            fieldValue = Short.valueOf(fieldValueString);
                        } else if (fieldClass.isAssignableFrom(Long.class)) {
                            fieldValue = Long.valueOf(fieldValueString);
                        } else if (fieldClass.isAssignableFrom(Byte.class)) {
                            fieldValue = Byte.valueOf(fieldValueString);
                        } else if (fieldClass.isAssignableFrom(Character.class)) {
                            char character = fieldValueString.trim().charAt(0);
                            fieldValue = Character.valueOf(character);
                        } else if (fieldClass.isAssignableFrom(Double.class)) {
                            fieldValue = Double.valueOf(fieldValueString);
                        } else if (fieldClass.isAssignableFrom(Float.class)) {
                            fieldValue = Float.valueOf(fieldValueString);
                        } else {
                            throw new InitializationException();
                        }
                    }
                    field.set(serviceAttribute, fieldValue);
                }
            }
            catch (IllegalAccessException e) {
                exception = e;
                return exception;
            }
            catch (NoSuchFieldException e) {
                exception = e;
                return exception;
            }
            finally {
                if (exception == null) break block25;
                serviceAttribute = null;
                throw new InitializationException(exception, RB.getStringResource("ServiceAttribute.getServiceAttribute.ex.txt"));
            }
        }
        return serviceAttribute;
    }

    public final String toString() {
        String lineSeparator = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
        StringBuilder buffer = new StringBuilder(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceAttribute.toString.fmt.txt", (Object)lineSeparator, (Object)this.getAttributeClassName(), (Object)lineSeparator));
        for (Map.Entry<String, String> mapEntry : this.getNameValueMap().entrySet()) {
            buffer.append(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceAttribute.toStringField.fmt.txt", (Object)mapEntry.getKey(), (Object)mapEntry.getValue(), (Object)lineSeparator));
        }
        buffer.append(Message.format((ResourceBundle)RB.getResources(), (String)"DeployableService.closingBraceNewLine.fmt.txt", (Object)lineSeparator));
        return buffer.toString();
    }

    @SASScope
    private static class AttributeConfiguration {
        private final Class<?> _attributeClass;
        private final ServiceAttributeInterface _attribute;

        private AttributeConfiguration(Class<?> attributeClass, ServiceAttributeInterface attribute) {
            this._attributeClass = attributeClass;
            this._attribute = attribute;
        }

        final Class<?> getAttributeClass() {
            return this._attributeClass;
        }

        final ServiceAttributeInterface getAttribute() {
            return this._attribute;
        }
    }
}

