/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.deployment;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertyType;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Text;
import com.sas.services.ServiceException;
import com.sas.services.deployment.DependentServicesException;
import com.sas.services.deployment.RB;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
class RootDeleter {
    static final String PROPERTIES = "<Properties/>";
    private static final String DELETE_TEMPLATE_ROOT = "<Root><Properties/></Root>";
    private static final String DELETE_TEMPLATE_DEPLOYEDCOMPONENT = "<DeployedComponent><Properties/></DeployedComponent>";
    private static final String DELETE_TEMPLATE_PROPERTY = "<Property><OwningType/><Resources/><StoredConfiguration/></Property><LocalizedResource><Properties/></LocalizedResource><PropertyType><Customizers/><Properties/><StoredConfiguration/><Validators/></PropertyType>";
    private static final String DELETE_TEMPLATE_TEXTSTORE = "<TextStore><Properties/></TextStore>";
    private static final String DELETE_TEMPLATE_LOCALIZEDRESOURCE = "<LocalizedResource><Properties/></LocalizedResource>";
    private static final String DELETE_TEMPLATE_NAMEDSERVICE = "<NamedService><Properties/></NamedService>";
    private static final String DELETE_TEMPLATE_EVENT = "<Event><Properties/><TriggeredTransforms/></Event>";
    private static final int NUM_DELETE_TEMPLATES = 10;
    private static final int TYPICAL_NUM_OBJS_TO_DELETE = 25;
    private static final int DELETION_TEMPLATE_LENGTH = 200;
    private final Root _root;

    RootDeleter(Root root) {
        if (root == null) {
            throw new IllegalArgumentException(RB.getStringResource("IllegalArgument.specifyMetadata.ex.txt"));
        }
        this._root = root;
    }

    protected static final String getDeleteTemplateDeployedComponent() {
        return DELETE_TEMPLATE_DEPLOYEDCOMPONENT;
    }

    protected static final String getDeleteTemplateEvent() {
        return DELETE_TEMPLATE_EVENT;
    }

    protected static final String getDeleteTemplateLocalizedResource() {
        return DELETE_TEMPLATE_LOCALIZEDRESOURCE;
    }

    protected static final String getDeleteTemplateNamedService() {
        return DELETE_TEMPLATE_NAMEDSERVICE;
    }

    protected static final String getDeleteTemplateTextStore() {
        return DELETE_TEMPLATE_TEXTSTORE;
    }

    protected static final String getDeleteTemplateProperty() {
        return DELETE_TEMPLATE_PROPERTY;
    }

    public void delete() throws DependentServicesException, ServiceException {
        block5: {
            IllegalArgumentException exception = null;
            try {
                this.verifyIsOKToDelete();
                ArrayList<CMetadata> deletedObjects = new ArrayList<CMetadata>(25);
                this.deleteMetadataObjects(deletedObjects);
                this.deleteUsingTemplate();
            }
            catch (IllegalArgumentException e) {
                exception = e;
            }
            finally {
                if (exception == null) break block5;
                throw new ServiceException(exception);
            }
        }
    }

    protected void verifyIsOKToDelete() throws ServiceException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void deleteUsingTemplate() throws ServiceException {
        block8: {
            HashMap<String, String> deletionTemplateMap = new HashMap<String, String>(10);
            String name = null;
            Throwable exception = null;
            try {
                name = this._root.getName();
                this.addDeletionTemplates(deletionTemplateMap);
                StringBuilder deletionTemplate = new StringBuilder(200);
                deletionTemplate.append("<Templates>");
                for (String nextDeletionTemplate : deletionTemplateMap.values()) {
                    deletionTemplate.append(nextDeletionTemplate);
                }
                deletionTemplate.append("</Templates>");
                this._root.getObjectStore().getFactory().deleteMetadataObjects((CMetadata)this._root, deletionTemplate.toString());
            }
            catch (MdException e) {
                exception = e;
            }
            catch (RemoteException e) {
                exception = e;
            }
            finally {
                if (exception == null) break block8;
                throw new ServiceException(exception, Message.format((ResourceBundle)RB.getResources(), (String)"RootDeleter.delete.ex.fmt.txt", (Object)name));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteMetadataObjects(List<CMetadata> deletedObjects) throws ServiceException {
        block8: {
            if (deletedObjects.size() > 0) {
                Throwable exception = null;
                String name = null;
                try {
                    name = this._root.getName();
                    this._root.getObjectStore().getFactory().deleteMetadataObjects(deletedObjects);
                }
                catch (MdException e) {
                    exception = e;
                }
                catch (RemoteException e) {
                    exception = e;
                }
                finally {
                    if (exception == null) break block8;
                    String msg = Message.format((ResourceBundle)RB.getResources(), (String)"RootDeleter.delete.ex.fmt.txt", (Object)name);
                    LogManager.getLogger(this.getClass()).error(msg, exception);
                    throw new ServiceException(exception, msg);
                }
            }
        }
    }

    protected void addDeletionTemplates(Map<String, String> deletionTemplateMap) throws ServiceException {
        deletionTemplateMap.put("Root", DELETE_TEMPLATE_ROOT);
        deletionTemplateMap.put("Property", DELETE_TEMPLATE_PROPERTY);
        deletionTemplateMap.put("TextStore", DELETE_TEMPLATE_TEXTSTORE);
    }

    protected static final void deleteProperties(Root root, List<CMetadata> deletedObjects) throws MdException {
        try {
            AssociationList properties = root.getProperties();
            if (properties.size() > 0) {
                Iterator propertiesIter = properties.iterator();
                Property property = null;
                Text textStore = null;
                while (propertiesIter.hasNext()) {
                    property = (Property)propertiesIter.next();
                    textStore = property.getStoredConfiguration();
                    if (textStore != null) {
                        deletedObjects.add((CMetadata)textStore);
                    }
                    deletedObjects.add((CMetadata)property.getOwningType());
                    deletedObjects.add((CMetadata)property);
                }
            }
        }
        catch (RemoteException e) {
            throw new MdException((Throwable)e);
        }
    }

    protected static final void deleteProperty(Property property, List<CMetadata> deletedObjects) throws MdException {
        try {
            if (property != null && deletedObjects != null) {
                PropertyType propertyType;
                Text textStore = property.getStoredConfiguration();
                if (textStore != null) {
                    deletedObjects.add((CMetadata)textStore);
                }
                if ((propertyType = property.getOwningType()) != null) {
                    deletedObjects.add((CMetadata)property.getOwningType());
                }
                deletedObjects.add((CMetadata)property);
            }
        }
        catch (RemoteException e) {
            throw new MdException((Throwable)e);
        }
    }

    protected final Root getRoot() {
        return this._root;
    }
}

