/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.deployment;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.net.ssl.SSLRMIClientSocketFactory;
import com.sas.net.ssl.SSLRMISocketFactories;
import com.sas.services.InitializationException;
import com.sas.services.ServiceException;
import com.sas.services.deployment.RB;
import com.sas.text.Message;
import com.sas.util.Strings;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.rmi.AccessException;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.util.Enumeration;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class RMIConfiguration
implements Serializable {
    private static final long serialVersionUID = 1451236734494895240L;
    private static final String RMI_PROTOCOL = "rmi://";
    public static final int DEFAULT_PORT = 5091;
    public static final String LOCALHOST = "localhost";
    private String _id;
    private String _host;
    private int _port = 5091;
    private transient Registry _rmiRegistry;
    private transient SSLRMISocketFactories _sslRMISocketFactories;

    public RMIConfiguration(String host, String port) throws InitializationException {
        this("", host, port);
    }

    public RMIConfiguration(String host, int port) throws InitializationException {
        this("", host, Integer.toString(port));
    }

    public RMIConfiguration(String id, String host, String port) throws InitializationException {
        this(null, id, host, port);
    }

    public RMIConfiguration(SSLRMISocketFactories sslRMISocketFactories, String id, String host, String port) throws InitializationException {
        this._sslRMISocketFactories = sslRMISocketFactories;
        this.setId(id);
        this.setHost(host);
        this.setPort(port);
    }

    public RMIConfiguration() {
    }

    public final Registry createRegistry() throws RemoteException {
        SSLRMISocketFactories sslRMISocketFactories = this.getSSLRMISocketFactory();
        Registry registry = LocateRegistry.createRegistry(this.getPort(), sslRMISocketFactories.getRMIClientSocketFactoryForClass(Registry.class), sslRMISocketFactories.getRMIServerSocketFactoryForClass(Registry.class));
        return registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        RMIConfiguration rMIConfiguration = this;
        synchronized (rMIConfiguration) {
            this._rmiRegistry = null;
        }
    }

    public final String getId() {
        if (this._id == null) {
            this._id = "";
        }
        return this._id;
    }

    public final void setId(String id) {
        this._id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getHost() {
        String host = null;
        RMIConfiguration rMIConfiguration = this;
        synchronized (rMIConfiguration) {
            try {
                if (this._host == null) {
                    this._host = InetAddress.getLocalHost().getHostAddress();
                }
            }
            catch (UnknownHostException e) {
                Logger logger = LogManager.getLogger(RMIConfiguration.class);
                logger.error(RB.getStringResource("RMIConfiguration.exceptionUnknownHost.ex.txt"), (Throwable)e);
                if (logger.isInfoEnabled()) {
                    logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"RMIConfiguration.logMsgUsingDefaultRMIRegistryHost.fmt.txt", (Object)this._host));
                }
                this._host = LOCALHOST;
            }
            host = this._host;
        }
        return host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setHost(String host) {
        RMIConfiguration rMIConfiguration = this;
        synchronized (rMIConfiguration) {
            if (this._rmiRegistry != null && !Strings.equal((String)this._host, (String)host, (boolean)true, (boolean)false)) {
                this._rmiRegistry = null;
            }
            this._host = host;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getPort() {
        int port = 5091;
        RMIConfiguration rMIConfiguration = this;
        synchronized (rMIConfiguration) {
            port = this._port;
        }
        return port;
    }

    public final String getPortAsString() {
        return Integer.toString(this.getPort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setPort(String port) throws InitializationException {
        try {
            int newPort = port == null ? 5091 : Integer.parseInt(port);
            RMIConfiguration rMIConfiguration = this;
            synchronized (rMIConfiguration) {
                if (this._rmiRegistry != null && newPort != this._port) {
                    this._rmiRegistry = null;
                }
                this._port = newPort;
            }
        }
        catch (NumberFormatException e) {
            Logger logger = LogManager.getLogger(RMIConfiguration.class);
            logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"RMIConfiguration.exceptionInvalidPort.ex.fmt.txt", (Object)port), (Throwable)e);
            throw new InitializationException(e, e.getMessage());
        }
    }

    public final String getUrl() {
        return RMI_PROTOCOL + this.getHost() + ':' + this.getPortAsString();
    }

    public final String getUrl(String bindName) {
        return this.getUrl() + '/' + bindName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Registry getRMIRegistry(boolean isCreateIfNotAlreadyStarted) throws ServiceException {
        Registry theRegistry = null;
        Registry registry = null;
        RMIConfiguration rMIConfiguration = this;
        synchronized (rMIConfiguration) {
            block21: {
                theRegistry = this._rmiRegistry;
                if (this._rmiRegistry == null) {
                    Logger logger = LogManager.getLogger(RMIConfiguration.class);
                    RemoteException exception = null;
                    try {
                        boolean isDebugLogEnabled = logger.isDebugEnabled();
                        if (isDebugLogEnabled) {
                            logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"RMIConfiguration.locatingRegistry.fmt.txt", (Object)this._host, (Object)this._port));
                        }
                        registry = LocateRegistry.getRegistry(this._host, this._port, null);
                        try {
                            try {
                                registry.list();
                                this._rmiRegistry = registry;
                                theRegistry = registry;
                                if (isDebugLogEnabled) {
                                    logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"RMIConfiguration.serviceRegistryFound.fmt.txt", (Object)this._host, (Object)this._port));
                                }
                            }
                            catch (ConnectIOException e) {
                                registry = LocateRegistry.getRegistry(this._host, this._port, (RMIClientSocketFactory)new SSLRMIClientSocketFactory());
                                registry.list();
                                this._rmiRegistry = registry;
                                theRegistry = registry;
                            }
                        }
                        catch (ConnectException e) {
                            if (isCreateIfNotAlreadyStarted) {
                                if (!RMIConfiguration.isValidHostForRegistry(this._host, this._port)) {
                                    throw new ServiceException(e, Message.format((ResourceBundle)RB.getResources(), (String)"RMIConfiguration.serviceRegistryNotAvailable.ex.fmt.txt", (Object)this._host, (Object)this._port));
                                }
                                if (isDebugLogEnabled) {
                                    logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"RMIConfiguration.startServiceRegistry.fmt.txt", (Object)this._host, (Object)this._port));
                                }
                                SSLRMISocketFactories sslRMISocketFactories = this.getSSLRMISocketFactory();
                                registry = LocateRegistry.createRegistry(this.getPort(), sslRMISocketFactories.getRMIClientSocketFactoryForClass(Registry.class), sslRMISocketFactories.getRMIServerSocketFactoryForClass(Registry.class));
                                registry.list();
                                this._rmiRegistry = registry;
                                theRegistry = registry;
                            }
                        }
                    }
                    catch (AccessException e) {
                        exception = e;
                        return exception;
                    }
                    catch (RemoteException e) {
                        exception = e;
                        return exception;
                    }
                    finally {
                        if (exception == null) break block21;
                        throw new ServiceException(exception, Message.format((ResourceBundle)RB.getResources(), (String)"RMIConfiguration.exceptionUnableToLocateRMIRegistry.ex.fmt.txt", (Object)this._host, (Object)this._port));
                    }
                }
            }
        }
        if (theRegistry == null) {
            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"RMIDeployableService.getRMIRegistry.ex.fmt.txt", (Object)this.getUrl()));
        }
        return theRegistry;
    }

    private static final boolean isValidHostForRegistry(String host, int port) {
        boolean isValid = false;
        InetAddress inetAddressLocalHost = null;
        String ipAddressLocalHost = null;
        Exception exception = null;
        Logger logger = LogManager.getLogger(RMIConfiguration.class);
        try {
            inetAddressLocalHost = InetAddress.getLocalHost();
            ipAddressLocalHost = inetAddressLocalHost.getHostAddress();
            InetAddress inetAddressHost = InetAddress.getByName(host);
            String ipAddressHost = inetAddressHost.getHostAddress();
            boolean bl = isValid = Strings.equal((String)host, (String)LOCALHOST, (boolean)false, (boolean)true) || Strings.equal((String)ipAddressLocalHost, (String)ipAddressHost, (boolean)false, (boolean)false);
            if (!isValid) {
                boolean isDebugLoggingEnabled = logger != null && logger.isDebugEnabled();
                Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
                block4: while (netInterfaces.hasMoreElements()) {
                    NetworkInterface networkInterface = netInterfaces.nextElement();
                    Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                    while (inetAddresses.hasMoreElements()) {
                        InetAddress inetAddress = inetAddresses.nextElement();
                        if (inetAddress == null) continue;
                        if (isDebugLoggingEnabled) {
                            logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"RMIConfiguration.networkInterface.name.fmt.txt", (Object)networkInterface.getName(), (Object)inetAddress.getHostAddress()));
                        }
                        if (!Strings.equal((String)ipAddressHost, (String)inetAddress.getHostAddress(), (boolean)false, (boolean)false)) continue;
                        isValid = true;
                        continue block4;
                    }
                }
            }
        }
        catch (UnknownHostException e) {
            isValid = false;
            exception = e;
        }
        catch (ClassCastException e) {
            exception = e;
        }
        catch (SocketException e) {
            exception = e;
        }
        if (!isValid) {
            logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"RMIConfiguration.invalidHostToStartRegistry.ex.fmt.txt", (Object)host, (Object)port, (Object)ipAddressLocalHost), (Throwable)exception);
        }
        return isValid;
    }

    public final String toString() {
        return this.getUrl();
    }

    private SSLRMISocketFactories getSSLRMISocketFactory() {
        return this._sslRMISocketFactories == null ? SSLRMISocketFactories.getInstance() : this._sslRMISocketFactories;
    }
}

