/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.deployment;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.meta.SASOMI.IOMI;
import com.sas.meta.SASOMI.IOMIHelper;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdOMIWrapper;
import com.sas.metadata.remote.MdRepositoryUtilImpl;
import com.sas.services.ServiceConfigurationInterface;
import com.sas.services.ServiceException;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.deployment.AbstractServiceConfigFactory;
import com.sas.services.deployment.MetadataSourceInterface;
import com.sas.services.deployment.OMRMetadataSource;
import com.sas.services.deployment.RB;
import com.sas.services.util.IOUtil;
import com.sas.services.util.XMLUtil;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.ResourceBundle;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.omg.CORBA.Object;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public final class OMRServiceConfigFactory
extends AbstractServiceConfigFactory {
    private static final int XML_FLAGS = 2948;
    static final String XSL_TRANSFORM_FILENAME = "XSL_GetMetadataObjects_to_MdObjectStore.xsl";
    private String _repositoryID;

    public OMRServiceConfigFactory(String repositoryName, ConnectionInterface metadataServerConnection) throws ServiceException {
        this(repositoryName, IOMIHelper.narrow((Object)metadataServerConnection.getObject()));
    }

    public OMRServiceConfigFactory(String repositoryName, IOMI omi) throws ServiceException {
        super(omi);
        if (omi == null) {
            throw new IllegalArgumentException(RB.getStringResource("IllegalArgument.nullConnection.ex.txt"));
        }
        if (repositoryName == null) {
            throw new IllegalArgumentException(RB.getStringResource("IllegalArgument.repositoryName.ex.txt"));
        }
        this._repositoryID = OMRServiceConfigFactory.getRepositoryIDUsingName(this.getMdFactory(), repositoryName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceConfigurationInterface createConfigForService(String softwareComponentName, String treeName, String serviceComponentName, MetadataSourceInterface metadataSource, boolean isRMIExportEnabled) throws ServiceException {
        ServiceConfigurationInterface serviceConfig;
        block7: {
            serviceConfig = null;
            Throwable exception = null;
            try {
                MdFactory mdFactory = this.getMdFactory();
                MdOMIWrapper mdOMIWrapper = mdFactory.getOMIUtil().getOMIUtility();
                IOMI omi = mdFactory.getConnection().getCMRHandle();
                String query = "<GetMetadataObjects><ReposId>" + this._repositoryID + "</ReposId><Type>" + "ServiceComponent" + "</Type><Objects/><ns>SAS</ns><Flags>" + 2948 + "</Flags><Options><XMLSelect Search=\"*[@Name='" + serviceComponentName + "' AND @ClassIdentifier='" + "ABC1212121212" + "'][Trees/Tree[@Name='" + treeName + "']/SoftwareComponents/SoftwareComponent[@ClassIdentifier='" + "ABC1234567890" + "' AND @Name='" + softwareComponentName + "']]\"/><Templates><ServiceComponent Id=\"\" Name=\"\" IsRemotelyAccessible=\"\"><ServiceTypes/><SoftwareTrees/><Properties/></ServiceComponent><Property Id=\"\" Name=\"\" PropertyName=\"\"><StoredConfiguration/></Property><ServiceType Id=\"\" Name=\"\" InterfaceName=\"\"/><TextStore Id=\"\" Name=\"\" TextRole=\"\" StoredText=\"\" MetadataUpdated=\"\"/><Tree><SoftwareComponents/></Tree><SoftwareComponent/></Templates></Options></GetMetadataObjects>";
                String omiResult = mdOMIWrapper.DoRequest(omi, query, false);
                serviceConfig = this.createServiceConfig(OMRServiceConfigFactory.transformGetMetadataObjects(omiResult), softwareComponentName, treeName, serviceComponentName, metadataSource, isRMIExportEnabled);
            }
            catch (MdException e) {
                exception = e;
                return exception;
            }
            catch (RemoteException e) {
                exception = e;
                return exception;
            }
            finally {
                if (exception == null) break block7;
                throw new ServiceException(exception, Message.format((ResourceBundle)RB.getResources(), (String)"ServiceConfigurationFactory.queryConfig.ex.fmt.txt", (java.lang.Object)serviceComponentName, (java.lang.Object)treeName, (java.lang.Object)softwareComponentName));
            }
        }
        return serviceConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getRepositoryIDUsingName(MdFactory mdFactory, String repositoryName) throws ServiceException {
        String repositoryID;
        block8: {
            repositoryID = null;
            Throwable exception = null;
            try {
                repositoryID = new MdRepositoryUtilImpl(mdFactory).getRepositoryIDFromName(repositoryName);
            }
            catch (MdException e) {
                exception = e;
                return exception;
            }
            catch (RemoteException e) {
                exception = e;
                return exception;
            }
            finally {
                if (exception == null) break block8;
                throw new ServiceException(exception, Message.format((ResourceBundle)RB.getResources(), (String)"IllegalArgument.repositoryName.ex.fmt.txt", (java.lang.Object)repositoryName));
            }
        }
        if (repositoryID == null) {
            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"IllegalArgument.repositoryName.ex.fmt.txt", (java.lang.Object)repositoryName));
        }
        return repositoryID;
    }

    static String transformGetMetadataObjects(String inXML) throws ServiceException {
        String outXML = inXML;
        try {
            String xslTransform = IOUtil.getStringFromResourceUsingEncoding(OMRMetadataSource.class, XSL_TRANSFORM_FILENAME, "utf-8");
            outXML = XMLUtil.applyXSL(inXML, xslTransform);
        }
        catch (TransformerConfigurationException e) {
            throw new ServiceException(e, RB.getStringResource("OMRMetadataSource.transformerConfiguration.ex.txt"));
        }
        catch (TransformerException e) {
            throw new ServiceException(e, RB.getStringResource("OMRMetadataSource.applyXSL.ex.txt"));
        }
        return outXML;
    }
}

