/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.deployment;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.NamedService;
import com.sas.metadata.remote.ServiceComponent;
import com.sas.metadata.remote.ServiceType;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.services.RemoteServiceInterface;
import com.sas.services.ServiceConfigurationInterface;
import com.sas.services.ServiceException;
import com.sas.services.deployment.AbstractMetadataSource;
import com.sas.services.deployment.AbstractServiceConfigFactory;
import com.sas.services.deployment.DeployableService;
import com.sas.services.deployment.Environment;
import com.sas.services.deployment.MetadataSourceConfiguration;
import com.sas.services.deployment.MetadataSourceInterface;
import com.sas.services.deployment.RB;
import com.sas.services.deployment.RMIBinding;
import com.sas.services.deployment.RMIConfiguration;
import com.sas.services.deployment.RMIDeployableService;
import com.sas.services.util.GetPropertyAction;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.security.AccessController;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public final class DeployableServiceFactory {
    private static final String BASE_SERVICE_INTERFACE = RemoteServiceInterface.class.getName();
    private static final String NEW_LINE = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
    private static final int STRING_LENGTH_DEPENDENCIES = 250;

    private DeployableServiceFactory() {
    }

    public static DeployableService getDeployableService(ServiceComponent serviceComponent, String[] requiredServiceTypes, SoftwareComponent softwareComponent) throws ServiceException {
        return DeployableServiceFactory.getDeployableService(serviceComponent, requiredServiceTypes, softwareComponent, null);
    }

    public static DeployableService getDeployableService(ServiceComponent serviceComponent, String[] requiredServiceTypes, SoftwareComponent softwareComponent, MetadataSourceInterface metadataSource) throws ServiceException {
        return DeployableServiceFactory.getDeployableService(serviceComponent, requiredServiceTypes, softwareComponent, metadataSource, null);
    }

    public static DeployableService getDeployableService(ServiceComponent serviceComponent, String[] requiredServiceTypes, SoftwareComponent softwareComponent, MetadataSourceInterface metadataSource, Environment environment) throws ServiceException {
        Logger logger = LogManager.getLogger(DeployableServiceFactory.class);
        DeployableService deployableService = null;
        if (serviceComponent == null) {
            throw new IllegalArgumentException(RB.getStringResource("IllegalArgument.specifyServiceComponent.ex.txt"));
        }
        if (DeployableServiceFactory.satisfiesServiceTypes(requiredServiceTypes, serviceComponent)) {
            ServiceConfigurationInterface serviceConfiguration = DeployableServiceFactory.getServiceConfiguration(serviceComponent, logger, environment);
            if (metadataSource != null) {
                serviceConfiguration.addServiceConfiguration(ServiceConfigurationInterface.CONFIGURATION_METADATA_SOURCE, new MetadataSourceConfiguration(metadataSource));
            }
            deployableService = DeployableServiceFactory.getDeployableService(serviceComponent, serviceConfiguration, softwareComponent, metadataSource instanceof AbstractMetadataSource ? (AbstractMetadataSource)metadataSource : null, logger);
        }
        return deployableService;
    }

    public static ServiceConfigurationInterface getServiceConfiguration(ServiceComponent serviceComponent, Logger logger) throws ServiceException {
        return AbstractServiceConfigFactory.createServiceConfiguration(serviceComponent, true);
    }

    public static ServiceConfigurationInterface getServiceConfiguration(ServiceComponent serviceComponent, Logger logger, Environment environment) throws ServiceException {
        return AbstractServiceConfigFactory.createServiceConfigurationForEnvironment(serviceComponent, environment, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DeployableService getDeployableService(ServiceComponent serviceComponent, ServiceConfigurationInterface serviceConfiguration, SoftwareComponent softwareComponent, AbstractMetadataSource metadataSource, Logger logger) throws ServiceException {
        DeployableService deployableService;
        block11: {
            deployableService = null;
            RemoteException exception = null;
            try {
                if (DeployableServiceFactory.isFoundationService(serviceComponent)) {
                    AbstractServiceConfigFactory.initializeConfiguration(serviceConfiguration, serviceComponent, softwareComponent);
                    String[] serviceDependencies = DeployableServiceFactory.getServiceDependencies(serviceComponent);
                    String serviceId = serviceComponent.getFQID();
                    if (serviceComponent.getIsRemotelyAccessible() == 1) {
                        Set<RMIBinding> rmiBindings = DeployableServiceFactory.getRMIBindings(serviceComponent);
                        if (rmiBindings != null && rmiBindings.size() > 0) {
                            deployableService = new RMIDeployableService(serviceId, serviceConfiguration, serviceDependencies, rmiBindings, metadataSource);
                        } else {
                            deployableService = new DeployableService(serviceId, serviceConfiguration, serviceDependencies);
                            if (logger != null) {
                                logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"DeployableServiceFactory.isRemoteButNoBindings.ex.fmt.txt", (Object)serviceComponent.getName()));
                            }
                        }
                    } else {
                        deployableService = new DeployableService(serviceId, serviceConfiguration, serviceDependencies);
                    }
                }
            }
            catch (RemoteException e) {
                exception = e;
                return exception;
            }
            finally {
                if (exception == null) break block11;
                throw new ServiceException(exception, exception.getLocalizedMessage());
            }
        }
        return deployableService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isFoundationService(ServiceComponent serviceComponent) throws ServiceException {
        boolean isService;
        block8: {
            isService = false;
            Throwable exception = null;
            try {
                Iterator iterServiceTypes = serviceComponent.getServiceTypes(false).iterator();
                ServiceType serviceType = null;
                while (iterServiceTypes.hasNext()) {
                    serviceType = (ServiceType)iterServiceTypes.next();
                    if (!BASE_SERVICE_INTERFACE.equals(serviceType.getInterfaceName())) continue;
                    isService = true;
                    break;
                }
            }
            catch (MdException e) {
                exception = e;
                return (boolean)exception;
            }
            catch (RemoteException e) {
                exception = e;
                return (boolean)exception;
            }
            finally {
                if (exception == null) break block8;
                throw new ServiceException(exception, RB.getStringResource("DeployableServiceFactory.isService.ex.txt"));
            }
        }
        return isService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean satisfiesServiceTypes(String[] requiredServiceTypes, ServiceComponent serviceComponent) throws ServiceException {
        boolean satisfiesServiceTypes;
        block10: {
            satisfiesServiceTypes = true;
            Throwable exception = null;
            String name = null;
            try {
                name = serviceComponent.getName();
                if (requiredServiceTypes != null && requiredServiceTypes.length > 0) {
                    Iterator iterServiceTypes = serviceComponent.getServiceTypes(false).iterator();
                    String requiredServiceType = null;
                    ServiceType serviceType = null;
                    String interfaceName = null;
                    int numReqServiceTypes = requiredServiceTypes.length;
                    int numMatches = 0;
                    boolean okToContinue = true;
                    for (int i = 0; i < numReqServiceTypes; ++i) {
                        requiredServiceType = requiredServiceTypes[i];
                        okToContinue = false;
                        while (iterServiceTypes.hasNext()) {
                            serviceType = (ServiceType)iterServiceTypes.next();
                            interfaceName = serviceType.getInterfaceName();
                            if (!requiredServiceType.equals(interfaceName)) continue;
                            ++numMatches;
                            okToContinue = true;
                            break;
                        }
                        if (!okToContinue) break;
                    }
                    satisfiesServiceTypes = numMatches == numReqServiceTypes;
                }
            }
            catch (MdException e) {
                exception = e;
                return (boolean)exception;
            }
            catch (RemoteException e) {
                exception = e;
                return (boolean)exception;
            }
            finally {
                if (exception == null) break block10;
                throw new ServiceException(exception, Message.format((ResourceBundle)RB.getResources(), (String)"DeployableServiceFactory.unableToDetermineServiceTypes.ex.fmt.txt", (Object)name));
            }
        }
        return satisfiesServiceTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<RMIBinding> getRMIBindings(ServiceComponent serviceComponent) throws ServiceException {
        HashSet<RMIBinding> rmiBindings;
        block11: {
            rmiBindings = new HashSet<RMIBinding>(5);
            Throwable exception = null;
            try {
                Iterator iterServiceNames = serviceComponent.getServiceNames(false).iterator();
                if (iterServiceNames.hasNext()) {
                    short rmiNamedServiceType = -1;
                    Iterator iterNamingServices = null;
                    NamedService namedService = null;
                    String serviceName = null;
                    DeployedComponent namingService2 = null;
                    String namedServiceType = null;
                    RMIBinding rmiBinding = null;
                    while (iterServiceNames.hasNext()) {
                        namedService = (NamedService)iterServiceNames.next();
                        rmiNamedServiceType = -1;
                        serviceName = namedService.getServiceName();
                        namedServiceType = namedService.getType();
                        if (!RMIBinding.isValidBindingType(namedServiceType)) continue;
                        rmiNamedServiceType = RMIBinding.getBinding(namedServiceType);
                        for (DeployedComponent namingService2 : namedService.getNamingServices()) {
                            Iterator iterServiceTypes = namingService2.getServiceTypes(false).iterator();
                            boolean isRmiRegistry = false;
                            ServiceType serviceType = null;
                            while (iterServiceTypes.hasNext()) {
                                serviceType = (ServiceType)iterServiceTypes.next();
                                if (!serviceType.getInterfaceName().equals(Registry.class.getName())) continue;
                                isRmiRegistry = true;
                                break;
                            }
                            if (!isRmiRegistry || (rmiBinding = DeployableServiceFactory.getRMIBinding(rmiNamedServiceType, serviceName, namingService2)) == null) continue;
                            rmiBindings.add(rmiBinding);
                        }
                    }
                }
            }
            catch (MdException e) {
                exception = e;
                return exception;
            }
            catch (RemoteException e) {
                exception = e;
                return exception;
            }
            finally {
                if (exception == null) break block11;
                throw new ServiceException(exception, exception.getLocalizedMessage());
            }
        }
        return rmiBindings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RMIBinding getRMIBinding(short rmiNamedServiceType, String serviceName, DeployedComponent namingService) throws ServiceException {
        RMIBinding rmiBinding;
        block10: {
            rmiBinding = null;
            Throwable exception = null;
            String name = null;
            try {
                name = namingService.getName();
                Object sourceConnection2 = null;
                TCPIPConnection tcpipConnection = null;
                for (Object sourceConnection2 : namingService.getSourceConnections()) {
                    if (!(sourceConnection2 instanceof TCPIPConnection)) continue;
                    tcpipConnection = sourceConnection2;
                    int port = tcpipConnection.getPort();
                    String hostName = tcpipConnection.getHostName();
                    if (port <= 0 || hostName == null || (hostName = hostName.trim()).length() <= 0) continue;
                    rmiBinding = new RMIBinding(new RMIConfiguration(hostName, port), serviceName, rmiNamedServiceType);
                    break;
                }
            }
            catch (MdException e) {
                exception = e;
                return exception;
            }
            catch (RemoteException e) {
                exception = e;
                return exception;
            }
            catch (ClassCastException e) {
                exception = e;
                return exception;
            }
            finally {
                if (exception == null) break block10;
                throw new ServiceException(exception, Message.format((ResourceBundle)RB.getResources(), (String)"DeployableServiceFactory.getNameBinding.ex.fmt.txt", (Object)name));
            }
        }
        return rmiBinding;
    }

    /*
     * Exception decompiling
     */
    private static String[] getServiceDependencies(ServiceComponent serviceComponent) throws ServiceException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

