/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.deployment;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.entities.GUID;
import com.sas.util.Strings;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public final class Consumer
implements Cloneable {
    static final String XML_ELEMENT_CONSUMER = "Consumer";
    private static final String XML_ATTRIBUTE_ID = "id";
    private static final String XML_ATTRIBUTE_NAME = "name";
    private String _id = GUID.newGUID();
    private String _name;

    public Consumer(String name) {
        this.setName(name);
    }

    public Consumer(Element element) {
        if (element == null || !XML_ELEMENT_CONSUMER.equals(element.getNodeName())) {
            throw new IllegalArgumentException();
        }
        String value = element.getAttribute(XML_ATTRIBUTE_NAME);
        if (value == null || value.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        this._name = value;
        value = element.getAttribute(XML_ATTRIBUTE_ID);
        if (value != null && value.length() > 0) {
            this._id = value;
        }
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getID() {
        return this._id;
    }

    public Element createElement(Document document) {
        if (document == null) {
            throw new IllegalArgumentException("A non null Document must be specified.");
        }
        Element element = document.createElement(XML_ELEMENT_CONSUMER);
        element.setAttribute(XML_ATTRIBUTE_ID, this._id);
        element.setAttribute(XML_ATTRIBUTE_NAME, this._name);
        return element;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object other) {
        boolean isEqual = false;
        if (other == this) {
            isEqual = true;
        } else if (other == null) {
            isEqual = false;
        } else {
            try {
                Consumer otherConsumer = (Consumer)other;
                isEqual = Strings.equal((String)this.getID(), (String)otherConsumer.getID(), (boolean)false, (boolean)false) && Strings.equal((String)this.getName(), (String)otherConsumer.getName(), (boolean)false, (boolean)false);
            }
            catch (ClassCastException e) {
                isEqual = false;
            }
        }
        return isEqual;
    }

    public int hashCode() {
        int hashCode = 7;
        if (this._id != null) {
            hashCode ^= this._id.hashCode();
        }
        if (this._name != null) {
            hashCode ^= this._name.hashCode();
        }
        return hashCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("[name=");
        sb.append(this._name);
        sb.append("][id=");
        sb.append(this._id);
        sb.append(']');
        return sb.toString();
    }
}

