/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.deployment;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdFactoryImpl;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.services.ServiceException;
import com.sas.services.ServiceFactoryInterface;
import com.sas.services.deployment.RB;
import com.sas.services.deployment.ServiceDeployment;
import com.sas.text.Message;
import java.io.File;
import java.rmi.RemoteException;
import java.util.ResourceBundle;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public abstract class AbstractServiceDeployment {
    private static final int BUFFER_LENGTH = 200;
    private String _softwareComponentName;

    public AbstractServiceDeployment(String softwareComponentName) throws ServiceException {
        if (softwareComponentName == null) {
            throw new IllegalArgumentException();
        }
        this._softwareComponentName = softwareComponentName;
    }

    public final String getSoftwareComponentName() {
        return this._softwareComponentName;
    }

    public abstract boolean installServiceConfiguration(String var1, String var2, File var3, String var4) throws ServiceException;

    protected final String getXMLSelectProperty(String serviceComponentFQID, String configName) {
        return "<XMLSelect search=\"*[@PropertyName='INIT_DATA' and @Name='" + configName + "'][AssociatedObject/*[@Id='" + serviceComponentFQID + "']]\"/>";
    }

    protected String getSearchOptions(String softwareComponentID) {
        StringBuilder sb = new StringBuilder(200);
        sb.append("<XMLSelect search=\"*[Trees/*/SoftwareComponents/*[@Id='");
        sb.append(softwareComponentID);
        sb.append("']]\"/><Templates><ServiceComponent Id=\"\" Name=\"\" FactoryClassName=\"\" /></Templates>");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ServiceFactoryInterface getServiceFactory(String serviceFactoryClassName) throws ServiceException {
        ServiceFactoryInterface serviceFactory;
        block9: {
            serviceFactory = null;
            ReflectiveOperationException ex = null;
            try {
                Class<?> serviceFactoryClass = AbstractServiceDeployment.class.getClassLoader().loadClass(serviceFactoryClassName);
                serviceFactory = (ServiceFactoryInterface)serviceFactoryClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                ex = e;
                return ex;
            }
            catch (IllegalAccessException e) {
                ex = e;
                return ex;
            }
            catch (InstantiationException e) {
                ex = e;
                return ex;
            }
            finally {
                if (ex == null) break block9;
                throw new ServiceException(ex, Message.format((ResourceBundle)RB.getResources(), (String)"ServiceDeployment.getServiceFactory.ex.fmt.txt", (Object)serviceFactoryClassName));
            }
        }
        return serviceFactory;
    }

    static final String getRepositoryID(MdFactory mdFactory, String repositoryName) throws ServiceException {
        String repositoryID = null;
        try {
            for (CMetadata cMetadata : mdFactory.getOMIUtil().getRepositories()) {
                if (!repositoryName.equals(cMetadata.getName())) continue;
                repositoryID = cMetadata.getFQID();
                break;
            }
        }
        catch (MdException e) {
            throw new ServiceException(e);
        }
        catch (RemoteException e) {
            throw new ServiceException(e);
        }
        return repositoryID;
    }

    static final MdStore createMdStore(String host, String port, String userID, String userPassword, boolean isRemoteEnvironment) throws ServiceException {
        MdObjectStore mdStore = null;
        try {
            MdFactoryImpl mdFactory = new MdFactoryImpl(isRemoteEnvironment);
            mdFactory.makeOMRConnection(host, port, userID, userPassword);
            mdStore = mdFactory.createObjectStore(null, ServiceDeployment.class.getName());
        }
        catch (MdException e) {
            throw new ServiceException(e);
        }
        catch (RemoteException e) {
            throw new ServiceException(e);
        }
        return mdStore;
    }
}

