/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services;

import com.sas.codepolicy.SASScope;
import com.sas.services.AbstractRemoteService;
import com.sas.services.RB;
import com.sas.services.RemoteServiceInterface;
import com.sas.services.ServiceException;
import com.sas.services.ServiceState;
import com.sas.text.Message;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;

@SASScope
public final class ShutdownThread
extends Thread {
    private RemoteServiceInterface _service;
    private boolean _isDisabled;
    private AbstractRemoteService _abstractService;

    private ShutdownThread() {
        super(RB.getStringResource("ShutdownThread.threadName.txt"));
    }

    public ShutdownThread(RemoteServiceInterface service) throws NullPointerException {
        super(Message.format((ResourceBundle)RB.getResources(), (String)"ShutdownThread.threadNameEntityId.fmt.txt", (Object)service.getClass().getName()));
        this.setService(service);
    }

    public ShutdownThread(AbstractRemoteService service) {
        this();
        if (service == null) {
            throw new IllegalArgumentException(RB.getStringResource("ShutdownThread.nonNullServiceRequired.ex.txt"));
        }
        this._abstractService = service;
        this.setService(service);
    }

    void setService(RemoteServiceInterface service) {
        this._service = service;
        try {
            if (service != null) {
                this.setName(Message.format((ResourceBundle)RB.getResources(), (String)"ShutdownThread.threadNameEntityId.fmt.txt", (Object)service.getEntityKey()));
            }
        }
        catch (RemoteException e) {
            LogManager.getLogger(ShutdownThread.class).error(Message.format((ResourceBundle)RB.getResources(), (String)"ShutdownThread.getEntityKey.ex.fmt.txt", service.getClass()));
        }
    }

    public void disable() {
        this._isDisabled = true;
    }

    public void enable() {
        this._isDisabled = false;
    }

    @Override
    public void run() {
        Serializable ex = null;
        try {
            if (!this._isDisabled && this._service != null && !ServiceState.isStateDeactivated(this._service.getServiceState())) {
                if (this._abstractService == null) {
                    this._service.destroy();
                } else {
                    this._abstractService.handleJVMShutdown();
                }
            }
        }
        catch (ServiceException e) {
            ex = e;
        }
        catch (RemoteException e) {
            ex = e;
        }
        finally {
            if (ex != null) {
                LogManager.getLogger(ShutdownThread.class).error(RB.getStringResource("ShutdownThread.run.ex.txt"), (Throwable)ex);
            }
            this._service = null;
            this._abstractService = null;
        }
    }
}

