/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services;

import com.sas.services.AbstractServiceComponentConfig;
import com.sas.services.DocumentServiceConfigAdapterInterface;
import com.sas.services.InitializationException;
import com.sas.services.InitializationObjectInterface;
import com.sas.services.RB;
import com.sas.services.ServiceConfigDocument;
import com.sas.services.ServiceException;
import com.sas.services.util.XMLUtil;
import com.sas.text.Message;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class ServiceInitializationObject
implements InitializationObjectInterface {
    private static final long serialVersionUID = -3268675511535448082L;
    private transient List<ServiceConfigDocument> _serviceConfigDocuments = new ArrayList<ServiceConfigDocument>(5);

    public ServiceInitializationObject() {
    }

    public ServiceInitializationObject(String configXML) throws ServiceException, IllegalArgumentException {
        this.setInitializationObject(configXML);
    }

    public ServiceInitializationObject(InputSource configXMLInputSource) throws ServiceException, IllegalArgumentException {
        this.setInitializationObject(configXMLInputSource);
    }

    public final Document createDocument(Object config) throws InitializationException {
        Document document = null;
        try {
            String initObjectString = (String)config;
            if (initObjectString != null && initObjectString.trim().length() > 0) {
                document = XMLUtil.convertInputSourceToDocument(new InputSource(new StringReader(initObjectString)));
            }
        }
        catch (ClassCastException e) {
            try {
                document = this.createDocumentFromInputSource((InputSource)config);
            }
            catch (ClassCastException e2) {
                throw new InitializationException(RB.getStringResource("ServiceInitializationObject.exceptionInvalidInitObjectType.ex.txt"));
            }
        }
        return document;
    }

    public final Document createDocumentFromString(String config) throws InitializationException {
        Document document = null;
        if (config != null && config.trim().length() > 0) {
            document = this.createDocumentFromInputSource(new InputSource(new StringReader(config)));
        }
        return document;
    }

    public final Document createDocumentFromInputSource(InputSource config) throws InitializationException {
        Document document = null;
        if (null != config) {
            document = XMLUtil.convertInputSourceToDocument(config);
        }
        return document;
    }

    public final void setInitializationObject(Object config) throws InitializationException {
        this._serviceConfigDocuments.clear();
        if (config != null) {
            Document document = null;
            if (config instanceof Document) {
                document = (Document)config;
            } else if (config instanceof String) {
                document = this.createDocumentFromString((String)config);
            } else if (config instanceof InputSource) {
                document = this.createDocumentFromInputSource((InputSource)config);
            }
            if (document != null) {
                this._serviceConfigDocuments.add(new ServiceConfigDocument("", document));
            }
        }
    }

    public final void addConfiguration(String configName, String configXML) throws InitializationException {
        if (configXML != null) {
            this.addConfigurationDocument(configName, this.createDocumentFromString(configXML));
        }
    }

    public final void addConfigurationDocument(String configName, Document document) throws InitializationException {
        if (document != null) {
            this._serviceConfigDocuments.add(new ServiceConfigDocument(configName, document));
        }
    }

    @Override
    public final Object getInitializationObject() {
        Document document = null;
        if (this._serviceConfigDocuments.size() > 0) {
            ServiceConfigDocument serviceConfigDocument = this._serviceConfigDocuments.get(0);
            document = serviceConfigDocument.getDocument();
        }
        return document;
    }

    public final List<ServiceConfigDocument> getConfigurations() {
        return new ArrayList<ServiceConfigDocument>(this._serviceConfigDocuments);
    }

    public final AbstractServiceComponentConfig getConfiguration(DocumentServiceConfigAdapterInterface adapter) throws ServiceException {
        if (adapter == null) {
            throw new IllegalArgumentException(RB.getStringResource("IllegalArgument.docToServiceConfigAdapter.ex.txt"));
        }
        AbstractServiceComponentConfig config = null;
        Object nextConfig = null;
        try {
            int numConfigs = this._serviceConfigDocuments.size();
            if (numConfigs == 1) {
                config = adapter.createConfigFromDocument(this._serviceConfigDocuments.get(0).getDocument());
            } else if (numConfigs > 1) {
                for (ServiceConfigDocument serviceConfigDocument : this._serviceConfigDocuments) {
                    nextConfig = adapter.createConfigFromDocument(serviceConfigDocument.getDocument());
                    if (config != null) {
                        config.mergeConfiguration((AbstractServiceComponentConfig)nextConfig);
                        continue;
                    }
                    config = (AbstractServiceComponentConfig)((AbstractServiceComponentConfig)nextConfig).clone();
                }
            }
        }
        catch (CloneNotSupportedException e) {
            throw new ServiceException(e, Message.format((ResourceBundle)RB.getResources(), (String)"ServiceInitializationObject.cloneConfig.ex.fmt.txt", (Object)nextConfig.getClass().getName()));
        }
        return config;
    }
}

