/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceConfigurationInterface;
import com.sas.services.deployment.Environment;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class ServiceConfiguration
implements ServiceConfigurationInterface {
    private static final long serialVersionUID = 1389424401615764532L;
    private Map<Object, ServiceConfigurationInterface> _map = new HashMap<Object, ServiceConfigurationInterface>(5);
    private transient Object _initializationObject;
    private transient Environment _environment;

    public ServiceConfiguration() {
    }

    public ServiceConfiguration(Object initializationObject) {
        this();
        this.setInitializationObject(initializationObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addServiceConfiguration(Object key, ServiceConfigurationInterface serviceConfiguration) {
        if (key == null || serviceConfiguration == null) {
            throw new IllegalArgumentException();
        }
        Map<Object, ServiceConfigurationInterface> map = this._map;
        synchronized (map) {
            try {
                Serializable configKey = (Serializable)key;
                this._map.put(configKey, serviceConfiguration);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException(e.getLocalizedMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeServiceConfiguration(Object key) {
        if (key != null) {
            Map<Object, ServiceConfigurationInterface> map = this._map;
            synchronized (map) {
                this._map.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ServiceConfigurationInterface getServiceConfiguration(Object key) {
        ServiceConfigurationInterface serviceConfiguration = null;
        Map<Object, ServiceConfigurationInterface> map = this._map;
        synchronized (map) {
            serviceConfiguration = this._map.get(key);
        }
        return serviceConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Iterator<ServiceConfigurationInterface> getServiceConfigurations() {
        Iterator<ServiceConfigurationInterface> iter = null;
        Map<Object, ServiceConfigurationInterface> map = this._map;
        synchronized (map) {
            iter = new ArrayList<ServiceConfigurationInterface>(this._map.values()).iterator();
        }
        return iter;
    }

    @Override
    public final Object getInitializationObject() {
        return this._initializationObject;
    }

    @Override
    public final void setInitializationObject(Object initializationObject) {
        this._initializationObject = initializationObject;
    }

    @Override
    public final Environment getEnvironment() {
        return this._environment;
    }

    public final void setEnvironment(Environment environment) {
        this._environment = environment;
    }
}

