/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServiceComponent;
import com.sas.metadata.remote.Text;
import com.sas.metadata.remote.TextStore;
import com.sas.services.MergePolicy;
import com.sas.services.RB;
import com.sas.services.ServiceComponentConfigInterface;
import com.sas.services.ServiceConfigurationException;
import com.sas.services.ServiceException;
import com.sas.services.deployment.ConsumedResourceAdapter;
import com.sas.services.deployment.ConsumedResourceInterface;
import com.sas.services.deployment.Consumer;
import com.sas.services.deployment.ConsumerResourceAssoc;
import com.sas.services.deployment.ConsumerUsage;
import com.sas.services.deployment.MergePolicyAdd;
import com.sas.services.util.XMLUtil;
import com.sas.text.Message;
import com.sas.util.Strings;
import com.sas.util.UsageVersion;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractServiceComponentConfig
implements Cloneable,
ServiceComponentConfigInterface {
    public static final String ENCODING = "UTF-8";
    public static final String PROPERTY_NAME_INIT_DATA = "INIT_DATA";
    public static final String PROPERTY_NAME_INITIALIZATIONDATA = "Initialization Data";
    public static final String PROPERTYROLE_APPCONFIG = "Application Configuration";
    public static final String LOOKUPKEY_PROPERTYNAME_VIEWCLASS = "ServiceInitializationDataView";
    public static final String PROPERTYROLE_INITIALIZATION = "initialization";
    public static final String XML_ELEMENT_ATTRIBUTE_VERSION = "version";
    private static final int PRIME_NUMBER = 31;
    private transient ConsumerUsage _consumerUsage = new ConsumerUsage();
    private UsageVersion _usageVersionOldest = new UsageVersion(0, 0);
    private UsageVersion _usageVersionCurrent = new UsageVersion(0, 0);
    private UsageVersion _usageVersion = new UsageVersion(0, 0);
    private String _xmlDocument;
    private String _xmlDocumentElementName;
    private boolean _isServiceConfigurationUpdateable;
    private String _configName;
    private boolean _isBaseConfig;
    private Map<String, ConsumedResourceAdapter> _consumedResourceAdapterMap = new HashMap<String, ConsumedResourceAdapter>(4);

    protected AbstractServiceComponentConfig(InputStream configInputStream, boolean isServiceConfigurationUpdateable) throws IllegalArgumentException {
        this.setXMLDocument(XMLUtil.convertStreamToDocument(configInputStream), null);
        this._isServiceConfigurationUpdateable = isServiceConfigurationUpdateable;
    }

    protected AbstractServiceComponentConfig(String xmlDocument) {
        this.setXMLDocument(xmlDocument);
    }

    protected AbstractServiceComponentConfig(String xmlDocument, boolean isServiceConfigurationUpdateable) {
        this.setXMLDocument(xmlDocument);
        this.setIsConfigurationUpdateable(isServiceConfigurationUpdateable);
    }

    @Override
    public String getConfigName() {
        return this._configName == null ? (this._isBaseConfig ? AbstractServiceComponentConfig.getBaseConfigName() : "") : this._configName;
    }

    @Override
    public final void setConfigName(String configName) {
        this._configName = configName;
    }

    public static String getConfigName(Property property) throws ServiceException {
        String value = null;
        try {
            value = AbstractServiceComponentConfig.isBaseConfig(property) ? AbstractServiceComponentConfig.getBaseConfigName() : property.getName();
        }
        catch (RemoteException e) {
            throw new ServiceException(e);
        }
        return value;
    }

    public void setConfigName(Property property) throws ServiceException {
        this._configName = AbstractServiceComponentConfig.getConfigName(property);
    }

    public static final String getBaseConfigName() {
        return RB.getStringResource("AbstractServiceComponentConfig.baseConfig.txt");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isBaseConfig(Property property) throws ServiceException {
        boolean isBaseConfig;
        block9: {
            isBaseConfig = false;
            if (property != null) {
                Throwable exception = null;
                try {
                    Root serviceComponent = property.getAssociatedObject();
                    for (Property aProperty : serviceComponent.getProperties()) {
                        if (!PROPERTY_NAME_INIT_DATA.equals(aProperty.getPropertyName())) continue;
                        isBaseConfig = property.getFQID().equals(aProperty.getFQID());
                        break;
                    }
                }
                catch (MdException e) {
                    exception = e;
                    return (boolean)exception;
                }
                catch (RemoteException e) {
                    exception = e;
                    return (boolean)exception;
                }
                finally {
                    if (exception == null) break block9;
                    throw new ServiceException(exception, RB.getStringResource("AbstractServiceComponentConfig.isBaseConfig.ex.txt"));
                }
            }
        }
        return isBaseConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isBaseConfiguration(Property property) throws ServiceException {
        boolean isBaseConfig;
        block9: {
            isBaseConfig = false;
            if (property != null) {
                Throwable exception = null;
                try {
                    Root serviceComponent = property.getAssociatedObject();
                    for (Property aProperty : serviceComponent.getProperties()) {
                        if (!PROPERTY_NAME_INIT_DATA.equals(aProperty.getPropertyName())) continue;
                        isBaseConfig = property.getFQID().equals(aProperty.getFQID());
                        break;
                    }
                }
                catch (MdException e) {
                    exception = e;
                    return (boolean)exception;
                }
                catch (RemoteException e) {
                    exception = e;
                    return (boolean)exception;
                }
                finally {
                    if (exception == null) break block9;
                    throw new ServiceException(exception, RB.getStringResource("AbstractServiceComponentConfig.isBaseConfig.ex.txt"));
                }
            }
        }
        return isBaseConfig;
    }

    private final void setXMLDocument(String xmlDocument) throws IllegalArgumentException {
        if (xmlDocument == null) {
            throw new IllegalArgumentException("AbstractServiceComponentConfig.specifyXMLDocument.ex.txt");
        }
        this.setXMLDocument(this.getConfigDocument(xmlDocument), xmlDocument);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfig(Property property) throws ServiceException {
        block9: {
            Throwable exception = null;
            try {
                String xml;
                TextStore textStore = (TextStore)property.getStoredConfiguration();
                if (textStore != null && (xml = textStore.getStoredText()) != null && xml.trim().length() > 0) {
                    Document document = XMLUtil.convertStringToDocument(xml);
                    AbstractServiceComponentConfig addConfig = this.createConfiguration(document);
                    if (addConfig != null) {
                        addConfig.setConfigName(property);
                        this.mergeConfiguration(this, addConfig);
                    }
                    this.setConfigName(property);
                }
            }
            catch (MdException e) {
                exception = e;
            }
            catch (RemoteException e) {
                exception = e;
            }
            finally {
                if (exception == null) break block9;
                throw new ServiceException(exception, RB.getStringResource("AbstractServiceComponentConfig.setConfig.ex.txt"));
            }
        }
    }

    protected AbstractServiceComponentConfig createConfiguration(Document document) throws ServiceException {
        return null;
    }

    private final void setXMLDocument(Document xmlDocument, String xmlDocumentString) {
        this._xmlDocumentElementName = xmlDocument.getDocumentElement().getNodeName();
        this._xmlDocument = xmlDocumentString == null ? XMLUtil.convertNodeToString(xmlDocument) : xmlDocumentString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Property getServiceConfigProperty(ServiceComponent serviceComponent) throws ServiceException {
        Property serviceConfigProperty;
        block10: {
            serviceConfigProperty = null;
            Throwable exception = null;
            try {
                for (Property property : serviceComponent.getProperties()) {
                    if (!PROPERTY_NAME_INIT_DATA.equals(property.getPropertyName())) continue;
                    serviceConfigProperty = property;
                    break;
                }
            }
            catch (RemoteException e) {
                exception = e;
                return exception;
            }
            catch (ClassCastException e) {
                exception = e;
                return exception;
            }
            catch (MdException e) {
                exception = e;
                return exception;
            }
            finally {
                if (exception == null) break block10;
                throw new ServiceException(exception, RB.getStringResource("AbstractServiceComponentConfig.unableToGetServiceProperties.ex.txt"));
            }
        }
        return serviceConfigProperty;
    }

    @Override
    public final boolean isConfigurationUpdateable() {
        return this._isServiceConfigurationUpdateable;
    }

    private void setIsConfigurationUpdateable(boolean isServiceConfigurationUpdateable) {
        this._isServiceConfigurationUpdateable = isServiceConfigurationUpdateable;
    }

    protected final void validateServiceComponent(ServiceComponent serviceComponent) throws ServiceConfigurationException, IllegalArgumentException {
        AbstractServiceComponentConfig.verifyServiceComponentIsNotNull(serviceComponent);
        try {
            String value = serviceComponent.getFactoryClassName();
            String expectedValue = this.getServiceFactoryClassName();
            if (!Strings.equal((String)value, (String)expectedValue, (boolean)false, (boolean)false)) {
                throw new ServiceConfigurationException(Message.format((ResourceBundle)RB.getResources(), (String)"AbstractServiceComponentConfig.invalidServiceComponentFactory.ex.fmt.txt", (Object)value, (Object)expectedValue));
            }
            value = serviceComponent.getClassIdentifier();
            String[] validClassIdentifiers = this.getServiceClassIdentifiers();
            int numIds = validClassIdentifiers.length;
            boolean isValidClassIdentifier = false;
            for (int i = 0; i < numIds; ++i) {
                if (!Strings.equal((String)value, (String)validClassIdentifiers[i], (boolean)false, (boolean)false)) continue;
                isValidClassIdentifier = true;
            }
            if (!isValidClassIdentifier) {
                throw new ServiceConfigurationException(Message.format((ResourceBundle)RB.getResources(), (String)"AbstractServiceComponentConfig.invalidServiceComponentClassIdentifier.ex.fmt.txt", (Object)value, (Object)validClassIdentifiers));
            }
        }
        catch (RemoteException e) {
            throw new ServiceConfigurationException(e);
        }
    }

    protected final void validateServiceConfiguration(Document document) throws ServiceException, IllegalArgumentException {
        if (document == null) {
            throw new IllegalArgumentException(RB.getStringResource("AbstractServiceComponentConfig.mustSpecifyServiceConfig.ex.txt"));
        }
        this.validateServiceConfigurationCustom(document);
    }

    protected String[] getServiceClassIdentifiers() {
        return new String[]{"ABC1212121212"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void mergeConfigFromDocument(ServiceComponent serviceComponent, Document serviceConfiguration) throws ServiceException {
        block9: {
            if (!this._isServiceConfigurationUpdateable) {
                throw new ServiceException(RB.getStringResource("AbstractServiceComponentConfig.updateNotSupported.ex.txt"));
            }
            AbstractServiceComponentConfig.verifyServiceComponentIsNotNull(serviceComponent);
            if (serviceConfiguration == null) {
                throw new IllegalArgumentException(RB.getStringResource("AbstractServiceComponentConfig.mustSpecifyServiceConfig.ex.txt"));
            }
            Throwable exception = null;
            try {
                this.mergeConfig(serviceComponent, serviceConfiguration);
                serviceComponent.getObjectStore().updatedMetadataAll();
            }
            catch (MdException e) {
                exception = e;
            }
            catch (RemoteException e) {
                exception = e;
            }
            finally {
                if (exception == null) break block9;
                throw new ServiceException(exception, RB.getStringResource("AbstractServiceComponentConfig.updateMetadata.ex.txt"));
            }
        }
    }

    public void mergeConfiguration(AbstractServiceComponentConfig newConfig) throws ServiceConfigurationException, IllegalArgumentException {
        this.mergeConfiguration(this, newConfig);
    }

    public void mergeConfiguration(AbstractServiceComponentConfig newConfig, MergePolicy mergePolicy) throws ServiceConfigurationException, IllegalArgumentException {
        this.mergeConfiguration(this, newConfig, mergePolicy);
    }

    protected abstract void mergeConfiguration(AbstractServiceComponentConfig var1, AbstractServiceComponentConfig var2) throws ServiceConfigurationException, IllegalArgumentException;

    protected abstract void mergeConfiguration(AbstractServiceComponentConfig var1, AbstractServiceComponentConfig var2, MergePolicy var3) throws ServiceConfigurationException, IllegalArgumentException;

    protected abstract DocumentFragment appendDOM(Document var1, AbstractServiceComponentConfig var2) throws ServiceConfigurationException, IllegalArgumentException;

    protected abstract void validateServiceConfigurationCustom(Document var1) throws ServiceException;

    @Override
    public Document getDocument() throws ServiceException {
        Document document = null;
        try {
            document = this.getConfigDocument(this._xmlDocument);
            try {
                document.getDocumentElement().setAttribute(XML_ELEMENT_ATTRIBUTE_VERSION, Integer.toString(Double.valueOf(this._usageVersionCurrent.encode()).intValue()));
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        catch (IllegalArgumentException e) {
            throw new ServiceException(e, RB.getStringResource("AbstractServiceComponentConfig.getDocument.ex.txt"));
        }
        return document;
    }

    public static final String convertDocumentToString(Document document) throws ServiceException {
        String value = null;
        if (document != null) {
            value = XMLUtil.convertNodeToString((Node)document, AbstractServiceComponentConfig.getOutputFormatProperties());
        }
        return value;
    }

    public static final Properties getOutputFormatProperties() {
        Properties properties = new Properties();
        properties.put("encoding", "utf-8");
        properties.put("indent", "yes");
        return properties;
    }

    @Override
    public Document createDocument(ServiceComponent serviceComponent) throws ServiceException {
        AbstractServiceComponentConfig configObj;
        DocumentFragment docFragment;
        String xmlConfig;
        Document document = this.getDocument();
        if (document != null && (xmlConfig = AbstractServiceComponentConfig.getServiceComponentConfigurationFromTextStore(serviceComponent)) != null && (docFragment = this.appendDOM(document, configObj = this.getConfig(XMLUtil.convertStringToDocument(xmlConfig)))) != null) {
            document.getDocumentElement().appendChild(docFragment);
        }
        return document;
    }

    private final Document getConfigDocument(String xmlDocument) throws IllegalArgumentException {
        if (xmlDocument == null) {
            throw new IllegalArgumentException();
        }
        return XMLUtil.convertStringToDocument(xmlDocument);
    }

    protected abstract String getServiceFactoryClassName();

    protected abstract AbstractServiceComponentConfig getConfig(Document var1) throws ServiceConfigurationException, IllegalArgumentException;

    public void mergeConfig(ServiceComponent serviceComponent, Document serviceConfiguration) throws ServiceException {
        this.validateServiceComponent(serviceComponent);
        this.validateServiceConfiguration(serviceConfiguration);
        try {
            Document currentConfigDocument = AbstractServiceComponentConfig.getTextStoreServiceConfig(serviceComponent);
            AbstractServiceComponentConfig currentConfig = this.getConfig(currentConfigDocument);
            AbstractServiceComponentConfig newConfig = this.getConfig(serviceConfiguration);
            this.mergeConfiguration(currentConfig, newConfig);
            Document newDocument = this.getDocument();
            DocumentFragment documentFragment = this.appendDOM(newDocument, currentConfig);
            if (documentFragment != null) {
                newDocument.getDocumentElement().appendChild(documentFragment);
            }
            AbstractServiceComponentConfig.setTextStoreServiceConfig(serviceComponent, newDocument);
        }
        catch (ClassCastException e) {
            throw new ServiceException(e, e.getLocalizedMessage());
        }
    }

    @Override
    public void mergeConfigFromFile(ServiceComponent serviceComponent, File file) throws ServiceException {
        if (!this._isServiceConfigurationUpdateable) {
            throw new ServiceException(RB.getStringResource("AbstractServiceComponentConfig.updateNotSupported.ex.txt"));
        }
        AbstractServiceComponentConfig.verifyServiceComponentIsNotNull(serviceComponent);
        if (file == null) {
            throw new IllegalArgumentException(RB.getStringResource("AbstractServiceComponentConfig.mustSpecifyFile.ex.txt"));
        }
        this.mergeConfigFromDocument(serviceComponent, this.readServiceConfigFromFile(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document readServiceConfigFromFile(File file) throws ServiceException {
        Document serviceConfiguration;
        block19: {
            serviceConfiguration = null;
            if (file == null) {
                throw new IllegalArgumentException(RB.getStringResource("AbstractServiceComponentConfig.mustSpecifyFile.ex.txt"));
            }
            Exception exception = null;
            FileInputStream fileInputStream = null;
            try {
                String documentElementNodeName;
                fileInputStream = new FileInputStream(file);
                serviceConfiguration = XMLUtil.convertStreamToDocument(fileInputStream);
                Element documentElement = serviceConfiguration.getDocumentElement();
                if (this._xmlDocumentElementName != null && !this._xmlDocumentElementName.equals(documentElementNodeName = documentElement.getNodeName())) {
                    throw new ServiceConfigurationException(Message.format((ResourceBundle)RB.getResources(), (String)"AbstractServiceComponentConfig.invalidXMLDocumentElement.ex.fmt.txt", (Object)file.getName(), (Object)this._xmlDocumentElementName));
                }
            }
            catch (IllegalArgumentException e) {
                exception = e;
                return exception;
            }
            catch (FileNotFoundException e) {
                exception = e;
                return exception;
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        ((InputStream)fileInputStream).close();
                    }
                    catch (IOException e) {
                        AbstractServiceComponentConfig.logIOCloseException(Level.WARN, e);
                    }
                }
                if (exception == null) break block19;
                String cause = exception.getLocalizedMessage();
                if (cause == null) {
                    cause = "";
                }
                throw new ServiceException(exception, Message.format((ResourceBundle)RB.getResources(), (String)"AbstractServiceComponentConfig.unableToReadConfigFromFile.ex.fmt.txt", (Object)file.getName(), (Object)cause));
            }
        }
        return serviceConfiguration;
    }

    public void writeServiceConfigToFile(File file) throws ServiceException {
        AbstractServiceComponentConfig.writeServiceConfigToFile(file, XMLUtil.convertNodeToString((Node)this.toDocument(), AbstractServiceComponentConfig.getOutputFormatProperties()));
    }

    @Override
    public void writeServiceConfigToFile(File file, ServiceComponent serviceComponent) throws ServiceException {
        AbstractServiceComponentConfig.verifyServiceComponentIsNotNull(serviceComponent);
        AbstractServiceComponentConfig.writeServiceConfigToFile(file, this.getServiceComponentConfiguration(serviceComponent));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeServiceConfigToFile(File file, String xmlConfig) throws ServiceException {
        block46: {
            if (file == null) {
                throw new IllegalArgumentException(RB.getStringResource("AbstractServiceComponentConfig.mustSpecifyFile.ex.txt"));
            }
            IOException exception = null;
            FileOutputStream fileOutputStream = null;
            OutputStreamWriter outputStreamWriter = null;
            BufferedWriter bufferedWriter = null;
            try {
                fileOutputStream = new FileOutputStream(file);
                outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, ENCODING);
                bufferedWriter = new BufferedWriter(outputStreamWriter);
                bufferedWriter.write(xmlConfig);
                bufferedWriter.flush();
            }
            catch (FileNotFoundException e) {
                exception = e;
            }
            catch (UnsupportedEncodingException e) {
                exception = e;
            }
            catch (IOException e) {
                exception = e;
            }
            finally {
                if (bufferedWriter != null) {
                    try {
                        bufferedWriter.close();
                    }
                    catch (IOException e) {
                        AbstractServiceComponentConfig.logIOCloseException(Level.ERROR, e);
                    }
                } else if (outputStreamWriter != null) {
                    try {
                        outputStreamWriter.close();
                    }
                    catch (IOException e) {
                        AbstractServiceComponentConfig.logIOCloseException(Level.ERROR, e);
                    }
                } else if (fileOutputStream != null) {
                    try {
                        ((OutputStream)fileOutputStream).close();
                    }
                    catch (IOException e) {
                        AbstractServiceComponentConfig.logIOCloseException(Level.ERROR, e);
                    }
                }
                if (exception == null) break block46;
                String cause = exception.getLocalizedMessage();
                if (cause == null) {
                    cause = "";
                }
                throw new ServiceException(exception, Message.format((ResourceBundle)RB.getResources(), (String)"AbstractServiceComponentConfig.unableToWriteConfigToFile.ex.fmt.txt", (Object)file.getName(), (Object)cause));
            }
        }
    }

    public String getServiceComponentConfiguration(ServiceComponent serviceComponent) throws ServiceException {
        return AbstractServiceComponentConfig.getServiceComponentConfigurationFromTextStore(serviceComponent);
    }

    public static final String getServiceComponentConfigurationFromTextStore(ServiceComponent serviceComponent) throws ServiceException {
        String configuration = "";
        try {
            TextStore serviceConfigTextStore = AbstractServiceComponentConfig.getServiceComponentConfigTextStore(serviceComponent);
            if (serviceConfigTextStore != null && (configuration = serviceConfigTextStore.getStoredText()) != null && configuration.trim().length() > 0) {
                configuration = XMLUtil.convertNodeToString((Node)XMLUtil.convertStringToDocument(configuration), AbstractServiceComponentConfig.getOutputFormatProperties());
            }
        }
        catch (RemoteException e) {
            throw new ServiceException(e);
        }
        return configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final TextStore getServiceComponentConfigTextStore(ServiceComponent serviceComponent) throws ServiceException {
        TextStore serviceConfigTextStore;
        block10: {
            serviceConfigTextStore = null;
            if (serviceComponent == null) {
                throw new IllegalArgumentException();
            }
            Throwable exception = null;
            try {
                String textRole;
                Text configurationText;
                Property property = AbstractServiceComponentConfig.getServiceConfigProperty(serviceComponent);
                if (property != null && (configurationText = property.getStoredConfiguration()) != null && PROPERTYROLE_INITIALIZATION.equals(textRole = configurationText.getTextRole())) {
                    serviceConfigTextStore = (TextStore)configurationText;
                }
            }
            catch (MdException e) {
                exception = e;
                return exception;
            }
            catch (RemoteException e) {
                exception = e;
                return exception;
            }
            finally {
                if (exception == null) break block10;
                throw new ServiceException(exception, RB.getStringResource("AbstractServiceComponentConfig.unableToReadConfigProperty.ex.txt"));
            }
        }
        if (serviceConfigTextStore == null) {
            throw new ServiceException(RB.getStringResource("AbstractServiceComponentConfig.unableToReadConfigProperty.ex.txt"));
        }
        return serviceConfigTextStore;
    }

    public ConsumedResourceAdapter getConsumedResourceAdapter(String resourceID) {
        return this._consumedResourceAdapterMap.get(resourceID);
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractServiceComponentConfig clone = (AbstractServiceComponentConfig)super.clone();
        clone.setConsumerUsage((ConsumerUsage)this._consumerUsage.clone());
        clone.setUsageVersion(new UsageVersion(this._usageVersion.getMajorVersion(), this._usageVersion.getMinorVersion(), this._usageVersion.getMicroVersion()));
        clone.setUsageVersionCompatibility(new UsageVersion(this._usageVersionOldest.getMajorVersion(), this._usageVersionOldest.getMinorVersion(), this._usageVersionOldest.getMicroVersion()), new UsageVersion(this._usageVersionCurrent.getMajorVersion(), this._usageVersionCurrent.getMinorVersion(), this._usageVersionCurrent.getMicroVersion()));
        clone._consumedResourceAdapterMap = new HashMap<String, ConsumedResourceAdapter>(this._consumedResourceAdapterMap.size());
        ConsumedResourceAdapter craClone = null;
        for (ConsumedResourceAdapter cra : this._consumedResourceAdapterMap.values()) {
            craClone = (ConsumedResourceAdapter)cra.clone();
            clone._consumedResourceAdapterMap.put(craClone.getResourceID(), craClone);
        }
        return clone;
    }

    protected static Document getTextStoreServiceConfig(ServiceComponent serviceComponent) throws ServiceException {
        Document serviceConfigDocument = null;
        TextStore serviceConfigTextStore = AbstractServiceComponentConfig.getServiceComponentConfigTextStore(serviceComponent);
        if (serviceConfigTextStore != null) {
            try {
                serviceConfigDocument = XMLUtil.convertStringToDocument(serviceConfigTextStore.getStoredText());
            }
            catch (RemoteException e) {
                throw new ServiceException(e);
            }
            catch (IllegalArgumentException e) {
                throw new ServiceException(e, RB.getStringResource("AbstractServiceComponentConfig.unableToRepresentConfigAsXML.ex.txt"));
            }
        }
        return serviceConfigDocument;
    }

    protected static final void setTextStoreServiceConfig(ServiceComponent serviceComponent, Document serviceConfigDocument) throws ServiceException {
        String validatedData = XMLUtil.convertNodeToString(serviceConfigDocument);
        TextStore serviceConfigTextStore = AbstractServiceComponentConfig.getServiceComponentConfigTextStore(serviceComponent);
        try {
            serviceConfigTextStore.setStoredText(validatedData);
        }
        catch (RemoteException e) {
            throw new ServiceException(e);
        }
    }

    private static final void verifyServiceComponentIsNotNull(ServiceComponent serviceComponent) throws IllegalArgumentException {
        if (serviceComponent == null) {
            throw new IllegalArgumentException(RB.getStringResource("AbstractServiceComponentConfig.mustSpecifyServiceComponent.ex.txt"));
        }
    }

    public UsageVersion getUsageVersion() {
        return this._usageVersion;
    }

    public UsageVersion getUsageVersionCurrent() {
        return this._usageVersionCurrent;
    }

    public UsageVersion getUsageVersionOldest() {
        return this._usageVersionOldest;
    }

    public void setUsageVersion(UsageVersion usageVersion) throws IllegalArgumentException {
        if (usageVersion == null) {
            throw new IllegalArgumentException();
        }
        if (!usageVersion.isCompatible(this._usageVersionOldest, this._usageVersionCurrent)) {
            throw new IllegalArgumentException();
        }
        this._usageVersion = usageVersion;
    }

    protected final void setUsageVersionCompatibility(UsageVersion usageVersionOldest, UsageVersion usageVersionCurrent) throws IllegalArgumentException {
        if (usageVersionOldest == null || usageVersionCurrent == null) {
            throw new IllegalArgumentException();
        }
        if (usageVersionOldest.compareTo((Object)usageVersionCurrent) > 0) {
            throw new IllegalArgumentException();
        }
        this._usageVersionOldest = usageVersionOldest;
        this._usageVersionCurrent = usageVersionCurrent;
    }

    public String getConfirmDeleteUnusedResourcesMsg() {
        return RB.getStringResource("AbstractServiceComponentConfig.confirmRemovalUnusedResources.txt");
    }

    public String getConfirmDeleteUnusedResourceMsg(ConsumedResourceInterface consumedResource) {
        return Message.format((ResourceBundle)RB.getResources(), (String)"AbstractServiceComponentConfig.confirmRemovalUnusedResource.fmt.txt", (Object)consumedResource.getLocalizedResourceType(), (Object)consumedResource.getResourceValue());
    }

    protected int getPrimeNumber() {
        return 31;
    }

    public Document toDocument() throws ServiceException {
        Document document = this.getDocument();
        try {
            this.appendDOM(document);
            this.appendConsumerUsageToDOM(document);
        }
        catch (DOMException e) {
            throw new ServiceException(e, RB.getStringResource("AbstractServiceComponentConfig.toDocument.ex.txt"));
        }
        return document;
    }

    private void appendConsumerUsageToDOM(Document document) {
        if (this._consumerUsage != null) {
            this._consumerUsage.validate();
            Element element = this._consumerUsage.createElement(document);
            if (element != null) {
                document.getDocumentElement().appendChild(element);
            }
        }
    }

    public String toXMLString() throws ServiceException {
        Document document = this.toDocument();
        return document == null ? null : XMLUtil.convertNodeToString((Node)document, AbstractServiceComponentConfig.getOutputFormatProperties());
    }

    protected abstract DocumentFragment appendDOM(Document var1) throws ServiceException;

    public void parseConsumerUsage(Element element) {
        if (element == null || !"ConsumerUsage".equals(element.getNodeName())) {
            throw new IllegalArgumentException();
        }
        this._consumerUsage.configureUsingElement(element);
    }

    public ConsumerUsage getConsumerUsage() {
        return this._consumerUsage;
    }

    public void setConsumerUsage(ConsumerUsage consumerUsage) {
        this._consumerUsage = consumerUsage;
    }

    public Consumer addConsumer(Consumer consumer, boolean isConsumer) {
        return this._consumerUsage.addConsumer(consumer, isConsumer);
    }

    public Consumer removeConsumer(Consumer consumer, boolean isRemoveResourceIfUnused) throws ServiceException {
        Consumer removedConsumer = null;
        HashSet<ConsumedResourceInterface> removedConsumedResources = new HashSet<ConsumedResourceInterface>(5);
        if (consumer != null) {
            removedConsumer = this._consumerUsage.removeConsumer(consumer);
            if (isRemoveResourceIfUnused) {
                for (ConsumedResourceInterface consumedResource : this.getUnusedResources(new HashSet<String>(0))) {
                    String nextResourceID = consumedResource.getResourceID();
                    if (consumedResource.isRequired() || this.getConsumersForResource(nextResourceID).size() != 0) continue;
                    this.removeResource(nextResourceID, removedConsumedResources);
                }
            }
        }
        return removedConsumer;
    }

    public void removeConsumer(ServiceComponent serviceComponent) throws ServiceException {
    }

    public Set<ConsumedResourceInterface> getUnusedResources(Set<String> removedConsumerNames) {
        HashSet<ConsumedResourceInterface> unusedConsumedResources = new HashSet<ConsumedResourceInterface>(5);
        ConsumerUsage consumerUsage = this.getConsumerUsage();
        HashSet<String> removedConsumerIDs = new HashSet<String>(removedConsumerNames.size());
        for (String consumerName : removedConsumerNames) {
            Consumer consumer = consumerUsage.getConsumerUsingName(consumerName);
            if (consumer == null) continue;
            removedConsumerIDs.add(consumer.getID());
        }
        HashSet<String> usedResourceIDs = new HashSet<String>(25);
        for (ConsumerResourceAssoc consumerResourceAssoc : consumerUsage.getConsumerResourceAssocs()) {
            if (!consumerResourceAssoc.isConsumer() || removedConsumerIDs.contains(consumerResourceAssoc.getConsumerID())) continue;
            usedResourceIDs.add(consumerResourceAssoc.getResourceID());
        }
        for (ConsumedResourceInterface consumedResource : consumerUsage.getConsumedResources()) {
            if (usedResourceIDs.contains(consumedResource.getResourceID())) continue;
            unusedConsumedResources.add(consumedResource);
        }
        return unusedConsumedResources;
    }

    protected boolean isOKToRemoveResource(String resourceID) {
        return true;
    }

    protected final Set<String> getConsumersForResource(String resourceID) {
        HashSet<String> consumers = new HashSet<String>(this._consumerUsage.getConsumers().size());
        for (ConsumerResourceAssoc consumerResourceAssoc : this._consumerUsage.getConsumerResourceAssocsForResourceID(resourceID)) {
            if (!consumerResourceAssoc.isConsumer()) continue;
            consumers.add(this._consumerUsage.getConsumerUsingUID(consumerResourceAssoc.getConsumerID()).getName());
        }
        return consumers;
    }

    public void setIsConsumer(Consumer consumer, boolean isConsumer) {
        this._consumerUsage.setIsConsumer(consumer, isConsumer);
    }

    protected void addResourceAdapter(ConsumedResourceAdapter consumedResource) {
        this._consumedResourceAdapterMap.put(consumedResource.getResourceID(), consumedResource);
        this.addResource(consumedResource);
    }

    protected ConsumedResourceInterface removeResourceAdapter(ConsumedResourceAdapter consumedResource, Set<ConsumedResourceInterface> removedConsumedResources) throws ServiceException {
        ConsumedResourceInterface removedConsumedResource = null;
        String resourceID = consumedResource.getResourceID();
        removedConsumedResource = this._consumedResourceAdapterMap.remove(resourceID);
        this.removeResource(resourceID, removedConsumedResources);
        return removedConsumedResource;
    }

    protected void addResource(ConsumedResourceInterface consumedResource) {
        this._consumerUsage.addResource(consumedResource);
    }

    public ConsumedResourceInterface removeResource(String resourceID, Set<ConsumedResourceInterface> removedConsumedResourceSet) throws ServiceException {
        return this.removeConsumedResource(resourceID);
    }

    protected ConsumedResourceInterface removeConsumedResource(String resourceID) {
        return this._consumerUsage.removeResource(resourceID);
    }

    public Set<ConsumedResourceInterface> getResourcesWhichUseResource(Set<ConsumedResourceInterface> consumedResources) {
        return Collections.emptySet();
    }

    private static final void logIOCloseException(Level level, Throwable throwable) {
        LogManager.getLogger(AbstractServiceComponentConfig.class).log(level, RB.getStringResource("IO.close.ex.txt"), throwable);
    }

    public MergePolicy getDefaultMergePolicy() {
        return new MergePolicyAdd();
    }
}

