/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.xml.data;

import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.util.DynamicDoubleArray;
import com.sas.graphics.xml.GraphParser;
import com.sas.graphics.xml.GraphParserFactory;
import com.sas.graphics.xml.data.DataValueParserInterface;
import com.sas.sg.datamodel.impl.SgDataModel;
import com.sas.text.SASFormat;
import java.io.CharArrayWriter;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.DefaultHandler;

public class DataHandler
extends DefaultHandler {
    private Hashtable context = null;
    SgDataModel model = null;
    Vector variables = new Vector();
    int numVars = 0;
    int numObs = 0;
    int current = 0;
    String id = null;
    CharArrayWriter content = new CharArrayWriter();
    ResourceBundle rb = ResourceLoader.loadBundle("com.sas.graphics.xml.data.graph_xml_data_NLS");
    DataValueParserInterface valueParser = null;

    public DataHandler(Hashtable context) {
        this.context = context;
        this.model = new SgDataModel();
    }

    public static void parse(Hashtable context, String xml) {
        if (xml == null) {
            return;
        }
        DataHandler handler = new DataHandler(context);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            factory.setFeature("http://apache.org/xml/features/allow-java-encodings", true);
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(new InputSource(new StringReader(xml)), (DefaultHandler)handler);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
        if (this.valueParser != null) {
            this.valueParser.characters(buf, offset, len);
        } else {
            this.content.write(buf, offset, len);
        }
    }

    @Override
    public void endElement(String namespaceURI, String sName, String name) throws SAXException {
        if (name.equalsIgnoreCase("V") || name.equalsIgnoreCase("Value")) {
            if (name.equalsIgnoreCase("V")) {
                if (this.current >= this.numVars) {
                    this.current = 0;
                }
                if (this.current == 0) {
                    ++this.numObs;
                }
            }
            if (this.current >= this.numVars) {
                return;
            }
            String type = this.model.getVarType(this.current);
            if (type == "Numeric Variable") {
                double val = Double.NaN;
                try {
                    val = Double.parseDouble(this.content.toString());
                }
                catch (Exception e) {
                    val = Double.NaN;
                }
                ((DynamicDoubleArray)this.variables.elementAt(this.current)).add(val);
            } else if (type == "Generic Object Variable") {
                Object val = null;
                val = this.valueParser != null ? this.valueParser.getDataValue() : new Double(Double.NaN);
                ((Vector)this.variables.elementAt(this.current)).addElement(val);
            } else {
                String val = this.content.toString();
                if (val == null) {
                    val = "";
                }
                ((Vector)this.variables.elementAt(this.current)).addElement(val);
            }
            this.valueParser = null;
            ++this.current;
        } else if (name.equalsIgnoreCase("Row")) {
            StringTokenizer tokenizer = new StringTokenizer(this.content.toString().trim(), "\"");
            int counter = -1;
            while (tokenizer.hasMoreTokens()) {
                String type;
                String token = tokenizer.nextToken().trim();
                if (++counter % 2 == 1) {
                    if (token.length() == 0) continue;
                    ++counter;
                }
                if ((type = this.model.getVarType(this.current)) == "Numeric Variable") {
                    double val = Double.NaN;
                    try {
                        val = Double.parseDouble(token);
                    }
                    catch (Exception e) {
                        val = Double.NaN;
                    }
                    ((DynamicDoubleArray)this.variables.elementAt(this.current)).add(val);
                } else {
                    String val = token;
                    if (val == null) {
                        val = "";
                    }
                    ((Vector)this.variables.elementAt(this.current)).addElement(val);
                }
                ++this.current;
            }
            ++this.numObs;
        } else if (name.equalsIgnoreCase("Values")) {
            ++this.numObs;
        } else if (name.equalsIgnoreCase("IQData") && this.numObs > 0) {
            this.model.addObs(0, this.numObs);
            for (int i = 0; i < this.variables.size(); ++i) {
                Object obj = this.variables.elementAt(i);
                if (obj instanceof DynamicDoubleArray) {
                    DynamicDoubleArray dda = (DynamicDoubleArray)obj;
                    this.model.setValue(i, 0, Math.min(this.numObs - 1, dda.getNumberElements() - 1), dda.getElements());
                    continue;
                }
                Vector v = (Vector)obj;
                this.model.setValue(i, 0, Math.min(this.numObs - 1, v.size() - 1), v.toArray());
            }
            this.variables.clear();
        } else if (this.valueParser != null) {
            this.valueParser.endElement(name);
        }
    }

    @Override
    public void startElement(String namespaceURI, String lName, String name, Attributes attrs) throws SAXException {
        this.content.reset();
        if (name.equalsIgnoreCase("V") || name.equalsIgnoreCase("Value")) {
            return;
        }
        if (name.equals("IQData")) {
            this.model = new SgDataModel();
            this.numVars = 0;
            this.numObs = 0;
            this.current = 0;
            this.id = attrs.getValue("name");
            if (this.id == null) {
                throw new SAXException(ResourceLoader.getResourceString(this.rb, "DataHandler.No_name_provided_for_IQData.txt", "No name provided for IQData"));
            }
            this.context.put(this.id, this.model);
            this.variables.clear();
            GraphParser.addData(this.context, this.id);
        } else if (name.equalsIgnoreCase("Variable")) {
            String id = attrs.getValue("name");
            String label = attrs.getValue("label");
            String type = attrs.getValue("type");
            String formatString = attrs.getValue("sasFormat");
            if (formatString == null || formatString.length() == 0) {
                formatString = attrs.getValue("SASFormat");
            }
            if (id == null || type == null) {
                throw new SAXException(ResourceLoader.getResourceString(this.rb, "DataHandler.Error__Variable_must_have_varName_and_type.txt", "Error: Variable must have varName and type"));
            }
            int obsCount = 1000;
            String valuesCount = attrs.getValue("valuesCount");
            if (valuesCount != null && valuesCount.trim().length() > 0) {
                obsCount = Integer.parseInt(valuesCount);
            }
            String typ = "";
            if (type.equalsIgnoreCase("numeric")) {
                typ = "Numeric Variable";
                this.variables.addElement(new DynamicDoubleArray(obsCount));
            } else if (type.equalsIgnoreCase("object")) {
                typ = "Generic Object Variable";
                this.variables.addElement(new Vector(obsCount));
            } else {
                typ = "Charater Variable";
                this.variables.addElement(new Vector(obsCount));
            }
            SASFormat format = null;
            if (formatString != null && formatString.trim().length() > 0 && formatString.compareTo("NONE") != 0) {
                format = SASFormat.getInstance((String)formatString);
            }
            this.model.addVars(this.numVars, 1, typ);
            this.model.setVarName(this.numVars, id);
            this.model.setVarLabel(this.numVars, label);
            if (format != null) {
                this.model.setVarFormat(this.numVars, (Object)format);
            }
            ++this.numVars;
        } else if (name.equalsIgnoreCase("Values")) {
            this.current = 0;
        } else if (name.equalsIgnoreCase("Row")) {
            this.current = 0;
        } else if (this.valueParser != null) {
            this.valueParser.startElement(name, attrs);
        } else {
            DataValueParserInterface parser = GraphParserFactory.loadDataValueParser(name);
            if (parser != null) {
                this.valueParser = parser;
                this.valueParser.init(this.context);
                this.valueParser.startElement(name, attrs);
            }
        }
    }
}

