/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.ods.data;

import com.sas.MissingValues;
import com.sas.graphics.util.ods.data.DataVariableInterface;
import com.sas.graphics.util.ods.data.VariableAttributes;
import com.sas.text.SASCharacterFormat;
import com.sas.text.SASFormat;
import java.util.Locale;
import java.util.Vector;

public class BaseDataVariable
implements DataVariableInterface {
    private final int isVector = 0;
    private final int isdouble = 1;
    private final int isDouble = 2;
    private final int isString = 3;
    protected Object min;
    protected Object max;
    protected Vector values;
    protected Locale locale;
    protected SASFormat bestFmt = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseDataVariable(Locale localeIn, Class typeIn, String nameIn, String descIn, Object dataIn) {
        this.locale = localeIn;
        BaseDataVariable baseDataVariable = this;
        synchronized (baseDataVariable) {
            if (this.bestFmt == null) {
                this.bestFmt = this.locale == null ? SASFormat.getInstance((String)"BEST") : SASFormat.getInstance((String)"BEST", (Locale)this.locale);
            }
        }
        this.values = this.CreateVariableVector(typeIn, nameIn, descIn);
        if (this.values != null && dataIn != null) {
            this.UpdateData(dataIn);
        }
    }

    public BaseDataVariable(Locale localeIn, Class typeIn, String nameIn, String descIn) {
        this(localeIn, typeIn, nameIn, descIn, null);
    }

    public BaseDataVariable(Locale localeIn, Class typeIn, String nameIn) {
        this(localeIn, typeIn, nameIn, nameIn, null);
    }

    public BaseDataVariable(Locale localeIn, String nameIn) {
        this(localeIn, null, nameIn, nameIn, null);
    }

    public BaseDataVariable(Locale localeIn) {
        this(localeIn, null, null, null, null);
    }

    public BaseDataVariable() {
        this(null, null, null, null, null);
    }

    protected Vector CreateVariableVector(Class typeIn, String nameIn, String descIn) {
        Vector<VariableAttributes> v = null;
        VariableAttributes va = null;
        va = new VariableAttributes(typeIn, nameIn, descIn);
        if (va == null) {
            return null;
        }
        v = new Vector<VariableAttributes>();
        if (v == null) {
            return null;
        }
        v.addElement(va);
        return v;
    }

    protected boolean isMissingValue(Object o, boolean countNullAsMissing) {
        if (o == null) {
            return countNullAsMissing;
        }
        return o instanceof MissingValues || o instanceof Double && ((Double)o).isNaN();
    }

    protected VariableAttributes GetAttributes(Vector vec) {
        Object o = null;
        VariableAttributes va = null;
        if (vec != null && vec.size() > 0) {
            o = vec.elementAt(0);
        }
        if (o != null && o instanceof VariableAttributes) {
            va = o;
        }
        return va;
    }

    protected Class GetObjectClass(Vector vec) {
        VariableAttributes va = this.GetAttributes(vec);
        if (va == null) {
            return null;
        }
        return va.objClass;
    }

    protected boolean SetObjectClass(Vector vec, Object objIn) {
        VariableAttributes va = this.GetAttributes(vec);
        if (va == null || objIn == null) {
            return false;
        }
        va.objClass = objIn instanceof MissingValues ? Double.class : objIn.getClass();
        return true;
    }

    protected String GetName(Vector vec) {
        VariableAttributes va = this.GetAttributes(vec);
        if (va == null) {
            return null;
        }
        return va.name;
    }

    protected boolean SetName(Vector vec, String newName) {
        VariableAttributes va = this.GetAttributes(vec);
        if (va == null) {
            return false;
        }
        va.name = newName;
        return true;
    }

    protected String GetDescription(Vector vec) {
        VariableAttributes va = this.GetAttributes(vec);
        if (va == null) {
            return null;
        }
        return va.description;
    }

    protected boolean SetDescription(Vector vec, String newDesc) {
        VariableAttributes va = this.GetAttributes(vec);
        if (va == null) {
            return false;
        }
        va.description = newDesc;
        return true;
    }

    protected int GetNumberMissing(Vector vec) {
        VariableAttributes va = this.GetAttributes(vec);
        if (va == null) {
            return 0;
        }
        return va.nmiss;
    }

    protected boolean SetNumberMissing(Vector vec, int n) {
        VariableAttributes va = this.GetAttributes(vec);
        if (va == null || n < 0) {
            return false;
        }
        va.nmiss = n;
        return true;
    }

    protected int GetNumberValues(Vector v) {
        if (v == null || v.size() < 2) {
            return 0;
        }
        return v.size() - 1;
    }

    protected Object GetValue(Vector vec, int idx) {
        if (vec == null || idx < 0 || idx >= vec.size() - 1) {
            return null;
        }
        return vec.elementAt(idx + 1);
    }

    protected boolean SetValue(Vector vec, int idx, Object newValue) {
        boolean oldIsMissing = false;
        boolean newIsMissing = false;
        Object oldValue = null;
        Class objClass = this.GetObjectClass(vec);
        if (vec == null || newValue == null) {
            return false;
        }
        if (objClass == null) {
            objClass = newValue instanceof MissingValues ? Double.class : newValue.getClass();
        }
        if (objClass == Double.class ? !(newValue instanceof MissingValues) && newValue.getClass() != Double.class : newValue.getClass() != objClass) {
            return false;
        }
        if (newValue instanceof MissingValues) {
            newIsMissing = true;
        } else if (newValue instanceof Double && ((Double)newValue).isNaN()) {
            newIsMissing = true;
        }
        if (idx >= 0 && idx < this.GetNumberValues(vec)) {
            oldValue = this.GetValue(vec, idx);
        }
        oldIsMissing = this.isMissingValue(oldValue, false);
        if (idx < 0) {
            vec.addElement(newValue);
        } else {
            if (idx >= this.GetNumberValues(vec)) {
                return false;
            }
            vec.setElementAt(newValue, idx + 1);
        }
        if (!oldIsMissing && newIsMissing) {
            this.SetNumberMissing(vec, this.GetNumberMissing(vec) + 1);
        } else if (oldIsMissing && !newIsMissing) {
            this.SetNumberMissing(vec, this.GetNumberMissing(vec) - 1);
        }
        if (!newIsMissing) {
            if (this.isMissingValue(this.min, true)) {
                this.min = newValue;
            } else if (newValue instanceof Double && (Double)newValue < (Double)this.min) {
                this.min = newValue;
            } else if (newValue instanceof String && ((String)newValue).compareTo((String)this.min) < 0) {
                this.min = newValue;
            }
            if (this.isMissingValue(this.max, true)) {
                this.max = newValue;
            } else if (newValue instanceof Double && (Double)newValue > (Double)this.max) {
                this.max = newValue;
            } else if (newValue instanceof String && ((String)newValue).compareTo((String)this.max) > 0) {
                this.max = newValue;
            }
        }
        return true;
    }

    protected boolean DeleteValue(Vector vec, int idx) {
        boolean oldIsMissing = false;
        Object oldValue = null;
        if (vec == null || idx < 0 || idx >= this.GetNumberValues(vec)) {
            return false;
        }
        oldValue = this.GetValue(vec, idx);
        oldIsMissing = this.isMissingValue(oldValue, false);
        vec.removeElementAt(idx + 1);
        if (oldIsMissing) {
            this.SetNumberMissing(vec, this.GetNumberMissing(vec) - 1);
        }
        return true;
    }

    protected String GetFormat(Vector vec) {
        VariableAttributes va = this.GetAttributes(vec);
        if (va == null || va.format == null) {
            return null;
        }
        return va.format.getName();
    }

    protected boolean SetFormat(Vector vec, String name) {
        SASFormat fmt = null;
        VariableAttributes va = this.GetAttributes(vec);
        if (va == null || va.objClass == null) {
            return false;
        }
        if (name == null) {
            va.format = null;
            return true;
        }
        fmt = this.locale != null ? SASFormat.getInstance((String)name, (Locale)this.locale) : SASFormat.getInstance((String)name);
        if (fmt == null) {
            return false;
        }
        if (va.objClass == String.class && !(fmt instanceof SASCharacterFormat) || va.objClass != String.class && fmt instanceof SASCharacterFormat) {
            return false;
        }
        va.format = fmt;
        return true;
    }

    @Override
    public String GetName() {
        return this.GetName(this.values);
    }

    @Override
    public boolean SetName(String newName) {
        return this.SetName(this.values, newName);
    }

    @Override
    public String GetDescription() {
        return this.GetDescription(this.values);
    }

    @Override
    public boolean SetDescription(String newDesc) {
        return this.SetDescription(this.values, newDesc);
    }

    @Override
    public int GetNumberMissing() {
        return this.GetNumberMissing(this.values);
    }

    @Override
    public Class GetObjectClass() {
        return this.GetObjectClass(this.values);
    }

    @Override
    public int GetNumberValues() {
        return this.GetNumberValues(this.values);
    }

    @Override
    public Object GetValue(int idx) {
        return this.GetValue(this.values, idx);
    }

    @Override
    public boolean SetValue(int idx, Object newValue) {
        return this.SetValue(this.values, idx, newValue);
    }

    @Override
    public Object GetMinimumValue() {
        return this.min;
    }

    @Override
    public Object GetMaximumValue() {
        return this.max;
    }

    @Override
    public boolean DeleteValue(int idx) {
        return this.DeleteValue(this.values, idx);
    }

    @Override
    public String GetFormat() {
        return this.GetFormat(this.values);
    }

    @Override
    public boolean SetFormat(String name) {
        return this.SetFormat(this.values, name);
    }

    @Override
    public String GetFormattedValue(Object rawValue) {
        String result = null;
        VariableAttributes va = this.GetAttributes(this.values);
        if (rawValue == null) {
            return null;
        }
        result = va == null ? rawValue.toString() : (va.format == null ? (va.objClass == String.class ? (String)rawValue : (this.bestFmt != null ? this.bestFmt.format(rawValue) : rawValue.toString())) : va.format.format(rawValue));
        return result;
    }

    @Override
    public boolean UpdateData(Object dataIn) {
        int count;
        int inType;
        boolean allTypesOK = true;
        Object o = null;
        if (dataIn == null) {
            inType = 0;
            count = 0;
        } else if (dataIn instanceof Vector) {
            inType = 0;
            count = ((Vector)dataIn).size();
        } else if (dataIn instanceof double[]) {
            inType = 1;
            count = ((double[])dataIn).length;
        } else if (dataIn instanceof Double[]) {
            inType = 2;
            count = ((Double[])dataIn).length;
        } else if (dataIn instanceof String[]) {
            inType = 3;
            count = ((String[])dataIn).length;
        } else {
            return false;
        }
        Vector d = this.CreateVariableVector(this.GetObjectClass(), this.GetName(), this.GetDescription());
        if (d == null) {
            return false;
        }
        this.max = null;
        this.min = null;
        for (int i = 0; i < count; ++i) {
            switch (inType) {
                case 0: {
                    o = ((Vector)dataIn).elementAt(i);
                    break;
                }
                case 1: {
                    o = new Double(((double[])dataIn)[i]);
                    break;
                }
                case 2: {
                    o = ((Double[])dataIn)[i];
                    break;
                }
                case 3: {
                    o = ((String[])dataIn)[i];
                }
            }
            if (o == null) {
                return false;
            }
            if (this.SetValue(d, -1, o)) continue;
            return false;
        }
        this.values = d;
        return true;
    }
}

