/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util;

import com.sas.graphics.util.CompareInterface;
import com.sas.graphics.util.DynamicIntArray;
import com.sas.graphics.util.Search;
import com.sas.graphics.util.Sort;
import com.sas.graphics.util.SortKeyInterface;
import java.util.Collection;
import java.util.List;
import java.util.Vector;

public class SortedVector
implements CompareInterface {
    protected boolean keyInterface;
    protected boolean inSortedOrder;
    protected boolean allowDuplicates;
    protected boolean isChar;
    protected boolean sortingOn;
    protected boolean sorted;
    protected DynamicIntArray sortIndicies;
    protected Vector dataValues;

    public SortedVector(int initialCapacity, boolean keepDuplicates) {
        this.init(initialCapacity, keepDuplicates, null);
    }

    public SortedVector(int initialCapacity) {
        this(initialCapacity, false);
    }

    public SortedVector(boolean keepDuplicates) {
        this(0, keepDuplicates);
    }

    public SortedVector() {
        this(0, false);
    }

    public SortedVector(Collection c) {
        int ic = 0;
        if (c != null) {
            ic = c.size();
        }
        this.init(ic, false, c);
        if (ic > 0 && this.sortingOn) {
            this.sorted = Sort.heapsort(this.isChar ? String.class : Double.class, (List)this.dataValues, this.sortIndicies.getElements(), -1, (CompareInterface)this);
        }
    }

    protected void init(int initialCapacity, boolean keepDuplicates, Collection c) {
        this.keyInterface = false;
        this.inSortedOrder = true;
        this.sortingOn = true;
        this.sorted = true;
        this.allowDuplicates = keepDuplicates;
        this.isChar = false;
        this.sortIndicies = new DynamicIntArray(initialCapacity);
        if (c != null) {
            this.dataValues = new Vector(c);
            this.sortIndicies.setSequential(c.size());
        } else {
            this.dataValues = new Vector(initialCapacity);
        }
    }

    public boolean keepDuplicates() {
        return this.allowDuplicates;
    }

    public boolean setKeepDuplicates(boolean keepem) {
        if (this.size() > 0) {
            return false;
        }
        this.allowDuplicates = keepem;
        return true;
    }

    public boolean isRetrieveInSortedOrder() {
        return this.inSortedOrder;
    }

    public void setRetrieveInSortedOrder(boolean sortedGet) {
        this.inSortedOrder = sortedGet;
    }

    public boolean isSortingOn() {
        return this.sortingOn;
    }

    public void setSortingOn(boolean on) {
        this.sortingOn = on;
        if (this.sortingOn && !this.sorted) {
            this.sorted = Sort.heapsort(this.isChar ? String.class : Double.class, (List)this.dataValues, this.sortIndicies.getElements(), -1, (CompareInterface)this);
        }
    }

    protected int intValue(Vector v, int idx) {
        return (Integer)v.elementAt(idx);
    }

    protected void setup(Object obj) {
        if (obj == null) {
            this.keyInterface = false;
            this.isChar = false;
        } else if (obj instanceof SortKeyInterface) {
            this.keyInterface = true;
            this.isChar = ((SortKeyInterface)obj).getKeyType() == 1;
        } else if (obj instanceof String) {
            this.keyInterface = false;
            this.isChar = true;
        } else {
            this.keyInterface = false;
            this.isChar = false;
        }
        this.sorted = true;
    }

    protected Object getKey(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof SortKeyInterface) {
            return ((SortKeyInterface)obj).getKeyValue();
        }
        return obj;
    }

    protected synchronized boolean addIt(int idx, Object obj) {
        Object key = this.getKey(obj);
        if (key == null || !(key instanceof Number) && !(key instanceof String)) {
            return false;
        }
        if (this.dataValues == null || this.sortIndicies == null) {
            return false;
        }
        if (this.dataValues.size() <= 0) {
            this.setup(obj);
        }
        if (!this.isChar && key instanceof String || this.isChar && key instanceof Number) {
            return false;
        }
        if (!this.allowDuplicates && this.contains(obj)) {
            return true;
        }
        int curSize = this.size();
        if (idx < 0 || idx >= curSize) {
            this.dataValues.addElement(obj);
            this.sortIndicies.add(curSize);
        } else {
            this.dataValues.insertElementAt(obj, idx);
            this.sortIndicies.insertAt(curSize, idx);
        }
        if (this.sortingOn) {
            Sort.heapsort(this.isChar ? String.class : Double.class, (List)this.dataValues, this.sortIndicies.getElements(), -1, (CompareInterface)this);
        } else {
            this.sorted = false;
        }
        return true;
    }

    protected boolean delIt(int idx) {
        int n;
        if (idx < 0 || idx >= (n = this.size())) {
            return false;
        }
        int delIndex = this.sortIndicies.get(idx);
        this.dataValues.removeElementAt(idx);
        this.sortIndicies.removeAt(idx);
        for (int i = 0; i < n - 1; ++i) {
            int itmp = this.sortIndicies.get(i);
            if (itmp < delIndex) continue;
            this.sortIndicies.setAt(itmp - 1, i);
        }
        return true;
    }

    public synchronized void copyIndiciesInto(int[] anArray) {
        int maxlen = 0;
        if (this.sortIndicies == null || anArray == null) {
            return;
        }
        maxlen = this.size();
        if (anArray.length < maxlen) {
            maxlen = anArray.length;
        }
        for (int i = 0; i < maxlen; ++i) {
            anArray[i] = this.sortIndicies.get(i);
        }
    }

    public synchronized void copyIndiciesInto(Object[] anArray) {
        int maxlen = 0;
        if (this.sortIndicies == null || anArray == null) {
            return;
        }
        maxlen = this.size();
        if (anArray.length < maxlen) {
            maxlen = anArray.length;
        }
        for (int i = 0; i < maxlen; ++i) {
            anArray[i] = new Integer(this.sortIndicies.get(i));
        }
    }

    public synchronized int sortIndexAt(int index) {
        if (this.sortIndicies == null || index < 0 || index >= this.sortIndicies.getNumberElements()) {
            return -1;
        }
        return this.sortIndicies.get(index);
    }

    public synchronized void addElement(Object obj) {
        this.addIt(-1, obj);
    }

    public boolean contains(Object elem) {
        int n = 0;
        Object key = this.getKey(elem);
        if (this.dataValues == null || this.sortIndicies == null || elem == null) {
            return false;
        }
        if (this.sorted) {
            return Search.binarylookup(key, this.dataValues, this.sortIndicies.getElements(), false, -1, (CompareInterface)this) >= 0;
        }
        if (!this.keyInterface) {
            return this.dataValues.contains(elem);
        }
        n = this.dataValues.size();
        for (int i = 0; i < n; ++i) {
            Object objKey = this.getKey(this.dataValues.elementAt(i));
            if (objKey == null || !key.equals(objKey)) continue;
            return true;
        }
        return false;
    }

    public synchronized void copyInto(Object[] anArray) {
        int maxlen = 0;
        if (!this.inSortedOrder && this.dataValues != null && anArray != null) {
            this.dataValues.copyInto(anArray);
        } else if (this.inSortedOrder && this.dataValues != null && this.sortIndicies != null && anArray != null) {
            maxlen = this.size();
            if (anArray.length < maxlen) {
                maxlen = anArray.length;
            }
            for (int i = 0; i < maxlen; ++i) {
                anArray[i] = this.dataValues.elementAt(this.sortIndicies.get(i));
            }
        }
    }

    public synchronized Object elementAt(int index) {
        if (index < 0 || index >= this.size()) {
            return null;
        }
        if (!this.inSortedOrder) {
            return this.dataValues.elementAt(index);
        }
        return this.dataValues.elementAt(this.sortIndicies.get(index));
    }

    public synchronized Object firstElement() {
        if (this.dataValues == null || this.sortIndicies == null) {
            return null;
        }
        if (!this.inSortedOrder) {
            return this.dataValues.firstElement();
        }
        return this.dataValues.elementAt(this.sortIndicies.get(0));
    }

    public synchronized void insertElementAt(Object obj, int index) {
        this.addIt(index, obj);
    }

    public final int indexOf(Object elem) {
        boolean loop = true;
        Object key = this.getKey(elem);
        if (this.dataValues == null || this.sortIndicies == null || elem == null) {
            return -1;
        }
        int idx = Search.binarylookup(key, this.dataValues, this.sortIndicies.getElements(), false, -1, (CompareInterface)this);
        if (idx < 0) {
            return -1;
        }
        if (this.allowDuplicates && idx > 0) {
            while (loop) {
                if (idx > 0 && elem.equals(this.dataValues.elementAt(this.sortIndicies.get(idx - 1)))) {
                    --idx;
                    continue;
                }
                loop = false;
            }
        }
        return this.sortIndicies.get(idx);
    }

    public boolean isEmpty() {
        if (this.dataValues == null) {
            return true;
        }
        return this.dataValues.isEmpty();
    }

    public synchronized Object lastElement() {
        if (this.dataValues == null || this.sortIndicies == null) {
            return null;
        }
        if (!this.inSortedOrder) {
            return this.dataValues.lastElement();
        }
        return this.dataValues.elementAt(this.sortIndicies.get(this.sortIndicies.getNumberElements() - 1));
    }

    public int lastIndexOf(Object elem) {
        boolean loop = true;
        if (this.dataValues == null || this.sortIndicies == null || elem == null) {
            return -1;
        }
        int idx = Search.binarylookup(elem, this.dataValues, this.sortIndicies.getElements(), false, -1, (CompareInterface)this);
        if (idx < 0) {
            return -1;
        }
        int n = this.size();
        if (this.allowDuplicates && idx < n - 1) {
            while (loop) {
                if (idx > n - 1 && elem.equals(this.dataValues.elementAt(this.sortIndicies.get(idx + 1)))) {
                    ++idx;
                    continue;
                }
                loop = false;
            }
        }
        return this.sortIndicies.get(idx);
    }

    public synchronized void removeAllElements() {
        if (this.dataValues != null) {
            this.dataValues.removeAllElements();
        }
        if (this.sortIndicies != null) {
            this.sortIndicies.removeAll();
        }
        this.sorted = true;
    }

    public synchronized boolean removeElement(Object obj) {
        boolean saveOrder = this.inSortedOrder;
        this.inSortedOrder = false;
        int idx = this.indexOf(obj);
        this.inSortedOrder = saveOrder;
        if (idx < 0) {
            return false;
        }
        return this.delIt(idx);
    }

    public synchronized void removeElementAt(int index) {
        this.delIt(index);
    }

    public synchronized void setElementAt(Object obj, int index) {
        if (index < 0 || index >= this.size()) {
            return;
        }
        this.dataValues.setElementAt(obj, index);
        if (this.sortingOn) {
            Sort.heapsort(this.isChar ? String.class : Double.class, (List)this.dataValues, this.sortIndicies.getElements(), -1, (CompareInterface)this);
        } else {
            this.sorted = false;
        }
    }

    public int size() {
        if (this.dataValues == null || this.sortIndicies == null) {
            return 0;
        }
        int s = this.dataValues.size();
        if (this.sortIndicies.getNumberElements() < s) {
            s = this.sortIndicies.getNumberElements();
        }
        return s;
    }

    public Object[] getValues() {
        int n = this.size();
        if (n <= 0) {
            return null;
        }
        Object[] out = new Object[n];
        if (out == null) {
            return null;
        }
        this.copyInto(out);
        return out;
    }

    public Object[] toArray() {
        return this.getValues();
    }

    @Override
    public double getNumericElement(Object entry) {
        if (this.keyInterface) {
            return ((SortKeyInterface)entry).getNumericKeyValue();
        }
        return ((Number)entry).doubleValue();
    }

    @Override
    public String getStringElement(Object entry) {
        if (this.keyInterface) {
            return (String)((SortKeyInterface)entry).getKeyValue();
        }
        return (String)entry;
    }
}

