/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util;

import com.sas.graphics.data.sort.SortContextFactory;
import com.sas.graphics.silk.util.FilterFactory;
import com.sas.text.SASCharacterFormat;
import com.sas.text.SASDateTimeFormat;
import com.sas.text.SASFormat;
import com.sas.text.SASNumericFormat;
import com.sas.text.SASUserDefinedFormat;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.lang.reflect.Field;

public class GraphUtilities {
    public static final int NO_TYPE = -1;
    public static final int TIME = 0;
    public static final int DATE = 1;
    public static final int DATE_TIME = 2;
    public static final int NUMERIC = 3;
    public static final int CHARACHTER = 4;
    public static final int USER_DEFINED = 5;
    private static final String[] TIME_FORMATS = new String[]{"HHMM", "HOUR", "MMSS", "TIME", "TIMEAMPM", "NLTIME", "NLTIMAP"};
    private static final String[] DATE_TIME_FORMATS = new String[]{"DATETIME", "DATEAMPM", "TOD", "DTDATE", "DTMONYY", "DTWKDATX", "DTYEAR", "NLDATM", "NLDATMAP", "NLDATMW", "NLDATMTM", "NLDATMYM", "NLDATMMD", "NLDATMDT", "AFRDFDT", "CATDFDT", "CRODFDT", "CSYDFDT", "DANDFDT", "DESDFDT", "DEUDFDT", "ENGDFDT", "ESPDFDT", "EURDFDT", "FINDFDT", "FRADFDT", "FRSDFDT", "HUNDFDT", "ITADFDT", "MACDFDT", "NLDDFDT", "NORDFDT", "POLDFDT", "PTGDFDT", "RUSDFDT", "SLODFDT", "SVEDFDT"};

    public static void reportError(Object obj) {
        if (obj instanceof Throwable) {
            ((Throwable)obj).printStackTrace();
        } else {
            System.err.println(obj);
        }
    }

    public static int getFormatType(SASFormat format) {
        if (format == null) {
            return -1;
        }
        if (format instanceof SASDateTimeFormat) {
            int i;
            String formatName = format.getBaseFormatName();
            for (i = 0; i < TIME_FORMATS.length; ++i) {
                if (!TIME_FORMATS[i].equalsIgnoreCase(formatName)) continue;
                return 0;
            }
            for (i = 0; i < DATE_TIME_FORMATS.length; ++i) {
                if (!DATE_TIME_FORMATS[i].equalsIgnoreCase(formatName)) continue;
                return 2;
            }
            return 1;
        }
        if (format instanceof SASUserDefinedFormat) {
            return 5;
        }
        if (format instanceof SASCharacterFormat) {
            return 4;
        }
        if (format instanceof SASNumericFormat) {
            return 3;
        }
        return -1;
    }

    public static Object getReflectedFieldValue(String name) {
        String interfaceName;
        if (name == null) {
            return null;
        }
        int first = name.indexOf(46);
        int last = name.lastIndexOf(46);
        if (first < 0 || last < 0) {
            return null;
        }
        String fieldName = name.substring(last + 1);
        String fullyQualifiedInterfaceName = interfaceName = name.substring(0, last);
        if (first == last) {
            fullyQualifiedInterfaceName = "com.sas.graphics.silk.interfaces." + interfaceName;
        }
        Class<?> cls = null;
        try {
            cls = Class.forName(fullyQualifiedInterfaceName);
        }
        catch (ClassNotFoundException e) {
            try {
                fullyQualifiedInterfaceName = "com.sas.graphics.components.pfd.interfaces." + interfaceName;
                cls = Class.forName(fullyQualifiedInterfaceName);
            }
            catch (ClassNotFoundException cnfe) {
                return null;
            }
        }
        if (cls == null) {
            return null;
        }
        Field field = null;
        try {
            field = cls.getField(fieldName);
        }
        catch (NoSuchFieldException nsfe) {
            return null;
        }
        catch (SecurityException se) {
            return null;
        }
        if (field == null) {
            return null;
        }
        Object rc = null;
        try {
            rc = field.get(null);
        }
        catch (Exception e) {
            return null;
        }
        return rc;
    }

    public static BufferedImage createCompatibleImage(int width, int height, int transparency) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (ge.isHeadlessInstance()) {
            BufferedImage compatibleImage = new BufferedImage(width, height, 2);
            return compatibleImage;
        }
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        return gc.createCompatibleImage(width, height, transparency);
    }

    public static void clearImage(Image image) {
        if (image == null) {
            return;
        }
        Graphics g = image.getGraphics();
        Graphics2D g2 = null;
        if (g instanceof Graphics2D) {
            g2 = (Graphics2D)g;
        }
        Composite old = g2.getComposite();
        g2.setComposite(AlphaComposite.Clear);
        g2.fillRect(0, 0, image.getWidth(null), image.getHeight(null));
        g2.setComposite(old);
    }

    public static void detachFromDataModel(Object dataModel) {
        if (dataModel == null) {
            return;
        }
        SortContextFactory.detachFromDataModel(dataModel);
        FilterFactory.detachAllFilters(dataModel);
        System.gc();
    }
}

