/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util;

import com.sas.graphics.util.SortedVector;
import java.awt.Color;
import java.util.Enumeration;
import java.util.Objects;
import java.util.Vector;

public class Extract {
    public static final int IS_VECTOR = 1;
    public static final int IS_INTEGER_ARRAY = 2;
    public static final int IS_INT_ARRAY = 3;
    public static final int IS_BIG_LONG_ARRAY = 4;
    public static final int IS_LITTLE_LONG_ARRAY = 5;
    public static final int IS_BIG_FLOAT_ARRAY = 6;
    public static final int IS_LITTLE_FLOAT_ARRAY = 7;
    public static final int IS_BIG_DOUBLE_ARRAY = 8;
    public static final int IS_LITTLE_DOUBLE_ARRAY = 9;
    public static final int IS_STRING_ARRAY = 10;
    public static final int IS_COLOR_ARRAY = 11;
    public static final int IS_OBJECT_ARRAY = 12;
    public static final int IS_LITTLE_BOOLEAN_ARRAY = 13;
    public static final int IS_BIG_BOOLEAN_ARRAY = 14;
    public static final int IS_SORTED_VECTOR = 15;
    public static final int IS_INTEGER = 16;
    public static final int IS_LONG = 17;
    public static final int IS_FLOAT = 18;
    public static final int IS_DOUBLE = 19;
    public static final int IS_STRING = 20;
    public static final int IS_COLOR = 21;
    public static final int IS_BOOLEAN = 22;
    public static final int IS_OBJECT = 23;

    public static int getSourceType(Object source) {
        if (source == null) {
            return 0;
        }
        if (source instanceof Vector) {
            return 1;
        }
        if (source instanceof SortedVector) {
            return 15;
        }
        if (source instanceof Integer[]) {
            return 2;
        }
        if (source instanceof int[]) {
            return 3;
        }
        if (source instanceof Long[]) {
            return 4;
        }
        if (source instanceof long[]) {
            return 5;
        }
        if (source instanceof Float[]) {
            return 6;
        }
        if (source instanceof float[]) {
            return 7;
        }
        if (source instanceof Double[]) {
            return 8;
        }
        if (source instanceof double[]) {
            return 9;
        }
        if (source instanceof String[]) {
            return 10;
        }
        if (source instanceof Color[]) {
            return 11;
        }
        if (source instanceof boolean[]) {
            return 13;
        }
        if (source instanceof Boolean[]) {
            return 14;
        }
        if (source instanceof Object[]) {
            return 12;
        }
        if (source instanceof Integer) {
            return 16;
        }
        if (source instanceof Long) {
            return 17;
        }
        if (source instanceof Float) {
            return 18;
        }
        if (source instanceof Double) {
            return 19;
        }
        if (source instanceof String) {
            return 20;
        }
        if (source instanceof Color) {
            return 21;
        }
        if (source instanceof Boolean) {
            return 22;
        }
        return 23;
    }

    public static int getNumberItems(Object source, int type) {
        int n = 0;
        if (source == null) {
            return 0;
        }
        switch (type) {
            case 1: {
                n = ((Vector)source).size();
                break;
            }
            case 15: {
                n = ((SortedVector)source).size();
                break;
            }
            case 2: {
                n = ((Integer[])source).length;
                break;
            }
            case 3: {
                n = ((int[])source).length;
                break;
            }
            case 4: {
                n = ((Long[])source).length;
                break;
            }
            case 5: {
                n = ((long[])source).length;
                break;
            }
            case 6: {
                n = ((Float[])source).length;
                break;
            }
            case 7: {
                n = ((float[])source).length;
                break;
            }
            case 8: {
                n = ((Double[])source).length;
                break;
            }
            case 9: {
                n = ((double[])source).length;
                break;
            }
            case 10: {
                n = ((String[])source).length;
                break;
            }
            case 11: {
                n = ((Color[])source).length;
                break;
            }
            case 14: {
                n = ((Boolean[])source).length;
                break;
            }
            case 13: {
                n = ((boolean[])source).length;
                break;
            }
            case 12: {
                n = ((Object[])source).length;
                break;
            }
            default: {
                n = 1;
            }
        }
        return n;
    }

    public static Object getObject(Object source, int idx, int type) {
        Object out = null;
        switch (type) {
            case 1: {
                out = ((Vector)source).elementAt(idx);
                break;
            }
            case 15: {
                out = ((SortedVector)source).elementAt(idx);
                break;
            }
            case 2: {
                out = ((Integer[])source)[idx];
                break;
            }
            case 3: {
                out = new Integer(((int[])source)[idx]);
                break;
            }
            case 4: {
                out = ((Long[])source)[idx];
                break;
            }
            case 5: {
                out = new Long(((long[])source)[idx]);
                break;
            }
            case 8: {
                out = ((Double[])source)[idx];
                break;
            }
            case 9: {
                out = new Double(((double[])source)[idx]);
                break;
            }
            case 10: {
                out = ((String[])source)[idx];
                break;
            }
            case 11: {
                out = ((Color[])source)[idx];
                break;
            }
            case 14: {
                out = ((Boolean[])source)[idx];
                break;
            }
            case 13: {
                out = new Boolean(((boolean[])source)[idx]);
                break;
            }
            case 12: {
                out = ((Object[])source)[idx];
                break;
            }
            default: {
                out = source;
            }
        }
        return out;
    }

    public static double getNumeric(Object source, int idx, int type) {
        double out = Double.NaN;
        Object obj = null;
        Number num = null;
        switch (type) {
            case 1: {
                Object e = ((Vector)source).elementAt(idx);
                obj = e;
                if (e == null || !(obj instanceof Number)) break;
                out = ((Number)obj).doubleValue();
                break;
            }
            case 15: {
                obj = ((SortedVector)source).elementAt(idx);
                if (obj == null || !(obj instanceof Number)) break;
                out = ((Number)obj).doubleValue();
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                num = ((Number[])source)[idx];
                if (num == null) break;
                out = num.doubleValue();
                break;
            }
            case 3: {
                out = ((int[])source)[idx];
                break;
            }
            case 5: {
                out = ((long[])source)[idx];
                break;
            }
            case 9: {
                out = ((double[])source)[idx];
                break;
            }
            case 10: {
                break;
            }
            case 12: {
                obj = ((Object[])source)[idx];
                if (obj == null || !(obj instanceof Number)) break;
                out = ((Number)obj).doubleValue();
                break;
            }
            default: {
                if (source == null || !(source instanceof Number)) break;
                out = ((Number)source).doubleValue();
            }
        }
        return out;
    }

    public static int getInteger(Object source, int idx, int type) {
        int out = -1;
        Object obj = null;
        Number num = null;
        switch (type) {
            case 1: {
                Object e = ((Vector)source).elementAt(idx);
                obj = e;
                if (e == null || !(obj instanceof Number)) break;
                out = ((Number)obj).intValue();
                break;
            }
            case 15: {
                obj = ((SortedVector)source).elementAt(idx);
                if (obj == null || !(obj instanceof Number)) break;
                out = ((Number)obj).intValue();
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                num = ((Number[])source)[idx];
                if (num == null) break;
                out = num.intValue();
                break;
            }
            case 3: {
                out = ((int[])source)[idx];
                break;
            }
            case 5: {
                out = (int)((long[])source)[idx];
                break;
            }
            case 9: {
                out = (int)((double[])source)[idx];
                break;
            }
            case 10: {
                break;
            }
            case 12: {
                obj = ((Object[])source)[idx];
                if (obj == null || !(obj instanceof Number)) break;
                out = ((Number)obj).intValue();
                break;
            }
            default: {
                if (source == null || !(source instanceof Number)) break;
                out = ((Number)source).intValue();
            }
        }
        return out;
    }

    public static boolean getBoolean(Object source, int idx, int type, boolean defaultValue) {
        boolean out = defaultValue;
        Object obj = null;
        Number num = null;
        switch (type) {
            case 1: {
                Object e = ((Vector)source).elementAt(idx);
                obj = e;
                if (e == null) break;
                if (obj instanceof Boolean) {
                    out = (Boolean)obj;
                    break;
                }
                if (!(obj instanceof Number)) break;
                out = ((Number)obj).doubleValue() != 0.0;
                break;
            }
            case 15: {
                obj = ((SortedVector)source).elementAt(idx);
                if (obj == null) break;
                if (obj instanceof Boolean) {
                    out = (Boolean)obj;
                    break;
                }
                if (!(obj instanceof Number)) break;
                out = ((Number)obj).doubleValue() != 0.0;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                num = ((Number[])source)[idx];
                if (num == null) break;
                out = num.doubleValue() != 0.0;
                break;
            }
            case 3: {
                out = ((int[])source)[idx] != 0;
                break;
            }
            case 5: {
                out = ((long[])source)[idx] != 0L;
                break;
            }
            case 9: {
                out = ((double[])source)[idx] != 0.0;
                break;
            }
            case 10: {
                out = Boolean.valueOf(((String[])source)[idx]);
                break;
            }
            case 14: {
                if (((Boolean[])source)[idx] == null) break;
                out = ((Boolean[])source)[idx];
                break;
            }
            case 13: {
                out = ((boolean[])source)[idx];
                break;
            }
            case 12: {
                obj = ((Object[])source)[idx];
                if (obj == null) break;
                if (obj instanceof Boolean) {
                    out = (Boolean)obj;
                    break;
                }
                if (!(obj instanceof Number)) break;
                out = ((Number)obj).doubleValue() != 0.0;
                break;
            }
            default: {
                if (source == null || !(source instanceof Boolean)) break;
                out = (Boolean)source;
            }
        }
        return out;
    }

    public static Color getColor(Object source, int idx, int type) {
        Object obj = null;
        Color out = null;
        switch (type) {
            case 1: {
                obj = ((Vector)source).elementAt(idx);
                break;
            }
            case 15: {
                obj = ((SortedVector)source).elementAt(idx);
                break;
            }
            case 2: {
                obj = ((Integer[])source)[idx];
                break;
            }
            case 3: {
                obj = new Integer(((int[])source)[idx]);
                break;
            }
            case 4: {
                obj = ((Long[])source)[idx];
                break;
            }
            case 5: {
                obj = new Long(((long[])source)[idx]);
                break;
            }
            case 8: {
                obj = ((Double[])source)[idx];
                break;
            }
            case 9: {
                obj = new Double(((double[])source)[idx]);
                break;
            }
            case 10: {
                obj = ((String[])source)[idx];
                break;
            }
            case 11: {
                obj = ((Color[])source)[idx];
                break;
            }
            case 12: {
                obj = ((Object[])source)[idx];
                break;
            }
        }
        if (obj == null) {
            return null;
        }
        if (!(obj instanceof Color)) {
            if (obj instanceof Number) {
                int icolor = ((Number)obj).intValue();
                out = new Color(icolor >> 16 & 0xFF, icolor >> 8 & 0xFF, icolor & 0xFF);
            }
        } else {
            out = (Color)obj;
        }
        return out;
    }

    protected static Object getItems(Object source, Object storage, Class outputClass) {
        int type = Extract.getSourceType(source);
        int outType = 0;
        Object out = null;
        if (type <= 0) {
            return null;
        }
        int n = Extract.getNumberItems(source, type);
        if (n <= 0) {
            return null;
        }
        if (outputClass == null) {
            return null;
        }
        if (outputClass == int[].class) {
            outType = 3;
        } else if (outputClass == double[].class) {
            outType = 9;
        }
        switch (outType) {
            case 3: {
                if (storage != null && ((int[])storage).length >= n) {
                    out = storage;
                    break;
                }
                out = new int[n];
                if (out != null) break;
                return null;
            }
            case 9: {
                if (storage != null && ((double[])storage).length >= n) {
                    out = storage;
                    break;
                }
                double[] dArray = new double[n];
                out = dArray;
                if (dArray != null) break;
                return null;
            }
        }
        block8: for (int i = 0; i < n; ++i) {
            switch (outType) {
                case 3: {
                    out[i] = Extract.getInteger(source, i, type);
                    continue block8;
                }
                case 9: {
                    ((double[])out)[i] = Extract.getNumeric(source, i, type);
                }
            }
        }
        return out;
    }

    public static int[] getIntegers(Object source, int[] storage) {
        return (int[])Extract.getItems(source, storage, int[].class);
    }

    public static double[] getNumerics(Object source, double[] storage) {
        return (double[])Extract.getItems(source, storage, double[].class);
    }

    public static Enumeration elements(Object source) {
        if (source instanceof Enumeration) {
            return (Enumeration)source;
        }
        Extract extract = new Extract();
        Objects.requireNonNull(extract);
        return extract.new ListEnumeration(source);
    }

    public static Object[] toObjectArray(Object source) {
        Enumeration e = Extract.elements(source);
        Vector v = new Vector();
        while (e.hasMoreElements()) {
            v.addElement(e.nextElement());
        }
        Object[] rc = new Object[v.size()];
        return v.toArray(rc);
    }

    class ListEnumeration
    implements Enumeration {
        private int numItems = 0;
        private int currentItem = 0;
        private Object source = null;
        private int type = 0;

        public ListEnumeration(Object source) {
            this.source = source;
            this.type = Extract.getSourceType(source);
            this.numItems = Extract.getNumberItems(source, this.type);
        }

        @Override
        public boolean hasMoreElements() {
            return this.currentItem < this.numItems;
        }

        public Object nextElement() {
            return Extract.getObject(this.source, this.currentItem++, this.type);
        }
    }
}

