/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util;

import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import java.util.LinkedHashMap;
import java.util.Vector;

public class BinValues {
    public static final int MISSING = -3;
    public static final int COLOR_DISCRETE = 0;
    public static final int COLOR_NUMERIC = 1;
    public static final int COLOR_IS_NULL = 2;
    public static final int STAT_SUM = 30;
    public static final int STAT_MEAN = 31;
    protected int colorType = 1;
    protected int statisticType = 30;
    protected double maxXYBinCount = Double.NEGATIVE_INFINITY;
    protected double minContinuousColorValue = Double.POSITIVE_INFINITY;
    protected double maxContinuousColorValue = Double.NEGATIVE_INFINITY;
    protected int numberOfRows = 0;
    protected int numberOfColumns = 0;
    protected double[] xyBinCount;
    protected double[] xMissingBinCount;
    protected double[] yMissingBinCount;
    protected String[] xyBinColorDiscrete;
    protected String[] xMissingBinColorDiscrete;
    protected String[] yMissingBinColorDiscrete;
    protected double[] xyBinColorNumeric;
    protected double[] xMissingBinColorNumeric;
    protected double[] yMissingBinColorNumeric;
    protected double bothXYMissingBinCount = 0.0;
    protected double bothXYMissingBinColorNumeric = 0.0;
    protected String bothXYMissingBinColorDiscrete;
    protected LinkedHashMap<Integer, Integer> xBinMap = null;
    protected LinkedHashMap<Integer, Integer> yBinMap = null;
    protected LinkedHashMap<Integer, LinkedHashMap<Integer, Vector<Integer>>> binToObsIndexMap = new LinkedHashMap();

    public void initWith(int numberOfXBins, int numberOfYBins, int colorVariableType, int statisticType) {
        this.numberOfRows = numberOfYBins;
        this.numberOfColumns = numberOfXBins;
        this.xyBinCount = new double[this.numberOfColumns * this.numberOfRows];
        switch (colorVariableType) {
            case 1: {
                this.colorType = colorVariableType;
                this.xyBinColorNumeric = new double[this.xyBinCount.length];
                break;
            }
            case 0: {
                this.colorType = colorVariableType;
                this.xyBinColorDiscrete = new String[this.xyBinCount.length];
                break;
            }
            default: {
                this.colorType = 2;
            }
        }
        this.xBinMap = new LinkedHashMap();
        this.yBinMap = new LinkedHashMap();
        if (this.binToObsIndexMap != null) {
            this.binToObsIndexMap.clear();
        }
    }

    public void addBinToObservationIndex(int xBinIndex, int yBinIndex, int obs) {
        LinkedHashMap<Integer, Vector<Integer>> m = null;
        if (!this.binToObsIndexMap.containsKey(xBinIndex)) {
            this.binToObsIndexMap.put(xBinIndex, new LinkedHashMap());
        }
        m = this.binToObsIndexMap.get(xBinIndex);
        Vector<Integer> obsList = null;
        if (!m.containsKey(yBinIndex)) {
            m.put(yBinIndex, new Vector());
        }
        obsList = m.get(yBinIndex);
        obsList.add(obs);
    }

    public int[] getObservationIndices(int xBinIndex, int yBinIndex) {
        Vector<Integer> obsList;
        LinkedHashMap<Integer, Vector<Integer>> m;
        int[] obs = null;
        if (this.binToObsIndexMap.containsKey(xBinIndex) && (m = this.binToObsIndexMap.get(xBinIndex)).containsKey(yBinIndex) && (obsList = m.get(yBinIndex)).size() > 0) {
            obs = new int[obsList.size()];
            for (int i = 0; i < obsList.size(); ++i) {
                obs[i] = obsList.elementAt(i);
            }
        }
        return obs;
    }

    public void update(int xIndex, int yIndex, int count, Object colorValue, int obs) {
        this.xBinMap.put(obs, xIndex);
        this.yBinMap.put(obs, yIndex);
        if (xIndex == -3 || yIndex == -3) {
            if (xIndex == -3 && yIndex == -3) {
                this.bothXYMissingBinCount += (double)count;
                switch (this.colorType) {
                    case 1: {
                        this.bothXYMissingBinColorNumeric += ((Number)colorValue).doubleValue();
                        break;
                    }
                    case 0: {
                        this.bothXYMissingBinColorDiscrete = (String)colorValue;
                    }
                }
            } else if (xIndex == -3 && yIndex >= 0) {
                if (this.xMissingBinCount == null) {
                    this.xMissingBinCount = new double[this.numberOfRows];
                    switch (this.colorType) {
                        case 1: {
                            this.xMissingBinColorNumeric = new double[this.numberOfRows];
                            break;
                        }
                        case 0: {
                            this.xMissingBinColorDiscrete = new String[this.numberOfRows];
                        }
                    }
                }
                switch (this.colorType) {
                    case 1: {
                        this.updateBin(yIndex, this.xMissingBinCount, count, this.xMissingBinColorNumeric, colorValue);
                        break;
                    }
                    case 0: {
                        this.updateBin(yIndex, this.xMissingBinCount, count, this.xMissingBinColorDiscrete, colorValue);
                    }
                }
            } else if (yIndex == -3 && xIndex >= 0) {
                if (this.yMissingBinCount == null) {
                    this.yMissingBinCount = new double[this.numberOfColumns];
                    switch (this.colorType) {
                        case 1: {
                            this.yMissingBinColorNumeric = new double[this.numberOfColumns];
                            break;
                        }
                        case 0: {
                            this.yMissingBinColorDiscrete = new String[this.numberOfColumns];
                        }
                    }
                }
                switch (this.colorType) {
                    case 1: {
                        this.updateBin(xIndex, this.yMissingBinCount, count, this.yMissingBinColorNumeric, colorValue);
                        break;
                    }
                    case 0: {
                        this.updateBin(xIndex, this.yMissingBinCount, count, this.yMissingBinColorDiscrete, colorValue);
                    }
                }
            }
        } else if (xIndex < 0 && yIndex < 0) {
            return;
        }
        if (xIndex < 0) {
            return;
        }
        if (yIndex < 0) {
            return;
        }
        switch (this.colorType) {
            case 1: {
                this.updateBin(yIndex * this.numberOfColumns + xIndex, this.xyBinCount, count, this.xyBinColorNumeric, colorValue);
                break;
            }
            case 0: {
                this.updateBin(yIndex * this.numberOfColumns + xIndex, this.xyBinCount, count, this.xyBinColorDiscrete, colorValue);
                break;
            }
            default: {
                int n = yIndex * this.numberOfColumns + xIndex;
                this.xyBinCount[n] = this.xyBinCount[n] + (double)count;
            }
        }
    }

    protected void updateBin(int index, double[] binCount, int count, String[] binColor, Object colorValue) {
        int n = index;
        binCount[n] = binCount[n] + (double)count;
        binColor[index] = (String)colorValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void updateBin(int index, double[] binCount, int count, double[] binColor, Object colorValue) {
        double d = Double.NaN;
        if (colorValue instanceof Number) {
            d = ((Number)colorValue).doubleValue();
        }
        if (Double.isNaN(d)) {
            if (binCount[index] != 0.0) return;
            int n = index;
            binCount[n] = binCount[n] + (double)count;
            int n2 = index;
            binColor[n2] = binColor[n2] + d;
            return;
        } else if (binCount[index] == 1.0 && Double.isNaN(binColor[index])) {
            binCount[index] = count;
            binColor[index] = d;
            return;
        } else {
            int n = index;
            binCount[n] = binCount[n] + (double)count;
            int n3 = index;
            binColor[n3] = binColor[n3] + d;
        }
    }

    public int getColorType() {
        return this.colorType;
    }

    public double getCount(int xIndex, int yIndex) {
        return this.xyBinCount[xIndex + yIndex * this.numberOfColumns];
    }

    public double getColorNumeric(int xIndex, int yIndex) {
        if (this.xyBinColorNumeric == null) {
            return Double.NaN;
        }
        switch (this.statisticType) {
            default: {
                return this.xyBinColorNumeric[xIndex + yIndex * this.numberOfColumns];
            }
            case 31: 
        }
        return this.xyBinColorNumeric[xIndex + yIndex * this.numberOfColumns] / this.getCount(xIndex, yIndex);
    }

    public String getColorDiscrete(int xIndex, int yIndex) {
        if (this.xyBinColorDiscrete == null) {
            return null;
        }
        return this.xyBinColorDiscrete[xIndex + yIndex * this.numberOfColumns];
    }

    public double[] getXYBinCount() {
        return this.xyBinCount;
    }

    public double[] getXYBinColorNumeric() {
        return this.xyBinColorNumeric;
    }

    public String[] getXYBinColorDiscrete() {
        return this.xyBinColorDiscrete;
    }

    public double[] getXMissingBinCount() {
        return this.xMissingBinCount;
    }

    public double[] getYMissingBinCount() {
        return this.yMissingBinCount;
    }

    public double getMaxBinCount() {
        if (Double.isInfinite(this.maxXYBinCount)) {
            this.findMinMaxCounts();
        }
        return this.maxXYBinCount;
    }

    public double getMinBinColorValue() {
        if (Double.isInfinite(this.minContinuousColorValue) && this.colorType == 1) {
            this.findMinMaxContinuousColorValues();
        }
        return this.minContinuousColorValue;
    }

    public double getMaxBinColorValue() {
        if (Double.isInfinite(this.minContinuousColorValue) && this.colorType == 1) {
            this.findMinMaxContinuousColorValues();
        }
        return this.maxContinuousColorValue;
    }

    protected void findMinMaxCounts() {
        int i;
        for (i = this.numberOfRows * this.numberOfColumns - 1; i >= 0; --i) {
            this.maxXYBinCount = Math.max(this.maxXYBinCount, this.xyBinCount[i]);
        }
        if (this.xMissingBinCount != null) {
            for (i = this.numberOfRows - 1; i >= 0; --i) {
                this.maxXYBinCount = Math.max(this.maxXYBinCount, this.xMissingBinCount[i]);
            }
        }
        if (this.yMissingBinCount != null) {
            for (i = this.numberOfColumns - 1; i >= 0; --i) {
                this.maxXYBinCount = Math.max(this.maxXYBinCount, this.yMissingBinCount[i]);
            }
        }
    }

    protected void findMinMaxContinuousColorValues() {
        int i;
        for (i = this.numberOfRows * this.numberOfColumns - 1; i >= 0; --i) {
            this.minContinuousColorValue = Math.min(this.minContinuousColorValue, this.xyBinColorNumeric[i]);
            this.maxContinuousColorValue = Math.max(this.maxContinuousColorValue, this.xyBinColorNumeric[i]);
        }
        if (this.xMissingBinCount != null) {
            for (i = this.numberOfRows - 1; i >= 0; --i) {
                this.minContinuousColorValue = Math.min(this.minContinuousColorValue, this.xMissingBinColorNumeric[i]);
                this.maxContinuousColorValue = Math.max(this.maxContinuousColorValue, this.xMissingBinColorNumeric[i]);
            }
        }
        if (this.yMissingBinCount != null) {
            for (i = this.numberOfColumns - 1; i >= 0; --i) {
                this.minContinuousColorValue = Math.min(this.minContinuousColorValue, this.yMissingBinColorNumeric[i]);
                this.maxContinuousColorValue = Math.max(this.maxContinuousColorValue, this.yMissingBinColorNumeric[i]);
            }
        }
    }

    public ContinuousRange getContinuousColorRange() {
        switch (this.colorType) {
            case 1: {
                return new ContinuousRange(this.getMinBinColorValue(), this.getMaxBinColorValue());
            }
            case 0: {
                return null;
            }
        }
        return new ContinuousRange(1.0, this.getMaxBinCount());
    }

    public int getXBinIndex(int obs) {
        if (this.xBinMap != null && this.xBinMap.containsKey(obs)) {
            return this.xBinMap.get(obs);
        }
        return -1;
    }

    public int getYBinIndex(int obs) {
        if (this.yBinMap != null && this.yBinMap.containsKey(obs)) {
            return this.yBinMap.get(obs);
        }
        return -1;
    }

    public void dispose() {
        this.xyBinCount = null;
        this.xMissingBinCount = null;
        this.yMissingBinCount = null;
        this.xyBinColorDiscrete = null;
        this.xMissingBinColorDiscrete = null;
        this.yMissingBinColorDiscrete = null;
        this.xyBinColorNumeric = null;
        this.xMissingBinColorNumeric = null;
        this.yMissingBinColorNumeric = null;
        if (this.xBinMap != null) {
            this.xBinMap.clear();
        }
        this.xBinMap = null;
        if (this.yBinMap != null) {
            this.yBinMap.clear();
        }
        this.yBinMap = null;
    }
}

