/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util;

import com.sas.MissingValues;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.silk.interfaces.DataFilterInfoInterface;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.util.Bin;
import com.sas.graphics.util.BinValues;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.Variable;
import java.util.Vector;
import org.apache.xalan.xsltc.runtime.Hashtable;

public class BinUtilities {
    protected static final int BELOW_FIRST_BIN = -1;
    protected static final int ABOVE_LAST_BIN = -2;

    public static boolean doBivariateBinning(Variable xGTKVariable, DataRange xAxisDataRange, boolean xAxisIsDiscrete, int xNumberOfBins, double[] xAxisBinBoundaries, int xBinBoundaryValueInclusionRule, boolean xBinToDataRange, Variable yGTKVariable, DataRange yAxisDataRange, boolean yAxisIsDiscrete, int yNumberOfBins, double[] yAxisBinBoundaries, int yBinBoundaryValueInclusionRule, boolean yBinToDataRange, NumericVariable frequencyGTKVariable, Variable colorGTKVariable, Vector<Bin> xBins, Vector<Bin> yBins, BinValues binValues) {
        NumericVariable nv;
        ContinuousRange cr;
        if (xGTKVariable == null || yGTKVariable == null || xAxisDataRange == null || yAxisDataRange == null) {
            return false;
        }
        double[] temp = new double[2];
        Hashtable xMap = null;
        Hashtable yMap = null;
        if (!xAxisIsDiscrete) {
            cr = (ContinuousRange)xAxisDataRange;
            nv = (NumericVariable)xGTKVariable;
            if (Double.isNaN(cr.getMin()) || Double.isNaN(cr.getMax()) || Double.isNaN(cr.getMin()) || Double.isNaN(cr.getMax())) {
                return false;
            }
            if (xBinToDataRange) {
                xAxisDataRange = new ContinuousRange(nv.getMin(), nv.getMax());
            }
            xBins = BinUtilities.createContinuousBins((ContinuousRange)xAxisDataRange, xNumberOfBins, xAxisBinBoundaries, xBins, temp);
        } else {
            xMap = BinUtilities.buildIndexMap((DiscreteRange)xAxisDataRange);
            xBins = BinUtilities.createDiscreteBins((DiscreteRange)xAxisDataRange, xBins, temp);
        }
        xNumberOfBins = xBins.size();
        double xBinStart = temp[0];
        double xBinEnd = temp[1];
        if (!yAxisIsDiscrete) {
            cr = (ContinuousRange)yAxisDataRange;
            nv = (NumericVariable)yGTKVariable;
            if (Double.isNaN(cr.getMin()) || Double.isNaN(cr.getMax()) || Double.isNaN(cr.getMin()) || Double.isNaN(cr.getMax())) {
                return false;
            }
            if (yBinToDataRange) {
                yAxisDataRange = new ContinuousRange(nv.getMin(), nv.getMax());
            }
            yBins = BinUtilities.createContinuousBins((ContinuousRange)yAxisDataRange, yNumberOfBins, yAxisBinBoundaries, yBins, temp);
        } else {
            yMap = BinUtilities.buildIndexMap((DiscreteRange)yAxisDataRange);
            yBins = BinUtilities.createDiscreteBins((DiscreteRange)yAxisDataRange, yBins, temp);
        }
        yNumberOfBins = yBins.size();
        double yBinStart = temp[0];
        double yBinEnd = temp[1];
        if (xBins == null || yBins == null) {
            return false;
        }
        if (binValues == null) {
            return true;
        }
        int colorVariableType = 2;
        int colorVariableStatisticType = 30;
        if (colorGTKVariable != null) {
            colorVariableType = colorGTKVariable instanceof NumericVariable ? 1 : 0;
        }
        binValues.initWith(xNumberOfBins, yNumberOfBins, colorVariableType, colorVariableStatisticType);
        int frequency = 1;
        Object colorValue = null;
        int numberOfObservations = xGTKVariable.getValueCount();
        for (int i = 0; i < numberOfObservations; ++i) {
            double xValue = BinUtilities.getNumericValue(xGTKVariable, xMap, i, xAxisIsDiscrete);
            double yValue = BinUtilities.getNumericValue(yGTKVariable, yMap, i, yAxisIsDiscrete);
            int xBinIndex = BinUtilities.getBinIndex(xBins, xBinStart, xBinEnd, xValue, xBinBoundaryValueInclusionRule, xAxisBinBoundaries == null);
            int yBinIndex = BinUtilities.getBinIndex(yBins, yBinStart, yBinEnd, yValue, yBinBoundaryValueInclusionRule, yAxisBinBoundaries == null);
            if (frequencyGTKVariable != null) {
                frequency = ((Number)Variable.getValue((Variable)frequencyGTKVariable, (int)i, (boolean)false)).intValue();
            }
            if (colorGTKVariable != null) {
                colorValue = Variable.getValue((Variable)colorGTKVariable, (int)i, (boolean)false);
            }
            if (colorValue instanceof MissingValues) {
                colorValue = Double.NaN;
            }
            binValues.update(xBinIndex, yBinIndex, frequency, colorValue, i);
            binValues.addBinToObservationIndex(xBinIndex, yBinIndex, i);
        }
        return true;
    }

    public static double getNumericValue(Variable variable, Hashtable map, int index, boolean variableIsDiscrete) {
        try {
            if (!variableIsDiscrete) {
                return ((NumericVariable)variable).value.getValue(index);
            }
            Object key = Variable.getValue((Variable)variable, (int)index, (boolean)true);
            if (key instanceof MissingValues) {
                key = "";
            }
            if (map.containsKey(key)) {
                return ((Number)map.get(key)).doubleValue();
            }
            return Double.NaN;
        }
        catch (MissingValueException e) {
            return Double.NaN;
        }
    }

    protected static Vector<Bin> createContinuousBins(ContinuousRange dataRange, int numberOfBins, double[] binNames, Vector<Bin> bins, double[] binMinMax) {
        if (bins == null) {
            bins = new Vector(binNames != null ? binNames.length : numberOfBins);
        } else {
            bins.clear();
        }
        if (binMinMax == null) {
            binMinMax = new double[]{0.0, 0.0};
        }
        if (binNames != null) {
            Bin b = null;
            for (int i = 1; i < binNames.length; ++i) {
                b = new Bin();
                b.setMin(binNames[i - 1]);
                b.setMax(binNames[i]);
                b.setIndex(i - 1);
                bins.add(b);
            }
            binMinMax[0] = binNames[0];
            binMinMax[1] = binNames[binNames.length - 1];
        } else {
            double min = dataRange.getMin();
            double max = dataRange.getMax();
            double step = (max - min) / (double)numberOfBins;
            Bin b = null;
            for (int i = 0; i < numberOfBins; ++i) {
                b = new Bin();
                b.setMin(min + (double)i * step);
                b.setMax(min + (double)(i + 1) * step);
                b.setIndex(i);
                bins.add(b);
            }
            binMinMax[0] = min;
            binMinMax[1] = max;
        }
        return bins;
    }

    protected static Vector<Bin> createDiscreteBins(DiscreteRange dataRange, Vector<Bin> bins, double[] binMinMax) {
        if (bins == null) {
            bins = new Vector(dataRange.getValuesSize());
        } else {
            bins.clear();
        }
        if (binMinMax == null) {
            binMinMax = new double[2];
        }
        int numberOfBins = dataRange.getValuesSize();
        Bin b = null;
        Vector discreteValues = dataRange.getValues();
        for (double i = 0.0; i < (double)numberOfBins; i += 1.0) {
            b = new Bin();
            b.setMin(i - 0.5);
            b.setMax(i + 0.5);
            b.setIndex((int)i);
            b.setDiscreteValue((String)discreteValues.get((int)i));
            bins.add(b);
        }
        binMinMax[0] = -0.5;
        binMinMax[1] = (double)numberOfBins - 0.5;
        return bins;
    }

    protected static ContinuousRange getDataRange(DataFilterInfoInterface infoFilter, Object var) {
        if (var == null || infoFilter == null) {
            return null;
        }
        double min = 0.0;
        double max = 0.0;
        Object o = infoFilter.getMinimumValue(var);
        if (o instanceof Number) {
            min = ((Number)o).doubleValue();
        }
        if ((o = infoFilter.getMaximumValue(var)) instanceof Number) {
            max = ((Number)o).doubleValue();
        }
        return new ContinuousRange(min, max);
    }

    protected static int getFrequencyCount(DataFilterReadInterface filter, int obs, int frequencyVarIndex) {
        int count = 1;
        if (filter != null && frequencyVarIndex >= 0) {
            count = (int)filter.getNumericValue(frequencyVarIndex, (long)obs);
        }
        if (count < 0) {
            count = 0;
        }
        return count;
    }

    protected static int getBinIndex(Vector<Bin> bins, double binStart, double binEnd, double value, int boundary, boolean equalSpacedBins) {
        if (Double.isNaN(value)) {
            return -3;
        }
        if (bins == null || bins.size() < 1) {
            return -1;
        }
        if (value < binStart) {
            return -1;
        }
        if (value > binEnd) {
            return -2;
        }
        int numberOfBins = bins.size();
        if (equalSpacedBins) {
            Bin b = bins.get(0);
            double equalBinWidth = b.getLength();
            if (equalBinWidth <= 0.0) {
                return 0;
            }
            int startIndex = (int)((value - binStart) / equalBinWidth - 1.0);
            for (int i = Math.max(startIndex, 0); i < numberOfBins; ++i) {
                b = bins.get(i);
                if (b == null || !b.contains(value, boundary)) continue;
                return i;
            }
        } else {
            for (int i = 0; i < numberOfBins; ++i) {
                if (!bins.get(i).contains(value, boundary)) continue;
                return i;
            }
        }
        if (value <= binEnd) {
            return bins.size() - 1;
        }
        return -2;
    }

    public static Vector[] pruneBinVectorsOfEmptyBinsAndProduceBinPositionAndLengthArrays(Vector<Bin> xBins, Vector<Bin> yBins, BinValues binValues, double xGap, double yGap) {
        if (xBins == null || yBins == null || binValues == null) {
            return null;
        }
        int numberOfColumns = xBins.size();
        double[] binCount = binValues.getXYBinCount();
        Vector<Double> xBinPosition = new Vector<Double>();
        Vector<Double> xBinLength = new Vector<Double>();
        Vector<Double> yBinPosition = new Vector<Double>();
        Vector<Double> yBinLength = new Vector<Double>();
        Vector<Integer> binIndex = new Vector<Integer>();
        Vector<Double> binNonZeroCount = new Vector<Double>();
        double[] binColorNumeric = binValues.getXYBinColorNumeric();
        String[] binColorDiscrete = binValues.getXYBinColorDiscrete();
        Vector<Object> binNonZeroColor = null;
        if (binColorNumeric != null || binColorDiscrete != null) {
            binNonZeroColor = new Vector<Object>();
        }
        int numberOfBins = binCount.length;
        for (int i = 0; i < numberOfBins; ++i) {
            int colNumber = i % numberOfColumns;
            int rowNumber = (int)Math.floor(i / numberOfColumns);
            if (!(binCount[i] > 0.0)) continue;
            Bin xBin = xBins.get(colNumber);
            Bin yBin = yBins.get(rowNumber);
            xBinPosition.add(xBin.getMidpoint());
            xBinLength.add(xBin.getLength() - xGap);
            yBinPosition.add(yBin.getMidpoint());
            yBinLength.add(yBin.getLength() - yGap);
            binNonZeroCount.add(binCount[i]);
            if (binColorDiscrete != null) {
                binNonZeroColor.add(binColorDiscrete[i]);
            } else if (binColorNumeric != null) {
                binNonZeroColor.add(binColorNumeric[i]);
            }
            binIndex.add(i);
        }
        return new Vector[]{xBinPosition, xBinLength, yBinPosition, yBinLength, binNonZeroCount, binNonZeroColor, binIndex};
    }

    private static Hashtable buildIndexMap(DiscreteRange dataRange) {
        if (dataRange == null) {
            return null;
        }
        int numValues = dataRange.getValuesSize();
        Vector values = dataRange.getValues();
        Hashtable map = new Hashtable(numValues);
        for (int i = 0; i < numValues; ++i) {
            map.put(values.elementAt(i), (Object)i);
        }
        return map;
    }
}

