/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.styles.ui.swatch;

import com.sas.graphics.styles.ui.Messages;
import com.sas.graphics.styles.ui.swatch.Apply;
import com.sas.graphics.styles.ui.swatch.ColorGrabber;
import com.sas.graphics.styles.ui.swatch.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SGDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    public static final String RB_KEY = "SGDialog.";
    JPanel panel;
    static final int OK_CANCEL = 0;
    static final int OK_CANCEL_APPLY = 1;
    static final int INFO_ONLY = 2;
    static final int OK_OPTION = 0;
    static final int CANCEL_OPTION = 1;
    public static final int NOT_DONE = -1;
    int value = 0;
    int type = 0;
    Apply apply;
    JFrame owner = null;
    JButton applyButton;
    ColorGrabber cg = null;

    public void initialize() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(Box.createHorizontalGlue());
        JButton okButton = new JButton(Messages.getString("ok.txt"));
        okButton.setActionCommand("ok");
        okButton.addActionListener(this);
        buttonPanel.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        buttonPanel.add(Box.createRigidArea(new Dimension(4 * UIUtil.DLU, 0)));
        JButton cancelButton = new JButton(Messages.getString("cancel.txt"));
        cancelButton.setActionCommand("cancel");
        cancelButton.addActionListener(this);
        buttonPanel.add(cancelButton);
        Dimension ps = new Dimension(cancelButton.getPreferredSize().width, cancelButton.getPreferredSize().height);
        if (this.apply != null) {
            buttonPanel.add(Box.createRigidArea(new Dimension(4 * UIUtil.DLU, 0)));
            this.applyButton = new JButton(Messages.getString("apply.txt"));
            this.applyButton.setActionCommand("apply");
            this.applyButton.addActionListener(this);
            buttonPanel.add(this.applyButton);
            ps.width = (int)Math.ceil(Math.max((double)ps.width, this.applyButton.getPreferredSize().getWidth()));
            this.applyButton.setPreferredSize(ps);
            this.applyButton.setEnabled(this.apply.isModified());
            this.apply.setChangeListener(new ApplyListener());
        }
        okButton.setPreferredSize(ps);
        cancelButton.setPreferredSize(ps);
        buttonPanel.setBorder(new EmptyBorder(7 * UIUtil.DLU, 0, 0, 0));
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        ((JComponent)contentPane).setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), new EmptyBorder(0, 3, 0, 3)));
        ((JComponent)contentPane).setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), new EmptyBorder(7 * UIUtil.DLU, 7 * UIUtil.DLU, 7 * UIUtil.DLU, 7 * UIUtil.DLU)));
        contentPane.add(this.panel);
        contentPane.add((Component)buttonPanel, "South");
    }

    public void initialize2() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(Box.createHorizontalGlue());
        JButton button = new JButton(Messages.getString("close.txt"));
        button.setActionCommand("ok");
        button.addActionListener(this);
        buttonPanel.add(button);
        this.getRootPane().setDefaultButton(button);
        buttonPanel.setBorder(new EmptyBorder(7 * UIUtil.DLU, 0, 0, 0));
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        ((JComponent)contentPane).setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), new EmptyBorder(0, 3, 0, 3)));
        ((JComponent)contentPane).setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), new EmptyBorder(7 * UIUtil.DLU, 7 * UIUtil.DLU, 7 * UIUtil.DLU, 7 * UIUtil.DLU)));
        contentPane.add(this.panel);
        contentPane.add((Component)buttonPanel, "South");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("apply")) {
            this.apply.apply();
        } else {
            this.value = cmd.equals("cancel") ? 1 : 0;
            this.setVisible(false);
            if (this.apply != null) {
                this.apply.setChangeListener(null);
            }
        }
    }

    public SGDialog(JFrame parent, String title, JPanel panel, Apply apply) {
        super(parent, title, true);
        this.apply = apply;
        this.panel = panel;
        this.owner = parent;
        this.type = apply == null ? 0 : 1;
        this.initialize();
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(parent);
    }

    public SGDialog(JFrame parent, String title, JPanel panel) {
        super(parent, title, true);
        this.owner = parent;
        this.panel = panel;
        Container contentPane = this.getContentPane();
        contentPane.add(panel);
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(parent);
    }

    public SGDialog(JFrame parent, String title) {
        super(parent, title, false);
        this.setResizable(false);
    }

    public SGDialog(JFrame parent, String title, JPanel panel, boolean info) {
        super(parent, title, true);
        this.apply = null;
        this.panel = panel;
        this.owner = parent;
        if (info) {
            this.type = 2;
            this.initialize2();
        } else {
            this.type = 0;
            this.initialize();
        }
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(parent);
    }

    public SGDialog makeDisabledCopy(ColorGrabber colorGrabber) {
        SGDialog dd = this.getOwner() instanceof JFrame ? new SGDialog((JFrame)this.getOwner(), this.getTitle()) : new SGDialog(null, this.getTitle());
        dd.setColorGrabber(colorGrabber);
        dd.apply = this.apply;
        dd.type = this.type;
        Container contentPane = dd.getContentPane();
        contentPane.setLayout(new BorderLayout());
        ((JComponent)contentPane).setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), new EmptyBorder(0, 3, 0, 3)));
        ((JComponent)contentPane).setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), new EmptyBorder(7 * UIUtil.DLU, 7 * UIUtil.DLU, 7 * UIUtil.DLU, 7 * UIUtil.DLU)));
        Component[] cc = this.getContentPane().getComponents();
        contentPane.add(this.panel);
        contentPane.add(cc[1], "South");
        Component glass = dd.getGlassPane();
        glass.setVisible(true);
        dd.pack();
        dd.setResizable(false);
        dd.setLocationRelativeTo(this.owner);
        dd.setLocation(this.getLocation());
        dd.setDefaultCloseOperation(0);
        dd.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Toolkit.getDefaultToolkit().beep();
            }
        });
        return dd;
    }

    public void setColorGrabber(ColorGrabber colorGrabber) {
        this.cg = colorGrabber;
        this.cg.setMouseMoveEnabled(false);
        Component glass = this.getGlassPane();
        glass.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                String message = Messages.getString("pickerwarning.txt");
                String title = Messages.getString("colorPicker.txt");
                Component parent = e.getSource() instanceof Component ? (Component)e.getSource() : null;
                int returnVal = JOptionPane.showConfirmDialog(parent, message, title, 0, 2);
                if (returnVal != 0) {
                    SGDialog.this.cg.mouseEventGenerator.dispatchEvent(new MouseEvent(SGDialog.this.cg.mouseEventGenerator, e.getID(), e.getWhen(), e.getModifiers(), Integer.MAX_VALUE, Integer.MAX_VALUE, e.getClickCount(), e.isPopupTrigger()));
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (SGDialog.this.cg != null) {
                    SGDialog.this.cg.setMouseMoveEnabled(true);
                }
            }
        });
        glass.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                e.consume();
            }
        });
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public static int showInputDialog(JFrame parent, String title, JPanel panel, Apply apply) {
        return SGDialog.showInputDialog(parent, title, panel, apply, null);
    }

    public static int showInputDialog(JFrame parent, String title, JPanel panel, Apply apply, Point loc) {
        Component[] c = panel.getComponents();
        boolean toolbar = false;
        for (int i = 0; i < c.length; ++i) {
            if (!(c[i] instanceof JToolBar)) continue;
            toolbar = true;
            break;
        }
        SGDialog dialog = toolbar ? new SGDialog(parent, title, panel, apply){

            @Override
            public Insets getInsets() {
                Insets insets = super.getInsets();
                insets.top = 0;
                return insets;
            }
        } : new SGDialog(parent, title, panel, apply);
        dialog.pack();
        if (loc != null) {
            dialog.setLocation(loc);
        }
        dialog.setVisible(true);
        int value = dialog.getValue();
        return value;
    }

    public static int showInputDialog(JFrame parent, String title, JPanel panel) {
        return SGDialog.showInputDialog(parent, title, panel, (Point)null);
    }

    public static int showInputDialog(JFrame parent, String title, JPanel panel, Point loc) {
        SGDialog dialog;
        Component[] c = panel.getComponents();
        boolean toolbar = false;
        for (int i = 0; i < c.length; ++i) {
            if (!(c[i] instanceof JToolBar)) continue;
            toolbar = true;
            break;
        }
        if (toolbar) {
            dialog = new SGDialog(parent, title, panel, null){

                @Override
                public Insets getInsets() {
                    Insets insets = super.getInsets();
                    insets.top -= (int)(1.5 * (double)insets.bottom);
                    return insets;
                }
            };
            for (int i = 0; i < c.length; ++i) {
                if (c[i] instanceof JToolBar) continue;
                c[i].requestFocusInWindow();
                break;
            }
        } else {
            dialog = new SGDialog(parent, title, panel, null);
        }
        if (loc != null) {
            dialog.setLocation(loc);
        }
        dialog.setVisible(true);
        int value = dialog.getValue();
        return value;
    }

    class ApplyListener
    implements ChangeListener {
        ApplyListener() {
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            if (SGDialog.this.applyButton != null) {
                SGDialog.this.applyButton.setEnabled(SGDialog.this.apply.isModified());
            }
        }
    }
}

