/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.styles.ui;

import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.styles.Style;
import com.sas.graphics.styles.StyleCollection;
import com.sas.graphics.styles.ui.DefaultStylePreview;
import com.sas.graphics.styles.ui.GraphStyleEditorDialog;
import com.sas.graphics.styles.ui.StyleSelectorCombo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JPanel;

public class StylePreviewPanel
extends JPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = -4549874398039227118L;
    private JPanel jPanel = null;
    private StyleSelectorCombo styleSelectorCombo = null;
    private JPanel jPanel1 = null;
    private JButton jButton = null;
    private DefaultStylePreview defaultStylePreview = null;
    private GraphStyleEditorDialog dialog = null;
    private StyleCollection styles = null;
    private boolean allowEdit = true;
    ResourceBundle rb = ResourceLoader.loadBundle("com.sas.graphics.silk.ui.silk_ui_NLS");

    public StylePreviewPanel() {
        this(new StyleCollection(true));
    }

    public StylePreviewPanel(StyleCollection styleCollection) {
        this(styleCollection, true);
    }

    public StylePreviewPanel(StyleCollection styleCollection, boolean allowStyleEditing) {
        this.allowEdit = allowStyleEditing;
        this.styles = styleCollection;
        this.styles.addChangeListener((PropertyChangeListener)this);
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(208, 231);
        this.add((Component)this.getJPanel(), "North");
        if (this.allowEdit) {
            this.add((Component)this.getJPanel1(), "South");
        }
        this.add((Component)this.getDefaultStylePreview(), "Center");
        this.styleSelectorCombo.setSelectedItem(this.styles.getCurrentStyle());
        this.defaultStylePreview.setStyle(this.styles.getCurrentStyle());
    }

    public void reload() {
        this.styleSelectorCombo.setSelectedItem(this.styles.getCurrentStyle());
        this.defaultStylePreview.setStyle(this.styles.getCurrentStyle());
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new FlowLayout(2));
            this.jPanel.add(this.getStyleSelectorCombo());
        }
        return this.jPanel;
    }

    public StyleSelectorCombo getStyleSelectorCombo() {
        if (this.styleSelectorCombo == null) {
            this.styleSelectorCombo = new StyleSelectorCombo(this.styles);
            this.styleSelectorCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    StylePreviewPanel.this.defaultStylePreview.setStyle((Style)StylePreviewPanel.this.styleSelectorCombo.getSelectedItem());
                }
            });
        }
        return this.styleSelectorCombo;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            this.jPanel1 = new JPanel();
            this.jPanel1.setLayout(new FlowLayout(1));
            this.jPanel1.add(this.getJButton());
        }
        return this.jPanel1;
    }

    private JButton getJButton() {
        if (this.jButton == null) {
            this.jButton = new JButton();
            this.jButton.setText(ResourceLoader.getResourceString(this.rb, "GraphPanel.Edit_Style.txt", "Edit Style..."));
            this.jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StylePreviewPanel.this.getStyleEditor().setSelectedStyle(StylePreviewPanel.this.styleSelectorCombo.getSelectedStyle());
                    StylePreviewPanel.this.getStyleEditor().setVisible(true);
                    StylePreviewPanel.this.styleSelectorCombo.setSelectedItem(StylePreviewPanel.this.getStyleEditor().getSelectedStyle());
                    StylePreviewPanel.this.defaultStylePreview.setStyle(StylePreviewPanel.this.styles.getCurrentStyle());
                }
            });
        }
        return this.jButton;
    }

    public GraphStyleEditorDialog getStyleEditor() {
        if (this.dialog == null) {
            Dialog parentDialog = StylePreviewPanel.getParentDialog(this);
            this.dialog = parentDialog != null ? new GraphStyleEditorDialog(this.styles, parentDialog) : new GraphStyleEditorDialog(this.styles, StylePreviewPanel.getParentDialog(this));
        }
        return this.dialog;
    }

    public static Frame getParentFrame(Component c) {
        Container parent;
        for (parent = c.getParent(); parent != null && !(parent instanceof Frame); parent = parent.getParent()) {
        }
        return (Frame)parent;
    }

    public static Dialog getParentDialog(Component c) {
        Container parent;
        for (parent = c.getParent(); parent != null && !(parent instanceof Dialog); parent = parent.getParent()) {
        }
        return (Dialog)parent;
    }

    private DefaultStylePreview getDefaultStylePreview() {
        if (this.defaultStylePreview == null) {
            this.defaultStylePreview = new DefaultStylePreview();
            this.defaultStylePreview.setRampPreviewVisible(false);
        }
        return this.defaultStylePreview;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("currentStyleChanged".equals(evt.getPropertyName())) {
            this.styleSelectorCombo.setSelectedItem(this.styles.getCurrentStyle());
            this.defaultStylePreview.setStyle(this.styles.getCurrentStyle());
        }
    }
}

