/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.styles.ui;

import com.sas.graphics.styles.StyleElement;
import com.sas.graphics.styles.ui.Messages;
import com.sas.graphics.util.HTMLColors;
import java.awt.Color;
import java.util.EventListener;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class StyleElementTableModel
implements TableModel {
    private StyleElement element = null;
    private EventListenerList listeners = null;
    private Vector attributes = new Vector();
    private boolean changed = false;
    private String[] supportedAttributes = new String[]{"color", "altColor", "markerSymbol", "markerSize", "lineStyle", "lineThickness", "transparency", "textColor", "displayOpts", "fontFamily", "fontSize", "fontStyle", "fontWeight", "fillGradientStartColor", "fillGradientNeutralColor", "fillGradientEndColor"};

    public void setElement(StyleElement se) {
        this.changed = false;
        this.element = se;
        if (this.element == null) {
            return;
        }
        if (!se.hasAttribute("color") && se.hasAttribute("fillColor")) {
            se.setAttribute("color", se.getAttribute("fillColor"));
        }
        if (!se.hasAttribute("altColor") && se.hasAttribute("markerColor")) {
            se.setAttribute("altColor", se.getAttribute("markerColor"));
        }
        if (!se.hasAttribute("altColor") && se.hasAttribute("lineColor")) {
            se.setAttribute("altColor", se.getAttribute("lineColor"));
        }
        this.attributes.clear();
        for (int i = 0; i < this.supportedAttributes.length; ++i) {
            if (!this.element.hasAttribute(this.supportedAttributes[i])) continue;
            this.attributes.addElement(this.supportedAttributes[i]);
        }
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        if (l == null) {
            return;
        }
        if (this.listeners == null) {
            this.listeners = new EventListenerList();
        }
        this.listeners.add(TableModelListener.class, l);
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return String.class;
        }
        if (columnIndex == 1) {
            return Object.class;
        }
        return null;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return Messages.getString("EditorPanel.35.txt");
        }
        if (columnIndex == 1) {
            return Messages.getString("EditorPanel.34.txt");
        }
        return "";
    }

    @Override
    public int getRowCount() {
        return this.attributes.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.attributes.elementAt(rowIndex);
        }
        if (columnIndex == 1) {
            return this.element.getAttribute(this.attributes.elementAt(rowIndex).toString());
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (this.element.isReadOnly()) {
            return false;
        }
        return columnIndex == 1;
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        if (l == null || this.listeners == null) {
            return;
        }
        this.listeners.remove(TableModelListener.class, l);
    }

    @Override
    public void setValueAt(Object arg0, int arg1, int arg2) {
        String value = null;
        if (arg0 == null) {
            return;
        }
        value = arg0 instanceof Color ? HTMLColors.getColorString((Color)((Color)arg0)) : arg0.toString();
        String attribute = this.getValueAt(arg1, 0).toString();
        this.element.setAttribute(attribute, value);
        this.changed = true;
        EventListener[] list = this.listeners.getListeners(TableModelListener.class);
        for (int i = 0; i < list.length; ++i) {
            ((TableModelListener)list[i]).tableChanged(new TableModelEvent(this));
        }
    }

    public boolean isModified() {
        return this.changed;
    }
}

