/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.styles.ui;

import com.sas.graphics.styles.StyleElement;
import com.sas.graphics.styles.StyleUtils;
import com.sas.graphics.styles.ui.ColorRenderer;
import com.sas.graphics.styles.ui.LineStyleRenderer;
import com.sas.graphics.styles.ui.MarkerSymbolRenderer;
import com.sas.graphics.styles.ui.Messages;
import com.sas.graphics.styles.ui.StyleElementTableModel;
import com.sas.graphics.styles.ui.swatch.SwatchComboBox;
import com.sas.graphics.styles.ui.swatch.SwatchRenderer;
import com.sas.graphics.styles.ui.swatch.UIUtil;
import com.sas.graphics.util.FontManager;
import com.sas.graphics.util.HTMLColors;
import com.sas.graphics.util.Markers;
import com.sas.graphics.util.SASLinePatterns;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class StyleElementEditorPanel
extends JPanel
implements TableCellRenderer {
    private static final long serialVersionUID = 8603493780656699241L;
    private TableCellRenderer defaultRenderer = null;
    private ColorRenderer colorRenderer = null;
    private LineStyleRenderer lineRenderer = null;
    private MarkerSymbolRenderer markerRenderer = null;
    private CellEditor cellEditor = null;
    private JScrollPane jScrollPane = null;
    private JTable jTable = null;
    private EventListenerList propertyChangeListeners = new EventListenerList();
    private StyleElementTableModel model = new StyleElementTableModel();
    private StyleElementEditorPanel instance = this;

    public StyleElementEditorPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setSize(300, 400);
        this.setLayout(new BorderLayout());
        this.add((Component)this.getJScrollPane(), "Center");
        this.defaultRenderer = new DefaultTableCellRenderer();
        ((JComponent)((Object)this.defaultRenderer)).putClientProperty(new StringBuffer("AATextPropertyKey"), Boolean.TRUE);
        this.colorRenderer = new ColorRenderer();
        this.lineRenderer = new LineStyleRenderer();
        this.markerRenderer = new MarkerSymbolRenderer();
        this.cellEditor = new CellEditor();
        this.model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                StyleElementEditorPanel.this.firePropertyChangeEvent();
            }
        });
    }

    public void setStyleElement(StyleElement element) {
        this.model.setElement(element);
        this.getJTable().tableChanged(new TableModelEvent(this.model));
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setPreferredSize(new Dimension(250, 80));
            this.jScrollPane.setBackground(Color.white);
            this.jScrollPane.setViewportView(this.getJTable());
        }
        return this.jScrollPane;
    }

    private JTable getJTable() {
        if (this.jTable == null) {
            this.jTable = new JTable();
            this.jTable.setModel(this.model);
            this.jTable.setTableHeader(null);
            this.jTable.setSelectionMode(0);
            this.jTable.setRowHeight(32);
            TableColumn tc = this.jTable.getColumn(Messages.getString("EditorPanel.34.txt"));
            tc.setCellRenderer(this);
            tc.setCellEditor(this.getCellEditor());
            tc = this.jTable.getColumn(Messages.getString("EditorPanel.35.txt"));
            tc.setCellRenderer(this);
            this.jTable.setShowGrid(false);
        }
        return this.jTable;
    }

    private CellEditor getCellEditor() {
        if (this.cellEditor == null) {
            this.cellEditor = new CellEditor();
        }
        return this.cellEditor;
    }

    @Override
    public Component getTableCellRendererComponent(JTable arg0, Object arg1, boolean arg2, boolean arg3, int arg4, int arg5) {
        if (arg5 == 0) {
            Component defaultComponent = this.defaultRenderer.getTableCellRendererComponent(arg0, StyleUtils.getAttributeDisplayName((String)arg1.toString()), false, false, arg4, arg5);
            return defaultComponent;
        }
        String name = this.model.getValueAt(arg4, 0).toString();
        Component defaultComponent = this.defaultRenderer.getTableCellRendererComponent(arg0, arg1, false, arg3, arg4, arg5);
        if (name.equalsIgnoreCase("color") || name.equalsIgnoreCase("altColor") || name.equalsIgnoreCase("textColor") || name.equalsIgnoreCase("lineColor") || name.equalsIgnoreCase("markerColor") || name.equalsIgnoreCase("fillColor") || name.equalsIgnoreCase("shadowColor") || name.equalsIgnoreCase("fillGradientStartColor") || name.equalsIgnoreCase("fillGradientNeutralColor") || name.equalsIgnoreCase("fillGradientEndColor")) {
            this.colorRenderer.setColor(HTMLColors.getInstance().getColor(arg1.toString()));
            this.colorRenderer.setBackground(defaultComponent.getBackground());
            return this.colorRenderer;
        }
        if (name.equalsIgnoreCase("lineStyle") || name.equalsIgnoreCase("linePattern")) {
            this.lineRenderer.setLineStyle(Integer.valueOf(arg1.toString()));
            this.lineRenderer.setBackground(defaultComponent.getBackground());
            return this.lineRenderer;
        }
        if (name.equalsIgnoreCase("markerSymbol")) {
            this.markerRenderer.setMarkerSymbol(Markers.getShape((String)arg1.toString()));
            this.markerRenderer.setBackground(defaultComponent.getBackground());
            return this.markerRenderer;
        }
        return defaultComponent;
    }

    public boolean isModified() {
        return this.model.isModified();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners.add(PropertyChangeListener.class, listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners.remove(PropertyChangeListener.class, listener);
    }

    private void firePropertyChangeEvent() {
        PropertyChangeEvent event = new PropertyChangeEvent(this, "MODIFIED", null, null);
        EventListener[] arr = this.propertyChangeListeners.getListeners(PropertyChangeListener.class);
        for (int i = 0; i < arr.length; ++i) {
            ((PropertyChangeListener)arr[i]).propertyChange(event);
        }
    }

    class CellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    CellEditorListener {
        private static final long serialVersionUID = -7665301227081453171L;
        private Object currentEditor = null;
        private DefaultCellEditor defaultEditor = new DefaultCellEditor(new JTextField());
        private DefaultCellEditor markerEditor = null;
        private DefaultCellEditor lineEditor = new DefaultCellEditor(new JComboBox());
        private DefaultCellEditor fontFamilyEditor = new DefaultCellEditor(new JComboBox());
        private DefaultCellEditor colorEditor = null;
        private SwatchComboBox colorCombo = null;
        private SwatchComboBox markerCombo = null;
        JColorChooser colorChooser = new JColorChooser();
        JDialog colorDialog = null;

        public CellEditor() {
            int i;
            this.colorCombo = new SwatchComboBox(UIUtil.getColors(), 8, 4, null, null, null, Messages.getString("More.txt"));
            this.colorCombo.setRenderer(new SwatchRenderer());
            this.colorCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getID() == 2) {
                        CellEditor.this.getColorDialog().setVisible(true);
                        CellEditor.this.colorCombo.setSelectedItem(CellEditor.this.colorChooser.getColor());
                    }
                }
            });
            this.colorCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (CellEditor.this.colorCombo.getSelectedItem() != null) {
                        CellEditor.this.stopCellEditing();
                    }
                }
            });
            this.colorEditor = new DefaultCellEditor(this.colorCombo);
            String[] markerStrings = UIUtil.getMarkers();
            Object[] markerList = new Integer[markerStrings.length];
            for (i = 0; i < markerList.length; ++i) {
                markerList[i] = new Integer(Markers.getShape((String)markerStrings[i]));
            }
            this.markerCombo = new SwatchComboBox(markerList, 6, 4, null, null, null);
            this.markerCombo.setRenderer(new MarkerListCellRenderer());
            this.markerCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (CellEditor.this.markerCombo.getSelectedItem() != null) {
                        CellEditor.this.stopCellEditing();
                    }
                }
            });
            this.markerEditor = new DefaultCellEditor(this.markerCombo);
            ((JComboBox)this.lineEditor.getComponent()).setBackground(Color.WHITE);
            ((JComboBox)this.lineEditor.getComponent()).setRenderer(new LineListCellRenderer());
            for (i = 1; i < SASLinePatterns.getPatternCount(); ++i) {
                ((JComboBox)this.lineEditor.getComponent()).addItem(new Integer(i));
            }
            ((JComboBox)this.fontFamilyEditor.getComponent()).setBackground(Color.WHITE);
            ((JComboBox)this.fontFamilyEditor.getComponent()).setFont(FontManager.getFont((String)"Arial", (int)0, (int)12));
            String[] ff = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
            for (int i2 = 0; i2 < ff.length; ++i2) {
                ((JComboBox)this.fontFamilyEditor.getComponent()).addItem(ff[i2]);
            }
            this.lineEditor.addCellEditorListener(this);
            this.fontFamilyEditor.addCellEditorListener(this);
        }

        @Override
        public Component getTableCellEditorComponent(JTable arg0, Object arg1, boolean arg2, int arg3, int arg4) {
            String name = StyleElementEditorPanel.this.model.getValueAt(arg3, 0).toString();
            if (name.equalsIgnoreCase("color") || name.equalsIgnoreCase("altColor") || name.equalsIgnoreCase("textColor") || name.equalsIgnoreCase("lineColor") || name.equalsIgnoreCase("markerColor") || name.equalsIgnoreCase("fillColor") || name.equalsIgnoreCase("shadowColor") || name.equalsIgnoreCase("fillGradientStartColor") || name.equalsIgnoreCase("fillGradientNeutralColor") || name.equalsIgnoreCase("fillGradientEndColor")) {
                this.currentEditor = this.colorEditor;
                return this.colorEditor.getTableCellEditorComponent(arg0, HTMLColors.getInstance().getColor(arg1.toString()), arg2, arg3, arg4);
            }
            if (name.equalsIgnoreCase("markerSymbol")) {
                this.currentEditor = this.markerEditor;
                return this.markerEditor.getTableCellEditorComponent(arg0, new Integer(Markers.getShape((String)((String)arg1))), arg2, arg3, arg4);
            }
            if (name.equalsIgnoreCase("lineStyle") || name.equalsIgnoreCase("linePattern")) {
                this.currentEditor = this.lineEditor;
                return this.lineEditor.getTableCellEditorComponent(arg0, arg1, arg2, arg3, arg4);
            }
            if (name.equalsIgnoreCase("fontFamily")) {
                this.currentEditor = this.fontFamilyEditor;
                return this.fontFamilyEditor.getTableCellEditorComponent(arg0, arg1, arg2, arg3, arg4);
            }
            this.currentEditor = this.defaultEditor;
            return this.defaultEditor.getTableCellEditorComponent(arg0, arg1, arg2, arg3, arg4);
        }

        @Override
        public Object getCellEditorValue() {
            if (this.currentEditor == this.markerEditor) {
                return Markers.getShapeName((int)((Integer)this.markerEditor.getCellEditorValue()));
            }
            if (this.currentEditor == this.lineEditor) {
                return (Integer)this.lineEditor.getCellEditorValue();
            }
            if (this.currentEditor == this.colorEditor) {
                Object obj = this.colorCombo.getSelectedItem();
                return obj;
            }
            if (this.currentEditor instanceof DefaultCellEditor) {
                return ((DefaultCellEditor)this.currentEditor).getCellEditorValue();
            }
            return null;
        }

        private JDialog getColorDialog() {
            if (this.colorDialog == null) {
                this.colorDialog = JColorChooser.createDialog(StyleElementEditorPanel.this.instance, Messages.getString("EditorPanel.46.txt"), true, this.colorChooser, null, null);
            }
            return this.colorDialog;
        }

        @Override
        public void editingCanceled(ChangeEvent e) {
            this.fireEditingCanceled();
        }

        @Override
        public void editingStopped(ChangeEvent e) {
            this.fireEditingStopped();
        }

        class LineListCellRenderer
        implements ListCellRenderer {
            LineStyleRenderer renderer = new LineStyleRenderer();

            LineListCellRenderer() {
            }

            public Component getListCellRendererComponent(JList arg0, Object arg1, int arg2, boolean arg3, boolean arg4) {
                this.renderer.setLineStyle(arg1 == null ? 1 : (Integer)arg1);
                this.renderer.setPreferredSize(new Dimension(85, 35));
                return this.renderer;
            }
        }

        class MarkerListCellRenderer
        implements ListCellRenderer {
            MarkerSymbolRenderer renderer = new MarkerSymbolRenderer();

            MarkerListCellRenderer() {
            }

            public Component getListCellRendererComponent(JList arg0, Object arg1, int arg2, boolean arg3, boolean arg4) {
                this.renderer.setMarkerSymbol((Integer)arg1);
                this.renderer.setPreferredSize(new Dimension(85, 35));
                return this.renderer;
            }
        }
    }
}

