/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.styles.ui;

import com.sas.graphics.util.SASLinePatterns;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class LineStyleRenderer
extends JPanel {
    private static final long serialVersionUID = 2531906595252831074L;
    private LineRenderer lineRenderer = new LineRenderer();

    public LineStyleRenderer() {
        this.initialize();
    }

    public void setLineStyle(int style) {
        this.lineRenderer.setLineStyle(style);
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(231, 53);
        this.setBackground(Color.white);
        this.setOpaque(true);
        this.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.add("Center", this.lineRenderer);
    }

    class LineRenderer
    extends JComponent {
        private static final long serialVersionUID = -6953692105344779603L;
        int lineStyle = 1;

        public LineRenderer() {
            this.setOpaque(false);
        }

        public void setLineStyle(int style) {
            this.lineStyle = style;
        }

        @Override
        protected void paintComponent(Graphics g) {
            BasicStroke bs = SASLinePatterns.getStroke((int)this.lineStyle, (int)1);
            Graphics2D g2 = (Graphics2D)g;
            g2.setStroke(bs);
            g.drawLine(0, this.getHeight() / 2, this.getWidth(), this.getHeight() / 2);
        }
    }
}

