/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.styles.ui;

import com.sas.graphics.styles.Style;
import com.sas.graphics.styles.StyleCollection;
import com.sas.graphics.styles.StyleUtils;
import com.sas.graphics.styles.ui.GraphStyleEditor;
import com.sas.graphics.styles.ui.Messages;
import com.sas.graphics.styles.ui.SingleDirectoryStyleChooser;
import com.sas.graphics.styles.ui.StyleSelectorCombo;
import com.sas.graphics.util.FontManager;
import com.sas.iom.SAS.ILanguageServicePackage.CarriageControlSeqHolder;
import com.sas.iom.SAS.ILanguageServicePackage.LineTypeSeqHolder;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import com.sas.iom.WorkspaceConnector;
import com.sas.iom.WorkspaceFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.basic.BasicToolBarUI;

public class GraphStyleEditorDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private StyleCollection styles = null;
    private String dialogFontFace = Messages.getString("DialogFont.fnt");
    private JToolBar toolbarPanel = null;
    private JPanel buttonPanel = null;
    private GraphStyleEditor styleEditor = null;
    private StyleSelectorCombo styleSelector = null;
    private JButton openButton = null;
    private JButton cancelButton = null;
    private JButton saveButton = null;
    private JButton saveAsButton = null;
    private Action saveAction = null;
    private Action saveAsAction = null;
    private Action cancelAction = null;
    private JFileChooser fileChooser = null;
    private FileFilter styleFileFilter = null;
    private boolean allowOpenStyle = false;
    private boolean allowFileSystemNavigation = false;
    private File homeDirectory = null;
    private SingleDirectoryStyleChooser singleDirFileChooser = null;
    private Vector actionListeners = null;
    public static final int CANCEL = 0;
    public static final int SAVE = 1;
    public static final int SAVE_AS = 2;
    public static final int SELECTED_STYLE = 3;

    public GraphStyleEditorDialog() {
        this.init(new StyleCollection());
    }

    public GraphStyleEditorDialog(StyleCollection collection, Frame frame) {
        super(frame);
        this.init(collection);
    }

    public GraphStyleEditorDialog(StyleCollection collection, Dialog frame) {
        super(frame);
        this.init(collection);
    }

    private void init(StyleCollection collection) {
        this.styles = collection;
        this.homeDirectory = new File(System.getProperty("user.home"));
        this.setLayout(new BorderLayout());
        JPanel contents = new JPanel();
        contents.setBorder(BorderFactory.createEmptyBorder(17, 17, 17, 17));
        contents.setLayout(new BorderLayout());
        this.add((Component)contents, "Center");
        contents.add((Component)this.getToolbarPanel(), "North");
        contents.add((Component)this.getStyleEditor(), "Center");
        contents.add((Component)this.getButtonPanel(), "South");
        this.pack();
        this.setLocationRelativeTo(null);
        this.setModal(true);
        this.getStyleEditor().setStyle(this.styles.getCurrentStyle());
        this.getSaveButton().setEnabled(this.styles.getCurrentStyle() != null && !this.styles.getCurrentStyle().isReadOnly());
        Style style = (Style)this.styleSelector.getSelectedItem();
        this.setTitle(Messages.getString("DialogTitle.txt") + " - " + style.getDisplayName());
    }

    private JToolBar getToolbarPanel() {
        if (this.toolbarPanel == null) {
            this.toolbarPanel = new JToolBar();
            this.toolbarPanel.setFloatable(false);
            BasicToolBarUI ui = new BasicToolBarUI();
            this.toolbarPanel.setUI(ui);
            JLabel label = new JLabel(Messages.getString("Style.txt"));
            label.putClientProperty(new StringBuffer("AATextPropertyKey"), Boolean.TRUE);
            label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 7));
            label.setFont(FontManager.getFont((String)this.dialogFontFace, (int)0, (int)12));
            this.toolbarPanel.add(label);
            this.toolbarPanel.setRollover(true);
            this.toolbarPanel.add(this.getStyleSelector());
            this.toolbarPanel.add(Box.createRigidArea(new Dimension(7, 7)));
            this.toolbarPanel.add(this.getOpenButton());
        }
        return this.toolbarPanel;
    }

    private JButton getOpenButton() {
        if (this.openButton == null) {
            this.openButton = new JButton();
            this.openButton.setIcon(new ImageIcon(this.getClass().getResource("/com/sas/graphics/styles/ui/FolderOpen.gif")));
            this.openButton.setContentAreaFilled(false);
            this.openButton.setRolloverEnabled(true);
            this.openButton.setFocusPainted(false);
            this.openButton.setVisible(this.allowOpenStyle);
        }
        return this.openButton;
    }

    private StyleSelectorCombo getStyleSelector() {
        if (this.styleSelector == null) {
            this.styleSelector = new StyleSelectorCombo(this.styles);
            this.styleSelector.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    Style style = (Style)GraphStyleEditorDialog.this.styleSelector.getSelectedItem();
                    GraphStyleEditorDialog.this.getSaveButton().setEnabled(!style.isReadOnly());
                    GraphStyleEditorDialog.this.getStyleEditor().setStyle(style);
                    GraphStyleEditorDialog.this.setTitle(Messages.getString("DialogTitle.txt") + " - " + style.getDisplayName());
                    GraphStyleEditorDialog.this.fireActionEvent(3, "SelectedStyle");
                }
            });
            this.styleSelector.setPreferredSize(new Dimension(192, 25));
            this.styleSelector.setMaximumSize(new Dimension(192, 25));
        }
        return this.styleSelector;
    }

    public void setSelectedStyle(Style style) {
        this.getStyleSelector().setSelectedItem(style);
    }

    public Style getSelectedStyle() {
        return (Style)this.getStyleSelector().getSelectedItem();
    }

    public GraphStyleEditor getStyleEditor() {
        if (this.styleEditor == null) {
            this.styleEditor = new GraphStyleEditor();
            this.styleEditor.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    Style style = (Style)GraphStyleEditorDialog.this.styleSelector.getSelectedItem();
                    GraphStyleEditorDialog.this.setTitle(Messages.getString("DialogTitle.txt") + " - " + style.getDisplayName() + " *");
                }
            });
        }
        return this.styleEditor;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(new FlowLayout(2));
            this.buttonPanel.add(this.getSaveButton());
            this.buttonPanel.add(this.getSaveAsButton());
            this.buttonPanel.add(this.getCancelButton());
        }
        return this.buttonPanel;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton(this.getCancelAction());
            this.cancelButton.putClientProperty(new StringBuffer("AATextPropertyKey"), Boolean.TRUE);
            this.cancelButton.setFont(FontManager.getFont((String)this.dialogFontFace, (int)0, (int)12));
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GraphStyleEditorDialog.this.setVisible(false);
                }
            });
        }
        return this.cancelButton;
    }

    private JButton getSaveButton() {
        if (this.saveButton == null) {
            this.saveButton = new JButton(this.getSaveAction());
            this.saveButton.putClientProperty(new StringBuffer("AATextPropertyKey"), Boolean.TRUE);
            this.saveButton.setFont(FontManager.getFont((String)this.dialogFontFace, (int)0, (int)12));
        }
        return this.saveButton;
    }

    private JButton getSaveAsButton() {
        if (this.saveAsButton == null) {
            this.saveAsButton = new JButton(this.getSaveAsAction());
            this.saveAsButton.putClientProperty(new StringBuffer("AATextPropertyKey"), Boolean.TRUE);
            this.saveAsButton.setFont(FontManager.getFont((String)this.dialogFontFace, (int)0, (int)12));
        }
        return this.saveAsButton;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        StyleCollection sc = null;
        if (args != null && args.length >= 2) {
            String host = args[0];
            String port = args[1];
            sc = GraphStyleEditorDialog.getAllSASStyles(host, port, new File("C:/temp/styletemp/"));
        }
        if (sc == null) {
            sc = new StyleCollection(true);
        }
        GraphStyleEditorDialog editor = new GraphStyleEditorDialog(sc, new JFrame());
        editor.setVisible(true);
    }

    private static StyleCollection getAllSASStyles(String host, String port, File tempDir) {
        StyleCollection rc = null;
        Properties[] p = new Properties[]{new Properties()};
        p[0].put("host", host);
        p[0].put("port", port);
        try {
            WorkspaceFactory wFactory = new WorkspaceFactory(p, null, null);
            WorkspaceConnector connector = wFactory.getWorkspaceConnector(0L);
            IWorkspace workspace = connector.getWorkspace();
            if (!tempDir.exists()) {
                tempDir.mkdirs();
            }
            String pgmloc = "/com/sas/graphics/styles/ui/dumpAllStyles.txt";
            InputStream is = GraphStyleEditorDialog.class.getResourceAsStream(pgmloc);
            StringBuffer pgm = new StringBuffer();
            boolean eof = false;
            while (!eof) {
                int size = is.available();
                byte[] data = new byte[size];
                int numRead = is.read(data);
                if (numRead <= 0) {
                    eof = true;
                    continue;
                }
                String str = new String(data, 0, numRead);
                pgm.append(str);
            }
            int index = pgm.indexOf("__TEMPPATH__");
            if (index >= 0) {
                pgm.replace(index, index + 12, tempDir.getAbsolutePath());
            }
            workspace.LanguageService().Submit(pgm.toString());
            CarriageControlSeqHolder ccsh = new CarriageControlSeqHolder();
            LineTypeSeqHolder ltsh = new LineTypeSeqHolder();
            StringSeqHolder ssh = new StringSeqHolder();
            workspace.LanguageService().FlushLogLines(Integer.MAX_VALUE, ccsh, ltsh, ssh);
            String[] strs = ssh.value;
            for (int i = 0; i < strs.length; ++i) {
                System.out.println(strs[i]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        rc = new StyleCollection();
        try {
            File[] files = tempDir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].getAbsolutePath().endsWith(".xml")) continue;
                rc.addStyle(Style.getStyle((InputStream)new FileInputStream(files[i])));
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return rc;
    }

    public Action getSaveAction() {
        if (this.saveAction == null) {
            this.saveAction = new SaveAction();
        }
        return this.saveAction;
    }

    public Action getSaveAsAction() {
        if (this.saveAsAction == null) {
            this.saveAsAction = new SaveAsAction();
        }
        return this.saveAsAction;
    }

    public Action getCancelAction() {
        if (this.cancelAction == null) {
            this.cancelAction = new CancelAction();
        }
        return this.cancelAction;
    }

    public boolean isAllowFileSystemNavigation() {
        return this.allowFileSystemNavigation;
    }

    public void setAllowFileSystemNavigation(boolean allowFileSystemNavigation) {
        this.allowFileSystemNavigation = allowFileSystemNavigation;
        this.fileChooser = null;
    }

    public File showSaveDialog() {
        File rc = null;
        if (this.allowFileSystemNavigation) {
            int result;
            if (this.fileChooser == null) {
                this.fileChooser = new JFileChooser();
                this.fileChooser.setAcceptAllFileFilterUsed(false);
                this.fileChooser.setFileFilter(this.getStyleFileFilter());
            }
            if ((result = this.fileChooser.showSaveDialog(this.getContentPane())) == 0) {
                rc = this.fileChooser.getSelectedFile();
            }
        } else {
            int result;
            if (this.singleDirFileChooser == null) {
                this.singleDirFileChooser = new SingleDirectoryStyleChooser();
                this.singleDirFileChooser.setDirectory(this.homeDirectory);
                this.singleDirFileChooser.setFileFilter(this.getStyleFileFilter());
            }
            if ((result = this.singleDirFileChooser.showSaveDialog(this.getContentPane())) == 0) {
                rc = this.singleDirFileChooser.getSelectedXMLFile();
            }
        }
        return rc;
    }

    public FileFilter getStyleFileFilter() {
        if (this.styleFileFilter == null) {
            this.styleFileFilter = new StyleFileFilter();
        }
        return this.styleFileFilter;
    }

    public File getHomeDirectory() {
        return this.homeDirectory;
    }

    public void setHomeDirectory(File homeDirectory) {
        this.homeDirectory = homeDirectory;
        if (homeDirectory != null && !homeDirectory.exists()) {
            homeDirectory.mkdirs();
        }
    }

    public boolean isAllowOpenStyle() {
        return this.allowOpenStyle;
    }

    public void setAllowOpenStyle(boolean allowOpenStyle) {
        this.allowOpenStyle = allowOpenStyle;
        this.getOpenButton().setVisible(allowOpenStyle);
    }

    public void addActionListener(ActionListener al) {
        if (al == null) {
            return;
        }
        if (this.actionListeners == null) {
            this.actionListeners = new Vector();
        }
        this.actionListeners.addElement(al);
    }

    public void removeActionListener(ActionListener al) {
        if (this.actionListeners == null || al == null || !this.actionListeners.contains(al)) {
            return;
        }
        this.actionListeners.removeElement(al);
    }

    private void fireActionEvent(int eventId, String command) {
        if (this.actionListeners == null || this.actionListeners.isEmpty()) {
            return;
        }
        ActionEvent ae = new ActionEvent(this, eventId, command);
        for (int i = 0; i < this.actionListeners.size(); ++i) {
            ((ActionListener)this.actionListeners.elementAt(i)).actionPerformed(ae);
        }
    }

    class StyleFileFilter
    extends FileFilter {
        StyleFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.getAbsolutePath().endsWith(".sty");
        }

        @Override
        public String getDescription() {
            return Messages.getString("FileFilter.Description.txt");
        }
    }

    class CancelAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CancelAction() {
            this.putValue("Name", Messages.getString("Cancel.txt"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GraphStyleEditorDialog.this.fireActionEvent(0, Messages.getString("Cancel.txt"));
            GraphStyleEditorDialog.this.setVisible(false);
        }
    }

    class SaveAsAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public SaveAsAction() {
            this.putValue("Name", Messages.getString("SaveAs.txt"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Style style = GraphStyleEditorDialog.this.getStyleEditor().getStyle();
            File file = GraphStyleEditorDialog.this.showSaveDialog();
            if (file == null) {
                return;
            }
            String filename = file.getAbsolutePath();
            if (filename.endsWith(".sty")) {
                filename = filename.substring(0, filename.length() - 4) + ".sas.";
            }
            File sasFile = new File(filename);
            String name = file.getName().substring(0, file.getName().lastIndexOf(46));
            style.setParent(style.getStyleName());
            style.setStyleName(name);
            style.setSchemeName(name);
            GraphStyleEditorDialog.this.styles.addStyle(style, (Object)file);
            GraphStyleEditorDialog.this.getStyleSelector().setSelectedItem(style);
            try {
                FileOutputStream xmlfos = new FileOutputStream(file);
                FileOutputStream sasfos = new FileOutputStream(sasFile);
                StringBuffer sb = StyleUtils.getStyleAsSASCode((Style)style, null);
                sasfos.write(sb.toString().getBytes());
                style.toOutputStream((OutputStream)xmlfos);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            GraphStyleEditorDialog.this.fireActionEvent(2, Messages.getString("SaveAs.txt"));
        }
    }

    class SaveAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public SaveAction() {
            this.putValue("Name", Messages.getString("Save.txt"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int index = GraphStyleEditorDialog.this.styleSelector.getSelectedIndex();
            Object source = GraphStyleEditorDialog.this.styles.getStyleSource(index);
            Style style = GraphStyleEditorDialog.this.getStyleEditor().getStyle();
            File file = null;
            file = source instanceof File ? (File)source : GraphStyleEditorDialog.this.showSaveDialog();
            if (file == null) {
                return;
            }
            String path = file.getAbsolutePath();
            if (path.endsWith(".sty")) {
                path = path.substring(0, path.length() - 4) + ".sas";
            }
            File sasFile = new File(path);
            try {
                FileOutputStream xmlfos = new FileOutputStream(file);
                FileOutputStream sasfos = new FileOutputStream(sasFile);
                StringBuffer sb = StyleUtils.getStyleAsSASCode((Style)style, null);
                sasfos.write(sb.toString().getBytes());
                style.toOutputStream((OutputStream)xmlfos);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            style.copyInto(GraphStyleEditorDialog.this.styles.getStyleAt(index));
            GraphStyleEditorDialog.this.setTitle(Messages.getString("DialogTitle.txt") + " - " + style.getDisplayName());
            GraphStyleEditorDialog.this.fireActionEvent(1, Messages.getString("Save.txt"));
        }
    }
}

