/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.styles.ui;

import com.sas.graphics.styles.Style;
import com.sas.graphics.styles.StyleElement;
import com.sas.graphics.styles.StyleUtils;
import com.sas.graphics.styles.ui.DefaultBarPreview;
import com.sas.graphics.styles.ui.DefaultHistogramPreview;
import com.sas.graphics.styles.ui.DefaultStylePreview;
import com.sas.graphics.styles.ui.Messages;
import com.sas.graphics.styles.ui.StyleElementEditorPanel;
import com.sas.graphics.styles.ui.StylePreview;
import com.sas.graphics.util.FontManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.CompoundBorder;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class GraphStyleEditor
extends JComponent
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JList groupingList = null;
    private JScrollPane groupingScroll = null;
    private JPanel mainPane = null;
    private JLabel groupLabel = null;
    private JPanel groupEditorPane = null;
    private JPanel jPanel = null;
    private JPanel previewPanel = null;
    private JScrollPane elementsScroll = null;
    private JList elementsList = null;
    private JPanel editorPanel = null;
    private JLabel editorLabel = null;
    private StyleElementEditorPanel elementEditor = null;
    private JPanel previewSelectorPanel = null;
    private JComboBox previewCombo = null;
    private JPanel previewContainer = null;
    private String dialogFontFace = Messages.getString("DialogFont.fnt");
    private Style style = null;
    private Hashtable previews = new Hashtable();
    private Vector textElements = new Vector();
    private Vector plotElements = new Vector();
    private Vector specialElements = new Vector();
    private Vector fillElements = new Vector();
    private Vector rampElements = new Vector();
    private Vector lineElements = new Vector();
    private Vector otherElements = new Vector();
    private boolean styleModified = false;
    private EventListenerList propertyChangeListeners = new EventListenerList();

    public GraphStyleEditor() {
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(630, 341));
        this.setBorder(BorderFactory.createEmptyBorder(7, 0, 7, 0));
        this.add((Component)this.getGroupingPane(), "West");
        this.add((Component)this.getMainPane(), "Center");
    }

    public void setStyle(Style styleIn) {
        this.style = new Style(styleIn);
        Enumeration e = this.previews.elements();
        while (e.hasMoreElements()) {
            ((StylePreview)e.nextElement()).setStyle(this.style);
        }
        this.textElements.clear();
        this.plotElements.clear();
        this.specialElements.clear();
        this.fillElements.clear();
        this.rampElements.clear();
        this.lineElements.clear();
        this.otherElements.clear();
        if (this.style == null) {
            return;
        }
        StyleElement[] allElements = this.style.getAllStyleElements();
        for (int i = 0; i < allElements.length; ++i) {
            StyleElement current = allElements[i];
            if (StyleUtils.isTextContextName((String)current.getContextName())) {
                this.textElements.addElement(current.getAsTextStyle());
                continue;
            }
            if (StyleUtils.isFillContextName((String)current.getContextName())) {
                this.fillElements.addElement(current.getAsFillStyle());
                continue;
            }
            if (StyleUtils.isRampContextName((String)current.getContextName())) {
                this.rampElements.addElement(current.getAsRampStyle());
                continue;
            }
            if (StyleUtils.isLineContextName((String)current.getContextName())) {
                this.lineElements.addElement(current.getAsLineStyle());
                continue;
            }
            if (this.isSpecialElement(current)) {
                this.specialElements.addElement(current);
                continue;
            }
            if (this.isPlotElement(current)) {
                this.plotElements.addElement(current.getAsDataStyle());
                continue;
            }
            this.otherElements.addElement(current);
        }
        Comparator comparator = new Comparator(){

            public int compare(Object arg0, Object arg1) {
                StyleElement se0 = (StyleElement)arg0;
                StyleElement se1 = (StyleElement)arg1;
                if (se0.getContextName().equalsIgnoreCase("GraphDataStyleDefault")) {
                    return -1;
                }
                if (se1.getContextName().equalsIgnoreCase("GraphDataStyleDefault")) {
                    return 1;
                }
                if (se0.getContextName().startsWith("GraphDataStyle") && se1.getContextName().startsWith("GraphDataStyle")) {
                    int num0 = -1;
                    int num1 = -1;
                    try {
                        num0 = Integer.parseInt(se0.getContextName().substring("GraphDataStyle".length()));
                        num1 = Integer.parseInt(se1.getContextName().substring("GraphDataStyle".length()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (num0 > 0 && num1 > 0) {
                        return num0 < num1 ? -1 : 1;
                    }
                }
                return se0.getDisplayName().compareTo(se1.getDisplayName());
            }
        };
        Collections.sort(this.textElements, comparator);
        Collections.sort(this.plotElements, comparator);
        Collections.sort(this.specialElements, comparator);
        Collections.sort(this.fillElements, comparator);
        Collections.sort(this.rampElements, comparator);
        Collections.sort(this.lineElements, comparator);
        Collections.sort(this.otherElements, comparator);
        this.groupingList.setSelectedIndex(1);
        this.elementsList.setSelectedIndex(0);
        this.getEditorLabel().setText(this.elementsList.getSelectedValue().toString());
        this.getEditor().setStyleElement((StyleElement)this.elementsList.getSelectedValue());
        this.repaint();
    }

    public Style getStyle() {
        return this.style;
    }

    private boolean isPlotElement(StyleElement element) {
        if (element == null) {
            return false;
        }
        String context = element.getContextName();
        if (context == null) {
            return false;
        }
        if ("GraphDataStyleDefault".equalsIgnoreCase(context)) {
            return true;
        }
        if (context.startsWith("GraphDataStyle")) {
            int num = -1;
            try {
                num = Integer.parseInt(context.substring("GraphDataStyle".length()));
            }
            catch (Exception e) {
                num = -1;
            }
            if (num > 0) {
                return true;
            }
        }
        return false;
    }

    private boolean isSpecialElement(StyleElement element) {
        return element.getContextName().startsWith("Box");
    }

    private JScrollPane getGroupingPane() {
        if (this.groupingList == null) {
            this.groupingList = new JList();
            this.groupingList.setFixedCellHeight(29);
            this.groupingList.setListData(new String[]{"Text", "Plot", "Special Plots", "Backgrounds", "Gradients", "Lines", "Others"});
            this.groupingList.setFont(FontManager.getFont((String)this.dialogFontFace, (int)0, (int)12));
            this.groupingList.setSelectionMode(0);
            this.groupingList.setCellRenderer(new ListCellRenderer(){
                DefaultListCellRenderer renderer = new DefaultListCellRenderer();

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    this.renderer.putClientProperty(new StringBuffer("AATextPropertyKey"), Boolean.TRUE);
                    Component c = this.renderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    this.renderer.setBorder(new CompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.gray), BorderFactory.createEmptyBorder(0, 5, 0, 0)));
                    return c;
                }
            });
            this.groupingList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    GraphStyleEditor.this.getGroupLabel().setText(GraphStyleEditor.this.groupingList.getSelectedValue().toString());
                    Vector elements = null;
                    switch (GraphStyleEditor.this.groupingList.getSelectedIndex()) {
                        case 0: {
                            elements = GraphStyleEditor.this.textElements;
                            break;
                        }
                        case 1: {
                            elements = GraphStyleEditor.this.plotElements;
                            break;
                        }
                        case 2: {
                            elements = GraphStyleEditor.this.specialElements;
                            break;
                        }
                        case 3: {
                            elements = GraphStyleEditor.this.fillElements;
                            break;
                        }
                        case 4: {
                            elements = GraphStyleEditor.this.rampElements;
                            break;
                        }
                        case 5: {
                            elements = GraphStyleEditor.this.lineElements;
                            break;
                        }
                        case 6: {
                            elements = GraphStyleEditor.this.otherElements;
                        }
                    }
                    GraphStyleEditor.this.elementsList.setListData(elements);
                    GraphStyleEditor.this.elementsList.setSelectedIndex(0);
                    GraphStyleEditor.this.getEditor().setStyleElement((StyleElement)GraphStyleEditor.this.elementsList.getSelectedValue());
                }
            });
            this.groupingScroll = new JScrollPane();
            this.groupingScroll.setViewportView(this.groupingList);
            this.groupingScroll.setPreferredSize(new Dimension(107, 100));
            this.groupingScroll.setBorder(BorderFactory.createLineBorder(Color.black));
        }
        return this.groupingScroll;
    }

    private JPanel getMainPane() {
        if (this.mainPane == null) {
            this.mainPane = new JPanel();
            this.mainPane.setLayout(new BorderLayout());
            this.mainPane.setBorder(BorderFactory.createEmptyBorder(0, 18, 0, 0));
            this.mainPane.add((Component)this.getGroupLabel(), "North");
            this.mainPane.add((Component)this.getGroupEditorPane(), "Center");
        }
        return this.mainPane;
    }

    private JLabel getGroupLabel() {
        if (this.groupLabel == null) {
            this.groupLabel = new JLabel();
            this.groupLabel.setBackground(new Color(153, 153, 153));
            this.groupLabel.setOpaque(true);
            this.groupLabel.setForeground(Color.white);
            this.groupLabel.setPreferredSize(new Dimension(100, 20));
            this.groupLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            this.groupLabel.setFont(FontManager.getFont((String)this.dialogFontFace, (int)1, (int)14));
        }
        return this.groupLabel;
    }

    private JPanel getGroupEditorPane() {
        if (this.groupEditorPane == null) {
            this.groupEditorPane = new JPanel();
            this.groupEditorPane.setLayout(new BorderLayout());
            JPanel p = new JPanel();
            p.setPreferredSize(new Dimension(100, 13));
            this.groupEditorPane.add((Component)p, "North");
            this.groupEditorPane.add((Component)this.getJPanel(), "West");
            this.groupEditorPane.add((Component)this.getPreviewPane(), "Center");
        }
        return this.groupEditorPane;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new BorderLayout());
            this.jPanel.add((Component)this.getElementsList(), "North");
            this.jPanel.add((Component)this.getEditorPanel(), "Center");
        }
        return this.jPanel;
    }

    private JScrollPane getElementsList() {
        if (this.elementsList == null) {
            this.elementsList = new JList();
            this.elementsList.setFont(FontManager.getFont((String)this.dialogFontFace, (int)0, (int)12));
            this.elementsList.setCellRenderer(new ElementListCellRenderer());
            ((JComponent)((Object)this.elementsList.getCellRenderer())).putClientProperty(new StringBuffer("AATextPropertyKey"), Boolean.TRUE);
            this.elementsList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (GraphStyleEditor.this.elementsList.getSelectedValue() == null) {
                        GraphStyleEditor.this.getEditorLabel().setText("");
                    } else {
                        GraphStyleEditor.this.getEditorLabel().setText(GraphStyleEditor.this.elementsList.getSelectedValue().toString());
                        GraphStyleEditor.this.getEditor().setStyleElement((StyleElement)GraphStyleEditor.this.elementsList.getSelectedValue());
                    }
                }
            });
            this.elementsScroll = new JScrollPane(this.elementsList);
            this.elementsScroll.setPreferredSize(new Dimension(210, 130));
        }
        return this.elementsScroll;
    }

    private JPanel getEditorPanel() {
        if (this.editorPanel == null) {
            this.editorPanel = new JPanel();
            this.editorPanel.setLayout(new BorderLayout());
            this.editorPanel.setBorder(BorderFactory.createEmptyBorder(13, 0, 0, 0));
            this.editorPanel.add((Component)this.getEditorLabel(), "North");
            this.editorPanel.add((Component)this.getEditor(), "Center");
        }
        return this.editorPanel;
    }

    private StyleElementEditorPanel getEditor() {
        if (this.elementEditor == null) {
            this.elementEditor = new StyleElementEditorPanel();
            this.elementEditor.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    GraphStyleEditor.this.styleModified = (byte)(GraphStyleEditor.this.styleModified & (GraphStyleEditor.this.elementEditor.isModified() ? 1 : 0));
                    GraphStyleEditor.this.repaint();
                    GraphStyleEditor.this.firePropertyChangeEvent();
                }
            });
        }
        return this.elementEditor;
    }

    private JLabel getEditorLabel() {
        if (this.editorLabel == null) {
            this.editorLabel = new JLabel("Foo");
            this.editorLabel.putClientProperty(new StringBuffer("AATextPropertyKey"), Boolean.TRUE);
            this.editorLabel.setFont(FontManager.getFont((String)this.dialogFontFace, (int)0, (int)12));
        }
        return this.editorLabel;
    }

    private JPanel getPreviewPane() {
        if (this.previewPanel == null) {
            this.previewPanel = new JPanel();
            this.previewPanel.setLayout(new BorderLayout());
            this.previewPanel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
            this.previewPanel.add((Component)this.getPreviewSelectorPanel(), "North");
            this.previewPanel.add((Component)this.getPreviewContainer(), "Center");
        }
        return this.previewPanel;
    }

    private JPanel getPreviewContainer() {
        if (this.previewContainer == null) {
            this.previewContainer = new JPanel();
            this.previewContainer.setLayout(new BorderLayout());
            this.previewContainer.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(13, 0, 0, 0), BorderFactory.createMatteBorder(2, 2, 2, 2, Color.LIGHT_GRAY)));
        }
        return this.previewContainer;
    }

    private JPanel getPreviewSelectorPanel() {
        if (this.previewSelectorPanel == null) {
            this.previewSelectorPanel = new JPanel();
            this.previewSelectorPanel.setLayout(new BorderLayout());
            JLabel label = new JLabel(Messages.getString("SelectSample.txt"));
            label.putClientProperty(new StringBuffer("AATextPropertyKey"), Boolean.TRUE);
            label.setFont(FontManager.getFont((String)this.dialogFontFace, (int)0, (int)11));
            label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
            this.previewSelectorPanel.add((Component)label, "West");
            this.previewSelectorPanel.add((Component)this.getPreviewCombo(), "Center");
        }
        return this.previewSelectorPanel;
    }

    private JComboBox getPreviewCombo() {
        if (this.previewCombo == null) {
            this.previewCombo = new JComboBox();
            this.previewCombo.setBackground(Color.white);
            ((JComponent)((Object)this.previewCombo.getRenderer())).putClientProperty(new StringBuffer("AATextPropertyKey"), Boolean.TRUE);
            this.previewCombo.setFont(FontManager.getFont((String)this.dialogFontFace, (int)0, (int)12));
            this.previewCombo.addItem(Messages.getString("BarHist.txt"));
            DefaultStylePreview preview = new DefaultStylePreview();
            preview.setRampPreviewVisible(false);
            preview.setRolloverEnabled(true);
            preview.addActionListener(this);
            this.previews.put(Messages.getString("BarHist.txt"), preview);
            this.previewCombo.addItem(Messages.getString("BarChart.txt"));
            DefaultBarPreview bar = new DefaultBarPreview();
            bar.setRolloverEnabled(true);
            bar.addActionListener(this);
            this.previews.put(Messages.getString("BarChart.txt"), bar);
            this.previewCombo.addItem(Messages.getString("Histogram.txt"));
            DefaultHistogramPreview hist = new DefaultHistogramPreview();
            hist.setRolloverEnabled(true);
            hist.addActionListener(this);
            this.previews.put(Messages.getString("Histogram.txt"), hist);
            this.getPreviewContainer().add(preview);
            this.previewCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    GraphStyleEditor.this.getPreviewContainer().removeAll();
                    GraphStyleEditor.this.getPreviewContainer().add((JComponent)GraphStyleEditor.this.previews.get(GraphStyleEditor.this.previewCombo.getSelectedItem()));
                    GraphStyleEditor.this.revalidate();
                    GraphStyleEditor.this.repaint();
                }
            });
        }
        return this.previewCombo;
    }

    public void addPreview(String displayName, StylePreview preview) {
        if (displayName == null || preview == null || !(preview instanceof Component)) {
            return;
        }
        preview.addActionListener(this);
        this.previews.put(displayName, preview);
        this.previewCombo.addItem(displayName);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e != null && e.getActionCommand() != null) {
            this.setSelectedElement(e.getActionCommand());
        }
    }

    public void setSelectedElement(String elementName) {
        int i;
        if (elementName == null) {
            return;
        }
        for (i = 0; i < this.textElements.size(); ++i) {
            if (!elementName.equalsIgnoreCase(((StyleElement)this.textElements.elementAt(i)).getContextName())) continue;
            this.groupingList.setSelectedIndex(0);
            this.elementsList.setSelectedValue(this.textElements.elementAt(i), true);
            return;
        }
        for (i = 0; i < this.plotElements.size(); ++i) {
            if (!elementName.equalsIgnoreCase(((StyleElement)this.plotElements.elementAt(i)).getContextName())) continue;
            this.groupingList.setSelectedIndex(1);
            this.elementsList.setSelectedValue(this.plotElements.elementAt(i), true);
            return;
        }
        for (i = 0; i < this.specialElements.size(); ++i) {
            if (!elementName.equalsIgnoreCase(((StyleElement)this.specialElements.elementAt(i)).getContextName())) continue;
            this.groupingList.setSelectedIndex(2);
            this.elementsList.setSelectedValue(this.specialElements.elementAt(i), true);
            return;
        }
        for (i = 0; i < this.fillElements.size(); ++i) {
            if (!elementName.equalsIgnoreCase(((StyleElement)this.fillElements.elementAt(i)).getContextName())) continue;
            this.groupingList.setSelectedIndex(3);
            this.elementsList.setSelectedValue(this.fillElements.elementAt(i), true);
            return;
        }
        for (i = 0; i < this.rampElements.size(); ++i) {
            if (!elementName.equalsIgnoreCase(((StyleElement)this.rampElements.elementAt(i)).getContextName())) continue;
            this.groupingList.setSelectedIndex(4);
            this.elementsList.setSelectedValue(this.rampElements.elementAt(i), true);
            return;
        }
        for (i = 0; i < this.lineElements.size(); ++i) {
            if (!elementName.equalsIgnoreCase(((StyleElement)this.lineElements.elementAt(i)).getContextName())) continue;
            this.groupingList.setSelectedIndex(5);
            this.elementsList.setSelectedValue(this.lineElements.elementAt(i), true);
            return;
        }
        for (i = 0; i < this.otherElements.size(); ++i) {
            if (!elementName.equalsIgnoreCase(((StyleElement)this.otherElements.elementAt(i)).getContextName())) continue;
            this.groupingList.setSelectedIndex(6);
            this.elementsList.setSelectedValue(this.otherElements.elementAt(i), true);
            return;
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners.add(PropertyChangeListener.class, listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners.remove(PropertyChangeListener.class, listener);
    }

    private void firePropertyChangeEvent() {
        PropertyChangeEvent event = new PropertyChangeEvent(this, "MODIFIED", null, null);
        EventListener[] arr = this.propertyChangeListeners.getListeners(PropertyChangeListener.class);
        for (int i = 0; i < arr.length; ++i) {
            ((PropertyChangeListener)arr[i]).propertyChange(event);
        }
    }

    public boolean isStyleModified() {
        return this.styleModified;
    }

    class ElementListCellRenderer
    extends DefaultListCellRenderer {
        ElementListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Object val = value;
            if (value instanceof StyleElement) {
                val = ((StyleElement)value).getTemplateClassname();
            }
            return super.getListCellRendererComponent((JList<?>)list, val, index, isSelected, cellHasFocus);
        }
    }
}

