/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.styles.ui;

import com.sas.graphics.styles.DataStyleElement;
import com.sas.graphics.styles.FillStyleElement;
import com.sas.graphics.styles.LineStyleElement;
import com.sas.graphics.styles.StyleElement;
import com.sas.graphics.styles.TextStyleElement;
import com.sas.graphics.styles.ui.AbstractStylePreview;
import com.sas.graphics.styles.ui.Messages;
import com.sas.graphics.util.FillPattern;
import com.sas.graphics.util.FontManager;
import com.sas.graphics.util.Markers;
import com.sas.graphics.util.SASLinePatterns;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.Vector;

public class DefaultHistogramPreview
extends AbstractStylePreview {
    private static final long serialVersionUID = -4944302012464416232L;
    Rectangle wallRect = new Rectangle();
    Rectangle[] bars = null;
    Rectangle titleRect = new Rectangle();
    Rectangle yAxisRect = new Rectangle();
    Rectangle xAxisRect = new Rectangle();
    Rectangle selectRect = new Rectangle();
    private boolean drawXAxisLabel = true;
    private boolean drawYAxisLabel = true;
    private boolean useStyleNameAsTitle = false;
    private static double[] histValues = new double[]{0.15, 0.27, 0.35, 0.42, 0.58, 0.89, 0.71, 0.24};
    private boolean drawMarkers = false;

    @Override
    public String getStyleElementAt(Point arg0) {
        if (this.selectRect != null && this.selectRect.contains(arg0)) {
            return "Selection";
        }
        if (this.bars != null) {
            for (int i = 0; i < this.bars.length; ++i) {
                if (this.bars[i] == null || !this.bars[i].contains(arg0)) continue;
                return "GraphDataStyleDefault";
            }
        }
        if (this.wallRect != null && this.wallRect.contains(arg0)) {
            return "WallFill";
        }
        if (this.titleRect != null && this.titleRect.contains(arg0)) {
            return "TitleText";
        }
        if (this.xAxisRect != null && this.xAxisRect.contains(arg0)) {
            return "LabelText";
        }
        if (this.yAxisRect != null && this.yAxisRect.contains(arg0)) {
            return "LabelText";
        }
        return "Backfill";
    }

    @Override
    protected void paintComponent(Graphics g) {
        int fontSize;
        if (this.style == null) {
            return;
        }
        StyleElement sel = this.style.getStyleElement("Selection");
        BasicStroke selStroke = SASLinePatterns.getStroke((int)2, (int)1);
        Stroke defStroke = ((Graphics2D)g).getStroke();
        StyleElement se = null;
        se = this.style.getStyleElement("Backfill");
        if (se != null) {
            FillStyleElement bg = se.getAsFillStyle();
            g.setColor(bg.getFillColor());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if (this.rolloverEnabled && "Backfill".equalsIgnoreCase(this.highlightArea)) {
            g.setColor(Color.black);
            ((Graphics2D)g).setStroke(selStroke);
            g.drawRect(1, 1, this.getWidth() - 2, this.getHeight() - 2);
            ((Graphics2D)g).setStroke(defStroke);
        }
        Rectangle r = new Rectangle(5, 5, this.getWidth() - 10, this.getHeight() - 10);
        se = this.style.getStyleElement("TitleText");
        if (se != null) {
            String text = this.useStyleNameAsTitle ? this.style.getDisplayName() : Messages.getString("DefaultStylePreview.27.txt");
            TextStyleElement title = se.getAsTextStyle();
            g.setColor(title.getTextColor());
            fontSize = title.getFontSize().getSizeValue();
            g.setFont(FontManager.getFont((String)title.getFontFamily(), (int)(title.getFontWeight() + title.getFontStyle()), (int)fontSize));
            Rectangle2D bounds = g.getFont().getStringBounds(text, ((Graphics2D)g).getFontRenderContext());
            g.drawString(text, r.x + r.width / 2 - (int)(bounds.getWidth() / 2.0), r.y + fontSize);
            this.titleRect.setBounds(r.x + r.width / 2 - (int)(bounds.getWidth() / 2.0), r.y, (int)bounds.getWidth(), (int)bounds.getHeight());
            r.y += 10 + fontSize;
            r.height -= 10 + fontSize;
        }
        if (this.rolloverEnabled && "TitleText".equalsIgnoreCase(this.highlightArea)) {
            g.setColor(Color.black);
            ((Graphics2D)g).setStroke(selStroke);
            g.drawRect(this.titleRect.x, this.titleRect.y, this.titleRect.width, this.titleRect.height);
            ((Graphics2D)g).setStroke(defStroke);
        }
        if ((se = this.style.getStyleElement("LabelText")) != null) {
            TextStyleElement axisText = se.getAsTextStyle();
            Rectangle2D rect = null;
            g.setColor(axisText.getTextColor());
            fontSize = axisText.getFontSize().getSizeValue();
            if (this.drawXAxisLabel) {
                g.setFont(FontManager.getFont((String)axisText.getFontFamily(), (int)(axisText.getFontStyle() + axisText.getFontWeight()), (int)fontSize));
                rect = g.getFont().getStringBounds(Messages.getString("DefaultStylePreview.13.txt"), ((Graphics2D)g).getFontRenderContext());
                if (this.rolloverEnabled && "LabelText".equalsIgnoreCase(this.highlightArea)) {
                    g.setColor(Color.black);
                    ((Graphics2D)g).setStroke(selStroke);
                    g.drawRect(r.x + r.width / 2 - (int)rect.getWidth() / 2, r.y + r.height - (int)rect.getHeight(), (int)rect.getWidth(), (int)rect.getHeight());
                    ((Graphics2D)g).setStroke(defStroke);
                }
                g.drawString(Messages.getString("DefaultStylePreview.13.txt"), r.x + r.width / 2 - (int)rect.getWidth() / 2, r.y + r.height);
                r.height -= 10 + fontSize;
                this.xAxisRect.setBounds(r.x, r.y + r.height, r.width, this.getHeight() - (r.y + r.height));
            }
            if (this.drawYAxisLabel) {
                rect = g.getFont().getStringBounds(Messages.getString("DefaultStylePreview.15.txt"), ((Graphics2D)g).getFontRenderContext());
                ((Graphics2D)g).rotate(-1.5707963267948966, r.x + (int)rect.getHeight(), r.y + r.height / 2 + (int)rect.getWidth() / 2);
                g.drawString(Messages.getString("DefaultStylePreview.15.txt"), r.x + (int)rect.getHeight(), r.y + r.height / 2 + (int)rect.getWidth() / 2);
                if (this.rolloverEnabled && "LabelText".equalsIgnoreCase(this.highlightArea)) {
                    g.setColor(Color.black);
                    ((Graphics2D)g).setStroke(selStroke);
                    g.drawRect(r.x + (int)rect.getHeight(), r.y + r.height / 2 + (int)rect.getWidth() / 2 - (int)rect.getHeight(), (int)rect.getWidth(), (int)rect.getHeight());
                    ((Graphics2D)g).setStroke(defStroke);
                }
                ((Graphics2D)g).rotate(1.5707963267948966, r.x + (int)rect.getHeight(), r.y + r.height / 2 + (int)rect.getWidth() / 2);
                r.x += fontSize + 10;
                r.width -= fontSize + 10;
                this.yAxisRect.setBounds(0, r.y, r.x, r.height);
            }
        }
        if ((se = this.style.getStyleElement("WallFill")) != null) {
            FillStyleElement wall = se.getAsFillStyle();
            g.setColor(wall.getFillColor());
            g.fillRect(r.x, r.y, r.width, r.height);
            this.wallRect.setBounds(r.x, r.y, r.width, r.height);
            if (this.rolloverEnabled && "WallFill".equalsIgnoreCase(this.highlightArea)) {
                g.setColor(Color.black);
                ((Graphics2D)g).setStroke(selStroke);
                g.drawRect(this.wallRect.x + 2, this.wallRect.y + 2, this.wallRect.width - 4, this.wallRect.height - 4);
                ((Graphics2D)g).setStroke(defStroke);
            }
            if (wall.getBooleanAttribute("frameBorder", false)) {
                Stroke s = g instanceof Graphics2D ? ((Graphics2D)g).getStroke() : null;
                LineStyleElement lse = wall.getAsLineStyle();
                if (g instanceof Graphics2D) {
                    ((Graphics2D)g).setStroke(SASLinePatterns.getStroke((int)lse.getLineStyle(), (int)lse.getLineThickness().getSizeValue()));
                }
                g.setColor(lse.getLineColor());
                g.drawLine(r.x, r.y, r.x + r.width, r.y);
                g.drawLine(r.x + r.width, r.y, r.x + r.width, r.y + r.height);
                if (g instanceof Graphics2D) {
                    ((Graphics2D)g).setStroke(s);
                }
            }
        }
        if ((se = this.style.getStyleElement("AxisLines")) != null) {
            Stroke s = g instanceof Graphics2D ? ((Graphics2D)g).getStroke() : null;
            LineStyleElement axisLine = se.getAsLineStyle();
            if (g instanceof Graphics2D) {
                ((Graphics2D)g).setStroke(SASLinePatterns.getStroke((int)axisLine.getLineStyle(), (int)axisLine.getLineThickness().getSizeValue()));
            }
            g.setColor(axisLine.getLineColor());
            g.drawLine(r.x, r.y, r.x, r.y + r.height);
            g.drawLine(r.x, r.y + r.height, r.x + r.width, r.y + r.height);
            if (g instanceof Graphics2D) {
                ((Graphics2D)g).setStroke(s);
            }
        }
        Color outlineColor = Color.BLACK;
        se = this.style.getStyleElement("Outlines");
        if (se != null) {
            outlineColor = se.getAsLineStyle().getLineColor();
        }
        se = this.style.getStyleElement("GraphDataStyleDefault");
        Color defaultColor = null;
        defaultColor = se == null ? new Color(204, 204, 204) : se.getColorAttribute("color", defaultColor);
        int width = (r.width - 10 - 3 * histValues.length) / histValues.length;
        int x = r.x + 5;
        this.bars = new Rectangle[histValues.length];
        for (int i = 0; i < histValues.length; ++i) {
            int height = (int)((double)(r.height - (this.drawMarkers ? 12 : 5)) * histValues[i % histValues.length]);
            g.setColor(defaultColor);
            g.fillRect(x, r.y + (r.height - height), width, height);
            this.bars[i] = new Rectangle(x, r.y + (r.height - height), width, height);
            if (i == 5) {
                Color selectionColor = new Color(64, 128, 0);
                if (sel != null) {
                    selectionColor = sel.getAsFillStyle().getFillColor();
                }
                this.selectRect = new Rectangle(x, r.y + (r.height - height), width, height);
                if (this.rolloverEnabled && "Selection".equalsIgnoreCase(this.highlightArea)) {
                    g.setColor(Color.black);
                    ((Graphics2D)g).setStroke(selStroke);
                    g.drawRect(x + 2, r.y + (r.height - height) + 2, width - 4, height - 4);
                    ((Graphics2D)g).setStroke(defStroke);
                }
                Paint old = ((Graphics2D)g).getPaint();
                TexturePaint hatch = new FillPattern().getHatch45(selectionColor);
                ((Graphics2D)g).setPaint(hatch);
                g.fillRect(x, r.y + (r.height - height), width, height);
                ((Graphics2D)g).setPaint(old);
            }
            if (this.rolloverEnabled && "GraphDataStyleDefault".equalsIgnoreCase(this.highlightArea) && i != 5) {
                g.setColor(Color.black);
                ((Graphics2D)g).setStroke(selStroke);
                g.drawRect(x + 2, r.y + (r.height - height) + 2, width - 4, height - 4);
                ((Graphics2D)g).setStroke(defStroke);
            }
            if (outlineColor != null) {
                g.setColor(outlineColor);
                g.drawRect(x, r.y + (r.height - height), width, height);
            }
            x += width + 3;
        }
        Color lineColor = null;
        lineColor = se == null ? Color.BLACK : se.getAsLineStyle().getLineColor();
        g.setColor(lineColor);
        if (se != null) {
            DataStyleElement dse = se.getAsDataStyle();
            ((Graphics2D)g).setStroke(SASLinePatterns.getStroke((int)dse.getLineStyle(), (int)dse.getLineThickness().getSizeValue()));
        }
        Vector<Double> v = new Vector<Double>();
        for (double d = -1.5707963267948966; d <= 1.5707963267948966; d += Math.PI / (double)(r.width - 10)) {
            v.addElement(new Double(this.dist(d)));
        }
        GeneralPath path = new GeneralPath();
        for (int i = 0; i < v.size(); ++i) {
            if (i == 0) {
                path.moveTo(r.x + 5 + i, r.y + r.height - (int)(1.6 * (double)r.height * (Double)v.elementAt(i)));
                continue;
            }
            path.lineTo(r.x + 5 + i, r.y + r.height - (int)(1.6 * (double)r.height * (Double)v.elementAt(i)));
        }
        if (se != null) {
            DataStyleElement dse = se.getAsDataStyle();
            ((Graphics2D)g).setStroke(SASLinePatterns.getStroke((int)dse.getLineStyle(), (int)dse.getLineThickness().getSizeValue()));
        }
        ((Graphics2D)g).draw(path);
        if (this.drawMarkers) {
            Color[] colors = this.style.getDataFillColors();
            Color[] contrastColors = this.style.getDataLineColors();
            int[] markers = this.style.getDataMarkerSymbols();
            outlineColor = Color.BLACK;
            se = this.style.getStyleElement("Outlines");
            if (se != null) {
                outlineColor = se.getColorAttribute("altColor", null);
            }
            if (colors != null && colors.length > 0) {
                width = (r.width - 10 - 3 * colors.length) / colors.length;
                x = r.x + 5;
                for (int i = 0; i < colors.length && x + 10 <= r.x + r.width; ++i) {
                    g.setColor(colors[i]);
                    if (markers != null && markers.length > i) {
                        Markers.draw((Graphics)g, (Color)contrastColors[i], null, (int)markers[i], (int)10, (int)(x + width / 2), (int)(r.y + 10), (boolean)false, (int)0, (int)2);
                    }
                    x += width + 5;
                }
            }
        }
    }

    private double dist(double d) {
        return 1.0 / Math.pow(Math.E, d * d / 2.0) / Math.sqrt(Math.PI * 2);
    }

    public boolean isDrawXAxisLabel() {
        return this.drawXAxisLabel;
    }

    public void setDrawXAxisLabel(boolean drawXAxisLabel) {
        this.drawXAxisLabel = drawXAxisLabel;
    }

    public boolean isDrawYAxisLabel() {
        return this.drawYAxisLabel;
    }

    public void setDrawYAxisLabel(boolean drawYAxisLabel) {
        this.drawYAxisLabel = drawYAxisLabel;
    }

    public boolean isUseStyleNameAsTitle() {
        return this.useStyleNameAsTitle;
    }

    public void setUseStyleNameAsTitle(boolean useStyleNameAsTitle) {
        this.useStyleNameAsTitle = useStyleNameAsTitle;
    }

    public boolean isDrawMarkers() {
        return this.drawMarkers;
    }

    public void setDrawMarkers(boolean drawMarkers) {
        this.drawMarkers = drawMarkers;
    }
}

