/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.data.CustomModelManagerInterface;
import com.sas.graphics.data.FilterFilter;
import com.sas.graphics.data.FilterFilter2;
import com.sas.graphics.silk.interfaces.DataFilterInfoInterface;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JTable;

public abstract class FilterFactory {
    protected static String[] knownTypes = new String[]{"com.sas.sg.datamodel.DataModel", "javax.swing.JTable", "javax.swing.table.TableModel"};
    protected static String[] filters = new String[]{"com.sas.graphics.silk.data.SGDataFilter", "com.sas.graphics.silk.data.JTableDataFilter", "com.sas.graphics.silk.data.JTableDataFilter"};
    private static Hashtable instances = new Hashtable();
    private static boolean SELECT_CROPPED_OBSERVATIONS = false;

    private static void cacheFilter(Object source, DataFilterReadInterface filter) {
        if (source == null || filter == null) {
            return;
        }
        Vector<DataFilterReadInterface> v = (Vector<DataFilterReadInterface>)instances.get(source);
        if (v == null) {
            v = new Vector<DataFilterReadInterface>();
            instances.put(source, v);
        }
        if (!v.contains(filter)) {
            v.addElement(filter);
        }
    }

    public static DataFilterReadInterface getDataSourceFilter(Object source, boolean newInstance) {
        Object obj = null;
        Class<?> classObj = null;
        Class<?>[] interfaces = null;
        if (source == null) {
            return null;
        }
        if (source instanceof JTable) {
            try {
                classObj = Class.forName("com.sas.graphics.silk.data.JTableDataFilter");
                if (classObj == null) {
                    return null;
                }
                obj = classObj.newInstance();
            }
            catch (InstantiationException e) {
                return null;
            }
            catch (IllegalAccessException e) {
                return null;
            }
            catch (ClassNotFoundException e) {
                return null;
            }
            if (obj != null) {
                ((DataFilterReadInterface)obj).setSource(source);
            }
            FilterFactory.cacheFilter(source, obj);
            return obj;
        }
        if (source instanceof DataFilterReadInterface) {
            if (newInstance) {
                if (source instanceof DataFilterInfoInterface) {
                    return new FilterFilter2((DataFilterReadInterface)source);
                }
                return new FilterFilter((DataFilterReadInterface)source);
            }
            return (DataFilterReadInterface)source;
        }
        for (classObj = source.getClass(); classObj != null; classObj = classObj.getSuperclass()) {
            interfaces = classObj.getInterfaces();
            if (interfaces == null) continue;
            int nTypes = knownTypes.length;
            int nInterfaces = interfaces.length;
            try {
                for (int iInterface = 0; iInterface < nInterfaces; ++iInterface) {
                    for (int iType = 0; iType < nTypes; ++iType) {
                        if (!FilterFactory.isSupportedInterface(interfaces[iInterface], knownTypes[iType])) continue;
                        classObj = Class.forName(filters[iType]);
                        if (classObj == null) {
                            return null;
                        }
                        obj = classObj.newInstance();
                        break;
                    }
                    if (obj == null) {
                        continue;
                    }
                    break;
                }
            }
            catch (InstantiationException e) {
                return null;
            }
            catch (IllegalAccessException e) {
                return null;
            }
            catch (ClassNotFoundException e) {
                return null;
            }
            if (obj != null) break;
        }
        if (obj != null) {
            ((DataFilterReadInterface)obj).setSource(source);
        }
        FilterFactory.cacheFilter(source, obj);
        return obj;
    }

    public static DataFilterReadInterface getDataSourceFilter(Object source) {
        return FilterFactory.getDataSourceFilter(source, false);
    }

    protected static boolean isSupportedInterface(Class interfaceObj, String knownInterface) {
        String fullname = null;
        if (interfaceObj == null) {
            return false;
        }
        fullname = interfaceObj.getName();
        if (fullname == null) {
            return false;
        }
        if (fullname.equals(knownInterface)) {
            return true;
        }
        return FilterFactory.isSupportedInterface(interfaceObj.getSuperclass(), knownInterface);
    }

    public static void detachFilter(DataFilterReadInterface filter) {
        if (filter == null || filter.getSource() == null) {
            return;
        }
        if (!instances.containsKey(filter.getSource())) {
            return;
        }
        Vector v = (Vector)instances.get(filter.getSource());
        v.removeElement(filter);
    }

    public static void detachAllFilters(Object dataModel) {
        if (dataModel == null) {
            return;
        }
        Vector v = (Vector)instances.get(dataModel);
        if (v == null) {
            return;
        }
        instances.remove(dataModel);
        for (int i = 0; i < v.size(); ++i) {
            DataFilterReadInterface filter = (DataFilterReadInterface)v.elementAt(i);
            CustomModelManagerInterface cmmi = (CustomModelManagerInterface)filter.getAdapter(CustomModelManagerInterface.class);
            if (cmmi != null) {
                cmmi.detachCustomModels();
            }
            filter.removeSource();
        }
        v.clear();
    }

    public static boolean areCroppedObservationsSelectable() {
        return SELECT_CROPPED_OBSERVATIONS;
    }

    public static void setCroppedObservationsSelectable(boolean select_cropped_observations) {
        SELECT_CROPPED_OBSERVATIONS = select_cropped_observations;
    }
}

