/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.data;

import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.data.AbstractDataFilter;
import com.sas.graphics.data.sort.SortContext;
import com.sas.graphics.data.subset.WhereClauseSubset;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.util.RangeInfoModel;

public class DataFilterUtilities {
    public static final int ACTION_WHERE = 0;
    public static final int ACTION_SELECT = 1;
    public static final int ACTION_GRAPHED = 2;
    public static final int ACTION_CROPPED = 3;

    public static void setSelected(DataFilterReadInterface filter, String[] variables, DataRange[] boundingBox, boolean selected, boolean useFormat) {
        if (filter == null) {
            return;
        }
        filter.setSelected(variables, boundingBox, selected, useFormat);
    }

    public static boolean isSelected(DataFilterReadInterface filter, long iobs, SortContext sort) {
        if (filter == null) {
            return false;
        }
        return filter.isSelected(iobs, sort);
    }

    public static void setSelected(DataFilterReadInterface filter, long iobs, SortContext sort, boolean selected) {
        if (filter == null) {
            return;
        }
        filter.setSelected(iobs, sort, selected);
    }

    public static void unselectAll(DataFilterReadInterface filter) {
        if (filter == null) {
            return;
        }
        filter.unselectAll();
    }

    public static void setGraphed(DataFilterReadInterface filter, String[] variables, DataRange[] ranges, boolean[] graphed, boolean[] useFormat, boolean extendCurrentGraphedState, boolean setOrClearAll) {
        if (filter == null) {
            return;
        }
        filter.setGraphed(variables, ranges, graphed, useFormat, extendCurrentGraphedState, setOrClearAll);
    }

    public static void setGraphed(DataFilterReadInterface filter, String[] variables, DataRange[] boundingBox, boolean graphed, boolean useFormat) {
        if (filter == null) {
            return;
        }
        filter.setGraphed(variables, boundingBox, graphed, useFormat);
    }

    public static boolean isGraphed(DataFilterReadInterface filter, long iobs, SortContext sort) {
        if (filter == null) {
            return false;
        }
        return filter.isGraphed(iobs, sort);
    }

    public static void setGraphed(DataFilterReadInterface filter, long iobs, SortContext sort, boolean graphed) {
        if (filter == null) {
            return;
        }
        filter.setGraphed(iobs, sort, graphed);
    }

    public static double getGraphedMinimumValue(DataFilterReadInterface filter, Object variableId) {
        if (filter == null || variableId == null) {
            return Double.NaN;
        }
        RangeInfoModel rim = (RangeInfoModel)filter.getAdapter(RangeInfoModel.class);
        if (rim == null) {
            return Double.NaN;
        }
        return rim.getGraphedMinimum(variableId);
    }

    public static double getGraphedMaximumValue(DataFilterReadInterface filter, Object variableId) {
        if (filter == null || variableId == null) {
            return Double.NaN;
        }
        RangeInfoModel rim = (RangeInfoModel)filter.getAdapter(RangeInfoModel.class);
        if (rim == null) {
            return Double.NaN;
        }
        return rim.getGraphedMaximum(variableId);
    }

    public static void setAllGraphed(DataFilterReadInterface dfri, boolean graphed) {
        if (dfri == null) {
            return;
        }
        dfri.setAllGraphed(graphed);
    }

    public static boolean applyWhereClause(DataFilterReadInterface filter, String clause, boolean clearPrevious, int action) {
        if (filter == null) {
            return false;
        }
        if (clause == null) {
            switch (action) {
                case 2: 
                case 3: {
                    filter.setAllGraphed(true);
                    break;
                }
                case 1: {
                    filter.unselectAll();
                    break;
                }
                case 0: {
                    filter.applyWhereClause(null, clearPrevious);
                }
            }
            return true;
        }
        WhereClauseSubset subset = new WhereClauseSubset(clause);
        boolean rc = true;
        int[] passed = null;
        AbstractDataFilter adf = filter instanceof AbstractDataFilter ? (AbstractDataFilter)filter : null;
        switch (action) {
            case 3: {
                passed = subset.getPassedObs(filter);
                if (clearPrevious) {
                    if (adf != null && passed != null && passed.length > 0) {
                        adf.setSuppressEvents(true);
                    }
                    filter.setAllGraphed(true);
                    if (adf != null) {
                        adf.setSuppressEvents(false);
                    }
                }
                filter.setGraphed(passed, false);
                break;
            }
            case 2: {
                passed = subset.getPassedObs(filter);
                if (passed != null && clearPrevious) {
                    if (adf != null && passed.length > 0) {
                        adf.setSuppressEvents(true);
                    }
                    filter.setAllGraphed(false);
                    if (adf != null) {
                        adf.setSuppressEvents(false);
                    }
                }
                filter.setGraphed(passed, true);
                break;
            }
            case 1: {
                passed = subset.getPassedObs(filter);
                if (clearPrevious) {
                    if (adf != null && passed.length > 0) {
                        adf.setSuppressEvents(true);
                    }
                    filter.unselectAll();
                    if (adf != null) {
                        adf.setSuppressEvents(false);
                    }
                }
                filter.setSelected(passed, true);
                break;
            }
            case 0: {
                rc = filter.applyWhereClause(clause, clearPrevious);
            }
        }
        return rc;
    }
}

