/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.data.subset;

import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousPoint;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.data.subset.AbstractSubset;
import com.sas.graphics.data.subset.SubsetTest;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import java.util.Vector;

public class ContinuousSubset
extends AbstractSubset {
    private String variable = null;
    private Vector ranges = new Vector();
    private SubsetTest test = SubsetTest.IN;

    public ContinuousSubset(String varName, SubsetTest test, ContinuousRange range) {
        this.variable = varName;
        if (test != null) {
            this.test = test;
        }
        if (range != null) {
            this.ranges.addElement(range);
        }
    }

    public void addRange(ContinuousRange range) {
        if (range != null) {
            this.ranges.addElement(range);
        }
    }

    public void removeAllRanges() {
        this.ranges.removeAllElements();
    }

    public ContinuousRange[] getRanges() {
        Object[] rc = new ContinuousRange[this.ranges.size()];
        this.ranges.copyInto(rc);
        return rc;
    }

    @Override
    protected boolean passesSubset(DataFilterReadInterface filter, int obsNum) {
        if (filter == null || this.variable == null || this.test == null) {
            return false;
        }
        if (!filter.isNumericVariable(this.variable)) {
            return false;
        }
        double value = filter.getNumericValue(this.variable, (long)obsNum);
        ContinuousPoint dp = new ContinuousPoint(value);
        if (this.test == SubsetTest.IN) {
            for (int i = 0; i < this.ranges.size(); ++i) {
                ContinuousRange range = (ContinuousRange)this.ranges.elementAt(i);
                if (!range.contains(dp)) continue;
                return true;
            }
        } else if (this.test == SubsetTest.NOT_IN) {
            for (int i = 0; i < this.ranges.size(); ++i) {
                ContinuousRange range = (ContinuousRange)this.ranges.elementAt(i);
                if (!range.contains(dp)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

